/*
>>:yam3.c 8-13-81
 *
 * two-way conversation with remote -whatever.
 * Printer is buffered such that it needn't be as fast as the baudrate
 * as long as it eventually gets a chance to catch up.
 * This buffering also allows one to write the received data out to disk
 * after the conservation has started.
 */
#include "yam.h"

term()
{
	register c;
#ifndef BDSC
	register char cfast;
#endif
	unsigned charsent;

	charsent=0;
	Waitecho=Txwait=FALSE;
	if(Txgo || !Tfile)
		pstat("Term Mode");
	else
		pstat("Sending Stopped");
	for(;;) {
		if(MIREADY) {
			*bufcq++ = MICHAR;
			Timeout=0;
hdxstuff:
			if(bufcq >= bufend) {
				Wrapped=TRUE;
				bufcq=bufst;
			}
			if(--Free == Low)
				outp(MODATA, Xoffflg=XOFF);
			continue;
		}
		if(COREADY && bufcdq != bufcq) {
			switch(cfast= (*bufcdq & 0177) ) {
			 case ENQ:
				 abptr= ANSWERBACK; break;
			case '\b':
				if(Ttycol)
					--Ttycol;
				break;
			case '\t':
				if(++Ttycol & 07)
					outp(CDATA, ' ');
				else if(++bufcdq >= bufend)
					bufcdq=bufst;
				continue;
			default:
				++Ttycol; break;
			case '\r':
				Ttycol=0; break;
			case '\n':
				if(Txeoln==EOL_CRWAIT)
					Waitecho=FALSE;
				break;
cxoff:
			case XOFF:
#ifdef STATLINE
				if(Tfile)
					pstat("Sending stopped by XOFF");
#endif
				Txgo=FALSE; break;
cxon:
			case XON:
#ifdef STATLINE
				if(Tfile)
					pstat("Sending resumed");
#endif
				charsent=0;
				Waitecho=Txwait=FALSE;
				Txgo=TRUE; break;
			}
			outp(CDATA, cfast);
			if(++bufcdq >= bufend)
				bufcdq=bufst;
			continue;
		}
		if(Pflag && bufpcdq!=bufcq && POREADY) {
#ifdef CPM
			bios(5, *bufpcdq++);
#endif
			if(bufpcdq >= bufend)
				bufpcdq=bufst;
		}
		if(CIREADY) {
			if((cfast= CICHAR&0177)==Special)
				return;
			else if(cfast==XON && Tfile && !Txgo)
				goto cxon;
			else if(cfast==XOFF && Tfile && Txgo)
				goto cxoff;
txstuff:
			outp(MODATA, cfast);
			if(Hdx) {
				*bufcq++ =cfast;
				goto hdxstuff;
			}
		}
		if(MOREADY) {
			if(abptr) {
				if(cfast= *abptr++)
					goto txstuff;
				else
					abptr=NULL;
			}
			if(Tfile && !Txwait && !Waitecho && Txgo) {
				cfast= getc(fin);
#ifdef CPM
				if(cfast==EOF || cfast==CPMEOF)
#else
				if(cfast==EOF)
#endif
				{
					closetx();
					if(Exoneof)
						return;
					else
						continue;
				}
				if(Waitbunch && ++charsent==Waitnum) {
					charsent=0;
					if(Waitnum>1) {
						Waitecho=TRUE; Timeout=0;
					} else {
						Txwait=TRUE; Txtimeout=Throttle;
					}
				}
				if(cfast=='\r') {	/* end of line processing */
					switch(Txeoln) {
					case EOL_NL: continue;
					case EOL_CRPROMPT:
					case EOL_CRWAIT:
						Waitecho=TRUE; Timeout=0;
					case EOL_CR:
						if((c=getc(fin))!='\n')
							ungetc(c, fin);
						break;
					}
				}
				cfast &= txmask;
				goto txstuff;
			}
		}
		if(++Timeout == Tpause) {
			Waitecho=FALSE;
			if(Xoffflg) {
				dumprxbuff();
				if(bufcdq != bufcq)
					continue;
				if(Pflag && bufpcdq != bufcq)
					continue;
				Free=Bufsize;
				Xoffflg=FALSE;
				outp(MODATA, XON);
			}
		}
		if(--Txtimeout==0)
			Txwait=FALSE;
	}
}
/* open a capture file and set the removal pointer to get max goods */
opencapt(name)
char *name;
{
	dumprxbuff(); closerx(TRUE);
	if(openrx(name)==ERROR)
		return ERROR;
	if(buffcdq==NULL)
		buffcdq=bufst;
	if(Wrapped)
		buffcdq=bufcq+1;
	if(buffcdq >= bufend)
		buffcdq=bufst;
	dumprxbuff();
}


dumprxbuff()
{
	register c;

	if(!Rfile || buffcdq==NULL)
		return;
	while(buffcdq != bufcq) {
		c= *buffcdq++;
		if(buffcdq >= bufend)
			buffcdq=bufst;
		if(!Image) {
			switch(c &= rxmask) {
			 case 0:
				 continue;
			case 032:		/* ^Z or CPMEOF */
				if(Zeof) {
					closerx(TRUE);
					return;
				}
				else
#ifdef CPM
					continue;
#else
					break;
#endif
			case 022:
				if(Squelch) {
					Dumping=TRUE;
					continue;
				}
				break;
			case 024:
				if(Squelch) {
					Dumping=FALSE;
					continue;
				}
				break;
			default:
				break;
			}
		}
		if(Dumping)
			if(putc(c, fout)==ERROR) {
				printf("\nDisk Full\n");
				closerx(FALSE);
				return ERROR;
			}
	}
	return OK;
}

rewindcb()
{
	bufcdq=buffcdq=bufpcdq=Wrapped?bufcq+1:bufst;
}

/* replot redisplays the buffer contents thru putchar allowing XOFF */
/* number will represent how many lines to go back first */
replot(number)
unsigned number;
{

	bufcdq=Wrapped?bufcq+1:bufst;
	while(bufcdq != bufcq) {
		putchar(*bufcdq++);
		if(bufcdq >= bufend)
			bufcdq=bufst;
	}
}
 {
		c= *buffcdq++;
		if(buffcdq >= bufend)
			buffcdq=bufst;
		i