/*
>>:yam5.c 8-13-81
 * setbaud(nbaud) If legal rate, set modem registers and Baudrate
 */
#include "yam.h"

#ifdef TUART
/*
 * set baud rate for modem driven by Cromenco TUART
 */
setbaud(nbaud)
unsigned nbaud;
{
	char command, baudcmd;
	command=0;
	switch(nbaud) {
		case 110: baudcmd=0001;break;
		case 150: baudcmd=0202;break;
		case 300: baudcmd=0204;break;
		case 1200: baudcmd=0210;break;
		case 2400: baudcmd=0220;break;
		case 4800: baudcmd=0240;break;
		case 9600: baudcmd=0300;break;
		case 19200: baudcmd=0220;command=020;break;
		case 38400: baudcmd=0240;command=020; break;
	default:
		return ERROR;
	}
	outp(Sport, baudcmd);
	outp(Sport+2, command);
	Baudrate=nbaud;
	return 0;
}
#endif
#ifdef Z89
/*
 * Routine to set baud rate for 8250 driven modem port
 */
setbaud(nbaud)
unsigned nbaud;
{
	unsigned bcmd;

	if(nbaud==0)
		return ERROR;
	bcmd= 57600;		/* 1.8432 Mhz clock */
	bcmd /= (nbaud/2);	/* this must be done unsigned! */
	outp(Dport+3, 0203);    /* enable divisor latch */
	outp(Dport, bcmd);
	outp(Dport+1, (bcmd>>8));
	/* 8 data bits, 1 stop bit (2 if 110 baud), disable divisor latch */
	outp(Dport+3, nbaud==110? 07:03);
	outp(Dport+4, 03);	/* turn dtr and rts on */
	Baudrate=nbaud;
/*
	printf("bcmd=%d bcmdms=0%o bcmdls=0%o\n",bcmd,(bcmd>>8),(bcmd&0377));
*/
	return 0;
}
#endif

/*
 * Readline from MODEM13.C rewritten to allow much higher
 * baud rates.
 * Timeout is in deciseconds (1/10th's)
 * For top speed, character ready is checked in many places.
 * returns TIMEOUT if kbd character is ready.
 */
readline(decisecs)
{
	char kbhit();
	if(MIREADY)
		return MICHAR;
	while(--decisecs>=0) {
		if(MIREADY)
			return MICHAR;
		if(CIREADY)
			return TIMEOUT;
		if(MIREADY)
			return MICHAR;
		for(Timeout=T1pause; --Timeout; )
			if(MIREADY)
				return MICHAR;
	}
	return TIMEOUT;
}

sendline(data)
char data;
{
	while(!MOREADY)
		;
	outp(MODATA, data);
}
purgeline()
{
	while(MIREADY)
		MICHAR;
}

/* default "autodial" routine */
#ifndef AUTODIAL
dial(name)
char *name;
{
	printf("%s", name);
	return OK;
}
#endif

, disable div