@Style(TopMargin 1 lines, BottomMargin 1 lines,LeftMargin 1 chars,
HeaderSpacing 1 lines, FooterSpacing 1 lines,
Indent 0 chars)
@Comment(This file is intended as text input for Scribble, a product
of Mark of the Unicorn Inc.)
@Center'YAM (Yet Another Modem program)'
@Center'by Chuck Forsberg'

Yam performs a number of "Super-Terminal" functions.
It may be regarded as a (not proper) superset of MODEM7.
Commands and subcommands are listed below.

@Description<
bm@\
Set baudrate to m. Example: "b19200"

call name@\
Dial the telephone number corresponding to name.
If autodial is not supported, the telephone number and preferred
baudrate are displayed.  It is not necessary to type the entire name as it
appears in the file.
Example: "call tcbbs" or "call tc"

cd name@\
Change Directory to name.  For CP/M systems, name consists of a one
letter disk designator followed by an optional user number.
Example: "cd b0"

cpm@\
Dump cpature buffer if a recrive file is open, close files and return to
operating system.
^C will also get you there, but much more abruptly.

dir [pattern ...]@\
Display pathnames matching pattern alphabetized across the page.
The usual ambiguous filenames are allowed under CP/M provided a correct
version of setfcb() is used.
Since dir or any other commands which accept a pattern use the circular buffer
for filename expansion, be sure to write out any captured data first!
Example: "dir" "dir *.c" "dir *.c *.h"

dirr [pattern ...]@\
Displays the directory with the number of sectors in each file.
The number of files matched, number of blocks, number of kb allocated
to those files, and estimated transmission time at the current baudrate
for all files listed are displayed.
Transmission time estimate is based on batch transmission from a
Z89 with 700kb Tandon drives to a Cromenco 4mHz 4fdc
system with Persci 277 drive.
Time includes file i/o but not error correction.

d{mode}@\
Disable mode, where mode is 1 or more of the following.
(Modes affecting file transmission/reception affect term mode; the "s" and
"r" commands always send data transparently.
@Description<
>
@Description<

e@\
Exit from term mode when EOF is encountered on transmitted file.

f@\
Full duplex.

h@\
Half Duplex.

g@\
Resumes (GO) sending file once in term mode, equivalent to XON.

i@\
Image transparent data capture, all 8 bits of all characters received,
including NULLS.
This overrides the t and/or z modes.

l@\
List unit (Printer) on.
Since the printer is separately buffered, it needn't be as fast as the
incoming data as long as the difference doesn't exceed the buffer size.
The rewind command may be used to get extra copies of the received data.

n@\
Send NEWLINE (lf) only when transmitting file (no CR).

p@\
Send CR only at end of line, and then pause until echoes from remote
have stopped.  Useful for sending files to bulletin boards where the remote
needs time to prepare for the next text line.

r@\
Send CR only at the end of each transmitted line.

s@\
Squelch captured data with ^T and unsquelch with ^R.
These characters are not copied to the file.
This mode must be set/reset as desired BEFORE opening the receive file.

t@\
If Waitnum is more than 1, wait for echoes to stop after sending
each Waitnum characters for period Pause.
If Waitnum==1, send at
1/Throttle, measured in loops of the term() function.
The default values of Waitnum and Throttle provide transmission
at about 80 words per minute regardless of baud rate.

w@\
Wait to receive a newline afrer sending a CR at the end of a line.

z@\
Terminate data capture and close file when ^Z is received.
Otherwise ^Z is ignored.
It should be noted that The Source coughs up an occasional ^Z just as UPI
is about to output something interesting.

>

e{mode}@\
Enable 1 or more modes described with the d command.

f[mode] name@\
Open name for sending in term.
The optional mode enables one or modes of the "e" command.

help@\
Displays this file
This command closes any open send file.

initialize@\
Initializes yam to all its default values.
Does not reset the disk system (see "reset").

kill@\
Resets all pointers associated with the capture buffer, thus effectively
killing its contents.

l pattern [...]@\
Display the files specified by the possibly ambiguous pattern(s).
This command closes any open send file.
List stops/resumes printing with ^S.
Typing ^X cancels, and any other character skips to the next file.

mn@\
Change modem data port to (decimal) n.
Example: "m224"

pxm@\
Set Parameter x to value m.

@Description<
>
@Description<

aname@\
Set the alternate root to name.
If the "a" option is selected for the "r" command,
a batch mode file with the same name as a current file will be received
with the file name "nameN".
N starts at 1 each time the "a" parameter is set.
Default name is "TEMP." resulting in "TEMP.1" as the first generated name.

s@\
Set Special to decimal m.
Special is the character which exits from term mode, normally ^E.

wn@\
Set Waitnum to n.
See "w" mode for details.
Default is 1.

tm@\
Set Throttle to m.
The default value corresponds to about 80 words per minute sending speed.

pm@\
Set Pause to m.
When the free characters in the circular buffer reach 400, an XOFF is
sent.
Pause controls the time which must then pass without characters
received before believing
that the other end really has obeyed the XOFF character, as opposed to
the sometimes lengthy Compuserve hitches in the getalong.
If Pause is too short, it is possible that a lurch in output will be
interpreted as acknowledgement of the XOFF, only to have more characters
arrive whilst yam is occupied dumping the buffer
to disk.
When this happens, unfortunate characters are routed to the proverbial
bit bucket, and you can retry the download as the timesharing service
increments the connect charge.
The default value seems suitable for Source over Tymnet and BBS systems.
Pause is also the echo wait period used with the "p" mode.

>
reset [size]@\
Dump the capture buffer (if on), close all files, and
reset the disk system (this allows swapping diskettes).
The optional argument size becomes the size of the circular capture
buffer.

replot [m]@\
Redisplay the last m lines received from the modem.
If m is absent, redisplay the maximum possible.
Output is through CP/M, allowing XOFF and tabbing to work.

rewind@\
Rewind the buffer pointers for the display, printer, and file dump
from term mode.
The effect of this command is the same as if the data had been sent
another time.

r[options] [file ...]@\
Receive with options 1 or more files using the Wayne Christensen protocol.
If no filename is given, batch mode is assumed.
(Note: batch mode is not compatible with MODEM7.)
If more than one filename is given, a single file transfer will be made for
each.
Options are:
@Description<
>
@Description<
a@\
Alternate file name mode.
If an incoming file has the same name as one already on disk,
yam generates an alternate name for the now file.
Implies batch mode.

b@\
Batch mode.
Pathnames are provided by the sender.
Disk names are excluded from the transmitted pathname(s),
and may not be specified for batch mode reception
(use the change directory command).

q@\
Quiet mode inhibits some of the status information.
Quiet mode is not necessary for proprer operation at higher
baudrates.

t@\
Goto term mode after file transfer(s).

v@\
View the data being transmitted.
On receive, only correct data is displayed.
Viewing ascii files
does not interfere with correct transmission at high baud rates,
although throughput will be affected.
For each sector, data is viewed once before sending/after receiving.

y@\
Yes it is OK to clobber a file already on disk.
If absent, the operator is promped for a y or n decision.
>

s@\
Displays status information.

s[options] pattern ...@\
If batch mode is specified with the b option, 0 or more files are sent
according to the ambiguous pathname(s).
If batch mode is not specified, the named unambiguous file(s) are sent
each in single file mode.

t[c][mode] [file]@\
Term mode with optional capture to file.
The c option causes data already in the capture buffer to be written
to file, which is then closed.
For convenience, mode (see "e") may be enabled.
A receive file previously opened by t file will not be closed
by a t command without a file name.
While in term mode, the keyboarded characters are transmitted except for
@Enumerate(
^E
Exits from term mode back to main command level.

^Q
Iff a send file is open and its transmission has been stopped by a
XOFF, transmission is resumed.
Otherwise no special treatment.

^S
Iff a send file is open and it is being transmitted,
transmission is stopped.
Otherwise no special treatment.
)
The following received characters are recognized in term mode, when
they are fetched from the circular buffer for the display.
@Enumerate(
ENQ
Triggers transmission of the ANSWERBACK.

XOFF
Stops file transmission from yam.

XON
Resumes file transmission.

TAB
Tab characters are expanded on the display.
)

wrt@\
Write dumps the circular buffer to the receive file, if open.

;@\
Semicolon delimits commands about the same as CR.
Since commands such as "t" have an indefinite number of operands,
the semicolon must be used to string them together.
Example: "f foo te;f foo.1 t;" sends the two files in succession
without opening a (new) receive file.
>
A sample session might be:

A0>yam b19200 cd b (set 19kb, change to b disk)

dirr yam?.? yamhlp.mss	(list files and calculate xmsn time)

sb yam?.? yamhlp.mss	(send them to a local system)

m224	(switch to modem port)

call hydepark	(Can't remember the phone number!)

b450	(450 baud)

t	(go to term mode, log in, run minicbbs, begin entering a message)

.......

^E

etp f letter t	(enable prompt and throttle modes, open letter and send to bbs)



Notes
@Itemize<
The transmission of pathnames in batch mode differs from that used in
MODEM7.
Yam sends the pathname as a null terminated string in a standard
Wayne Christensen type packet
with sector a number of 0.
Disk specifiers (B:) are not sent.
The sender waits for an initial NAK before sending the pathname.
An explicit NAK is sent by the receiver at intervals
when is ready to receive a pathname.
Upon receiving the pathname, the receiver opens the file and then sends
an initial NAK for the data in the file.
A null pathname terminates batch transmission.


File transmission is compatible with MODEM7 in single file mode.
File transmission may be aborted by sending a sequence of CAN (^X)
of characters.
Each character keyboarded will cause readline() to return a TIMEOUT
error, thus regaining keyboard control relatively easily.

Files may be sent with handshaking
at 19200 baud from a Z89 (2 mHz) to a Cromenco 4mHz
system and 9600 baud the other way.
File reception in term mode works well up to 9600 baud on a Z89 provided
the printer is off.
File reception on a Cromenco with a 300 baud printer works fine at 2400
baud.
Baudrate selection routines are provided for the Cromenco TUART and
Z89 serial board (8250's).

In term mode, use of the circular buffer provides some advantages.
@Enumerate<
Incoming data may come in at a rate higher than the display and/or
printer.
Tab expansion for the display does not compromise this ability.

The user may decide to save a timesharing session on the disk AFTER
it has started (or possibly even finished) as long as the buffer pointers
have not wrapped around.

The same ability also applies to the printer.
The printer need not be as fast as the modem as long as the Tortoise is
allowed to catch up.

Received data may be redisplayed (rep command).
A future version might allow scrolling and/or string searching.
>
At high speeds, the display will fall behind the incoming data,
as storing of raw modem data into the buffer takes precedence over
all else.
As a result,
a defective or incorrectly programmed modem port which sources data
at high speed can lockout the keyboard.
If yam "goes away" when entering term mode, this may be the cause.

If insufficient stack space is provided above the end of the circular
buffer, yam may sulk when attempting to exit from term mode.

The enable t and z modes affecting data capture are executed when the circular
buffer is written to the receive file, not as the characters are first
received from the data port.
>

it has started (or possibly even finished) as long as the buffer pointers
ha