;
;Revised include file which excludes z80 opcodes, so 
; this program may be run on an 8080 or 8085 cpu
;
;DASMZLG.asm from DASM.ZLG (ver. >= 3.0)
;This routine is the ZILOG mnemonic disassembler module for DASM.MAC.
;It is included into DASM during assembly under M80.
;
	IF1
	.PRINTX	/DASM with ZILOG-Standard Mnemonics/
	ENDIF
;
;  This is the Header to be printed for this module
;
HEADER:
	DEFB	'DASM for ZILOG-Standard Mnemonics',0dh,0ah
	DEFB	'	Derived from ZZSOURCE/RESOURCE',0dh,0ah
	DEFB	'$',0
;
;  This is the Disassembler Module -- Instruction to be disassembled
;    is pted to by PC
;
DASM:
	CALL	HSYM		;WRITE A SYMBOL IF IT EXISTS
	;.. AND PUT PC ON THE CRT
	LD	HL,(RPLPTR)	;SEE IF THIS LINE IS REPLACED
	LD	A,H
	OR	L
	jp	Z,DASM1
	LD	B,(HL)
	INC	HL		;SKIP THE '*'
	DEC	B
	CALL	NWLN0		;PRINT THE REPLACING LINE AS A COMMENT
DASM1:
	LD	HL,(PC)	
	EX	DE,HL
	LD	HL,(OFFSET)
	ADD	HL,DE		;HL IS NOW THE BIASED PC
	LD	(BIASED),HL
	EX	DE,HL		;DE IS NOW THE BIASED PC
	INC	HL
	LD	(PC),HL		;THE NEW PC (NEXT BYTE)
	EX	DE,HL		;DE IS THE BYTE AFTER THE INSTRUCTION
	LD	B,(HL)
	LD	HL,OPC-4
	CALL	GTCD
	CALL	TYPEOC
	CP	0AH		;TYPES 0 THRU 9 ARE 1 BYTE
	jp	C,OLDPC		; .. SO DON'T CHANGE THE PC
	LD	HL,(PC)
	INC	HL
	CP	10H		;TYPES 0A THRU 0FH ARE 2-BYTERS
	jp	C,NEWPC
	CP	16H		;TYPES 10H THRU 15H ARE 3 BYTES
	jp	NC,NEWPC
	INC	HL
NEWPC:
	LD	(PC),HL
OLDPC:
	PUSH	DE		;SAVE THE 'E' REGISTER (MAY BE 'X' OR 'Y')
	LD	E,A
	LD	D,0
	LD	HL,JMPTBL
	ADD	HL,DE		;ADD 2*OPCODE TYPE TO JMPTBL TO GET
	ADD	HL,DE		;.. ROUTINE ADDRESS
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;HL NOW CONTAINS THE ROUTINE ADDRESS
	POP	DE
	PUSH	HL
	LD	HL,(BIASED)
	RET			;'RETURN' TO THE ROUTINE
;
GTCD:
	LD	DE,4
NXTCD:
	ADD	HL,DE
NXTCD1:
	LD	A,(HL)
	OR	A		;SEE IF WE'RE AT THE NEXT MASK YET
	INC	HL
	JP	P,NXTCD1	;JUMP IF NOT
	AND	B		;MASK OUT VARIABLES IN THE INSTRUCTION
	CP	(HL)		;CHECK THE GENERIC INSTRUCTION TYPE
	jp	NZ,NXTCD
	INC	HL
	LD	A,(HL)		;AFTER A MATCH, GET THE OPCODE TYPE
	LD	(OPCTP),A
	RET	
;
TOC2:
	CP	20H		;CONVERT SPACES IN THE TABLE TO TABS
	jp	NZ,TOC1
	LD	A,9
TOC1:
	CALL	COUT
TYPEOC:
	INC	HL		;TYPE THE OPCODE THAT HL IS POINTING TO
	LD	A,(HL)
	OR	A
	jp	Z,TYPEOC
	JP	P,TOC2
	LD	HL,(PC)
	LD	A,(OPCTP)
	RET	
;
JMPTBL:
	DEFW	T0		;SIMPLE 1 BYTE INSTRUCTIONS
	DEFW	T1		;8 BIT, REGISTER ARITHMETIC & LOGICAL
	DEFW	T2		;DEC & INC
	DEFW	T3		;DOUBLE REGISTER SINGLE BYTE ARITHMETIC
	DEFW	T4		;8 BIT LOAD FROM MEMORY
	DEFW	T5		;8 BIT LOAD TO MEMORY
	DEFW	T6		;POP's AND PUSH's
	DEFW	T7		;CONDITIONAL RETURNS
	DEFW	T8		;THE RST INSTRUCTIONS
	DEFW	T9		;REGISTER TO REGISTER LOADS
;2 BYTE INSTRUCTIONS
	DEFW	TA		;8 BIT LOAD IMMEDIATES
	DEFW	TB		;8 BIT IMMEDIATE ARITH. & LOGICAL
	DEFW	TC		;IN A,(n)
	DEFW	TD		;OUT (n),A
	DEFW	TE		;CONDITIONAL, RELATIVE JUMPS
	DEFW	TF		;OTHER RELATIVE JUMPS
;3 BYTE INSTRUCTIONS
	DEFW	T10		;16 BIT LOADS
	DEFW	T11		;JUMPS & CALLS
	DEFW	T12		;DIRECT LOADS
	DEFW	T13		;DIRECT STORES
	DEFW	T14		;LD (nn),A
	DEFW	T15		;CONDITIONAL JUMPS & CALLS
;MULTI-BYTE OPCODES
	DEFW	T16		;THE 'CB' SERIES {1, 1A, 2A}
	DEFW	T17		;THE 'DD' SERIES {1B thru 25 & 2A}
	DEFW	T18		;THE 'FD' SERIES {1B thru 25 & 2A}
	DEFW	T19		;THE 'ED' SERIES {0, 2, 3, 26 thru 2A}
;1 BYTE
	DEFW	T1A		;THE BIT, RES & SET FOR 'CB'
	DEFW	T1B		;INDEX REGISTER LOADS
	DEFW	T1C		;JUMP INDIRECT INDEX REGISTER
	DEFW	T1D		;INDEX REGISTER ADD
;2 BYTE
	DEFW	T1E		;INDEX REGISTER ARITH. AND LOGICAL
	DEFW	T1F		;INDEXED LOAD TO REGISTER
	DEFW	T20		;INDEXED REGISTER STORE
;3 BYTES AFTER 'DD' OR 'FE'
	DEFW	T21		;LD xx,nn
	DEFW	T22		;LD (nn),n
	DEFW	T23		;LD xx,(nn)
	DEFW	T24		;LD (xx+d),n
	DEFW	T25		;THE 'CB' EXTENSIONS TO 'DD' OR 'FD'
;1 BYTE AFTER 'ED'
	DEFW	T26		;IN r,(C)
	DEFW	T27		;BLOCK MOVES
;3 BYTES AFTER 'ED'
	DEFW	T28		;LD (nn),dd
	DEFW	T29		;LD dd,(nn)
;WHATEVER IS LEFT
	DEFW	T2A		;INDEFINED OPCODES	
;
;ONE BYTE INSTRUCTIONS, SIMPLE
;
T0:
	JP	DCRLF
;
;ARITHMETIC & LOGICAL, 8 BIT, REGISTER
;
T1:
	CALL	PSREG		;PRINT THE SOURCE REGISTER
	JP	DCRLF
;
;DEC AND INC INSTRUCTIONS
;
T2:
	CALL	PDREG		;PRINT THE DESTINATION REGISTER
	JP	DCRLF
;
;DOUBLE REGISTER SINGLE BYTE
;
T3:
	CALL	PXSREG		;PRINT HL, DE, BC, OR SP
	JP	DCRLF
T4:
	CALL	LPAR		;  LD A,(BC or DE)
	CALL	PXSREG
	CALL	RPAR
	JP	DCRLF
T5:
	CALL	LPAR		;  LD (BC or DE),A
	CALL	PXSREG
	CALL	RPAR
	CALL	PCMAA
	JP	DCRLF
;
;POP AND PUSH
;
T6:
	CALL	PXQREG		;PRINT HL, DE, BC, OR AF
	JP	DCRLF
;
;CONDITIONAL RETURNS
;
T7:
	CALL	PRCND
	JP	DCRLF
;
;THE RST INSTRUCTIONS
;
T8:
	LD	A,(HL)
	AND	38H
	CALL	PRST
	JP	DCRLF
;
;REGISTER TO REGISTER LOADS
;
T9:
	CALL	PDREG
	CALL	COMMA
	LD	HL,(BIASED)
	CALL	PSREG
	JP	DCRLF
;
;TWO BYTE INSTRUCTIONS
; 8 BIT IMMEDIATE LOADS
;
TA:
	CALL	PDREG
	CALL	COMMA
	LD	HL,(BIASED)
;ARITHMETIC & LOGICAL IMMEDIATES
TB:
	INC	HL
DTABYT:
	LD	A,(HL)
	CP	' '
	jp	C,NOTASC
	CP	5BH
	jp	NC,NOTASC
	CALL	PASCII
	LD	A,''''
	CALL	COUT
	LD	A,(XCSW)	;WANT SYMBOL COMMENTS?
	OR	A
	JP	Z,DCRLF
	CALL	TAB
	CALL	SEMI
NOTASC:
	LD	A,(HL)
	CP	0AH
	jp	C,NTSC0
	CALL	PASHEX
	LD	A,'H'
	CALL	COUT
	JP	DCRLF
NTSC0:
	ADD	A,'0'
	CALL	COUT
	JP	DCRLF
;
;IN
;
TC:
	CALL	LPAR		;FOR 'IN A,(C)'
	INC	HL
	LD	A,(HL)
	CALL	PASHEX
	LD	A,'H'
	CALL	COUT
	CALL	RPAR
	JP	DCRLF
;OUT
TD:
	CALL	LPAR
	INC	HL
	LD	A,(HL)
	CALL	PASHEX
	LD	A,'H'
	CALL	COUT
	CALL	RPAR
	CALL	COMMA
	LD	A,'A'
	CALL	COUT
	JP	DCRLF
;
;CONDITIONAL RELATIVE JUMPS
;
TE:
	CALL	PRCND1		;THE SPECIAL CC LIST
	LD	HL,(BIASED)
	CALL	COMMA
;OTHER RELATIVE INSTRUCTIONS
TF:
	INC	HL
	LD	A,(HL)
	LD	E,A
	LD	D,0
	LD	HL,(PC)
	OR	A
	JP	P,PSTV
	DEC	D
PSTV:
	ADD	HL,DE
	EX	DE,HL
	CALL	PRNTDE
	CALL	C,PDERTN
	JP	DCRLF
;
;THREE BYTE INSTRUCTIONS
;16 BIT LOADS
;
T10:
	CALL	PXSREG
	CALL	COMMA
	LD	HL,(BIASED)
;JUMPS AND CALLS
T11:
	CALL	PRNN
	CALL	C,PDERTN
	JP	DCRLF
;
;LOAD DIRECT
;
T12:
	CALL	DRADR
	CALL	C,PDERTN
	JP	DCRLF
DRADR:
	CALL	LPAR		;PRINT THE VALUE FOR DE IN PARENTHESIS
	CALL	PRNN
	PUSH	AF
	CALL	RPAR
	POP	AF
	RET	
;
;STORE DIRECT
;
T13:
	CALL	DRADR
	PUSH	AF
	CALL	COMMA
	LD	A,'H'
	CALL	COUT
	LD	A,'L'
	CALL	COUT
	POP	AF
	CALL	C,PDERTN
	JP	DCRLF
;
;STORE ACCUMULATOR DIRECT
;
T14:
	CALL	DRADR
	PUSH	AF
	CALL	PCMAA
	POP	AF
	CALL	C,PDERTN
	JP	DCRLF
;
;CONDITIONAL JUMPS & CALLS
;
T15:
	CALL	PRCND
	CALL	COMMA
	LD	HL,(BIASED)
	CALL	PRNN
	CALL	C,PDERTN
	JP	DCRLF
;
;THE 'CB' SERIES LEAD IN
;
T16:
	INC	HL
	LD	B,(HL)		;THE SECOND BYTE OF THE INSTRUCTION
	LD	(BIASED),HL
	LD	HL,OPC2-4
	CALL	GTCD		;FIND THE TYPE OF THE 'CB' INSTRUCTION
	CALL	TYPEOC
	JP	OLDPC
;
;THE 'DD' SERIES LEAD IN
;
T17:
	LD	E,'X'		;FOR THE 'IX' INSTRUCTIONS
T170:
	PUSH	DE
	INC	HL
	LD	(BIASED),HL
	LD	B,(HL)
	LD	HL,OPC3-4
	CALL	GTCD
	CALL	TYPEOC
	POP	DE
	CP	1EH
	JP	C,OLDPC
	CP	2AH
	JP	Z,OLDPC
	CP	21H
	INC	HL
	JP	C,NEWPC
	INC	HL
	JP	NEWPC
;
;THE 'FD' SERIES LEAD IN
;
T18:
	LD	E,'Y'
	jp	T170
;
;THE 'ED' SERIES LEAD IN
;
T19:
	INC	HL
	LD	(BIASED),HL
	LD	B,(HL)
	LD	HL,OPC4-4
	CALL	GTCD
	CALL	TYPEOC
	CP	28H
	JP	C,OLDPC
	CP	2AH
	JP	Z,OLDPC
	INC	HL
	INC	HL
	JP	NEWPC
;
;BIT, RES AND SET
;
T1A:
	CALL	PBIT
	CALL	COMMA
	CALL	PSREG
	JP	DCRLF
;
;INDEX REGISTER MOVES
;
T1B:
	CALL	PRXX		;TO TYPE EITHER 'IX' OR 'IY'
	JP	DCRLF
;
;JUMP INDIRECT TO INDEX REGISTER
;
T1C:
	CALL	LPAR
	CALL	PRXX
	CALL	RPAR
	JP	DCRLF
;
;INDEX REGISTER ADDITION
;
T1D:
	CALL	PRXX
	CALL	COMMA
	LD	A,E
	CP	'X'
	LD	A,(HL)
	LD	HL,IXREGS
	jp	Z,T1D0
	LD	HL,IYREGS
T1D0:
	CALL	PXREG
	JP	DCRLF
;
;INDEX REGISTER ARITHMETIC AND LOGICAL
;
T1E:
	INC	HL
	CALL	PDISP		;PRINT '(IX(Y)+d)
	JP	DCRLF
;
;INDEXED LOAD TO REGISTER
;
T1F:
	CALL	PDREG
	CALL	COMMA
	LD	HL,(BIASED)
	INC	HL
	CALL	PDISP
	JP	DCRLF
;
;INDEXED REGISTER STORE
;
T20:
	INC	HL
	CALL	PDISP
	CALL	COMMA
	LD	HL,(BIASED)
	CALL	PSREG		
	JP	DCRLF
;
; LD xx,nn
;
T21:
	CALL	PRXX
	CALL	COMMA
	CALL	PRNN
	CALL	C,PDERTN
	JP	DCRLF
;
; LD (nn),xx
;
T22:
	CALL	LPAR
	PUSH	DE
	CALL	PRNN
	EX	DE,HL		;HL NOW CONTAINS THE NUMBER
	POP	DE		;RECOVER THE 'E' REG.  ('X' OR 'Y')
	PUSH	AF		;SAVE THE CARRY FOR A LATER 'PEDRTN'
	CALL	RPAR
	CALL	COMMA
	CALL	PRXX
	POP	AF		;THE CARRY FLAG IS RESTORED
	EX	DE,HL		;DE AGAIN CONTAINS THE VALUE FOR nn
	CALL	C,PDERTN
	JP	DCRLF
;
; LD xx,(nn)
;
T23:
	CALL	PRXX
	CALL	COMMA
	CALL	LPAR
	CALL	PRNN
	PUSH	AF		;SAVE Cy VALUE
	CALL	RPAR
	POP	AF
	CALL	C,PDERTN
	JP	DCRLF
;
; LD (xx+d),n
;
T24:
	INC	HL
	CALL	PDISP
	CALL	COMMA
	JP	TB
;
;THE 'CB' EXTENSIONS TO 'DD' OR 'FD'
;
T25:
	INC	HL
	INC	HL
	LD	B,(HL)
	LD	HL,OPC2-4
	PUSH	DE		;SAVE 'X' OR 'Y'
	CALL	GTCD
	CALL	TYPEOC
	POP	DE
	LD	A,B		;GET THE O.C.
	AND	7
	CP	6
	jp	NZ,ILLEG
	LD	A,(OPCTP)
	LD	HL,(BIASED)
	CP	1AH
	JP	C,T1E
	jp	Z,DD12
ILLEG:
	LD	HL,(PC)
	DEC	HL
	DEC	HL
	LD	(PC),HL
	JP	T2A
DD12:
	INC	HL
	INC	HL
	CALL	PBIT
	CALL	COMMA
	DEC	HL
	DEC	HL
	JP	T1E
;
; IN r,(C)
;
T26:
	CALL	PDREG
	CALL	COMMA
	CALL	LPAR
	LD	A,'C'
	CALL	COUT
	CALL	RPAR
	JP	DCRLF
;
;THE BLOCK MOVES AND I/O
;
T27:
	LD	A,(HL)
	AND	8
	LD	A,'I'		;AN INCREMENTING TYPE OF INSTRUCTION?
	JP	Z,T270
	LD	A,'D'		;NO, IT WAS DECREMENTING
T270:
	CALL	COUT
	LD	A,(HL)
	AND	10H
	JP	Z,DCRLF
	LD	A,'R'		;A REPEATING INSTRUCTION TYPE
	CALL	COUT
	JP	DCRLF
;
; LD (nn),dd
;
T28:
	CALL	LPAR
	CALL	PRNN
	PUSH	AF		;SAVE Cy VALUE
	PUSH	DE		;SAVE THE 'NN' VALUE
	CALL	RPAR
	CALL	COMMA
	LD	HL,(BIASED)
	CALL	PXSREG
	POP	DE
	POP	AF
	CALL	C,PDERTN
	JP	DCRLF
;
; LD dd,(nn)
;
T29:
	CALL	PXSREG
	CALL	COMMA
	LD	HL,(BIASED)
	CALL	LPAR
	CALL	PRNN
	PUSH	AF
	CALL	RPAR
	POP	AF
	CALL	C,PDERTN
	JP	DCRLF
;
;ALL UNDEFINED OPCODES COME HERE FOR A 'DB VALUE' TREATMENT
;
T2A:
	LD	HL,(PC)
	DEC	HL
	LD	(PC),HL
	LD	HL,(BIASED)
	DEC	HL
	CALL	PSTG
	DEFB	'DB',9,0
	JP	DTABYT
;
;  VARIOUS CHARACTERS TO PRINT
;
COMMA:
	LD	A,','
	JP	COUT
TAB:
	LD	A,9
	JP	COUT
SEMI:
	LD	A,';'
	JP	COUT
LPAR:
	LD	A,'('
	JP	COUT
RPAR:
	LD	A,')'
	JP	COUT
PCMAA:
	CALL	COMMA
	LD	A,'A'
	JP	COUT
;
;  PRINT THE CONDITION CODE LETTERS FOR THIS INSTRUCTION.
;
PRCND:
	LD	A,(HL)
	AND	38H		;FOR A FULL SET OF CONDITION CODES
PRC:
	RRCA	
	RRCA	
	LD	HL,CNDTAB
	CALL	SKIP
	LD	A,(HL)
	CALL	COUT
	INC	HL
	LD	A,(HL)
	CP	'.'
	CALL	NZ,COUT
	RET	
PRCND1:
	LD	A,(HL)
	AND	18H
	jp	PRC
CNDTAB:
	DEFB	'NZZ.NCC.POPEP.M.'
;
;  PRINT THE SOURCE REGISTER FOR A BYTE
;
PSREG:
	LD	A,(HL)
PREG:
	LD	HL,REGTAB
	AND	7
	CP	6		;MUST CATCH THE (HL) REFERENCES
	JP	Z,PHLREG
	CALL	SKIP
	LD	A,(HL)
	JP	COUT
PHLREG:
	CALL	LPAR
	LD	A,'H'
	CALL	COUT
	LD	A,'L'
	CALL	COUT
	JP	RPAR
PDREG:
	LD	A,(HL)		;PRINT THE DESTINATION REGISTER FOR A BYTE
	RRA	
	RRA	
	RRA	
	JP	PREG
;
;  ADVANCE H&L BY (A)
;
SKIP:
	ADD	A,L
	LD	L,A
	RET	NC
	INC	H
	RET	
REGTAB:
	DEFB	'BCDEHLMA'	;'M' IS NEVER PRINTED - '(HL)' IS INSTEAD
;
;  PRINT A DOUBLE REGISTER PAIR
;
PXSREG:
	LD	A,(HL)
	LD	HL,DREGS
	jp	PXREG
PXQREG:
	LD	A,(HL)
	LD	HL,DREGQ
PXREG:
	RRA	
	RRA	
	RRA	
	AND	6
	CALL	SKIP
	LD	A,(HL)
	CALL	COUT
	INC	HL
	LD	A,(HL)
	JP	COUT
DREGS:
	DEFB	'BCDEHLSP'
DREGQ:
	DEFB	'BCDEHLAF'
IXREGS:
	DEFB	'BCDEIXSP'
IYREGS:
	DEFB	'BCDEIYSP'
;
PBIT:
	LD	A,(HL)
	RRA	
	RRA	
	RRA	
	AND	7
	ADD	A,'0'
	JP	COUT
PRXX:
	LD	A,'I'
	CALL	COUT
	LD	A,E
	JP	COUT
;
;PRINT A LEADING QUOTE AND THEN THE ASCII
;.. (PRINT '' FOR ').
;
PASCII:
	PUSH	AF
	LD	A,''''
	CALL	COUT
	POP	AF
	CP	''''
	JP	NZ,COUT
	PUSH	AF
	CALL	COUT
	POP	AF
	JP	COUT
;PRINT THE VALUE IN A AS HEX
;  WITH A LEADING ZERO IF NECESSARY
PASHEX:
	CP	0A0H
	JP	C,PHEX
	PUSH	AF
	LD	A,'0'
	CALL	COUT
	POP	AF
	JP	PHEX
;PRINT THE STRING AT (HL) FOR (B) CHARACTERS.
PRNT:
	LD	A,(HL)
	CALL	COUT
	INC	HL
	DEC	B
	JP	NZ,PRNT
	RET	
;
;PRINT A DISPLACEMENT IN THE FORM '(IX+d)'
PDISP:
	CALL	LPAR
	CALL	PRXX
	LD	A,'+'
	CALL	COUT
	LD	A,(HL)
	CALL	PASHEX
	LD	A,'H'
	CALL	COUT
	JP	RPAR
;
;PRINT THE NEXT 2 BYTES AS A SYMBOL (AND RETURN Cy=1) IF POSSIBLE
;
PRNN:
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
PRNTDE:
	PUSH	DE
	CALL	SYMSCH
	JP	C,NOMTCH
	CALL	PRNT		;GOT ONE, SO PRINT IT
	POP	DE
	SCF			;INDICATE THAT A SYMBOL WAS PRINTED
	RET	
NOMTCH:
	LD	A,(BUILD)	;DO WE BUILD A SYMBOL?
	OR	A
	POP	DE
	jp	Z,NOBLD		;JUST PRINT THE HEX VALUE
	PUSH	DE
	CALL	BLDSYM
	POP	DE
	jp	NOBLD
PDERTN:
	LD	A,(XCSW)
	OR	A
	RET	Z		;DON'T PRINT THE SYMBOL AS A COMMENT
	CALL	TAB		;WE'LL PRINT A VALUE AS A COMMENT
	CALL	SEMI
NOBLD:
	LD	A,D
	OR	E
	LD	A,'0'
	jp	Z,NOBLD1
	LD	A,D
	OR	A
	jp	Z,NOBLD2
	CALL	PASHEX		;PRINT THE HIGH ORDER BYTE
	LD	A,E
	CALL	PHEX
NOBLD0:
	LD	A,'H'
NOBLD1:
	CALL	COUT
	OR	A		;CLEAR THE CARRY
	RET	
NOBLD2:
	LD	A,E
PRST:
	CP	0AH
	jp	C,NOBLD3
	CALL	PASHEX
	jp	NOBLD0
NOBLD3:
	ADD	A,'0'
	jp	NOBLD1
;
;  OPCODE TABLES
;
OPC:
	DEFB	0FFH,0EBH,0,'EX DE,HL'
	DEFB	0FFH,008H,0,'EX AF,AF'''
	DEFB	0FFH,0D9H,0,'EXX'
	DEFB	0FFH,0E3H,0,'EX (SP),HL'
	DEFB	0FFH,027H,0,'DAA'
	DEFB	0FFH,0F3H,0,'DI'
	DEFB	0FFH,0FBH,0,'EI'
	DEFB	0FFH,076H,0,'HALT'
	DEFB	0FFH,02FH,0,'CPL'
	DEFB	0FFH,03FH,0,'CCF'
	DEFB	0FFH,000H,0,'NOP'
	DEFB	0FFH,037H,0,'SCF'
	DEFB	0FFH,0E9H,0,'JP (HL)'
	DEFB	0FFH,007H,0,'RLCA'
	DEFB	0FFH,017H,0,'RLA'
	DEFB	0FFH,00FH,0,'RRCA'
	DEFB	0FFH,01FH,0,'RRA'
	DEFB	0FFH,0C9H,0,'RET'
	DEFB	0FFH,0F9H,0,'LD SP,HL'
	DEFB	0F8H,088H,1,'ADC A,'
	DEFB	0F8H,080H,1,'ADD A,'
	DEFB	0F8H,0A0H,1,'AND '
	DEFB	0F8H,0B8H,1,'CP '
	DEFB	0F8H,0B0H,1,'OR '
	DEFB	0F8H,098H,1,'SBC A,'
	DEFB	0F8H,090H,1,'SUB '
	DEFB	0F8H,0A8H,1,'XOR '
	DEFB	0C7H,005H,2,'DEC '
	DEFB	0C7H,004H,2,'INC '
	DEFB	0CFH,009H,3,'ADD HL,'
	DEFB	0CFH,00BH,3,'DEC '
	DEFB	0CFH,003H,3,'INC '
	DEFB	0EFH,00AH,4,'LD A,'
	DEFB	0EFH,002H,5,'LD '
	DEFB	0CFH,0C1H,6,'POP '
	DEFB	0CFH,0C5H,6,'PUSH '
	DEFB	0C7H,0C0H,7,'RET '
	DEFB	0C7H,0C7H,8,'RST '
	DEFB	0C0H,040H,9,'LD '
	DEFB	0C7H,006H,0AH,'LD '
	DEFB	0FFH,0C6H,0BH,'ADD A,'
	DEFB	0FFH,0CEH,0BH,'ADC A,'
	DEFB	0FFH,0E6H,0BH,'AND '
	DEFB	0FFH,0FEH,0BH,'CP '
	DEFB	0FFH,0F6H,0BH,'OR '
	DEFB	0FFH,0D6H,0BH,'SUB '
	DEFB	0FFH,0DEH,0BH,'SBC A,'
	DEFB	0FFH,0EEH,0BH,'XOR '
	DEFB	0FFH,0DBH,0CH,'IN A,'
	DEFB	0FFH,0D3H,0DH,'OUT '
	DEFB	0E7H,020H,0EH,'JR '
	DEFB	0FFH,010H,0FH,'DJNZ '
	DEFB	0FFH,018H,0FH,'JR '
	DEFB	0CFH,001H,10H,'LD '
	DEFB	0FFH,0C3H,11H,'JP '
	DEFB	0FFH,0CDH,11H,'CALL '
	DEFB	0FFH,03AH,12H,'LD A,'
	DEFB	0FFH,02AH,12H,'LD HL,'
	DEFB	0FFH,022H,13H,'LD '
	DEFB	0FFH,032H,14H,'LD '
	DEFB	0C7H,0C4H,15H,'CALL '
	DEFB	0C7H,0C2H,15H,'JP '
	DEFB	0FFH,0CBH,16H,0,0
	DEFB	0FFH,0DDH,17H,0,0
	DEFB	0FFH,0FDH,18H,0,0
	DEFB	0FFH,0EDH,19H
OPC2:
	DEFB	0F8H,000H,01H,'RLC '
	DEFB	0F8H,008H,01H,'RRC '
	DEFB	0F8H,010H,01H,'RL '
	DEFB	0F8H,018H,01H,'RR '
	DEFB	0F8H,020H,01H,'SLA '
	DEFB	0F8H,028H,01H,'SRA '
	DEFB	0F8H,038H,01H,'SRL '
	DEFB	0C0H,040H,1AH,'BIT '
	DEFB	0C0H,080H,1AH,'RES '
	DEFB	0C0H,0C0H,1AH,'SET '
	DEFB	080H,000H,2AH
OPC3:
	DEFB	0FFH,0E3H,1BH,'EX (SP),'
	DEFB	0FFH,0E9H,1CH,'JP '
	DEFB	0FFH,0F9H,1BH,'LD SP,'
	DEFB	0FFH,0E1H,1BH,'POP '
	DEFB	0FFH,0E5H,1BH,'PUSH '
	DEFB	0CFH,009H,1DH,'ADD '
	DEFB	0FFH,023H,1BH,'INC '
	DEFB	0FFH,02BH,1BH,'DEC '
	DEFB	0FFH,034H,1EH,'INC '
	DEFB	0FFH,035H,1EH,'DEC '
	DEFB	0FFH,086H,1EH,'ADD A,'
	DEFB	0FFH,08EH,1EH,'ADC A,'
	DEFB	0FFH,096H,1EH,'SUB '
	DEFB	0FFH,09EH,1EH,'SBC A,'
	DEFB	0FFH,0A6H,1EH,'AND '
	DEFB	0FFH,0AEH,1EH,'XOR '
	DEFB	0FFH,0B6H,1EH,'OR '
	DEFB	0FFH,0BEH,1EH,'CP '
	DEFB	0C7H,046H,1FH,'LD '
	DEFB	0F8H,070H,20H,'LD '
	DEFB	0FFH,021H,21H,'LD '
	DEFB	0FFH,022H,22H,'LD '
	DEFB	0FFH,02AH,23H,'LD '
	DEFB	0FFH,036H,24H,'LD '
	DEFB	0FFH,0CBH,25H,0,0
	DEFB	080H,000H,2AH,0,0
	DEFB	080H,080H,2AH
OPC4:
	DEFB	0FEH,070H,2AH,0,0;PREVENTS 'IN (HL),(C)'
	DEFB	0FFH,044H,00H,'NEG'
	DEFB	0FFH,045H,00H,'RETN'
	DEFB	0FFH,046H,00H,'IM 0'
	DEFB	0FFH,056H,00H,'IM 1'
	DEFB	0FFH,05EH,00H,'IM 2'
	DEFB	0FFH,047H,00H,'LD I,A'
	DEFB	0FFH,04DH,00H,'RETI'
	DEFB	0FFH,04FH,00H,'LD R,A'
	DEFB	0FFH,057H,00H,'LD A,I'
	DEFB	0FFH,05FH,00H,'LD A,R'
	DEFB	0FFH,067H,00H,'RRD'
	DEFB	0FFH,06FH,00H,'RLD'
	DEFB	0CFH,042H,03H,'SBC HL,'
	DEFB	0CFH,04AH,03H,'ADC HL,'
	DEFB	0C7H,040H,26H,'IN '
	DEFB	0C7H,041H,02H,'OUT (C),'
	DEFB	0E7H,0A0H,27H,'LD'
	DEFB	0E7H,0A1H,27H,'CP'
	DEFB	0E7H,0A2H,27H,'IN'
	DEFB	0F7H,0A3H,27H,'OUT'
	DEFB	0F7H,0B3H,27H,'OT'
	DEFB	0CFH,043H,28H,'LD '
	DEFB	0CFH,04BH,29H,'LD '
	DEFB	080H,000H,2AH,0,0
	DEFB	080H,080H,2AH
;
;  END OF OPCODE TABLE
;
