MODULE POSITION;
(*$R+*)
(*
        These routines will allow you to emulate some
        TRS-80 functions on the SSM VB1-b.
        POINT replaces RESET(x,y), SET(x,y) and POINT(x,y)
        PRINT_AT replaces PRINT @
        CLS replaces CLS
        In addition PRTSCN will dump a mixture of GRAPHICS
        and TEXT from the VB1-b to an IDS 440G.
        RND is based on the one in 'Programming in Pascal' by
        Peter Grogono  page 118.
                  Richard  Blessing
                  June 1981       v 6
*)

TYPE
     COLOR = (WHITE, BLACK, NONE);
VAR 
    SCREEN : ABSOLUTE [$EC00] ARRAY [0 .. 15, 0 .. 63] OF CHAR; 

(* POINT 
This function will return TRUE if dot is on and FALSE
      if dot is off.
      The format of the call is:
      d := POINT( X,      Horizontal position 0 - 127
                  Y       Vertical   position 0 - 47     : integer;
                  Z       VALUE  WHITE, BLACK, NONE      : COLOR
                                                        ) : boolean;
                                                        
      The top left corner is (x,y) = (0,0),
      the bottom right corner is (x,y) = (127,47).
      A call with the COLOR NONE can be used to test
      a location without effecting the bit.
*)

FUNCTION POINT(X, Y: INTEGER; VALUE : COLOR) : BOOLEAN;
        VAR 
            BIT   : 0 .. 255;
            Y_ROW : 0 .. 47;
            X_COL : 0 .. 127;
        BEGIN
          Y_ROW := Y DIV 3;
          X_COL := X DIV 2;

          IF ODD(X) THEN
            BIT := (Y MOD 3) + 3
          ELSE
            BIT := Y MOD 3;


          CASE VALUE OF
            WHITE :     BEGIN
                      SETBIT(SCREEN[Y_ROW, X_COL], 7);
                      CLRBIT(SCREEN[Y_ROW, X_COL], BIT);
                      POINT := TRUE;
                    END;
            BLACK :     BEGIN
                      SETBIT(SCREEN[Y_ROW, X_COL], 7);
                      SETBIT(SCREEN[Y_ROW, X_COL], BIT);
                      POINT := FALSE
                    END;

            NONE :  POINT := NOT (TSTBIT(SCREEN[Y_ROW, X_COL], BIT));
          END;
        END; 

(* PRINT_AT 
This procedure will display text passed to it at
an absolute screen location. The format of the call is:
         PRINT_AT( LOC     LOC is 0 - 1023     : integer;
                   TEXT    STRING to be displayed     );
*)
            PROCEDURE PRINT_AT(I : INTEGER; DATA : STRING);
            VAR 
                X_COL : 0 .. 63;
                Y_ROW : 0 .. 15;

            BEGIN
              X_COL := I MOD 64;
              Y_ROW := I DIV 64;
              MOVE(DATA[1], SCREEN[Y_ROW, X_COL], LENGTH(DATA));
            END; 

(* CLS
              This procedure simply clears the screen.
*)
              PROCEDURE CLS;
              BEGIN
                FILLCHAR(SCREEN, 1024,CHR($BF));
              END;

(* RND
        This routine will provide pseudo random numbers in
        the form of integers 0 - 32766.
*)
              FUNCTION RND(VAR SEED : INTEGER) : INTEGER;
              CONST 
                    MULTIPILER = 27173;
                    INCREMENT  = 13849;
                    MODULUS    = 32767;

              BEGIN
                SEED := ABS(MULTIPILER * SEED + INCREMENT) MOD MODULUS;
                RND  := SEED;
              END;

(* PRTSCN
        This routine will dump the screen onto the Paper Tiger
        440G.  You may mix text and graphics.
*)

PROCEDURE PRTSCN;
CONST
  GR_ON = $03;       GR_OFF = $02;
  PP_STATUS = $06;   PP_OUT = $00;
  MASK = $01;        RESET_PP = $20;

VAR
  L, M,
  I, J, K : INTEGER;
  TEMP    : ARRAY [0 .. 47, 0 .. 127] OF BYTE;
  LINE    : ARRAY [0 .. 15] OF BOOLEAN;

  PROCEDURE DUMP(CH : BYTE);
  BEGIN
    WAIT(PP_STATUS, MASK, FALSE);
    OUT[PP_OUT] := CH;
    OUT[PP_STATUS] := RESET_PP
  END;

BEGIN
  FOR I := 0 TO 15 DO
    LINE[I] := FALSE;

  FOR I := 0 TO 15 DO
    FOR J := 0 TO 63 DO
      IF TSTBIT(SCREEN[I, J], 7) THEN
        BEGIN
          IF NOT TSTBIT(SCREEN[I, J], 0) THEN
            TEMP[I*3, J*2] := $3F;
          IF NOT TSTBIT(SCREEN[I, J], 1) THEN
            TEMP[I*3+1, J*2] := $3F;
          IF NOT TSTBIT(SCREEN[I, J], 2) THEN
            TEMP[I*3+2, J*2] := $3F;
          IF NOT TSTBIT(SCREEN[I, J], 3) THEN
            TEMP[I*3, J*2+1] := $3F;
          IF NOT TSTBIT(SCREEN[I, J], 4) THEN
            TEMP[I*3+1, J*2+1] := $3F;
          IF NOT TSTBIT(SCREEN[I, J], 5) THEN
            TEMP[I*3+2, J*2+1] := $3F
        END
      ELSE
        LINE[I] := TRUE; (* TEXT ON LINE *)

   DUMP(GR_ON);
   FOR I := 0 TO 47 DO
     BEGIN
       FOR J := 0 TO 127 DO
         FOR K := 1 TO 3 DO
           BEGIN
             IF TEMP[I, J] = $03 THEN
               DUMP($03);
             DUMP(TEMP[I,J])
           END;
       L := I MOD 3;
       IF L = 0 THEN
         BEGIN
           L := I DIV 3;
           IF LINE[L] THEN
             BEGIN
               DUMP($03);  DUMP($0D);
               DUMP($03);  DUMP(GR_OFF);
               FOR M := 0 TO 63 DO
                 IF SCREEN[L, M] >= CHR($80) THEN
                   DUMP($20)
                 ELSE
                   DUMP(SCREEN[L, M]);
               DUMP(GR_ON);
             END;
           END;
       DUMP($03); DUMP($0B);  (* VT *)
       DUMP($03); DUMP($0D);  (* CR *)
     END;
  DUMP($03);  DUMP(GR_OFF);
END;
MODEND.
_