; 22/2/80: 1117
; P.P.H. LEE,
; ROYAL MELBOURNE INSTITUTE OF TECHNOLOGY,
; APPLIED PHYSICS DEPARTMENT,
; 124 LATROBE STREET, MELBOURNE,
; VICTORIA 3000, AUSTRALIA.

; PROGRAM TO SET THE LIST DEVICE BITS OF THE SYSTEM'S
; IOBYTE TO LINE PRINTER OR TTY.
; TO EXECUTE TYPE:
; LPRINT ON	- EQUIVALENT TO STAT LST:=LPT:
; LPRINT OFF	- EQUIVALENT TO STAT LST:=TTY:

; EQUATES:
IOBYTE	EQU	3	; SYSTEM'S IOBYTE
BDOS	EQU	5	; CP/M BDOS ENTRY POINT
PRINT	EQU	9	; BDOS PRINT BUFFER
TFCB	EQU	5CH	; DEFAULT FCB

	ORG	100H

LPRINT:	LXI	H,0	; GET OLD STACK
	DAD	SP
	SHLD	STACK	; AND SAVE IT
	LXI	SP,STACK ; SET NEW STACK POINTER
	LDA	IOBYTE	; GET SYSTEM'S IOBYTE
	ANI	3FH	; CLEAR LST: BITS
	MOV	B,A	; SAVE IT FOR LATER
	LXI	H,TFCB+1
	LXI	D,ON	; CHECK FOR ON
	CALL	COMP
	JNZ	LPRNT1	; BRIF NOT
	MOV	A,B	; GET CLEARED IOBYTE TO A
	ORI	80H	; SET IT TO LPT:
	STA	IOBYTE	; REPLACE
	CALL	EXIT
	DB	'LST:=LPT:',0DH,0AH,'$'

LPRNT1:	LXI	H,TFCB+1
	LXI	D,OFF	; CHECK FOR OFF
	CALL	COMP
	JNZ	LPRNT2	; BRIF NOT
	MOV	A,B	; GET CLEARED IOBYTE TO A
	STA	IOBYTE	; REPLACE
	CALL	EXIT
	DB	'LST:=TTY:',0DH,0AH,'$'

LPRNT2:	CALL	EXIT
	DB	'++ NO ON/OFF',0DH,0AH,'$'

EXIT:	POP	D	; GET START OF MESSAGE
	MVI	C,PRINT	; PRINT MESSAGE
	CALL	BDOS
	LHLD	STACK	; GET OLD STACK
	SPHL		; RESTORE
	RET		; EXIT BACK TO CP/M

COMP:	MVI	C,3	; SET CHARACTER COUNT
COMP1:	LDAX	D	; GET TEST CHAR
	CMP	M	; COMPARE WITH INPUT CHAR
	RNZ		; RIF NOT SAME
	INX	
	INX	H
	DCR	C
	JNZ	COMP1	; BRIF SOME MORE
	RET

; DATA:
ON:	DB	'ON '
OFF:	DB	'OFF'
	DS	128	; STACK AREA
STACK:	DS	2	; OLD STACK
	END
