
NOW:	ORG	100H
	JMP	START
;
SIGNIN:	DB	' WHODERE.ASM '
XERS1:	DB	' VERSION 2.0 '
XERS2:	DB	' 3/03/82  R.H.JOHNSO',0CEH
;
;	What you say in secret,
;		shall be shouted from the house tops.
;
;
; An SAU to display sneaky Bios reads and writes.
;
SYSBIOS	EQU	0E100H	;THE BIOS TABLE WHICH WAS
			;CAN BE FOUND IN BYTES 1&2
;
NEWBIOS	EQU	0EB00H	;FREE SPACE ABOVE CP/M
			;
WASBIOS	EQU	SYSBIOS+1BH
;
;	MACRO EXPANSION
$-MACRO
;
LDIR	MACRO	;;LDIR MACRO
	DB	0EDH,0B0H
	ENDM
;
;
;
;	BIOS OVERLAY TABLE
;
SELDSK:	JMP	NEWDSK
SETTRK:	JMP	NEWTRK
SETSEC:	JMP	NEWSEC
SETDMA:	JMP	NEWDMA
SETRED:	JMP	NEWRED
SETWRT:	JMP	NEWWRT
;
;	COPY PROGRAM TO HIGH CORE
;
START:	LXI	H,PROGRAM
	LXI	D,NEWBIOS
	LXI	B,PROEND-PROGRAM	;03FFH
	LDIR
;
	LXI	H,WASBIOS
	LXI	D,OLDDSK
	LXI	B,18	;COPY OLD BIOS JUMPS FOR LATER
	LDIR
;
;
;	COPY IN NEWBIOS TABLE
;
	LXI	H,SELDSK
	LXI	D,WASBIOS
	LXI	B,18
	LDIR
;
;
	LXI	H,SIGNIN
	CALL	MSG
;	DONE
	JMP	0
;
;
;
PROGRAM:EQU	$
OFFSET:	EQU	NEWBIOS-PROGRAM
;
NEWDSK:	EQU	$+OFFSET	;CONVERT DISK # TO LETTER
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MOV	A,C		;AND DOIT
	STA	TDISK
	POP	PSW
	JMP	OLDDSK
;
NEWTRK:	EQU	$+OFFSET
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MOV	A,C		;AND DOIT
	STA	TTRACK
	POP	PSW
	JMP	OLDTRK
NEWSEC:	EQU	$+OFFSET
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MOV	A,C		;AND DOIT
	STA	TSECT
	POP	PSW
	JMP	OLDSEC
NEWDMA:	EQU	$+OFFSET
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MOV	A,B		;AND DOIT
	STA	TDMA
	MOV	A,C
	STA	TDMA+1	
	POP	PSW
	JMP	OLDDMA
NEWRED:	EQU	$+OFFSET
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MVI	A,'R'		;AND DOIT
	STA	OPCD
	POP	PSW
	CALL	CNVERT
	JMP	OLDRED
NEWWRT:	EQU	$+OFFSET
	PUSH	PSW		;PUT IN TABLE, DISPLAY
	MVI	A,'W'
	STA	OPCD
	POP	PSW
	CALL	CNVERT
	JMP	OLDWRT
;
; sample error reporting
; CONVERTS STRING POINTED TO BY HL AND PUTS
; RESULT IN MEMORY POINTED TO BY DE
CNVERT:	EQU	$+OFFSET
	PUSH	H
	PUSH	D
	LXI	H,TDISK
	LXI	D,DISK
	CALL	CVERT
;
	LXI	H,TTRACK
	LXI	D,TRACK
	CALL	CVERT
;
	LXI	H,TSECT
	LXI	D,SECT
	CALL	CVERT
;
	LXI	H,TDMA
	LXI	D,DMA
	CALL	CVERT
;
	LXI	H,TDMA+1
	LXI	D,DMA+2
	CALL	CVERT
;
	LXI	H,TABSTG
	CALL	MSG	
	POP	D
	POP	H
	RET
;
;
CVERT:	EQU	$+OFFSET
	MOV	A,M
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC	;CONVERT THE HIGH NIBBLE FIRST
	CALL	ASCII
	STAX	D	
	INX	D
	MOV	A,M	;STORE CHAR IN PRINT LINE
	ANI	0FH
	CALL	ASCII
	STAX	D
	RET		;CONVERT LOW NIBBLE
;
;
;CONVERT A TO ASCII
;
ASCII:	EQU	$+OFFSET
	ADI	30H
	CPI	'9'+1	;FE 3A OPCODE
	RM		
	ADI	7
	RET		;A NOW IN ASCIIFORM
;
;PMSG STRING POINTED TO BY HL TO CONSOLE
;MSB OF 1 IN LAST CHARACTER SENDS CR,LF.
;ZERO WILL ALSO END STRING WITH NO CR,LF...
;
;
MSG:	EQU	$+OFFSET
	MOV	C,M	;C=CHAR TO SEND TO CONSOLE
	CALL	CONOUT
	MOV	A,M
	ANI	80H
	JNZ	LFCR	;LAST ONE IF MSB=1
	INX	H
	MOV	A,M
	ORA	A	;TEST CHAR
	RZ		;C8 OPCODE
	JMP	MSG
;
;SEND CR,LF TO CONSOLE
;
LFCR:	EQU	$+OFFSET
	PUSH	B
	MVI	C,0DH
	CALL	CONOUT
	MVI	C,0AH
	CALL	CONOUT
	POP	B
	RET
;
CONOUT:	EQU	$+OFFSET
	PUSH	H
	PUSH	D
	PUSH	B
	MOV	A,C
	ANI	7FH	;STRIP HIGH BIT
	MOV	C,A
	CALL	SYSBIOS+0CH
	POP	B
	POP	D
	POP	H
	RET
;
;
;	OLD BIOS STORAGE
OLDDSK:	EQU	$+OFFSET
	DB 0,0,0
OLDTRK:	EQU	$+OFFSET
	DB 0,0,0
OLDSEC:	EQU	$+OFFSET
	DB 0,0,0
OLDDMA:	EQU	$+OFFSET
	DB 0,0,0
OLDRED:	EQU	$+OFFSET
	DB 0,0,0
OLDWRT:	EQU	$+OFFSET
	DB 0,0,0
;
;PRINT TABLE STORAGE
TABSTG:	EQU	$+OFFSET
	DB	' DSK- '
;
DISK:	EQU	$+OFFSET
	DB	20H,20H
	DB	' TRK- '
;
TRACK:	EQU	$+OFFSET
	DB	20H,20H
	DB	' SEC- '
;
SECT:	EQU	$+OFFSET
	DB	20H,20H
	DB	' DMA- '
;
DMA:	EQU	$+OFFSET
	DB	20H,20H,20H,20H
	DB	' OPCD-  '
;
OPCD:	EQU	$+OFFSET
	DB	20H,0A0H
;
;
;TEMP VALUE STORAGE
;
TDISK:	EQU	$+OFFSET
	DB	0
TTRACK:	EQU	$+OFFSET
	DB	0
TSECT:	EQU	$+OFFSET
	DB	0
TDMA:	EQU	$+OFFSET
	DB	0,0
TOPCD:	EQU	$+OFFSET
	DB	0
;
PROEND:	EQU	$
;
;
	END
