/*
	WILDEXP.C
	BDS C Command-line Wild-card expansion utility

	Written 3/15/82 by Leor Zolman

	Lets ambiguous file names appear on the command line to C programs,
	automatically expanding the parameter list to contain all files on
	the CURRENT drive that fit the afn's.

	An afn preceded by a "!" causes all names matching the given afn to
	be EXCLUDED from the resulting expansion list. Thus, to yield a
	command line containing all files except "COM" files, you'd say:

		A>progname !*.com <cr>

	When giving a "!" afn, "*" chars in the string matches to the end of
	either the filename or extension, just like CP/M, but "?" chars match
	ONE and ONLY ONE character in either the filename or extension.


	To use WILDEXP, begin your "main" function as follows:

	---------------------------------------------
	main(argc,argv)
	char **argv;
	{
		...			/* local declarations  */
		wildexp(&argc,&argv);	/* first statement in program  */
		dioinit(&argc,argv);	/* if using DIO, put this here */
		.
		.
		.
	---------------------------------------------

	and link WILDEXP.CRL in with your program. That's all there is to
	it; note that "wildexp" uses the "sbrk" function to obtain storage,
	so don't go playing around with memory that is outside of the
	external or stack areas unless you obtain the memory through "sbrk"
	or "alloc" calls.

*/

#include "bdscio.h"
#define MAXITEMS	200	/* maximum number of items after expansion */
#define SEARCH_FIRST	17	/* BDOS calls */
#define SEARCH_NEXT	18

wildexp(oargcp, oargvp)
int *oargcp;			/* pointer to old argc */
char ***oargvp;			/* pointer to old argv */
{
	int nargc;		/* new argc */
	char **nargv;		/* new argv */
	char **oargv;		/* old argv */
	int  oargc;		/* old argc */
	char fcb[33];		/* fcb used for search for first/next calls */
	char dmapos;		/* value returned by search calls */
	char first_time;	/* used in search routine */
	char tmpfn[20];		/* temp filename buffer */
	char *notfns[20];	/* list of !<afn> entries */
	int notcount;		/* count of entries in notfns */
	int i,j,k;

	oargv = *oargvp;
	oargc = *oargcp;
	nargc = 1;
	notcount = 0;

	if ((nargv = sbrk(MAXITEMS * 2 + 2)) == ERROR)
		return ERROR;

	for (i = 1; i < oargc; i++)
		if (oargv[i][0] == '!') {
			if (i == 1) {
				oargv[oargc] = "*.*";
				oargc++;
			}				
			notfns[notcount++] = &oargv[i][1];
		}
		else if (!haswild(oargv[i]))
			nargv[nargc++] = oargv[i];
		else {
		   setfcb(fcb,oargv[i]);
		   first_time = TRUE;
		   while (1) {
			dmapos = bdos(first_time ? SEARCH_FIRST : SEARCH_NEXT,
									fcb);
			if (dmapos == 255) break;
			first_time = FALSE;
			hackname(tmpfn,(BASE + 0x80 + dmapos * 32));
			nargv[nargc] = sbrk(strlen(tmpfn) + 1);
			if (nargv[nargc] == ERROR)
				return ERROR;
			strcpy(nargv[nargc++], tmpfn);
		   }
		}

	for (i = 0; i < notcount; i++)
		for (j = 1; j < nargc; j++)
			while (match(notfns[i],nargv[j]))
			{
				if(--nargc == 1)
					break;
				for (k = j; k < nargc; k++)
					nargv[k] = nargv[k+1];
			}
	*oargcp = nargc;
	*oargvp = nargv;
	return 0;
}

hackname(dest,source)
char *dest, *source;
{
	int i,j;

	j = 0;

	for (i = 1; i < 9; i++)
	{
		if (source[i] == ' ') break;
		dest[j++] = source[i];
	}
	if (source[9] != ' ')
		dest[j++] = '.';

	for (i = 9; i < 12; i++)
	{
		if (source[i] == ' ') break;
		dest[j++] = source[i];
	}
	dest[j] = '\0';
	return dest;
}

int haswild(fname)
char *fname;
{
	char c;

	while (c = *fname++)
		if (c == '*' || c == '?') 
			return TRUE;
	return FALSE;
}

int match(wildnam, string)
char *wildnam, *string;
{
   char c;
   while (c = *wildnam++)
	if (c == '?')
		if ((c = *string++) && c != '.')
			continue;
		else
			return FALSE;
	else if (c == '*')
	{
		while (c = *wildnam)
		{ 	wildnam++;
			if (c == '.') break;
		}
		while (c = *string)
		{	string++;
			if (c == '.') break;
		}
	}
	else if (c == *string++)
	 	continue;
	else return FALSE;

   if (!*string)
	return TRUE;
   else
	return FALSE;
}
