{ TOOLKIT - screen handling/attribute routines for IBM Pascal     }
{ under PC-DOS 2.0						  }
{								  }
{ This file, "TOOLKIT.PAS", allows you to incorporate easy to use }
{ screen handling routines into your IBM Pascal program. You must }
{ link your compiled code with the "DOSP.OBJ" file as in:         }
{	A>LINK <filespec>+DOSP				          }
{ in order to arrive at a working .EXE file. The screen attri-    }
{ butes (normal, blink, boldface, underline and reverse) use the  }
{ ANSI.SYS extended I/O driver present on the DOS 2.0, as does    }
{ clear routine. In order to use them you must include a file on  }
{ your boot disk called CONFIG.SYS, which contains this line:     }
{	DEVICE=ANSI.SYS						  }
{ for further information, see chapters 9 (Configuring your Sys-  }
{ tem) and 13 (Extended Keyboard/Screen Routines) of the DOS 2.0  }
{ manual.						          }
{								  }
{ Although the extended keyboard/screen driver includes a routine }
{ for directly locating the cursor (programmable in Pascal as:    }
{	write(chr(27),'[<row number>;<column number>H');)         }
{ for reasons I don't understand you can't place this routine in  }
{ a procedure (as I have done for the screen attribute calls) and }
{ pass the row and column values to it. All you get is an actual  }
{ write of the row and column values and the letter 'H' written   }
{ to the screen. In any event, the external compiled assembler    }
{ routine DOSSUB is a general DOS function call, and the cursor   }
{ routine in this listing makes use of it. You can can also use   }
{ DOSSUB for any DOS calls - the variables are:		          }
{	retcd - the returned error code				  }
{	intno - interrupt number				  }
{	ah through dl - the 8088 registers		          }
{ Obviously, such use demands thorough familiarity with DOS and   }
{ the values it expects to find in the appropriate registers for  }
{ the various service calls. See Peter Norton's excellent book,   }
{ "Inside the IBM PC" for the straight poop.			  }
{								  }
{ This documentation and the following program code are copyright }
{ (c) David A. Basskin 1983 and may be reproduced for any non-    }
{ commercial purpose.						  }


procedure dossub(var retcd,intno,ah,al,bh,bl,ch,cl,dh,dl:word); extern;

procedure normal;
	begin
		write(chr(27),'[0m')
	end;

procedure blink;
	begin
		write(chr(27),'[5m')
	end;

procedure boldface;
	begin
		write(chr(27),'[1m')
	end;

procedure reverse;
	begin
		write(chr(27),'[7m')
	end;

procedure underline;
	begin
		write(chr(27),'[4m')
	end;

procedure clear;
	begin
		write(chr(27),'[2J')
	end;

procedure timeout;
	var time1 , time2 : integer;
	begin
		for time1 := 1 to 1000 do
		  begin
			for time2 := 1 to 750 do
		  end
	end;

procedure cursor(row,column : word);
	var retcd,intno,ah,al,bh,bl,ch,cl,dh,dl:word;
	begin (* Cursor *)
		intno:=16;
		ah:=2;     {locate cursor}
		bh:=0;     {page number}
		row:=row-1;    {cursor row}
		column:=column-1;    {cursor column}
		dossub(retcd,intno,ah,al,bh,bl,ch,cl,row,column);
	end; (* Cursor *)

procedure drawbox;
	var count : word;
	begin
		cursor(1,1);
		write(chr(201));
		for count := 2 to 79 do
		  begin
			cursor(1,count);
			write(chr(205))
		  end;
		cursor(1,80);
		write(chr(187));
		for count := 2 to 23 do
		  begin
			cursor(count,1);
			write(chr(186));
			cursor(count,80);
			write(chr(186))
		  end;
		cursor(24,1);
		write(chr(200));
		for count := 2 to 79 do
		  begin
			cursor(24,count);
			write(chr(205))
		  end;
		cursor(24,80);
		write(chr(188))
	end;
                                                                                                                                