	LIST	3

; Coleco Adam modem overlay for MEX v1.1x
; Written 15 July 85 by Mike Rachuk
;
; Please leave any bug reports or requests on Royal Oak RCMP (313-759-6569)
; or call me at 313-725-7514 (voice).
;
; This overlay does initialization and sets parameters for the Adam.
; The overlay provides dialing, carrier detection, originate/answer modes,
; disconnect routine, clear screen, clear to end of screen, and also contains
; some set commands for configuring the modem and checking; it's status.
; The SET commands are briefly outlined later.
;
;
; Mex service processor

MEX	EQU	0D00H	; Address of service processor
INMDM	EQU	255	; Get character from port A, CY=no more in 100 ms.
TIMER	EQU	254	; Delay 100 ms. * reg B
TMDINP	EQU	253	; B=# secs. to wait for char., cy=no char.
CHEKCC	EQU	252	; Check for ^C from kyb., Z=present
SNDRDY	EQU	251
RCVRDY	EQU	250
SNDCHR	EQU	249
RCVCHR	EQU	248
LOOKUP	EQU	247	; Table lookup
PARSFN	EQU	246
BDPARS	EQU	245
SBLANK	EQU	244	; Scan input stream for next non-blank
EVALA	EQU	243
LKAHED	EQU	242
GNC	EQU	241
ILP	EQU	240
DECOUT	EQU	239
PRBAUD	EQU	238

CONOUT	EQU	2	; BDOS function 2, console character output
STRING	EQU	9	; BDOS function 9, output string till '$'

;------------------------------------------------------------------------------
CR	EQU	0DH
ESC	EQU	1BH
LF	EQU	0AH
YES	EQU	0FFH
NO	EQU	0

;------------------------------------------------------------------------------
DATAPT	EQU	05EH	; Modem data port
CTRLPT	EQU	05FH	; Modem control port

NULL	EQU	80H	; mode instruction value
IR	EQU	40H	; 1=internal reset
RTS	EQU	20H	; 1=set RTS to 0, enable transmitter
ER	EQU	10H	; 1=error condition
SBRK	EQU	08H	; 1=send break
RXE	EQU	04H	; 1=receiver enable
DTR	EQU	02H	; 1=set DTR to 0
TXE	EQU	01H	; 1=transmitter enable, seize phone line

STPB1	EQU	040H	; 1 stop bit
STPB15	EQU	080H	; 1.5 stop bits
STPB2	EQU	0C0H	; 2 stop bits

BITS5	EQU	00H	; 5 bits/character
BITS6	EQU	04H	; 6 bits/character
BITS7	EQU	08H	; 7 bits/character
BITS8	EQU	0CH	; 8 bits/character

NO_PAR	EQU	00H	; No parity
ODDPAR	EQU	10H	; Odd parity
EVNPAR	EQU	30H	; Even parity

X64	EQU	03H

DSR	EQU	7	; Bit to test for carrier

MODRCB	EQU	2	; Bit to test for receive
MODRCR	EQU	2	; Value when ready
MODSNB	EQU	1	; Bit to test for send
MODSNR	EQU	1	; Value when ready

;------------------------------------------------------------------------------

	ORG	100H

	DS	3	; "JMP   START" instruction

	DB	NO	; Not PMMI S-100 modem
	DB	NO	; Not Hayes modem either
	DB	'P'	; Pulse dial
	DB	37	; 3.68 MHz.
	DB	1	; 1=300 baud
	DB	5	; 50 msecs. to send character in terminal mode
	DB	5	; 500 msecs. default time for CRLF
	DB	2	; Number of columns for DIR
	DB	YES	; Yes=user added setup routine
	DB	YES	; Cursor control routine
	DB	0	; Spare
	DB	YES	; Yes=change any file name to .BAK
	DB	YES	; Yes default to CRC checking
	DB	YES	; Yes allows toggling of CRC or CHECKSUM
	DB	NO	; Yes=convert backspace to rub
	DB	YES	; Yes allows toggling backspace to rub
	DB	NO	; No=no LF after CR to send file in terminal mode
	DB	YES	; Yes allows toggling LF after CR
	DB	YES	; Yes allows transmission of LOGON
	DB	NO	; Yes=overwrite of CCP if needed
	DB	NO	; Yes=local, No=external command if EXTCHR precedes
	DB	YES	; Yes allows toggling of LOCONEXTCHR
	DB	YES	; Yes=printer available
	DB	NO	; Yes=checks for XOFF from remote while sending file
	DB	NO	; Yes=wait for XON after CR while sending file
	DB	YES	; Yes allows for toggling of XOFF checking
	DB	NO	; Yes=CTL-CHARS above ^M not displayed
	DB	0	; For future use
	DB	'E'-40H	; ^E = exit to main menu
	DB	'@'-40H	; ^@ = send 300 ms. break tone
	DB	'N'-40H	; ^N = disconnect from phone line
	DB	'L'-40H	; ^L = send logon
	DB	'P'-40H	; ^P = toggle printer
	DB	'R'-40H	; ^R = close input text file
	DB	'T'-40H	; ^T = transmit file to remote
	DB	'Y'-40H	; ^Y = open input text file
	DB	'^'-40H	; ^^ = send next character
	DS	2	; Unused by MEX

;------------------------------------------------------------------------------
; Modem input, output and bit tests follow

	IN	A,(CTRLPT)	; Input 8251 status word
	RET
	DS	7

	OUT	(DATAPT),A	; Output to data port
	RET
	DS	7

	IN	A,(DATAPT)	; Input from data port
	RET
	DS	7

	AND	MODRCB		; Bit to test for receive ready
	RET

	CP	MODRCR		; Value of receiver bit when ready
	RET

	AND	MODSNB		; Bit to test for send ready
	RET

	CP	MODSNR		; Value for send ready
	RET

;------------------------------------------------------------------------------
	DS	14		; Area not used

;------------------------------------------------------------------------------
; Jump table is next

	JP	DIAL
	JP	DISCON
	JP	GOODBY
	JP	INIMOD
	DS	3		; Baud rate selection
	RET			; NOPARV
	NOP
	NOP
	RET			; PARITV
	NOP
	NOP
	JP	SETCMD
	DS	3		; Not used
	JP	SYSVER
	JP	SBREAK

;------------------------------------------------------------------------------
	DS	18

;------------------------------------------------------------------------------
; Clear to end of screen
	LD	C,STRING	; Bdos print string function
	LD	DE,EOSMSG	; Address of clear to end of screen sequence
	CALL	MEX
	RET

; Clear screen
	LD	C,STRING	; Bdos print string function
	LD	DE,CLSMSG	; Address of clear screen sequence
	CALL	MEX
	RET

; End of fixed area

;------------------------------------------------------------------------------
; 10 msec. delay routine

DELA10:
	PUSH	BC
	LD	HL,8000H
	LD	DE,8000H
	LD	BC,1594
	LDIR
	POP	BC
	DJNZ	DELA10		; Jump if another 10 msec. delay needed
	RET

;------------------------------------------------------------------------------
CAR_ST:
	IN	A,(CTRLPT)
	BIT	DSR,A
	RET				; Z = no carrier

;------------------------------------------------------------------------------
; This routine dials the phone number passed to it from MEX.  After dialing the
; number, it checks for carrier detection.  If carrier is not detected in
; 30 secs., the phone is hungup.  This routine provides for CTRL C abort.
;
DIAL:
	LD	HL,(DIALPT)		; Get pointer for dial number
	CP	254			; Check if start dial
	JR	Z,STDIAL		; If so, go to start dial
	CP	255			; Check if end dial
	JR	Z,ENDIAL		; Jump if so
;  Not start or end, so must be number
	LD	(HL),A			; Put number in buffer
	INC	HL			; Advance pointer
	LD	(DIALPT),HL		; Save pointer for next time
	RET

STDIAL:	LD	HL,DIALBF		; Load address of start of dial buffer
	LD	(DIALPT),HL		; Save pointer for next time
	RET

ENDIAL:	LD	(HL),0			; Terminate phone number string

CLEARB:	LD	C,INMDM			; Clear data buffer in USART
	CALL	MEX
	JR	NC,CLEARB		; Jump if not clear yet
	CALL	MODINI			; Initialize modem
	CALL	DISCON			; Hangup
	LD	A,RXE+TXE+RTS+DTR
	OUT	(CTRLPT),A		; Seize phone line
	LD	B,10			; Wait 5 secs. for dial tone
DLT_LP:	PUSH	BC
	LD	C,TIMER
	LD	B,5
	CALL	MEX
	LD	C,CHEKCC
	CALL	MEX			; Check for control C
	JR	Z,ABORT			; Jump if so
	POP	BC
	DJNZ	DLT_LP			; Jump if more time to wait
	LD	HL,DIALBF		; Load address of start of dial buffer
	JR	F_DIAL			; Go and dial first digit

DIALLP:
	LD	(DIALPT),HL		; Save pointer into dial buffer
; Routine to dial a digit, digit passed in ACC
	CP	'P'
	JR	Z,PAUSE
	CP	'p'
	JR	Z,PAUSE
	CP	','
	JR	Z,PAUSE
	CP	'9'+1
	JR	NC,BAD_DG		; If digit > 9, then jump
	CP	'0'
	JR	C,BAD_DG		; If digit < 0, then jump
	JR	NZ,NOZERO
; 0 means 10 pulses, so start with '9'+1
	LD	A,'9'+1
NOZERO:
	SUB	'0'
	LD	B,A			; Number of pulses in reg B

PLSELP:
; Unseize line for 60 msecs.
	LD	A,RXE+TXE+RTS
	OUT	(CTRLPT),A
	PUSH	BC			; Save remaining pulses
	LD	B,6
	CALL	DELA10
; Seize line for 40 msecs.
	LD	A,RXE+TXE+RTS+DTR
	OUT	(CTRLPT),A
	LD	B,4
	CALL	DELA10
	POP	BC			; Get stored remaining pulses
	DJNZ	PLSELP			; Jump if more pulses
PAUSE:	LD	C,TIMER
	LD	B,10
	CALL	MEX			; Call for 1 sec. wait
	LD	C,CHEKCC
	CALL	MEX			; Check for control C
	JR	Z,ABORT1		; Jump if so
	LD	HL,(DIALPT)		; Get pointer into dial buffer
	INC	HL			; Advance pointer
F_DIAL:	LD	A,(HL)
	OR	A
	JR	NZ,DIALLP		; Jump if dialing finished

	LD	B,150			; Wait only 30 secs for carrier
WCARLP:	PUSH	BC
	LD	C,CHEKCC
	CALL	MEX			; Check for control C
	JR	Z,ABORT			; Jump if so
	LD	C,TIMER
	LD	B,2
	CALL	MEX			; 200 msecs. wait
	CALL	CAR_ST			; Check for carrier
	POP	BC
	JR	NZ,GOTCAR		; Jump if carrier present
	DJNZ	WCARLP			; Jump if more time left
	CALL	DISCON			; Hangup
	LD	A,2			; Value for modem timed out
	RET

BAD_DG:
	CALL	DISCON			; Hangup
	LD	A,4			; Return with modem error
	RET

ABORT:	POP	BC			; Restore stack
ABORT1:	CALL	DISCON			; Hangup
	LD	A,3			; Value for keyboard abort
	RET

GOTCAR:	LD	A,0			; Value for carrier detected
	RET

;------------------------------------------------------------------------------
ST_ORG:
GOODBY:
DISCON:
	LD	A,0FFH
	LD	(OP_MOD),A		; Save originate mode
	LD	A,RXE+TXE+RTS
	OUT	(CTRLPT),A		; Hangup and switch to originate mode
	RET

;------------------------------------------------------------------------------
; Initialization for the modem
;
INIMOD:
	LD	C,STRING		; Bdos print string function
	LD	DE,SK_OFF		; Address of code to turn smart keys off
	CALL	MEX
	LD	A,0FFH
	LD	(OP_MOD),A		; Default is originate mode
	LD	A,BITS8+NO_PAR+STPB1+X64
	LD	(MODEWD),A		; Save default, 8 bits/character,
					; no parity, 1 stop bit, 300 baud
MODINI:
	XOR	A
	OUT	(CTRLPT),A
	OUT	(CTRLPT),A
	OUT	(CTRLPT),A		; Get 8251's attention
	LD	A,40H
	OUT	(CTRLPT),A		; Internal reset
	LD	A,(MODEWD)		; Get mode word
	OR	X64			; Force 300 baud
	OUT	(CTRLPT),A		; Initialize 8251
	LD	A,10H
	OUT	(CTRLPT),A		; Reset error condition flags
	RET

;------------------------------------------------------------------------------
; SET commands
;-------------
;
; SET^ this displays modem parameters (parity, bits/character, # of stop bits,
;	originate/answer mode, and present carrier status
;
; SET ? or SET HELP  this displays valid command extensions
;
; SET ANS this seizes the phone line in answer mode
;
; SET ON  this seizes the phone line in originate mode
;
; SET ORG this switches to originate mode but does not seize the phone line
;
; !NOTE! ANS, ON, and ORG all force a disconnect when issued
;
; SET SB1	1 stop bit
; SET SB15	1.5 stop bits
; SET SB2	2 stop bits
;
; SET NPA	no parity
; SET OPA	odd parity
; SET EPA	even parity
;
; SET BC5	5 bits/character
; SET BC6	6 bits/character
; SET BC7	7 bits/character
; SET BC8	8 bits/character

SETCMD:
	LD	C,SBLANK	; Any arguments
	CALL	MEX
	JR	C,STSHOW	; If no, show 8251 command status
	LD	DE,CMDTBL	; Address of start of command set
	LD	C,LOOKUP
	CALL	MEX
	PUSH	HL		; Save any parsed argument address on stack
	RET	NC		; If we have one, return to it
	POP	HL		; No match, get return address back
	LD	C,STRING
	LD	DE,STERRM	; Address for set error message
	CALL	MEX
	RET

STSHOW:
	LD	C,STRING
	LD	DE,ST_MSG	; Address of status message
	CALL	MEX
	LD	A,(OP_MOD)	; Get originate or answer mode
	OR	A
	JR	Z,A_MODE
	LD	DE,ORGMSG
	JR	MODE_R
A_MODE:	LD	DE,ANSMSG
MODE_R:	LD	C,STRING
	CALL	MEX
	LD	C,STRING
	LD	DE,ST1MSG	; Address of next part of status message
	CALL	MEX
	LD	A,(MODEWD)	; Get number of bits/character
	AND	0CH
	CP	BITS8
	JR	NZ,TRY_7
	LD	E,'8'
	JR	BC_NUM
TRY_7:	CP	BITS7
	JR	NZ,TRY_6
	LD	E,'7'
	JR	BC_NUM
TRY_6:	CP	BITS6
	JR	NZ,TRY_5
	LD	E,'6'
	JR	BC_NUM
TRY_5:	LD	E,'5'
BC_NUM:	LD	C,CONOUT
	CALL	MEX
	LD	C,STRING
	LD	DE,ST2MSG	; Address of next part of status message
	CALL	MEX
	LD	A,(MODEWD)
	AND	30H
	CP	EVNPAR
	JR	NZ,TRY_O
	LD	DE,EVNMSG
	JR	P_SHOW
TRY_O:	CP	ODDPAR
	JR	NZ,NONPAR
	LD	DE,ODDMSG
	JR	P_SHOW
NONPAR:	LD	DE,NONMSG
P_SHOW:	LD	C,STRING
	CALL	MEX
	LD	C,STRING
	LD	DE,ST3MSG	; Address of next part of status message
	CALL	MEX
	LD	A,(MODEWD)	; Get number of stop bits
	AND	0C0H
	CP	STPB1
	JR	NZ,TRY_15
	LD	DE,SB1MSG
	JR	SB_NUM
TRY_15:	CP	STPB15		; Check if 1.5 stop bits
	JR	NZ,TRY_2
	LD	DE,SB5MSG
	JR	SB_NUM
TRY_2:	CP	STPB2		; Check if 2 stop bits
	JR	NZ,BAD_SB
	LD	DE,SB2MSG
	JR	SB_NUM
BAD_SB:	LD	DE,BADMSG
SB_NUM:	LD	C,STRING
	CALL	MEX
	CALL	CAR_ST		; Check for carrier
	JR	Z,NO_CAR
	LD	DE,CARMSG
	JR	C_SHOW
NO_CAR:	LD	DE,NOCARM
C_SHOW	LD	C,STRING
	CALL	MEX
	RET

ST__ON:
	CALL	DISCON			; Hangup
	LD	A,RXE+TXE+RTS+DTR
	OUT	(CTRLPT),A		; Seize phone line
	RET

ST_ANS:
	CALL	DISCON		; Hangup
	XOR	A
	LD	(OP_MOD),A	; Store mode as answer
	LD	A,RXE+TXE+RTS+DTR
	OUT	(CTRLPT),A
	PUSH	AF
	NOP
	POP	AF
	LD	A,RXE+TXE+DTR
	OUT	(CTRLPT),A
	PUSH	AF
	NOP
	POP	AF
	LD	A,RXE+TXE+RTS+DTR
	OUT	(CTRLPT),A
	RET

ST_SB1:
	LD	B,STPB1		; Save 1 stop bit for mode instruction
SET_SB:
	LD	A,(MODEWD)	; Get mode word
	AND	3FH		; Clear stop bit part of mode word
	OR	B		; Set stop bit part
	LD	(MODEWD),A
	RET

STSB15:
	LD	B,STPB15	; Save 1.5 stop bits for mode instruction
	JR	SET_SB

ST_SB2:
	LD	B,STPB2		; Save 2 stop bits for mode instruction
	JR	SET_SB

ST_BC5:
	LD	B,BITS5		; Save 5 bits/character
	JR	SET_BC

ST_BC6:
	LD	B,BITS6		; Save 6 bits/character
	JR	SET_BC

ST_BC7:
	LD	B,BITS7		; Save 7 bits/character
	JR	SET_BC

ST_BC8:
	LD	B,BITS8		; Save 8 bits/character
SET_BC:
	LD	A,(MODEWD)	; Get mode word
	AND	0F3H		; Clear bits/character part of mode word
	OR	B		; Set bits/character part
	LD	(MODEWD),A
	RET

STNPAR:
	LD	B,NO_PAR	; Save no parity
SETPAR:
	LD	A,(MODEWD)	; Get mode word
	AND	0CFH		; Clear parity part of mode word
	OR	B		; Set parity part
	LD	(MODEWD),A
	RET

STOPAR:
	LD	B,ODDPAR	; Save odd parity
	JR	SETPAR

STEPAR:
	LD	B,EVNPAR	; Save even parity
	JR	SETPAR

STHELP:
	LD	C,STRING
	LD	DE,HLPMSG	; Address of help message
	CALL	MEX

;------------------------------------------------------------------------------
SYSVER:
	LD	C,STRING	; Bdos print string function
	LD	DE,VERMSG	; Address of version message
	CALL	MEX
	RET

;------------------------------------------------------------------------------
SBREAK:
	LD	A,RXE+TXE+RTS+DTR+ER+SBRK
	OUT	(CTRLPT),A			; Send break
	LD	B,3
	LD	C,TIMER
	CALL	MEX				; 300 msec. pause
	LD	A,RXE+TXE+RTS+DTR+ER
	OUT	(CTRLPT),A			; Break done
	RET

;------------------------------------------------------------------------------
CMDTBL:
	DB	'?'+80H			; Help command
	DW	STHELP
	DEFM	'HEL'			; Help command
	DB	'P'+80H
	DW	STHELP
	DEFM	'AN'			; Answer mode
	DB	'S'+80H
	DW	ST_ANS
	DEFM	'OR'			; Originate mode
	DB	'G'+80H
	DW	ST_ORG
	DB	'O'			; Seize phone line
	DB	'N'+80H
	DW	ST__ON
	DEFM	'SB'			; Set 1 stop bit
	DB	'1'+80H
	DW	ST_SB1
	DEFM	'SB1'			; Set 1.5 stop bit
	DB	'5'+80H
	DW	STSB15
	DEFM	'SB'			; Set 2 stop bit
	DB	'2'+80H
	DW	ST_SB2
	DEFM	'BC'			; Set 5 bits/character
	DB	'5'+80H
	DW	ST_BC5
	DEFM	'BC'			; Set 6 bits/character
	DB	'6'+80H
	DW	ST_BC6
	DEFM	'BC'			; Set 7 bits/character
	DB	'7'+80H
	DW	ST_BC7
	DEFM	'BC'			; Set 8 bits/character
	DB	'8'+80H
	DW	ST_BC8
	DEFM	'NPA'			; Set no parity
	DB	'R'+80H
	DW	STNPAR
	DEFM	'EPA'			; Set even parity
	DB	'R'+80H
	DW	STEPAR
	DEFM	'OPA'			; Set odd parity
	DB	'R'+80H
	DW	STOPAR
	DB	0			; End of table indicator

;------------------------------------------------------------------------------
EOSMSG:
	DB	0BH
	DB	'$'
	DB	00H

CLSMSG:
	DB	0CH
	DB	'$'
	DB	00H

SK_OFF:
	DB	16H
	DB	'$'
	DB	00H

VERMSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  MEX ADAM overlay V1.0'
	DB	CR
	DB	LF
	DB	LF
	DB	'$'

STERRM:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  COMMAND NOT FOUND'
	DB	CR
	DB	LF
	DB	LF
	DB	'$'

ST_MSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  MODEM PARAMETERS'
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  MODE:  '
	DB	'$'

ORGMSG:
	DEFM	'ORIGINATE'
	DB	'$'

ANSMSG:
	DEFM	'ANSWER'
	DB	'$'

ST1MSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  BITS/CHARACTER:  '
	DB	'$'

ST2MSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  PARITY:  '
	DB	'$'

NONMSG:
	DEFM	'NONE'
	DB	'$'

ODDMSG:
	DEFM	'ODD'
	DB	'$'

EVNMSG:
	DEFM	'EVEN'
	DB	'$'

ST3MSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  STOP BITS:  '
	DB	'$'

SB1MSG:
	DB	'1'
	DB	'$'

SB5MSG:
	DEFM	'1.5'
	DB	'$'

SB2MSG:
	DB	'2'
	DB	'$'

BADMSG:
	DEFM	'BAD VALUE'
	DB	'$'

CARMSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  CARRIER ON LINE'
	DB	CR
	DB	LF
	DB	LF
	DB	'$'

NOCARM:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  NO CARRIER PRESENT'
	DB	CR
	DB	LF
	DB	LF
	DB	'$'

HLPMSG:
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  SET <command>'
	DB	CR
	DB	LF
	DB	LF
	DEFM	'  Where <command> is one of:'
	DB	CR
	DB	LF
	DB	LF
	DEFM	'    ?, HELP'
	DB	CR
	DB	LF
	DEFM	'    ORG, ANS, ON'
	DB	CR
	DB	LF
	DEFM	'    SB1, SB15, SB2'
	DB	CR
	DB	LF
	DEFM	'    NPA, EPA, OPA'
	DB	CR
	DB	LF
	DEFM	'    BC5, BC6, BC7, BC8'
	DB	CR
	DB	LF
	DB	LF
	DB	'$'

MODEWD:	DB	4FH
OP_MOD:	DB	0FFH

DIALPT:	DW	DIALBF
DIALBF:	DS	48

	END
