;$date.asm
	title	'Date Routine for PL/I'
; Usage:
; dcl	date	entry	returns (char(13));	/* 'Wed 14-Oct-82' */

	public	date	;returns char(13) on stack
	extrn	?date	;rtn to read clock board, cnvrt to ascii
	extrn	adate	;ascii date field left by above
	extrn	?slcts	;load char to stack
	name	'date'


date:	pop	h		;get return address from stack
	shld	return		;  and save for return to caller

	call	?date		;Upon return, adate contains char(13) ascii

	lxi	h,adate		;point to it
	mvi	a,13		;A=length
	call	?slcts		;PL/I rtn to load to stack

	lhld	return		;get return address
	pchl			;back to caller
return	dw	0
;	end

;$time.asm
	title	'Time Routine for PL/I'
; dcl	time	entry	returns (char(8));	/* '16:32:56' */

	public	time	;returns char(8) on stack
	extrn	?time	;rtn to read clock board, cnvrt to ascii
	extrn	atime	;ascii time field left by above
	extrn	?slcts	;load char to stack
	name	'time'

time:	pop	h		;get return address from stack
	shld	return		;  and save for return to caller

	call	?time		;Upon return, atime contains char(8) ascii

	lxi	h,atime		;point to it
	mvi	a,8		;A=length
	call	?slcts		;PL/I rtn to load to stack

	lhld	return		;get return address
	pchl			;back to caller
;return	dw	0
;	end

;$datime.asm
	title	'Date/Time Routine for PL/I'
; dcl	datime	entry	returns (char(22));	/* 'Wed 14-Oct-82 16:32:56' */

	public	datime	;returns char(22) on stack
	extrn	?date	;rtn to read clock board, cnvrt to ascii
	extrn	?time
	extrn	adate	;ascii date field left by above
	extrn	adate
	extrn	?slcts	;load char to stack
	name	'datime'

datime:	pop	h		;get return address from stack
	shld	return		;  and save for return to caller

	call	?date		;Upon return, adate contains char(22) ascii
	call	?time

	lxi	h,adate		;point to it
	mvi	a,22		;A=length
	call	?slcts		;PL/I rtn to load to stack

	lhld	return		;get return address
	pchl			;back to caller

;return	dw	0
;	end

;$ptime.asm
	title	'Date/Time Routine for PL/I'
; dcl	ptime	entry	returns (ptr);		/* ->(13) fixed bin(7)
;						8 2 1 0 1 4 3 1 6 3 2 5 6 */

	public	ptime	;returns ptr to (13) fixed bin(7)
	extrn	rddate,rdtime	;read date & time from clock board
	extrn	hdate,htime	;hex date/time fields

ptime:	lxi	h,hdate		;Where to store date field (hex)
	call	rddate		;Read the date from the clock
	lxi	h,hdate+4	;Point to day10
	mov	a,m		;Get digit
	ani	03h		;Mask leap year bit
	mov	m,a		;Put it back

	lxi	h,htime		;Where to store time
	call	rdtime		;Read the clock
	mov	a,m		;Get hr10 digit
	ani	03h		;Mask AM/PM
	mov	m,a		;Put it back

	lxi	h,hdate		;Pointer to date/time field to HL for return
	ret			; to PL/I

	END                                                                                                                                                                                                                                                                                                                                                                                       