	name	'getpad'
	title	'Get address of PL/I parameters'

	public	getpad	;Get address of passed parameter
	public	nxtpad	;Storage for next parameter address

;****************************************************************
;*	Retrieve parameters passed from PL/I routines		*
;****************************************************************
;
; entry conditions:
;	HL	contains the address of parameter addresses from PL/I
; exit:
;	DE	contains address of PL/I parameter
;	nxtpad	contains address of next parameter
; sample usage:
;
;	extrn	getpad,nxtpad
;
;first:	call	getpad	;Address of 1st parm to DE
;	ldax	d	;parm value to A reg
;	...
;	lhld	nxtpad	;Get pointer to addr of next parm
;	call	getpad	;Pointer to parameter to DE
;	ldax	d	;2nd parm value to A
;	...
;****************************************************************


getpad:	mov	e,m	;Move low byte of address to E
	inx	h	;point to second byte of address
	mov	d,m	;Move high byte of address to D
	inx	h	;Point to address of next parameter

	shld	nxtprm	;Save address for next call
	ret		;With address of parameter in DE pair

	dseg
nxtpad:	ds	2	;Storage for next parameter address
	end
                                                                                                                                                                                                                                                                