;
;BSTAM 4.5 UHSIO4.ASM  NORTH STAR HSIO-4
;
;Modification written by Robb Adams  (WA9ZMO/8)
;6354 North Twelth Street, Kalamazoo, MI 49009
;
;10-Oct-82  This version will adapt the North Star 
;HSIO-4 I/O Board to BSTAM. The user need only make
;three modifications if desired;
;
;    BOARD ADDR - PORT ADDR - BAUD RATE 
;

BEGIN	ORG	103H
INITIL	JMP	INITIU	;INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU	;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU	;ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU	;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU	;WRITE DATA PORT ENTRY POINT
BDOS	EQU	05H	;
CR	EQU	0AH	;CARRIAGE RETURN
LF	EQU	0DH	;LINE FEED
PA	EQU	00H	;PORT A
PB	EQU	04H	;PORT B
PC	EQU	08H	;PORT C
PD	EQU	0CH	;PORT D
B19200	EQU	00H	;-- BAUD RATES FOLLOW --
B9600	EQU	01H
B4800	EQU	02H
B2400	EQU	03H
B1200	EQU	04H
B600	EQU	05H
B300	EQU	06H
B110	EQU	07H
;----------------------------------------------------------
BAS	EQU	10H	;<- CHANGE BOARD ADDRESS HERE
PAD	EQU	PD	;<- CHANGE  PORT ADDRESS HERE
BAUD	EQU	B300	;<- CHANGE BAUD  RATE    HERE
;----------------------------------------------------------
PORT	EQU	BAS+PAD	;ADDRESS OF CHOSEN PORT
STATPT	EQU	PORT+3	;STATUS PORT
DATAPT	EQU	PORT+2	;DATA PORT
INTRPT	EQU	PORT+1	;INTERRUPT PORT
BAUDPT	EQU	PORT+0	;BAUD PORT
MI	EQU	4EH	;1 STOP,8 DATA
CI	EQU	37H	;ERROR RESET AND CHIP ENABLE
ERSET	EQU	37H	;ERROR RESET AND CHIP ENABLE

INITIU	EQU	$

;THIS IS THE UART/USART INITIALATION ROUTINE.
;
;TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;INITIALATION GUIDE LINES:
;
;1. USE 1 STOP BIT	(OPTIONAL - 2)
;2. USE 8 DATA BITS	(MUST)
;3. USE 1 START BIT	(MUST)
;4. USE 16X FOR CLOCK RATE 	(MUST)
;5. USE ASYNCHRONOUS MODE ONLY	(MUST)

	MVI	A,B300	;<- CHANGE BAUD RATE HERE
	OUT	BAUDPT
	CALL	SIGN		
	MVI	A,03H
	CALL	NOOP
	CALL	NOOP
	MVI	A,040H	;RESET 8251
	CALL	NOOP
	MVI	A,MI	;SEND MODE COMMAND 
	CALL	NOOP
	MVI	A,CI	;ENABLE AND RESET ERRORS (FE,OE,PE)
	CALL	NOOP
	IN	DATAPT	;CLEAR BUFFER
	IN	DATAPT	;... TWICE
	RET		;RETURN TO BSTAM

NOOP:	OUT 	STATPT
	NOP ! NOP ! NOP	
	NOP ! NOP ! NOP
	RET

INSPRU	EQU	$

;THIS IS THE STATUS READ PORT ROUTINE.
;WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;THE FOLLOWING BITS TO BE SET IF NEEDED:
;
;1. 02 BIT SET IF RECEIVER READY
;2. 01 BIT SET IF TRANSMITTER READY

	IN	STATPT	;FROM 8251 STATUS PORT
	RET		;RETURN TO BSTAM

ERRSTU	EQU	$

;THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;CASE, JUST DO A RETURN.

	MVI	A,ERSET	;RESET ERRORS 
	OUT	STATPT	;TO STATUS PORT
	RET		;RETURN TO BSTAM

INPRTU	EQU	$

;THIS IS THE READ DATA PORT ROUTINE.

	IN	DATAPT	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM

OUTPRU	EQU	$

;THIS IS THE WRITE DATA PORT ROUTINE.

	OUT	DATAPT	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM

MSGE:	DB	CR,LF,LF
	DB	'Version: North Star HSIO-4  11-Oct-82'
	DB	CR,LF
	DB	'Baud: 300    Port: D    by Robb Adams'
	DB	CR,LF,LF,'$'

SIGN:	PUSH B ! PUSH D ! PUSH	H
	LXI	D,MSGE
	MVI	C,9
	CALL	BDOS	
	POP  H ! POP  D ! POP	B
	RET
	END	BEGIN
