/*

fixdoc.c

	fix a file prepared in document mode by Wordstar by stripping
	all characters of the high order bit (bit 7).

*/

#include fcntl.h
#include stdio.h
#include ctype.h

int  i, count, fd_in, fd_out;
char c, buffer[4096], out_file[20];

main(argc, argv)
int  argc;
char *argv[];
{
    if (argc < 2)
      {
        printf("\nProper usage is: fixdoc dn:ufn\n\n");
        exit(1);
      }

    if ((fd_in = open(argv[1], O_RDONLY)) == -1)
      {
        printf("\nCannot open %s\n\n", argv[1]);
        exit(1);
      }

    if (argc == 2)
      {
        for (i = 0; i < 20, argv[1][i] != '.'; i++)
            out_file[i] = argv[1][i];
        strcat(out_file, ".FIX");
      }
    else 
      {
        strcpy(out_file, argv[2]);
      }
    if ((fd_out = open(out_file, O_CREAT+O_WRONLY+O_EXCL)) == -1)
      {
        printf("\nFile <%s> already exists. OK to delete (Y or N)? N\b",
                out_file);
        if ((c = toupper(getchar())) != 'Y')
            exit(1);
        unlink(out_file);
        fd_out = open(out_file, O_WRONLY+O_EXCL+O_CREAT);
      }

    do
      {
        count = read(fd_in, buffer, 4096);
        for (i = 0; i < count; i++)
            buffer[i] = buffer[i] & 0x7F;
        write(fd_out, buffer, count);
      } while (count > 0);

    close(fd_in);
    close(fd_out);
}
