; MXO-HZCM.ASM -- Heath/Zenith Z-100 overlay for MEX 01/11/86

;FOR TDD (TELECOMMUNICATIONS DEVICE FOR THE DEAF) EMULATION
;USING A Z-100 AND PHONE-TTY CM-4 MODEM.

;***IMPORTANT*** FOR BAUD RATES TO PRINT CORRECTLY AND FOR SETTING
;BAUDRATES FROM THE DIAL DIRECTORY, YOU MUST PATCH THE BAUD RATE TABLE
;WITHIN MEX.COM.  YOU CAN FIND IT EASILY WITH DDT.  EACH BAUD RATE IS
;GIVEN IN ASCII WITH BIT 7 SET IN THE UNIT'S DIGIT, AND IS FOLLOWED
;BY A BINARY WORD GIVING THE MSPEED VALUE.  CHANGE 450 TO 45, 710 TO
;50 AND (TO MAKE UP FOR SHORTENING THE ABOVE TWO NAMES) CHANGE 600 TO
;00600.

;***IMPORTANT*** THIS OVERLAY PATCHES THE CONSTAT, CONIN AND CONOUT
;VECTORS IN MEX.COM AND ALSO THE DIAL VECTOR.  TO CHANGE TO A DIFFERENT
;OVERLAY, USE A VIRGIN COPY OF MEX.COM.

;SUPPORTS THE PHONE-TTY CM-4 MODEM IN BELL 103 OR TDD (TELECOMMUNICATIONS
;DEVICE FOR THE DEAF) MODE, CONNECTED TO SERIAL PORT A WITH A SPECIAL
;CABLE (CABLE CAN BE USED FOR STANDARD SMARTMODEMS ALSO):

;	CM-4 MODEM:		Z-100 PORT A:	(Port B:)

;	TxD 2---------------------------3 RxD	(2 TxD - Transmitted Data)
;	RxD 3---------------------------2 TxD	(3 RxD - Received Data)
;	RTS 4---------------------------5 DTS	(4 RTS - Request to Send)
;	Gnd 7---------------------------7 Gnd	(7 Gnd - Signal Ground)
;	DTR 20--------------------------6 DSR	(20 DTR - Data Terminal Ready)
;	DCD 8---->|----+---------------20 DTR	(6 DSR - Data Set Ready)
;	RI  22--->|----+
;			       (DCD - Data Carrier Detect; RI - Ring Indicate)

; --->|--- is a 1N4001 or similar diode, used to OR the DCD and
; RI modem outputs into the DSR input of the 2661 chip.  The diodes
; are placed in the connector shell at the modem end of the cable.
; If ring indicate is not needed, eliminate the diodes and the connection
; to RI.

FALSE	EQU	0
TRUE	EQU	NOT FALSE
				;MEANING OF "TRUE" SETTING:
PORTA	EQU	TRUE		;USE SERIAL PORT A (FALSE = PORT B)
CM4	EQU	TRUE		;PHONE-TTY CM-4 MODEM (FALSE = SMARTMODEM)
DESBACK EQU	FALSE		;DESTRUCTIVE BACKSPACE	  (COMPUSERVE)
ESCLJ	EQU	FALSE		;ESCAPE 'j' CLEARS SCRN   (COMPUSERVE)
CONLF	EQU	FALSE		;INSERT LF AFTER CR IN CONOUT

;------------- END OF COMMENTARY AND CONFIGURATION EQUATES --------------

	IF	NOT PORTA
MODDATP:	EQU	0ECH		;SERIAL PORT B
INTMASK:	EQU	020H		;8259 MASK
	ENDIF
	IF	PORTA
MODDATP:	EQU	0E8H		;SERIAL PORT A
INTMASK:	EQU	010H		;8259 MASK
	ENDIF

MASKREG 	EQU	0F3H		;8259 INTERRUPT ENABLE REGISTER

MODCTL1:	EQU	MODDATP+1	;status port for Z-100
DSR:		EQU	80H		;WE USE FOR CARRIER DETECT FOR CM-4
MODRCVB:	EQU	2		;bit to test for received data
MODRCVR:	EQU	2		;modem receive ready
MODSNDB:	EQU	1		;bit to test for ready to send
MODSNDR:	EQU	1		;modem send ready bit

MODMODE:	EQU	MODDATP+2

MODCMD: 	EQU	MODDATP+3
CMDEF		EQU	15H		;DEFAULT SETTING: RESET, ENABLE T,R
RTS		EQU	20H		;SET RTS HIGH
BRK		EQU	08H		;FORCE BREAK
DTR		EQU	02H		;SET DTR HIGH

		IF	CM4
CM4WAIT 	EQU	45		;TIME TO WAIT FOR A CARRIER TONE
CM4TDD		EQU	CMDEF+DTR	;SET CM4 IN TDD MODE
CM4ORIG 	EQU	CMDEF+RTS	;SET CM4 IN BELL 103 ORIGINATE
CMRANSW 	EQU	CMDEF+DTR+RTS	;SET CM4 IN BELL 103 ANSWER MODE
		ENDIF

DIALOC		EQU	0B00H		;LOCATION OF SMARTMODEM DIAL

; MEX SERVICES

MEX	EQU	0D00H		;address of the service processor
STSVEC	EQU	0D09H		;ADDRESS OF CONSTAT VECTOR
INVEC	EQU	0D0BH		;ADDRESS OF CONIN VECTOR
OUTVEC	EQU	0D0DH		;ADDRESS OF CONOUT VECTOR
INMDM	EQU	255		;get char from port to A, CY=no more in 100 ms
TIMER	EQU	254		;delay 100ms * reg B
TMDINP	EQU	253		;B=# secs to wait for char, cy=no char
CHEKCC	EQU	252		;check for ^C from KBD, Z=present
SNDRDY	EQU	251		;test for modem-send ready
RCVRDY	EQU	250		;test for modem-receive ready
SNDCHR	EQU	249		;send a character to the modem (after sndrdy)
RCVCHR	EQU	248		;recv a char from modem (after rcvrdy)
LOOKUP	EQU	247		;table search: see CMDTBL comments for info
PARSFN	EQU	246		;parse filename from input stream
BDPARS	EQU	245		;parse baud-rate from input stream
SBLANK	EQU	244		;scan input stream to next non-blank
EVALA	EQU	243		;evaluate numeric from input stream
LKAHED	EQU	242		;get nxt char w/o removing from input
GNC	EQU	241		;get char from input, cy=1 if none
ILP	EQU	240		;inline print
DECOUT	EQU	239		;decimal output
PRBAUD	EQU	238		;print baud rate
;
PRINT	EQU	9		;MEX/BDOS print-string function call
;
BELL:	EQU	7
CR:	EQU	0DH
ESC:	EQU	1BH
LF:	EQU	0AH
;
YES:	EQU	0FFH
NO:	EQU	0

; Change the clock speed if needed, to match your system.  The 2661B
; normally runs 4.9152 MHz.

		ORG	100H
;
		DS	3	;(for  "JMP   START" instruction)
;
PMMIMODEM:	DB	NO	;yes=PMMI S-100 Modem			;103H
SMARTMODEM:	DB	YES	;yes=HAYES Smartmodem, no=non-Hayes	;104H
TOUCHPULSE:	DB	'T'	;T=touch, P=pulse (Smartmodem-only)	;105H
CLOCK:		DB	50	;clock speed in MHz x10, 25.5 MHz max.	;106H
				;20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
		IF	NOT CM4
MSPEED: 	DB	5	;0=110 1=300 2=450 3=600 4=710 5=1200	;107H
				;6=2400 7=4800 8=9600 9=19200 default
		ENDIF

		IF	CM4
MSPEED: 	DB	2	;0=110 1=300 2=450 3=600 4=710 5=1200	;107H
				;6=2400 7=4800 8=9600 9=19200 default
		ENDIF

BYTDLY: 	DB	5	;0=0 delay  1=10ms  5=50 ms - 9=90 ms	;108H
				;default time to send character in ter-
				;minal mode file transfer for slow BBS.
CRDLY:		DB	5	;0=0 delay 1=100 ms 5=500 ms - 9=900 ms ;109H
				;default time for extra wait after CRLF
				;in terminal mode file transfer
NOOFCOL:	DB	5	;number of DIR columns shown		;10AH
SETUPTST:	DB	YES	;yes=user-added Setup routine		;10BH
SCRNTEST:	DB	YES	;Cursor control routine 		;10CH
ACKNAK: 	DB	YES	;yes=resend a record after any non-ACK	;10DH
				;no=resend a record after a valid NAK
BAKUPBYTE:	DB	YES	;yes=change any file same name to .BAK	;10EH
CRCDFLT:	DB	YES	;yes=default to CRC checking		;10FH
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	;110H
CONVBKSP:	DB	NO	;yes=convert backspace to rub		;111H
TOGGLEBK:	DB	NO	;yes=allow toggling of bksp to rub	;112H
ADDLF:		DB	NO	;no=no LF after CR to send file in	;113H
				;terminal mode (added by remote echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR	;114H
TRANLOGON:	DB	NO	;yes=allow transmission of logon	;115H
				;write logon sequence at location LOGON
SAVCCP: 	DB	YES	;yes=do not overwrite CCP		;116H
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	;117H
				;no=external command if EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	;118H
LSTTST: 	DB	YES	;yes=printer available on printer port	;119H
XOFFTST:	DB	NO	;yes=checks for XOFF from remote while	;11AH
				;sending a file in terminal mode
XONWAIT:	DB	NO	;yes=wait for XON after CR while	;11BH
				;sending a file in terminal mode
TOGXOFF:	DB	YES	;yes=allow toggling of XOFF checking	;11CH
IGNORCTL:	DB	NO	;yes=CTL-chars above ^M not displayed	;11DH
EXTRA1: 	DB	0	;for future expansion			;11EH
EXTRA2: 	DB	0	;for future expansion			;11FH
BRKCHR: 	DB	'B'-40H ;^@ = Send a 300 ms. break tone 	;120H
NOCONNCT:	DB	'N'-40H ;^N = Disconnect from the phone line	;121H
LOGCHR: 	DB	'L'-40H ;^L = Send logon			;122H
LSTCHR: 	DB	'P'-40H ;^P = Toggle printer			;123H
UNSAVE: 	DB	'R'-40H ;^R = Close input text buffer		;124H
TRANCHR:	DB	'T'-40H ;^T = Transmit file to remote		;125H
SAVECHR:	DB	'Y'-40H ;^Y = Open input text buffer		;125H
EXTCHR: 	DB	'^'-40H ;^^ = Send next character		;126H
;
		DS	2		;				;128H
;
IN$MODCTL1:								;12AH
		IF	NOT CM4
		JMP	XSERVE		;GET STATUS, FILL BUFFER
		ENDIF

		IF	CM4
		CALL	XSERVE		;GET STATUS, FILL BUFFER
		JMP	CM4TEST 	;TEST FOR CARRIER IN CM4 MODEM
		ENDIF

		DS	(IN$MODCTL1+10-$) ;FILL REST OF 10 BYTES

OUT$MODDATP:	JMP	MDOUT		;OUT MODEM DATA PORT		;134H
		DS	7
IN$MODDATP:	JMP	XDATP		;in modem data port		;13EH
		DS	7
MASKR:		ANI	MODRCVB 					;148H
		RET
TESTR:		CPI	MODRCVR 					;14BH
		RET
MASKS:		ANI	MODSNDB 					;14EH
		RET
TESTS:		CPI	MODSNDR 					;151H
		RET
		DS	12						;154H
		DS	2		;for user message.		;160H

		IF	NOT CM4
		JMP	DIALOC		;DIALV				;162H
		ENDIF

		IF	CM4
		JMP	CM4DIAL 	;DIALV				;162H
		ENDIF

		JMP	DISCONN 	;DISCV				;165H
JMP$GOODBYE:	JMP	GOODBYE 	;				;168H
JMP$INITMOD:	JMP	INITMOD 	;go to user written routine	;16BH
JMP$NEWBAUD	JMP	NEWBAUD 	;Reset baudrate 		;16EH
		RET  !	NOP  !	NOP	;(by-passes PMMI routine)	;171H
		RET  !	NOP  !	NOP	;(by-passes PMMI routine)	;174H
JMP$SETUPR:	JMP	SETUPR		;				;177H
		DS	3		;				;17AH
JMP$SYSVER:	JMP	SYSVER		;				;17DH
JMP$BREAK:	JMP	SENDBRK 	;				;180H

; Do not change the following six lines.

JMP$ILPRT:	DS	3		;				;183H
JMP$INBUF	DS	3		;				;186H
JMP$INLNCOMP:	DS	3		;				;189H
JMP$INMODEM	DS	3		;				;18CH
JMP$NXTSCRN:	DS	3		;				;18FH
JMP$TIMER:	DS	3		;				;192H

CLREOS: 	CALL	XILPRT	;CALLED BY MEX ON EXIT FROM T MODE	;195H
		DB	27,'J',0
		RET

SYSVER: 	CALL	XILPRT

		DB	27,'x4',27,'x;',27,'v'

		DB	'For Zenith Z-120 modem port J'
		DB	(MODDATP-0E8H)/4+'1',' ('

		IF	NOT CM4
		DB	'Hayes Smartmodem)',CR,LF
		ENDIF

		IF	CM4
		DB	'Phone-TTY CM-4 Modem)',CR,LF
		ENDIF

		DB	'Overlay *JWS* 01/16/86'
		DB	CR,LF,LF,0
		LDA	MSPEED
		CALL	NEWBAUD 	;SET BAUD AND TELL USER
		RET

		IF	CM4
; CM4TEST -- TESTS FOR CARRIER IF CM4 MODEM RUNNING IN BELL 103 MODE

CM4TEST:
	PUSH	B
	PUSH	PSW		;DON'T CLOBBER STATUS INFO
	ANI	DSR+MODRCVB	;BUFFER EMPTY AND CARRIER LOST?
	JNZ	CM4T90		;STILL HAVE ONE OR OTHER, SO EXIT

	IN	MODCMD		;GET THE COMMAND REGISTER
	ANI	RTS+DTR 	;ARE WE OFF HOOK (CONNECTED)
	JNZ	CM4T10		;YES, CONTINUE

	IN	MODCTL1 	;WAIT FOR FALLING EDGE RING INDICATOR
	ANI	DSR		;(WE USE DSR FOR BOTH RI AND DCD)
	CPI	0		;COMPARE TO PREVIOUS VALUE
HOLDRI	EQU	$-1
	STA	HOLDRI		;AND MAKE PREVIOUS = MEW
	JNC	CM4T90		;C SET IF NEW = 00 AND OLD = DSR (080H)
	PUSH	H
	PUSH	D
	CALL	XILPRT		;PRINT "RING" JUST LIKE SMARTMODEM
	DB	CR,LF,'RING',CR,LF,0
	POP	D
	POP	H
	JMP	CM4T90
CM4T10:
	LDA	HOLDMR1 	;IN TTY MODE?
	CPI	N5
	JZ	CM4T90		;YES, DON'T CARE ABOUT CARRIER

	MVI	C,100		;100 * 10 MS. = 1 SECOND
CM4T20:
	MVI	A,10		;WAIT 10 MILLISECONDS
	CALL	MSDELAY
	IN	MODCTL1 	;NOW TEST CARRIER AGAIN
	ANI	DSR
	JNZ	CM4T90		;CAME BACK ON, GET OUT
	DCR	C		;LOOP FOR 1 SECOND
	JNZ	CM4T20

	CALL	DISCONN 	;REALLY LOST, DISCONNECT
	PUSH	H
	PUSH	D
	CALL	XILPRT		;SEND MESSAGE JUST LIKE SMARTMODEM
	DB	CR,LF,'NO CARRIER',CR,LF,0
	POP	D
	POP	H
CM4T90:
	POP	PSW
	POP	B
	RET

; CM4DIAL -- PULSE DIAL THE PHONE-TTY CM-4 MODEM

CM4DIAL:
	CPI	254			;START DIAL SEQUENCE?
	JC	CM4D40			;LOWER, MUST BE DIGIT
	JNZ	CM4D70			;MUST BE 255, END SEQUENCE

	CALL	CM4CONN 		;GO OFF HOOK
	MVI	C,14			;WAIT 2.1 SECONDS
CM4D10:
	CALL	MS150
	DCR	C
	JNZ	CM4D10
	RET				;AND RETURN TO MEX

CM4D40: 				;DIAL THE DIGIT IN A
	SUI	'0'			;GET AN ACTUAL COUNT
	RC				;IGNORE IF LESS THAN '0'
	JNZ	CMD4D45
	ADI	10			;'0' IS 10 PULSES
CMD4D45:
	CPI	11			;IGNORE IF GREATER THAN 10
	RNC

	MOV	C,A			;C IS NOW THE DIAL PULSE COUNT
CMD4D50:
	CALL	DISCONN 		;DISCONNECT
	MVI	A,60			;FOR 60 MILLISECONDS
	CALL	MSDELAY
	CALL	CM4CONN 		;THEN RECONNECT
	MVI	A,40			;AND WAIT 40 MILLISECONDS
	CALL	MSDELAY
	DCR	C			;AND REPEAT ACCORDING TO DIAL #
	JNZ	CMD4D50
	CALL	MS300			;THEN WAIT 600 MS. INTERDIGIT
	CALL	MS300			;SPACE
	RET				;AND RETURN TO MEX

CM4D70: 				;END DIAL SEQUENCE
	LDA	HOLDMR1 		;SEE IF TTY MODE
	CPI	N5
	JZ	CM4D87			;YES, EXIT, NO CARRIER TO TEST FOR

	LXI	B,CM4WAIT+256*10	;B = CARRIER CTR, C = WAIT TIME
CM4D80:
	MVI	L,10			;10 * 100 MS. = 1 SECOND
CM4D85:
	CALL	CM4DCD			;TEST FOR CARRIER
CM4D87:
	MVI	A,0			;ASSUME HAVE CARRIER
	RZ				;YES, WE'RE SET

	PUSH	H
	PUSH	B			;SEE IF ^C FROM KEYBOARD
	MVI	C,CHEKCC
	CALL	MEX
	POP	B
	POP	H
	MVI	A,3			;ASSUME SO
	JZ	CM4D90			;RETURN IF ^C

	MVI	A,100			;NOW WAIT .1 SECOND
	CALL	MSDELAY
	DCR	L			;DECR THE .1 SECOND COUNTER
	JNZ	CM4D85
	DCR	C			;DECR THE 1.0 SECOND COUNTER
	JNZ	CM4D80
	MVI	A,2			;NO ANSWER RESPONSE
CM4D90:
	PUSH	PSW			;PRESERVE RESULT CODE
	CALL	DISCONN 		;HANG UP THE PHONE
	POP	PSW			;RESTORE RESULT CODE
	RET				;AND RETURN TO MEX

; CM4DCD -- TEST FOR CARRIER

CM4DCD:
	IN	MODCTL1 		;READ THE STATUS PORT
	ANI	DSR			;WE USE DSR FOR CARRIER DETECT
	JNZ	CM4DCD2 		;SKIP IF HAVE CARRIER
	MVI	B,11			;DON'T HAVE IT, RESET THE COUNTER
CM4DCD2:
	DCR	B			;SETS ZERO FLAG ON 10 GOOD ONES
	RET

; CM4CONN -- GO OFF HOOK IN THE CORRECT MODE (TDD OR BELL 103)

CM4CONN:
	LDA	HOLDMR1 		;SEE WHAT MODE WE SHOULD BE IN
	CPI	N5			;BAUDOT?
	MVI	A,CM4TDD		;ASSUME SO
	JZ	CM4C20			;YES
	MVI	A,CM4ORIG		;NO, SET BELL 103 ORIGINATE
CM4C20:
	OUT	MODCMD			;AND GO OFF HOOK IN CORRECT MODE
	RET

	ENDIF	;CM4

; MODEM OUT -- BAUDOT TRANSLATION IF 5 DATA BITS

MDOUT:
	PUSH	H
	PUSH	B
	MOV	B,A			;SAVE BYTE TO SEND
	LDA	HOLDMR1 		;THEN CHECK IF 5 DATA BITS
	CPI	N5
	MOV	A,B			;RESTORE CHARACTER TO SEND
	JNZ	MT90			;NOT BAUDOT, WRITE IT OUT

	IF	CM4
	CALL	XADDBUF 		;LOCAL ECHO FOR TTY
	PUSH	PSW
	IN	MODCMD
	ANI	RTS+DTR
	CZ	CM4CONN 		;CONNECT IF WE'RE NOT ALREADY
	POP	PSW
	ENDIF

	CALL	ATOB			;TRANSLATE TO BAUDOT
	JM	MT95			;NO EQUIV., SKIP OUT
	JNC	MT90			;NO SHIFT REQ'D, SEND IT

	OUT	MODDATP 		;SEND THE SHIFT CODE
MT80:
	IN	MODCTL1 		;WAIT 'TIL READY TO SEND ANOTHER
	ANI	MODSNDB
	JZ	MT80
	LDA	HOLDBYT 		;AND LOAD HOLD BYT
MT90:
	OUT	MODDATP
MT95:
	POP	B
	POP	H
	RET

; SENDBRK -- SEND A 300 MS. BREAK

SENDBRK:IN	MODCMD		;READ THE COMMAND PORT
	ORI	BRK		;FORCE BREAK
	OUT	MODCMD
	CALL	MS300		;WAIT 300 MS. CLOBBERS A
	IN	MODCMD
	ANI	NOT BRK
	OUT	MODCMD
	RET

; GOODBYE -- CALLED ON MEX TERMINATION
; DISCONN -- CALLED BY MEX TO DISCONNECT MODEM

GOODBYE:
	CALL	XILPRT		;SET SCREEN BACK TO NORMAL
	DB	27,'x1',27,'j',27,'Y8 ',27,'K',27,'k' ;CLEAR LINE 25
	DB	27,'y4',27,'y;',27,'w',27,'y1',0      ;RESTORE MODES

	IN	MASKREG 	;RESTORE SERIAL PORT INTERRUPT
	ANI	0FFH		;TO ORIGINAL SETTING
SAVMASK EQU	$-1
	OUT	MASKREG
DISCONN:
	IN	MODCMD		;READ COMMAND REGISTER

	IF	NOT CM4
	ANI	NOT DTR 	;FOR SMARTMODEM, DROP DTR FOR 300 MS.
	OUT	MODCMD
	CALL	MS300		;WAIT 300 MS. CLOBBERS A
	IN	MODCMD
	ORI	DTR		;THEN BRING IT UP AGAIN
	ENDIF

	IF	CM4
	ANI	NOT (DTR OR RTS) ;FOR CM-4, DROP DTR,RTS AND LEAVE DOWN
	ENDIF

	OUT	MODCMD
	RET

; MODE REGISTER 1 VALUES FOR 2661 CHIP

N8	EQU	4EH		;1 STOP BIT NO PARITY 8 DATA BITS 16X ASYNCH
E7	EQU	7AH		;1 STOP EVEN PARITY 7 DATA BITS 16X ASYNCH
N5	EQU	82H		;1-1/2 STOP, NO PARITY 5 DATA BITS 16X ASYMCH

;CALLED AT INITIALIZATION TIME:

INITMOD:
	IN	MASKREG 	;INCASE CP/M EMULATOR UNDER DOS,
	PUSH	PSW
	ORI	NOT INTMASK
	STA	SAVMASK 	;DISABLE INTERRUPTS FROM SER PORT
	POP	PSW
	ORI	INTMASK
	OUT	MASKREG

	IF	NOT CM4
	MVI	A,CMDEF+DTR+RTS ;RTS, RESET ERR, DTR, ENABLE XMT,RCV
	ENDIF

	IF	CM4
	MVI	A,CMDEF 	;FOR CM-4, RTS AND DTR ARE LEFT OFF HERE
	ENDIF

	OUT	MODCMD		;SEND TO COMMAND REGISTER
	XRA	A		;CLEAR A REGISTER FOR MEX (?)
	RET

; SETUPR -- CALLED BY MEX WHEN SET COMMAND IS ISSUED

SETUPR:   CALL	XCLRBUF 	;FLUSH OUT THE BUFFER
	  MVI	C,SBLANK	;Any arguments?
	  CALL	MEX
	  JC	TELL		;If not, go display baud
	  LXI	D,CMDTBL
	  MVI	C,LOOKUP
	  CALL	MEX		;Parse argument
	  JC	BADBAUD 	;PRINT MESSAGE IF ERROR

SETUPOK:MOV	A,H		;GET MODE 1 REG VALUE
	STA	HOLDMR1 	;AND SAVE FOR INIT ROUTINE
	MOV	A,L		;GET MSPEED VALUE RETURNED FROM TABLE
	JMP	SETBAUD 	;NOW LOOKS JUST LIKE NEWBAUD CALL

; NEWBAUD -- CALLED BY MEX TO SET BAUD FROM PHONE DIRECTORY

NEWBAUD:PUSH	PSW		;NEW BAUD CALL ASSUMES NO PARITY, 8 DATA
	CALL	XCLRBUF 	;CLEAR MODEM INPUT BUFFER
	MVI	A,N8
	STA	HOLDMR1
	POP	PSW

SETBAUD:CPI	10		;MAKE SURE ITS LESS THAN 10
	JNC	BADBAUD 	;UNKNOWN VALUE, PRINT MESSAGE AND EXIT

	STA	MSPEED		;STORE NEW MSPEED VALUE
	MVI	D,0		;MOVE MSPEED VALUE TO DE
	MOV	E,A
	LXI	H,BAUDTAB	;POINT TO BAUD TABLE
	DAD	D		;ADD MSPEED VALUE
	MOV	A,M		;TABLE ENTRY TO A
	ORA	A		;MAKE SURE WE GOT A GOOD VALUE
	JZ	BADBAUD 	;IF NOT, PRINT ERROR MESSAGE
	STA	HOLDMR2 	;STORE VALUE FOR MODEM INIT ROUTINE
	CPI	72H		;SET TO 45 OR 50 BAUD?
	JNC	NOT45		;NO
	MVI	A,N5		;YES
	STA	HOLDMR1 	;SET 5 DATA BITS 1-1/2 STOP BITS
NOT45:
	  IN	MODCMD		;READ COMMAND REG TO RESET MR1/MR2 CYCLE
	  MVI	A,N8		;1 STOP, NO PARITY, 8 BITS, 16X ASYNCH
HOLDMR1   EQU	$-1
	  OUT	MODMODE 	;SEND TO MODE REGISTER 1

	  MVI	A,078H		;START WITH 1200 BAUD, INTERNAL CLOCK
HOLDMR2   EQU	$-1
	  OUT	MODMODE 	;SEND TO MODE REGISTER 2

	IF	CM4
	IN	MODCMD		;SEE IF WE'RE OFF HOOK
	ANI	RTS+DSR
	CNZ	CM4CONN 	;YES, GET SET IN CORRECT MODE
CM4IN10:
	ENDIF

TELL:
	  CALL	XILPRT		;Print current baud rate
	  DB	'(Current settings: ',0
	  LDA	MSPEED
	  MVI	C,PRBAUD
	  CALL	MEX
	  LDA	HOLDMR1
	  CPI	N8
	  JNZ	TELL1
	  CALL	XILPRT
	  DB	', no parity, 8 data, 1 stop bit',0
	  JMP	TELL2
TELL1:
	  CPI	E7
	  JNZ	TELL2
	  CALL	XILPRT
	  DB	', even parity, 7 data, 1 stop bit',0
TELL2:
	CPI	N5
	JNZ	TELL3
	CALL	XILPRT
	DB	', BAUDOT code, 5 data, 1-1/2 stop bits',0
TELL3:
	  CALL	XILPRT
	  DB	')',CR,LF,0
	  RET

BADBAUD:
	  CALL	XILPRT		;Tell user input not valid
	  DB	'Invalid baud rate. Valid baud rates are:',CR,LF
	  DB	'45, 50, 110, 300, 600, 1200, 2400, 4800, 9600, 19200',CR,LF
	  DB	'Default is no parity, 8 data bits.  Request even',CR,LF
	  DB	'parity, 7 data bits as: 300E7, 1200E7, etc.',CR,LF,0
	JMP	TELL

; TABLE OF BAUDRATE PARAMETERS FOR 2661 I/O

;		MR2:		MSPEED: BAUD:

BAUDTAB:DB	073H	;	0	  110
	DB	076H	;	1	  300
	DB	070H	;	2	  450 (45.45 baudot)
	DB	077H	;	3	  600
	DB	071H	;	4	  710 (50    baudot)
	DB	078H	;	5	 1200
	DB	07BH	;	6	 2400
	DB	07CH	;	7	 4800
	DB	07DH	;	8	 9600
	DB	07EH	;	9	19200

CMDTBL: DB	  '11','0'+80H,0,N8	;EACH ENTRY FOLLOWED BY
	DB	  '30','0'+80H,1,N8	;WORD CONTAINING MSPEED VALUE
	DB	   '4','5'+80H,2,N5
	DB	  '60','0'+80H,3,N8	;AND MODE1 REG VALUE
	DB	   '5','0'+80H,4,N5
	DB	 '120','0'+80H,5,N8
	DB	 '240','0'+80H,6,N8
	DB	 '480','0'+80H,7,N8
	DB	 '960','0'+80H,8,N8
	DB	'1920','0'+80H,9,N8

	DB	'110E','7'+80H,0,E7	;SAME, FOLLOWED BY 'E7'
	DB	'300E','7'+80H,1,E7	;FOR EVEN PARITY, 7 DATA BITS
	DB	'600E','7'+80H,3,E7
	DB     '1200E','7'+80H,5,E7
	DB     '2400E','7'+80H,6,E7
	DB     '4800E','7'+80H,7,E7
	DB     '9600E','7'+80H,8,E7
	DB    '19200E','7'+80H,9,E7

	DB	0	;END OF TABLE

;ROUTINES TO CALL BIOS CONIN AND CONOUT ROUTINES

CONSTAT:
	CALL	XSERVE		;SERVICE THE MODEM FIRST
	LHLD	0001H		;SAME AS CONIN, BUT DISPLACEMENT IS 3
	LXI	D,3
	DAD	D
	PCHL

CONIN:
	CALL	CONSTAT 	;WAIT VIA CONSTAT TO SAMPLE MODEM
	ORA	A
	JZ	CONIN
	LHLD	0001H		;GET WARM BOOT POINTER
	LXI	D,6		;DISPLACEMENT FROM WBOOT TO CONIN
	DAD	D		;ADD TO WBOOT
	PCHL			;JUMP TO CONIN ROUTINE

CONOUT:
	PUSH	B		;SAVE CHAR AND SERVICE MODEM
	CALL	XSERVE
	POP	B
	LHLD	0001H		;SAME AS CONIN, BUT DISPLACEMENT IS 9
	LXI	D,9
	DAD	D
	PCHL

;OVERLAY THE MEX VECTORS:

XBEGIN: EQU	$
	ORG	STSVEC		;CON STAT
	DW	CONSTAT
	ORG	INVEC		;CON IN
	DW	CONIN
	ORG	OUTVEC		;CON OUT
	DW	XCOUT
	ORG	XBEGIN

;OUR CONSOLE OUTPUT ROUTINE PERFORMS SCREEN CLEARS LINE BY LINE
XCOUT:
	IF	CONLF
	LDA	ESCSW		;PREVIOUS CARRIAGE RETURN?
	CPI	13
	JNZ	XCOUT1		;NO
	MOV	A,C
	CPI	10		;CR FOLLOWED BY LF?
	JZ	XCOUT1		;YES, NO SPECIAL HANDLING
	PUSH	B		;CR NOT FOLLOWED BY LF, SO INSERT ONE
	MVI	C,10
	CALL	CONOUT
	POP	B
	ENDIF

XCOUT1: LDA	ESCSW
	CPI	27
	MOV	A,C		;(MOVE THIS CHAR TO A AND SAVE IN ESCSW
	STA	ESCSW		;      FIRST)
	JNZ	XNPESC		;SKIP IF NOT PREVIOUS ESCAPE CODE
	CPI	'E'
	JZ	XFORMFD
	IF	ESCLJ
	CPI	'j'
	JZ	XFORMFD
	ENDIF
	CPI	'J'
	JZ	XCLEOS
	PUSH	B		;SAVE CURRENT CHAR AND PUT OUT THE
	MVI	C,27		;ESCAPE WE DROPPED LAST TIME
	CALL	CONOUT
	POP	B
XNPESC: CPI	27		;THIS ONE ESCAPE?
	RZ			;YES, RETURN, HANDLE NEXT TIME
	IF	DESBACK
	CPI	8		;IF BACKSPACE, MAKE IT DESTRUCTIVE
	JZ	XDESTBS
	ENDIF
	CPI	12		;FORM FEED?
	JNZ	CONOUT		;NO, LET CP/M PROCESS THIS CHARACTER

XFORMFD:CALL	XILPRT		;BEGIN FORM FEED WITH HOME CURSOR
	DB	27,'H',0
XCLEOS: CALL	XILPRT		;SAVE CURSOR LOC, TURN OFF, REPORT POS
	DB	27,'j',27,'x5',27,'n',0 	;x5=OFF  y5=ON
XRRPT:	CALL	CONIN		;GET THE CURSOR POSITION REPORT
	CPI	'Y'		;(SKIP OVER THE ESCAPE 'Y')
	JNZ	XRRPT
	CALL	CONIN		;GET THE ROW AND SAVE IT
	PUSH	PSW
	CALL	CONIN		;GET THE COLUMN AND THROW AWAY
	POP	B		;PREV A IS NOW IN B
	MVI	A,32+23+1	;COMPUTE # LINES TO CLEAR
	SUB	B
XCLOOP: PUSH	PSW
	CALL	XILPRT		;CLEAR THEN DOWN ONE LINE
	DB	27,'K',13,27,'B',0	;CLEAR THIS LINE, DROP TO NEXT
	POP	PSW
	DCR	A
	JNZ	XCLOOP
	CALL	XILPRT		;PUT CURSOR BACK AND TURN IT ON
	DB	27,'k',27,'y5',0
	RET

	IF	DESBACK
XDESTBS:CALL	XILPRT		;DESTRUCTIVE BACKSPACE FOR
	DB	8,' ',8,0	;COMPUSERVE
	RET
	ENDIF

XILPRT: POP	H		;GET STRING POINTER
	MOV	C,M		;GET CHARACTER TO PRINT
	INX	H		;BUMP STRING POINTER
	PUSH	H		;AND PUT BACK ON STACK
	MVI	A,0		;GET A ZERO
	CMP	C		;LAST BYTE?
	RZ			;YES, RETURN TO CALLER
	CALL	CONOUT		;CALL CONSOLE OUTPUT ROUTINE
	JMP	XILPRT		;AND GO BACK FOR NEXT CHARACTER

; ROUTINE TO LOAD DATA PORT -- GETS DATA FROM THE BUFFER INSTEAD

XDATP:	PUSH	H		;SAVE REG
	CALL	XSERVE		;UPDATE BUFFER IF NECESSARY
	LHLD	BUFOUT		;BUFFER OUTPUT POINTER
	LDA	BUFIN		;COMPARE WITH INPUT POINTER
	CMP	L		;IF EQUAL (EMPTY)
	JNZ	XDAOK		;THEN BACKUP, SO WE GIVE SAME CHAR AS
	DCR	L		;LAST TIME
XDAOK:	MOV	A,M		;GET DATA BYTE
	PUSH	PSW		;AND SAVE IT
	INR	L		;BUMP POINTER (256 BYTE WRAPAROUND)
	SHLD	BUFOUT		;AND SAVE NEW POINTER
	LDA	BUFIN		;DID WE JUST EMPTY THE BUFFER?
	CMP	L
	JNZ	XDAFUL		;NO
	MVI	A,0		;YES CLEAR THE SWITCH
	STA	BUFSTAT+1
XDAFUL: POP	PSW
	POP	H		;RESTORE REG
	RET			;RETURN

XCLRBUF:LDA	BUFIN		;CLEAR THE BUFFER (CALLED WHEN
	STA	BUFOUT		;BAUD RATE SET)
	MVI	A,0
	STA	BUFSTAT+1
	RET

;ROUTINE TO PUT INCOMING DATA INTO THE BUFFER

XSERVE:
	PUSH	H
	IN	MODCTL1 	;READ MODEM CONTROL PORT
	PUSH	PSW		;SAVE CONTROL PORT ON STACK
	ANI	MODRCVB 	;TEST THE BIT
	JZ	XSERV9		;RETURN FAST IF NO DATA
	LDA	HOLDMR1 	;IS THIS BAUDOT MODE?
	CPI	N5
	IN	MODDATP 	;GET DATA FROM MODEM
	JNZ	XSERV8		;GO STORE IT IN BUFFER
	CALL	BTOA		;TRANSLATE BAUDOT TO ASCII
	JZ	XSERV9		;SHIFT ONLY, DON'T STORE
XSERV8:
	CALL	XADDBUF 	;ADD THIS BYTE TO RING BUFFER
XSERV9:
	POP	PSW		;GET ORIGINAL STATUS
	ANI	NOT MODRCVB	;MAY BE THROWING AWAY SHIFT CODE

BUFSTAT:ORI	$-$		;OR IN ACTUAL BUFFER STATUS
	POP	H
	RET			;EXIT

; XADDBUF -- ADD AN ASCII BYTE TO THE RING BUFFER

XADDBUF:
	PUSH	PSW
	LHLD	BUFIN		;GET BUFFER POINTER
	MOV	M,A		;AND STORE IN BUFFER
	INR	L		;BUMP THE POINTER (256 BYTE WRAP AROUND)
	SHLD	BUFIN		;AND SAVE THE POINTER
	MVI	A,MODRCVB	;INDICATE ...
	STA	BUFSTAT+1	;BUFFER HAS DATA
	POP	PSW
	RET

ESCSW	DB	0
BUFIN	DW	BUFFER
BUFOUT	DW	BUFFER

; MSDELAY -- DELAY NUMBER OF MILLISECONDS IN A REGISTER
; NOTE: Z-100 ADDS 1 WAIT STATE PER MEMORY ACCESS

; TIME = A * 218 * 24 * .2 MICROSECONDS = .99 MILLISECONDS

MS300:
	CALL	MS150
MS150:
	MVI	A,150
MSDELAY:
	PUSH	B
MSDELA2:
	MVI	C,208
MSDELA3:
	DCR	C		;( 5 + 1) * 217 * A
	NOP			;( 4 + 1) * 217 * A
	JNZ	MSDELA3 	;(10 + 3) * 217 * A
	DCR	A		;( 5 + 1) * A
	NOP			;( 4 + 1) * A
	JNZ	MSDELA2 	;(10 + 3) * A
	POP	B
	RET

; ASCII -- BAUDOT TRANSLATION ROUTINES

SHFTSTA DB	00H		;SHIFT STATE, 00=LTRS 20H=FIGS
XSHIFT	DB	0FFH		;FORCE SHIFT IF NOT 00H OR 20H
HOLDBYT DB	0		;HOLD ADDITIONAL BYTE FOR ATOB ROUTINE

; ATOB - TRANSLATE ASCII TO BAUDOT
; SF RETURNED INDICATES NOT VALID BAUDOT CHARACTER
; CY RETURNED INDICATES TO GET ADDITIONAL BYTE FROM HOLDBYT

ATOB:
	PUSH	H
	PUSH	B
	MVI	H,ASBAUD/256	;POINT TO TRANSLATE TABLE
	MOV	L,A		;ADD CHARACTER
	MOV	A,M		;LOAD RESULT FROM TABLE
	ORA	A
	JM	AB60		;INVALID CHARACTER IF SIGN BIT SET

	PUSH	PSW		;SAVE IT
	ANI	1FH
	STA	HOLDBYT 	;BAUDOT CHARACTER IN HOLDBYT
	POP	PSW
	ANI	60H		;ISOLATE SHIFT BITS
	CPI	40H		;IS ANY SHIFT OK SET?
	JC	AB10		;NO
	LDA	SHFTSTA 	;YES, MAKE REQ = CURRENT
AB10:
	MOV	C,A		;SAVE SHIFT REQ AGAIN
	LDA	XSHIFT		;NOW GET CURRENT TRANSMIT STATE
	CMP	C		;AND COMPARE REQUESTED TO CURRENT
	LDA	HOLDBYT 	;LOAD BAUDOT CHARACTER IN CASE OK
	JZ	AB40		;RETURN IF SHIFT NOT REQ'D (CY CLEAR)
AB20:
	MOV	A,C		;GET REQUESTED SHIFT
	ANI	20H		;ZF ACCORDING TO REQUESTED SHIFT
	STA	SHFTSTA 	;SET NEW CURRENT SHIFT STATE
	STA	XSHIFT
	MVI	A,LTRS		;LETTERS IF NOT SET
	JZ	AB30
	MVI	A,FIGS		;FIGS IF SET
AB30:
	STC			;SET CARRY TO INDICATE HOLDBYT HAS CHAR
AB40:
	PUSH	PSW
	LDA	HOLDBYT
	CPI	BLF		;FORCE SHIFT AFTER LINEFEED
	JNZ	AB50
	STA	XSHIFT
AB50:
	POP	PSW
AB60:
	POP	B
	POP	H
	RET

; BTOA - TRANSLATE BAUDOT TO ASCII

BTOA:
	PUSH	H
	CPI	FIGS		;FIGS SHIFT
	JNZ	BA10
	MVI	A,20H
	JMP	BA15
BA10:
	CPI	LTRS
	JNZ	BA20
	MVI	A,00H
BA15:
	STA	SHFTSTA
	JMP	BA30		;RETURN WITH ZF SET
BA20:
	MVI	H,BAUDAS/256	;POINT TO TABLE
	PUSH	PSW
	LDA	SHFTSTA 	;GET CURRENT SHIFT STATE
	MOV	L,A
	POP	PSW
	ADD	L		;NOW GET CHAR + SHIFT STATE IN A
	ADI	BAUDAS AND 255	;NOTE: BAUDAS TABLE MUST NOT CROSS PAGE
	MOV	L,A		;HL = XLAT_TABLE + SHIFT_STATE + CHARACTER
	STA	XSHIFT		;(FORCE SHIFT IN NEXT CALL TO ATOB)
	MOV	A,M		;(NOTE ZF IS CLEAR AFTER ADI ABOVE)
BA30:
	POP	H
	RET

; ASCII -- BAUDOT TRANSLATION TABLES

FIGS		EQU	1BH	;BAUDOT CODE FOR FIGS SHIFT
LTRS		EQU	1FH	;BAUDOT CODE FOR LTRS SHIFT
BLF		EQU	02H	;BAUDOT CODE FOR LINE FEED
BCR		EQU	08H	;BAUDOT CODE FOR CARRIAGE RETURN

;IN THE FOLLOWING TABLE, BIT7=1 IS NO BAUDOT EQUIV, BIT6=1 MEANS LTRS SHFT
;BIT5=1 MEANS MUST BE FIGS SHIFT.

;			 0   1	 2   3	 4   5	 6   7
;			 8   9	 A   B	 C   D	 E   F

	ORG	($+255)AND 0FF00H ;MUST START ON PAGE BOUNDARY
ASBAUD:
		DB	80H,80H,80H,80H,80H,80H,80H,25H 	;00H-07H
		DB	40H,80H,42H,80H,80H,48H,80H,80H 	;08H-0FH
		DB	80H,80H,80H,80H,80H,80H,80H,80H 	;10H-17H
		DB	80H,80H,80H,80H,80H,80H,80H,80H 	;18H-1FH
		DB	44H,2DH,31H,34H,29H,80H,3AH,2BH 	;20H-27H
		DB	2FH,32H,80H,80H,2CH,23H,3CH,3DH 	;28H-2FH
		DB	36H,37H,33H,21H,2AH,30H,35H,27H 	;30H-37H
		DB	26H,38H,2EH,3EH,80H,80H,80H,39H 	;38H-3FH
		DB	80H,03H,19H,0EH,09H,01H,0DH,1AH 	;40H-47H
		DB	14H,06H,0BH,0FH,12H,1CH,0CH,18H 	;48H-4FH
		DB	16H,17H,0AH,05H,10H,07H,1EH,13H 	;50H-57H
		DB	1DH,15H,11H,80H,80H,80H,80H,80H 	;58H-5FH
		DB	80H,03H,19H,0EH,09H,01H,0DH,1AH 	;60H-67H
		DB	14H,06H,0BH,0FH,12H,1CH,0CH,18H 	;68H-6FH
		DB	16H,17H,0AH,05H,10H,07H,1EH,13H 	;70H-77H
		DB	1DH,15H,11H,80H,80H,80H,80H,40H 	;78H-7FH   

BAUDAS: 	;MUST NOT CROSS PAGE, MUST NOT START AT PAGE BNDRY

		DB	8,'E',10,'A SIU',13,'DRJNFCK'		;LETTERS
		DB	'TZLWHYPQOBG',0A0H,'MXV',80H
		DB	8,'3',10,'- ',7,'87',13,'$4',27H,',!:(' ;FIGURES
		DB	'5")2#6019?&',0A0H,'./;',80H

	ORG	($+255)AND 0FF00H

BUFFER: DS	256	;MUST BE ON PAGE BOUNDARY

; NOTE:  MUST TERMINATE PRIOR TO 0B00H (with Smartmodem)
;
	  END
;
