/* 		Gemini Justification & Print Program

  purpose: takes files created with perfect writer (or any similar 
           editor that creates files) and justifies and prints them
	   on a gemini printer.  Justification commands supported
	   are listed below.  
	   This program is written in C for the C/80 compiler.
*/
#define BS '\010'
#define HT '\011'
#define LF '\012'
#define VT '\013'
#define FF '\014'
#define CR '\015'
#define WORDLEN    40   /* Maximum word length */
#define NUMLINES   56   /* Number of lines per page */
#define NUMWORDS   30   /* Max number of words per line */
#define SIZE       65   /* Line length */ 
#define NONE 	    0
#define UNDERLINE   1 
#define SUBSCRIPT   2   /* Underline, Subscript, Superscript, italics, */
#define CENTER      3   /* doublestrike, possible at same time = 1,2,4,8,16 */
#define SUPERSCRIPT 4 
#define RIGHT	    5 
#define LEFT	    6 
#define TAB	    7 
#define ITALICS     8 
#define FOOT	    9
#define QUOTE      10
#define DSTRIKE    16
#define TRUE  	    1
#define FALSE       0
#define EOF        -1
#define EOF2       '\032'
#include "printf.c"
char word[NUMWORDS][WORDLEN], /* Buffer for words in a line */
     footbuff[500], /* Buffer for footnote */
     resp2[20];  /* Response to questions */
int spage,		   /* page to start printing on */
    epage,		   /* page to end printing on */
    apres[NUMWORDS],	   /* # of spaces after a word */
    fstart[SIZE+WORDLEN], /* print code for before a word */
    fend[SIZE+WORDLEN],   /* print code for after a word */
    letter,
    pageno,		/* page number */
    quotflag,		/* quote in progress */
    holdpara,		/* hold paragraph flag */
    printnow,		/* flag=TRUE if printing */
    flines,		/* lines - footnote */
    con,		/* console channel */
    chan,		/* Input file channel */
    ptr,		/* printer channel */
    stack[8],		/* bracket stack */
    sp,			/* stack pointer */
    place,		/* place in line */
    wordnow,		/* in the middle of a word now? */
    double,		/* Double spacing flag */
    number,		/* Page numbering flag */
    paraflag,		/* paragraph flag */
    footflag,		/* flag=TRUE if footnote in progress */
    footptr,		/* pointer to footnote buffer */
    wordlong[NUMWORDS], /* lengths of stored words */
    lines,		/* Number of lines so far on this page */
    wordsize,		/* size of present word */
    wordcount, 		/* number of words in line so far */
    underln,		/* flag=TRUE if underlining */
    linelen;		/* line length */
main (argc, argv)
char *argv[];
int argc;
{
int sum,prev,atfound,last,leftnow,rightnow,tabnow, i, k, c;
char file[15];
con = fopen("CON:","u");
fprintf(con," V1.1        Gemini Justification & Print Program\n\n");
if (argc == 1) {
    fprintf(con,"Usage: GEMINIPR filename\n\n");
    fprintf(con," Formatting commands accepted:\n\n");
    fprintf(con," @u(..)  Underline    @b(..)  suBscript    @p(..)  suPerscript\n");
    fprintf(con," @r(..)  Rightify     @l(..)  Leftify      @c(..)  Centre\n");
    fprintf(con," @d(..)  Doublestrike @i(..)  Italics      @s      Section\n");
    fprintf(con," @f(..)  Footnote     @q(..)  Quote        @t(..)  Tab for closing\n");
    fprintf(con," @###@   Prints character ###. (see printer manual for numbers)\n");
    exit();}
/* Open printer */
if ((ptr = fopen("LST:","w")) ==0) {
    fprintf(con,"Can't open printer\n");
    exit(); } 
/* Open input file */
if ((chan = fopen(argv[1],"r")) == 0) {
    fprintf(con,"Unable to open file: %s\n",argv[1]);
    exit();}
/* Ask option questions */
fprintf(con," Double spaced"); 
double = giveresp();
fprintf(con," Pages numbered"); 
number = giveresp();
fprintf(con," Start on Page Number? 1"); putchar(BS);
getline(resp2);
spage = atoi(resp2);
if (spage==0) printnow = TRUE; else printnow = FALSE;
fprintf(con," End after Page Number? #"); putchar(BS);
getline(resp2);
epage = atoi(resp2);
/* Printer set up */
fprintf(ptr,"\033M\010");	 /*  set lefthand print margin to 8 */
fprintf(ptr,"\033P\004\076");    /*  set vertical tabs at lines 4 & 62 */
putc('\0',ptr); 
fprintf(ptr,"\033D\052\060");	 /*  set horizontal tabs at 42 and 48*/
putc('\0',ptr);
nputc(VT);			 /* Go to line 4 */
/*   initialisation phase */
for (i=0;i<=NUMWORDS;apres[i++]=0);  
for (i=0;i<=SIZE;i++) { fstart[i] = NONE; fend[i] = NONE; }
lines = pageno = 1;
paraflag = TRUE;
linelen = 2; flines = footptr = 0;
/*   Main loop starts */
while (1) {
/*   Per program initialisation  */
quotflag=underln=prev=footflag=leftnow=tabnow=rightnow=atfound=wordnow=FALSE;
sp = letter = sum = place = wordcount = 0; 
/* Input data to be formatted here */
while (((c = getc(chan)) != EOF) && (c != EOF2)) {
    c = c & 127;
    switch (c) {
    case LF:
    case CR:
    case '\t':
    case ' ': finishword();       /* blank, cr, lf end a word */
	      if (c == LF) {
	          if (leftnow) dumpline();
	          else if (rightnow) rightfix();
		  else if (tabnow) tabfix();
		  else if (prev) {
		      if (wordcount)
	      		dumpline();
	      	      linefeed(); 
       	      	      paraflag = TRUE;
	              linelen += 2; 
		   }
	      }
    	      break;
    case '@': if (sum) {
		c = sum;
		sum = 0;
		atfound = FALSE; 
		goto cont; }
	      else {
		atfound = TRUE;	/* at character used in formatting commands */
	        holdpara = paraflag; 
                break; }
    case '(': if (atfound) {    /* ( used in formatting */
		atfound = FALSE;
		stack[sp++] = last; /* push bracket indicator on stack */
		if (last==UNDERLINE||last==SUBSCRIPT||last==SUPERSCRIPT||last==ITALICS||last==DSTRIKE) 
		    fstart[place] |= last;
                break; }
	      else { 
		stack[sp++] = NONE; 
		goto cont; }
    case ')': last = pop();	/* ) used in formatting */
	      if (last) {
		switch (last) {
		    case UNDERLINE:
		    case SUBSCRIPT:
		    case SUPERSCRIPT:
		    case ITALICS:
		    case DSTRIKE: fend[place] |= last;
				  break;
		    case TAB: finishword();
			      tabfix();
			      tabnow = FALSE;
			      break;
		    case CENTER: finishword();
				 centerfix();
				 break;
		    case RIGHT: finishword();
				rightfix();
				rightnow = FALSE;
				break;
		    case FOOT: finishword();
			       if (wordcount) dumpline();
			       footbuff[footptr++] = '\n';
			       footbuff[footptr] = EOF;
			       footflag = FALSE;
			       break;
		    case QUOTE: finishword();
				dumpline();
				quotflag = FALSE;
				break;
		    case LEFT: finishword();
		 	       dumpline(); 
			       leftnow = FALSE;
                  	       break; 
		} /* switch */
	        if (last==TAB||last==CENTER||last==QUOTE||last==LEFT||last==RIGHT||last==FOOT) {
			paraflag = holdpara;  
			if (paraflag) linelen += 2; 
			if (quotflag) linelen += 6; }
		break;
	    } /* if */
	    else goto cont;
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9': if (atfound) {
		 sum = (sum * 10) + (c - '0');
		 break; } 
    case 'S':
    case 's': if (atfound) {	/* Print the section character */
		atfound = FALSE;
		c = 201; 
		goto cont; }
    case 'R':
    case 'r': if (atfound) { /* rightify */
		if (wordcount) dumpline();
		linelen = 0;
		paraflag = FALSE;
		last = RIGHT;
		rightnow = TRUE;
		break; }
    case 'q':
    case 'Q': if (atfound) {
	     	if (wordcount) dumpline();
	      	quotflag = TRUE;
	      	linelen = 6;
	      	paraflag = FALSE;
	      	last = QUOTE;
	      	break; }
    case 'f':
    case 'F': if (atfound) {
		if (wordcount) dumpline();
		footflag = TRUE;
		last = FOOT;
		break; }
    case 'T':
    case 't': if (atfound) {   /*tab over for yours sincerely */
		if (wordcount) dumpline();
		linelen = 0;
		paraflag = FALSE;
		last = TAB;
		tabnow = TRUE;
		break; }
    case 'L':
    case 'l': if (atfound) {	/* leftify */
		if (wordcount) dumpline();
		linelen = 0;
		leftnow = TRUE;
		last = LEFT;
		paraflag = FALSE;
		break; }
    case 'C':
    case 'c': if (atfound) {	/* center */
		if (wordcount) dumpline();
		linelen = 0;
		paraflag = FALSE;
		last = CENTER;
		break; }
    case 'B':
    case 'b': if (atfound) {	/* subscript */
		last = SUBSCRIPT;
	 	break; }
    case 'P':
    case 'p': if (atfound) {	/* superscript */
		last = SUPERSCRIPT;
		break; }
    case 'I':
    case 'i': if (atfound) { /* italics */
		last = ITALICS;
		break; }
    case 'D':
    case 'd': if (atfound) {	/* doublestrike */
		last = DSTRIKE;
		break; }
    case 'U':
    case 'u': if (atfound) {	/* underline */
		  last = UNDERLINE;
                  break; }
    cont:
    default: if (atfound) {		/* add @ to word */
		word[wordcount][letter++] = '@';
		atfound = FALSE; }
	     word[wordcount][letter++] = c;  /* add letter to word */
	     place++;
	     wordnow = TRUE;
    }
/* If long enough, either dump (add no spaces) or justify line */
    if ((linelen-1) == SIZE) 
	dumpline();
    else if ((linelen-1) > SIZE) 
	justify();
    if (c==LF) prev = TRUE;
    else if (c != CR) prev = FALSE;
}
/* finish off last word, close file, dump line */
word[wordcount++][letter] = '\0';
fclose(chan);
dumpline();
chan = 0;
/* ask for next file & open it */
while (!chan) { 
    fprintf(con," Next file name or <Return> if done? ");
    getline(file);
    if (file[0] == '\0') break;
    chan = fopen(file,"r");
    if (!chan)
	fprintf(con," Cannot Open: %s\n",file);
}
if (!chan) break;
}
/* when done, put on page number if desired, close files */
while (lines != 1) linefeed();
fclose(ptr);
fclose(con);
exit();
}

/* pop a bracket indicator from the stack */
pop() {
    if (sp) return(stack[--sp]);
    else return(0);
}

/* Input a line from the console */
getline(data)
char data[];
{
    int c,i;
    i = 0;
    while ((c = getchar()) != LF)
	data[i++] = c; 
    data[i] = '\0';
}

/* center text */
centerfix() {
int j;
    linelen--;
    linelen = SIZE - linelen;
    linelen /= 2;
    for (j=1;j<=linelen;j++) jputc(' ');
    dumpline();
}

/* rightify text */
rightfix() {
int j;
    linelen--;
    linelen = SIZE - linelen;
    if (underln) {
	jprintf("\033-",0);  jputc('\0'); } /* stop underline */
    for (j=1; j<=linelen; j++) jputc(' ');
    if (underln) jprintf("\033-\001",0);    /* start underline */
    dumpline();
}

/* tabify text */
tabfix() {
    jputc(HT);
    jputc(HT);
    dumpline();
}

/* Stop underline momentarily for tab in, new paragraph */
checkun(data) 
char data[]; {
    if (underln) {
	jprintf("\033-",0);
	jputc('\0');		/* stop underline  */
	jprintf(data,0);	/* print spaces    */
	jprintf("\033-\001",0); /* start underline */
    } else
	jprintf(data,0);
}

/* print paragraph spaces if necessary */
paragraph() {
    if (quotflag) checkun("      ");
    if (paraflag) {
	checkun("  "); 
	paraflag = FALSE;}
}

/* Dump a line: print it, adding no spaces to it */
dumpline() {
int j;
       paragraph();
       place = 0;
       for (j=0;j<=wordcount-1;j++) {
		showword(j);
		if (j != wordcount-1)
		    jputc(' '); 
       }
       linefeed();
       linelen = place = wordcount = 0;
       if (quotflag) linelen = 6;
}

/* add end character on word */
finishword() {
  if (wordnow) {
    wordnow = FALSE;
    wordlong[wordcount] = letter; 
    word[wordcount++][letter] = '\0';
    linelen += (letter + 1);
    wordsize = letter;
    letter = 0; }
}

/* Split hyphenated words at end of line if possible */
hyphen() {
    int i,j,posn;
    i=0; posn=0;

    while (word[wordcount][i] != 0)
        if (word[wordcount][i++] == '-')
	    posn = i-1;

    if (posn != 0) {
        if (linelen+posn+2 <= SIZE) {
	    wordcount++; linelen+=(posn+2);
	    i = posn+1; j=0;
 	    while (word[wordcount-1][i-1] != 0)
	        word[wordcount][j++] = word[wordcount-1][i++];
	    word[wordcount-1][posn+1] = 0;
	    wordlong[wordcount] = j-1; wordsize = j-1;
        }
    }
}

/* left and right justify and print a line */
justify() {
  int oplace,perword,extra,j,k,d;
       paragraph();
       wordcount--;
       linelen -= (wordsize +2);
       hyphen();
       oplace = place - wordsize;
       place = 0;
/* calculate number of spaces to add */
       linelen = SIZE - linelen;
       perword = (linelen / (wordcount-1));
       extra = linelen % (wordcount-1);
/* figure out where to add spaces */
/* first: after .,;?! 		  */
	if (extra) {
 	    for (j=0;j<(wordcount-2);j++) {
		d = word[j][(wordlong[j] - 1)];
		if (d=='.' || d==',' || d==';' || d=='?' || d=='!') {
		    apres[j]++;
		    extra--; 
		    if (!extra) break; }
	    }
	}
/* then, around short words first until done */
	if (extra) {
	    for (k=1;k<=WORDLEN;k++) {
		for (j=0;j<(wordcount-2);j++) {
		    if (!apres[j]&&(wordlong[j] == k || wordlong[j+1] == k)) {
			apres[j]++;
			extra--; 
		        if (!extra) break; }
		}
		if (!extra) break;
	    }
	} 
/* Print the words */
       for (j=0;j<=(wordcount-1);j++){
	   showword(j);
           for (k=0;k<=perword;k++)
               if (j != wordcount-1)
     		  jputc(' ');
/* add spaces */
       for (k=1;k<=apres[j];k++)
	   jputc(' ');
	   apres[j] = 0;
       }
       linefeed();
       place = 0;
/* save last word for next sentence */
       for (j=0;j<=wordsize;j++) {
		fstart[place] = fstart[oplace];
		fend[place++] = fend[oplace];
		fstart[oplace] = fend[oplace] = 0;
		oplace++;
		word[0][j] = word[wordcount][j]; }
       linelen = wordsize+1;
       if (quotflag) linelen += 6;
       wordcount = 1;
       place = wordsize;
}

/* Print a word and add in printer instructions */
showword(j)
int j; {
int k = 0;
  while (word[j][k] != '\0') {
/* print pre-letter printer instructions */
    if (fstart[place]) {
	if (fstart[place] & UNDERLINE) {
	    underln = TRUE;
	    jprintf("\033-\001",0); }
	if (fstart[place] & SUBSCRIPT)
	    jprintf("\033S\001",0); 
	if (fstart[place] & SUPERSCRIPT) {
	    jprintf("\033S",0); jputc('\0');}
	if (fstart[place] & ITALICS) 
	    jprintf("\0334",0); 
	if (fstart[place] & DSTRIKE) 
	    jprintf("\033G",0); 
	fstart[place] = NONE;
    }
/* print letter */
    jputc(word[j][k++]);
    place++;
/* print post-letter printer instructions */
    if (fend[place]) {
	if (fend[place] & UNDERLINE) {
	    underln = FALSE;
	    jprintf("\033-",0); jputc('\0'); }
	if (fend[place] & SUBSCRIPT) 
	    jprintf("\033T",0); 
	if (fend[place] & SUPERSCRIPT)
	    jprintf("\033T",0); 
	if (fend[place] & ITALICS) 
	    jprintf("\0335",0); 
	if (fend[place] & DSTRIKE) 
	    jprintf("\033H",0);
	fend[place] = NONE;
    }
  }
}

/* print linefeed, count lines, end page if nec */
linefeed() {
    jputc('\n');
    if (footflag) flines++; 
    else { lines++; newpage(); }
    if (double && lines!=1 && !footflag) {
	jputc('\n');
	lines++; newpage();
    }
}

/* Print footnote, page number; start new page */
newpage() {
/* Print footnote if ready */
   if (!footflag && flines>0 && NUMLINES-lines == flines+1) {
	    nprintf("_____________________________\n",0);
	    lines++;
 	    footptr = 0;
	    while (footbuff[footptr] != EOF)
		nputc(footbuff[footptr++]);
	    lines += flines;
	    flines = footptr = 0; }
/* Print page number and go to new page when nec. */
   if (lines == NUMLINES) {
	nputc(VT);
	nputc(HT);
	if (number) nprintf("%d\n",pageno);
	pageno++;
	if (pageno==spage) printnow=TRUE;
	else if ((pageno-1)==epage) printnow=FALSE;
	nputc(VT);
	lines = 1;}
}

/* get a y/n response from the console. <cr> = no */
giveresp() {
char resp[10];
    fprintf(con," (y/n)? y\010");
    getline(resp);
    if (resp[0] == 'n' || resp[0] == 'N')
	return(FALSE);
    else
	return(TRUE);
}

/* print a character if printing now. Possibly put in footnote buffer */
jputc(t)
char t; {
    if (printnow) {
	if (footflag) footbuff[footptr++] = t;
	else putc(t,ptr); }
}

/* print character if printing now. No footbuffer access. */
nputc(t)
char t; {
    if (printnow) 
	putc(t,ptr);
}

/* print a string or put in footbuffer */
jprintf(t,val) 
int val;
char t[];
{ int n=0;
  char temp[75];
  if (printnow) {
    if (footflag) {
	sprintf(temp,t,val);
	while (temp[n] != '\0')
	   footbuff[footptr++] = temp [n++]; }
    else 
	fprintf(ptr,t,val); }
}

/* print string if printing now. No footbuffer access  */
nprintf(t,val)
int val;
char t[]; {
    if (printnow)
	fprintf(ptr,t,val);
}


/* atoi - convert string s to integer */
atoi(s) 
char *s; 
{
register int n;
if (*s=='\n') return(0);
for (;*s == ' ' || *s == '\t' || *s == '\n'; s++)
	/* skip white space */;
for (n= 0; '0' <= *s && *s <= '9'; s++) {
	n*= 10;
	n+= *s - '0';
	}
return(n);
}
