;---------------------------------------------------------------------
; BAUD19.ASM           v2.1			wcw 29 May 84
;
; this program sets the baudrate at the OSBORNE 1's RS232 port 
; to 19,200 baud... ON DOUBLE DENSITY, ROM 1.43 machines
; by setting the clock_divide factor from 16 to 1:  See the 6850
; documentation in Appx C of the Osborne Tech Manual.
; 
; note: 19.2K baud is correct, despite other documentation suggesting
; that use of the divide by 1 byte (54H) would result in 9600 baud.
;
; the address at the first CALL should be 0E53C HEX for the 1.3 ROMs
;
; CAUTION:  Altho this program and the OCC hardware appear reliable  
;           transmitting text (via W*, or TYPE) to a HARDWARE 
;           printer buffer,   most machines with which I've
;           experimented  (various terminals, micros and DEC minis)
;           CANNOT reliably receive at 19.2 Kbaud,  even 
;           when hardwired, Serial port to serial port. 
;           
; This program released thru the Yankee Osborne User Group (YOU)
; to the Public Domain for non-commerical use, by its author 5/29/84:
;          DO ANYTHING BUT SELL IT:  use it, improve it,
; but, please make this source code or a .DOC (if you feel this won't
; serve that purpose) available when object code is distributed.
;
;		COPYRIGHT 1984  W/S Associates
;				New Haven, CT
;
;
;----------------------------------------------------------------------
;
; EQUATES
;
BDOS 	equ	05H	;system call-BDOS entry
WCONSF	equ	09H	;BDOS call to print string to CON:
CR	equ	0dH	;carriage return
LF	equ	0aH	;line feed
TAB	equ	09H	;tab
;
;Start program
;
	org	0100h 
	mvi	c,54h
	call	0E13ch
;
;
	lxi	d,msg
	call	print
	lxi	d,warning
	call	print
	jmp	0000H
;
;
print:
	mvi	c,WCONSF
	call	BDOS
	ret
;
;
msg:
	db	CR,LF,TAB,'Serial Port/RS232 set to 19.2K baud',CR,LF,'$'

warning:
	db	CR,LF,TAB,'WARNING: SETUP will NOT report rate correctly!',CR,LF,'$'
;
;
	end
