#define MAXLINE 256 /* max number of chars in a line */
#define NMAX 100 /* max lines to tail */
#define DFLT  10 /* default to last 10 lines */

#include "libc.h"

main(argc,argv)
int argc;
char **argv;
{
	int n; /* buffer pointer */
	char ring; /* ring buffer - set if Num input lines > ntail */
	char head; /* are we doing a head instead of a tail */
	int ntail; /* number of lines to tail */
	int i;
	char *temp;
	char line[MAXLINE]; /* input string buffer */
	char *lineptr[NMAX]; /* line pointer buffer */
	FILE *fin;	/* stream pointer to an input file */
	char *alloc(); /* define the memory allocator */
	char *fgets(); /* define the string get function */
	FILE *fopen(); /* define the file open function */

	head = FALSE; ntail = DFLT;
	temp = argv[1];
	if (argc == 1 || argc > 3 || (argc == 2 && (*temp == '-' || *temp == '+')) || (argc == 3 && *temp != '-' && *temp != '+'))
		error(0);

	if (--argc == 2) {
		head = (*temp == '+');
		ntail = atoi(++temp);
		if ((ntail <= 0) || (ntail > NMAX))
			error(1);
	}
	
	temp = argv[argc];
	if ((n = index(temp, '.')) && (!strcmp(n, ".COM") || !strcmp(n, ".OBJ")))
		error(2);
	
	if ((fin = fopen(temp, "r")) == NULL) {
		fprintf(stderr, "error opening %s to read\n", temp);
		exit(1);
	}
	
	if (!head) {
		iseek(fin, 0, 2);
		if (itell(fin)/MAXLINE > ntail)
			iseek(fin, -ntail*MAXLINE, 2);
		else
			iseek(fin, 0, 0);
	}
	
	n = 0; ring = FALSE;
	while (fgets(line, MAXLINE, fin)) {
		if (ring)
			free(lineptr[n]);
		if ((lineptr[n] = alloc(strlen(line) + 3)) == NULL) {
			fputs("\n\nnot enough memory\007\n\n", stderr);
			exit(1);
		}
		strcpy(lineptr[n++],line);
		if (!(n %= ntail)) {
			if (head) {
				n = ntail;
				break;
			}
			ring = TRUE;
		}
	}

	if (ring)  /* print high end of ring first */
		for (i = n; i < ntail; i++)
			fputs(lineptr[i], stdout);
	for (i = 0; i < n; i++)
		fputs(lineptr[i], stdout);

	fclose(fin);
} /* main */

error(type)
int type;
{
	switch (type) {
	  case 1:
		fprintf(stderr, "must have 0<n<=%d\n", NMAX);
		break;
	  case 2:
		fputs("you can only tail a text file\n", stderr);
		break;
	}
	fputs("\nusage: tail [-n or +n] ufn\n", stderr);
	fprintf(stderr, " -n\ttail n last lines (0<n<=%d, default = %d)\n", NMAX, DFLT);
	fputs(" +n\thead first n lines (same limits)\n ufn\tan unambiguous text file name", stderr);
	
	exit(1);
}
		