
;******************************************************************************
;
	title		'ZCPR II  patches for Wordstar Overlay Files' 
;
;******************************************************************************
;
;		WS.COM can be made to work with ZCPR II		04/17/84
;
;  You know how irritating the @@@@'s get when you try to open a file in a 
; user area that does not have the *.OVR files present ?????  I had been 
; pipping everything to a given user area to edit and then back again. ARRGH.
; To make a long story short, a few hours with DDT revealed several key areas
; within WS.COM that should interest a true hacker. Seems as how the FCB for
; WSOVLY1.OVR is at 364Dh, WSMSGS.OVR is at 3784h, the only BDOS entry vector
; is at 1823h and finally, the area between 02E0h and 035Bh inclusive is a 
; safe patch area. Well, well well....... A real simple kludge of mushware will
; set a default drive and user area every time WS.COM looks for an *.OVR file
; and then set it back again after the DOS operation. The infernal thing can 
; find the *.OVR files from any drive and user area A dream come true and
; it is really painless......
;									
;
;//////////////////////////////////////////////////////////////////////////////
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;
;
;		Copyright (c) 1984 .... Oak Brook Design 
;   
;	  		     All rights reserved.
;
;	Permission  is  hereby  granted  to copy and distribute this
;	program  for  any  non-commercial  purpose. Any use of this
;	material  for  commercial  advantage  without  prior written
;	consent of John P Sojak acting on behalf of Oak Brook Design 
;	is prohibited. 
;
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
;//////////////////////////////////////////////////////////////////////////////
;
;	You MUST examine your Wordstar under SID or DCON to verify several
;	locations within the memory image.... > denotes a console input
;
;
;>	A0>DCON
;
;	--- dcon banner and some other gook ---
;
;>	#F100 5000 00		; clear the ram out
;>	#IWS.COM		; set up for read
;>	#R	
;
;>	#P0000			; set a break at warmboot 
;>	#G100
;
; 	--- you will get the usual WS menu.... Just eXit with 'X'
;
;	01 PASS 0000
;	 -Z-E- A=00 B=1800 D=0006 H=3441 S=3443 P=0000	
;	 ----- A'=00 B'=00 D'0000 H'0000 X=0000 Y=0000 JMP XXXX
;	*XXXX
;
;>	#D3780 3790
;	3780: 00 00 00 00 03 57 53 47 53 20 20 4F 56 52 .....WSMSGS  OVR
;	3790: 00	   \	
;		             there it is... 
;				
;					          here it is... 	    	
;>	#D3640 3660				/   
;	3640: 00 00 00 00 00 00 00 00 00 00 00 00 57 53 ..............WS
;	3650: 4F 56 4C 59 31 20 4F 56 52 00 00 00 00 00 OVLY1 OVR.......
;	3660: 00 . 	
;
;
;>	#L1820
;	1820   	INX  	H
;	1821	PUSH 	D	
;	1822	PUSH	H
;	1823	CALL	0005	--- here is the DOS entry @ 1823h  
;	1826	POP	H
;	1827	POP	D
;	1829	XTHL
;	182A	RET
;
;>	#-P		; clear the pass point at warmboot
;>	#G0		; and exit to CCP
;
;	A0>
;
;	Now you can assemble the file, I used Mac. M80 / L80 has a problem with
;	extranious 00 between the two ORGs. Dont use it. 
;
;	Use the same procedure to load WS.COM into memory again but this time,
;	dont set any pass point at 0000. Set up for the read with IWSUSER.HEX
;	and then do a R to overlay the hex file. Exit to the CCP and then
;	
;	A0>SAVE 64 WS-TEST.COM
;
;	Thats it..... WS  will, or should now, work with all user areas and 
;	drives.
;	
;
;******************************************************************************
;

bdos		equ	0005	; DOS entry

;
;==============================================================================
; The WSMSGS.OVR fcb... 

msgfcb		equ	3784h

;==============================================================================
; The WSOVR1.OVR fcb... 

ovrfcb		equ	364Dh	

;==============================================================================
; The original BDOS vector call address 
;

bdosvec		equ	02E0h	

;==============================================================================
;
;	set these to your desired default drive and user for the *.OVR files

ovruser		equ	15	; User area...  0-31
ovrdrv		equ	01	; Drive Spec... A:-> 01, B:-> 02 etc

;
;******************************************************************************
;
;			the patcher starts here
;
;******************************************************************************
;
		org	1823h	; remove the existing DOS hook
		call	bdosvec

		org	02E0h	; patch area is here

;	intercept the call to DOS before actual entry ... 

		mov	a,c
		sta	nowfun
		cpi	15		; open file
		jz	chkit
		cpi	16		; close
		jz	chkit
		cpi	17		; search first
		jz	chkit
		cpi	18		; search next
		jz	chkit
		cpi	20		; read next
		jz	chkit
		cpi	33		; read random
		jz	chkit

;	pass the call on without further hassle, its not for us

passit:		jmp	bdos


;******************************************************************************
;
;	check <de> for the two OVR fcb addresses, set <cy> if not found
;

chkit:		mvi	a,(LOW msgfcb)	;  fcb for WSMSGS.OVR 
		cmp	e
		jnz	nogood
		mvi	a,(HIGH msgfcb)
		cmp	d
		jz	good
		
nogood:		mvi	a,(LOW ovrfcb)	;  fcb for WSOVLY1.OVR 
		cmp	e
		jnz	bdos
		mvi	a,(HIGH ovrfcb)
		cmp	d
		jnz	bdos

;	found one of the FCB's... set the user and drive 

good:		push	d	; save the FCB

		mvi	c,32	; get the current user number
		mvi	e,0FFh
		call	bdos
		ani	00111111b
		sta	user

		mvi	c,32		
		mvi	e,ovruser	; find the overlays in this user
		call	bdos
		pop	d

;	now fix the drive specification

		ldax	d
		sta	nowdrive
		mvi	a,ovrdrv	; find the overlays on this drive
		stax	d	

		lda	nowfun		; original function call
		mov	c,a
		push	d
		call	bdos	
		pop	d
		
		push	psw		; save the result flags for later
		lda	nowdrive
		stax	d

		mvi	c,32		; set the old user... maybe funnies
		lda	user
		mov	e,a
		push	d		; save original FCB ...
		call	bdos
		pop	d		; ... restore 
		lda	nowfun
		mov	c,a		; restore c
		pop	psw		; get error flags
		ret			; back to Wordstar


user:		db	15
nowdrive:	db	00		
nowfun:		db	00

		end



	