;****************************************************************
;*								*
;*			CTRL-OUT V1.0				*
;*								*
;*    CALLING SEQUENCE: 0A>CTRL-OUT FILENAME.TYP		*
;*								*
;*    THIS IS A SIMPLE PROGRAM TO REMOVE THE CONTROL CHARACTERS *
;* FROM A SINGLE TEXT FILE (CP/M FORMAT). SINCE MANY PEOPLE USE *
;* USE THE TERMINAL MODE OF THE MODEM PROGRAMS AVAILABLE, THEY  *
;* SOMETIMES GET LINE HITS IN THE DATA. FOR SOME REASON, THIS   *
;* TENDS TO OCCUR IN THE 40H BIT (01000000B) ON MY SYSTEM, WHICH*
;* TURNS NORMAL CHARACTERS INTO CONTROL CHARACTERS. THIS ISN'T  *
;* TOO BAD WHILE "TYPE"ING THE FILE, BUT IT CHOKES MY POOR      *
;* CENTRONICS. THIS PROGRAM SIMPLY REMOVES ALL NON-ESSENTIAL    *
;* CONTROL CHARACTERS FROM THE FILE (BY OR'ING THEM WITH 40H).  *
;* THIS USUALLY RESULTS IN A CLEAN FILE.			*
;*								*
;*    THE CONTROL CHARACTERS DEFINED AS ESSENTIAL ARE:		*
;*								*
;*	CTRL-[ (ESC)	ESCAPE (FOR MX-80, ETC.)		*
;*	CTRL-M		CARRAIGE RETURN				*
;*	CTRL-L		FORMFEED				*
;*	CTRL-J		LINEFEED				*
;*								*
;*    ALL OTHER CONTROLS CHARACTERS (I.E. < 20H) ARE TRANSLATED *
;* TO THE CORRESPONDING UPPERCASE ASCII VALUE BY OR'ING WITH	*
;* 40H.								*
;*								*
;****************************************************************

; REVISION 1.0	4/1/82 (APRIL FOOL'S) BY JOE PLUTA
;		COPYRIGHT (C) 1982 BY JOE PLUTA
;		PERMISSION GRANTED TO USE, BUT NOT SELL OR TRADE

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

RMAC	EQU	TRUE	;TRUE IF USING RMAC

BDOS@	EQU	5

CONOUT	EQU	2
CONPRT	EQU	9
OPEN	EQU	15
CLOSE	EQU	16
RREAD	EQU	33
RWRITE	EQU	34

BDOS	MACRO	TYPE,PARM

    IF NOT NUL PARM
      IF (TYPE GE 9) AND (TYPE NE 14)
	LXI	D,PARM
      ELSE
	MVI	E,PARM
      ENDIF
    ENDIF

	MVI	C,TYPE
	CALL	BDOS@

    IF ((TYPE GE 15) AND (TYPE LE 19)) OR (TYPE EQ 22) OR (TYPE EQ 23)
	INR	A
    ELSE
      IF (TYPE GE 11)
	ORA	A
      ENDIF
    ENDIF

	ENDM

FCB	EQU	05CH
RANREC	EQU	FCB+33
RANOVF	EQU	FCB+35
BUF	EQU	080H

    IF NOT RMAC
	ORG	100H
    ENDIF

START:	BDOS	CONPRT,SIGNON
	BDOS	OPEN,FCB
	JZ	ERR01
	SUB	A
	STA	DONE
	LXI	H,0FFFFH	;INIT REC#
	PUSH	H
LOOP:	POP	H		;GET LAST REC NUMBER
	INX	H		;INCREMENT
	PUSH	H		;AND RESTORE
	SHLD	RANREC		;UPDATE RANDOM REC# IN FCB
	SUB	A
	STA	RANOVF
	BDOS	RREAD,FCB	;READ CURRENT REC
	JNZ	ERR02		;ERROR EXIT
	MVI	C,128		;INIT LOOP COUNTERS
	LXI	H,BUF
LOOP2:	LXI	D,EOLOOP	;TOP OF STACK = ADDR(EOLOOP)
	PUSH	D
	MOV	A,M
	CPI	20H		;IGNORE IF NOT CONTROL CHARACTER
	RNC			; (JNC EOLOOP)
	CPI	1BH		;IGNORE ESCAPE
	RZ			; (JZ EOLOOP)
	CPI	0DH		;IGNORE CARRAIGE RETURN
	RZ
	CPI	0CH		;IGNORE FORMFEED
	RZ
	CPI	0AH		;IGNORE LINEFEED
	RZ
	CPI	1AH		;IS CONTROL - IS IT ^Z (EOF)?
	JNZ	REPLACE		;IF NOT, THEN REPLACE
	STA	DONE		;IF IT IS, THEN SET DONE FLAG
	POP	D		;CLEAR A(EOLOOP)
	JMP	REWRITE		;AND GO REWRITE RECORD
REPLACE:ORI	40H		;IS CONTROL CHAR...SET ON 01000000B
	MOV	M,A		; AND REPLACE
	RET			;(JMP EOLOOP)
EOLOOP:	INX	H		;NEXT BYTE OF RECORD
	DCR	C		;ARE WE DONE WITH THIS REC?
	JNZ	LOOP2		;IF NOT, GO DO NEXT BYTE
REWRITE:POP	H		;DONE, SO GET RECORD NUMBER
	PUSH	H		; (AND RESTORE)
	SHLD	RANREC		;UPDATE RANDOM REC# IN FCB
	SUB	A
	STA	RANOVF
	BDOS	RWRITE,FCB	;AND REWRITE RECORD
	JNZ	ERR03		;ERROR EXIT
	BDOS	CONOUT,'*'	;TELL USER WHAT'S GOING ON
	LDA	DONE		;HAVE WE REACHED EOF?
	ORA	A
	JZ	LOOP		;IF NOT, GO DO NEXT RECORD
	CALL	ERRPRT		;ELSE PRINT SIGNOFF
	DB	0DH,0AH,'CONVERSION COMPLETE$'

ERR01:	CALL	ERRPRT
	DB	'OPEN ERROR$'
ERR02:	ORI	30H
	STA	RMSG
	CALL	ERRPRT
RMSG:	DB	'X ERROR IN READ$'
ERR03:	ORI	30H
	STA	WMSG
	CALL	ERRPRT
WMSG:	DB	'X ERROR IN WRITE$'

ERRPRT:	POP	D
	BDOS	CONPRT
	JMP	0

COPYRT:	DB	'COPYRIGHT (C) 1982 BY JOE PLUTA'
SIGNON:	DB	'CONTROL-CHARACTER REMOVER     V1.0',0DH,0AH,'$'
DONE:	DB	0

	END	START
