/*
 * For BDS C, a quicker version of prime number prog in Sep 81 BYTE p. 186
 * Timings (Bell to Bell)
 *	ZPU (4mHz)	13.7 Seconds
 *	Z89 (2mHz)	28.0 Seconds
 */
#include "A:BDSCIO.H"
#define TRUE 1
#define FALSE 0
#define SIZE 8190
#define SIZEP1 8191

char flags[SIZEP1], *p,*s;
int i,prime,count,iter;

main()
{
	printf("10 Iterations\007\n");
	for(iter=10; --iter>=0;) {
		count=0;
		setmem(flags, SIZE, TRUE);

		for(p=flags+(i= -1); ++i<=SIZE;) {
			if(*++p) {
				prime= i+i+3;
				for(s=p; (s+=prime)<=(flags+SIZE);)
					*s = FALSE;
				++count;
				/*printf("%d\n",prime);*/
			}
		}
	}
	printf("\n%d primes\007", count);
}

/* submit file for above
xsub
cc1 b:bytebnch.c -e 1000 -o
clink b:bytebnch -d
50.9 seconds RETURN to first bell with Z89 and dd 8" drives (Magnolia)

Observations:
	C compilers are notoriously inefficient at optimizing subscript
calculations.  In many cases, such as the above, array indexing can be
replaced by pointer arithmetic, a more idiomatic usage of C.
	A few of the "tricks" I used for BDS C:
	0.  All array refrences were recoded as pointer arithmetic.  Pointers
are one of C's great strength, so use them when performance is critical.
	1.  All variables were made external. This places them in fixed
memory locations which can be accesses by direct addressing on the 8080.
	2.  The array is cleared by "setmem", a function provided in the
BDS C library, which corresponds to "aryset" in ZSPL.  This would be faster
than a loop coded in BDS C.
	3.  Combining operations may produce better code.  On machines such as
the 8080 or even 8086, arithmetic operations are carried out in an accumulator,
so try to avoid unnecessary loads and stores.
	4.  When the value is needed, preincrement and predecrement wins
over postincrement.  When postincrement is used, a copy of the old value must
be saved, then the increment takes place, and finally the saved copy of the
old value is used.  Much quicker to modify the value, then use it.
	5.  Note that some of the choices would not be optimal for a machine
such as the PDP-11 or 68000, whose hardware supports address autoincrement.
However, the program will still be correct!
8-4-81
Chuck Forsberg
Computer Development Inc
Beaverton OR
RCP/M 503/621-3193 (300,450,1200baud: 24hrs intermittent)

*/es by direct addressing on the 8080.
	2.  The array is cleared by "setmem", 