;
;		decxham.asm
;		by roderick w. hart wa3mez
;		october 10, 1981
;
; this routine is called to decode a hamming coded character and
; act upon certain types of errors.
;
; see comments in the companion file FORMHAM.ASM.
;
;
;***************************************************************
;	entry
;	d = hamming code for most significant 4 bits of character
;	e = hamming code for least significant 4 bits of character
;
;	exit
;	a = character
;	uncorrectable error
;	carry = set
;***************************************************************
;
;
decode:	xra	a
	sta	store		;zero temporary storage registers
	sta	store1
	sta	dblerr
	mov	a,d		;put most significant bits in a
	call	test		;decode hamming code
	call	strip		;get rid of check bits
	ral			;shift
	ral			;...left
	ral			;......4
	ral			;..........places
	ani	0f0h		;strip 4 least significant bits
	mov	d,a		;put decoded bits in d
	mov	a,e		;get 4 least significant bits
	call	test		;decode hamming code
	call	strip		;get rid of check bits
	ora	d		;merge lsb and msb in d
	push	psw		;save decoded character
	lda	dblerr		;get double error flag
	ani	0ffh
	jnz	error
	pop	psw		;get character off stack
	ret
error:	pop	psw		;get character anyhow
	stc			;set carry and return
	ret
;
;
strip:	lda	store		;get decoded bits
	ani	10h		;test a bit
	jnz	reseta		;if = 1 goto reset a
	lda	store		;get saved bits again
	ani	0fh		;strip 4 most significant bits
	ret
;
;
reseta:	lda	store		;get decoded bits
	ani	0fh		;strip 4 most significant bits
	ori	8h		;set new a bit
	ret
;
;
test:	sta	store		;stash the bits temporarily
	ani	055h
	cpe	ck1fail		;ckeck bit 1 failure
	lda	store
	ani	033h
	cpe	ck2fail		;check bit 2 failure
	lda	store
	ani	0fh
	cpe	ck4fail		;check bit 4 failure
	lda	store
	ani	0ffh
	cpe	mckfail		;m bit failure
	lda	store1
	cpi	0
	rz			;return, no errors found
	cpi	0fh
	jz	fixd		;d bit error, correct it
	cpi	0bh
	jz	fixc		;c bit error, correct it
	cpi	0dh
	jz	fixb		;b bit error, correct it
	cpi	09h
	jz	fixx4		;check bit 4 error, correct it
	cpi	0eh
	jz	fixa		;a bit error, correct it
	cpi	0ah
	jz	fixx2		;check bit 2 error, correct it
	cpi	0ch
	jz	fixx1		;check bit 1 error, correct it
	cpi	08h
	jz	fixm		;m bit error, correct it
	ori	0ffh		;set double error flag
	sta	dblerr		;set double error flag
	ret
;
;
ck1fail:
	lda	store1
	ori	4h		;set bit 1 fail flag
	sta	store1
	ret
;
;
ck2fail:
	lda	store1
	ori	2h		;set bit 2 fail flag
	sta	store1
	ret
;
;
ck4fail:
	lda	store1
	ori	1h		;set bit 4 fail flag
	sta	store1
	ret
;
;
mckfail:
	lda	store1
	ori	8h		;set m bit fail flag
	sta	store1
	ret
;
;
fixd:	lda	store		;fetch bits
	ani	1h		;test d bit
	jnz	makzerd		;reset if d bit is set
	lda	store		;retrieve bits again
	ori	1h		;set d bit
	sta	store		;return corrected bits
	ret
makzerd:lda	store		;retrieve bits again
	ani	0feh		;reset d bit
	sta	store		;return corrected bits
	ret
;
;
fixc:	lda	store		;fetch bits
	ani	2h
	jnz	makzerc
	lda	store
	ori	2h
	sta	store
	ret
makzerc:lda	store
	ani	0fdh
	sta	store
	ret
;
;
fixb:	lda	store
	ani	4h
	jnz	makzerb
	lda	store
	ori	4h
	sta	store
	ret
makzerb:lda	store
	ani	0fbh
	sta	store
	ret
;
;
fixx4:	lda	store		;fetch bits
	ani	8h
	jnz	makzerx4
	lda	store
	ori	8h
	sta	store
	ret
makzerx4:
	lda	store
	ani	0fbh
	sta	store
	ret
;
;
fixa:	lda	store		;fetch bits
	ani	10h
	jnz	makzera
	lda	store
	ori	10h
	sta	store
	ret
makzera:lda	store
	ani	0efh
	sta	store
	ret
;
;
fixx2:	lda	store		;fetch bits
	ani	20h
	jnz	makzerx2
	lda	store
	ori	20h
	sta	store
	ret
makzerx2:
	lda	store
	ani	0dfh
	sta	store
	ret
;
;
fixx1:	lda	store		;fetch bits
	ani	40h
	jnz	makzerx1
	lda	store
	ori	40h
	sta	store
	ret
makzerx1:
	lda	store
	ani	0bfh
	sta	store
	ret
;
;
fixm:	lda	store		;fetch bits
	ani	80h
	jnz	makzerm
	lda	store
	ori	80h
	sta	store
	ret
makzerm:lda	store
	ani	7fh
	sta	store
	ret
;
;
store	db	1
store1	db	1
dblerr	db	1
	end
