100 REM: LPF-2, BY BOB SCALF ...  REVISED 9 JUNE 1974
110 REM: THIS PROGRAM IS DESIGNED TO CALCULATE AND PLOT THE DT-600
120 REM: THIRD ORDER LOW PASS FILTER FREQUENCY RESPONSE.
130 REM:
140 GOSUB 2110
150 PRINT
160 PRINT "DT-600 LOW PASS FILTER FREQUENCY RESPONSE PROGRAM"
170 REM: COMMAND ROUTINE
180 PRINT 
190 PRINT "CMD";
200 K9=0
210 INPUT A$
220 IF A$="END" THEN 2900
230 IF A$<>"PLOT" THEN 290
240 K9=1
250 GOSUB 1230
260 GOSUB 1470
270 GOSUB 1720
280 GOTO 180
290 IF A$<>"XFER" THEN 330
300 GOSUB 1230
310 GOSUB 1380
320 GOTO 180
330 IF A$<>"EQN" THEN 360
340 GOSUB 1140
350 GOTO 180
360 IF A$<>"STAT" THEN 390
370 GOSUB 1920
380 GOTO 180
390 IF A$<>"TABLE" THEN 430
400 GOSUB 1230
410 GOSUB 1470
420 GOTO 180
430 IF A$<>"RESET" THEN 460
440 GOSUB 2110
450 GOTO 180
460 IF A$<>"FREQ" THEN 490
470 GOSUB 1340
480 GOTO 180
490 IF A$<>"HELP" THEN 520
500 GOSUB 2250
510 GOTO 180
520 IF A$<>"CIRCUIT" THEN 550
530 GOSUB 2690
540 GOTO 180
550 IF A$<>"ALL" THEN 620
560 GOSUB 1920
570 GOSUB 1230
580 GOSUB 1380
590 GOSUB 1470
600 GOSUB 1720
610 GOTO 180
620 IF A$<>"MOD" THEN 1110
630 PRINT "MOD";
640 INPUT B$,V1
650 IF B$="NO" THEN 180
660 IF B$<>"R22" THEN 690
670 R4=V1
680 GOTO 630
690 IF B$<>"R23" THEN 720
700 R1=V1
710 GOTO 630
720 IF B$<>"R24" THEN 770
730 R2=V1
740 R3=V1
750 PRINT "R24=R26=";V1;"KOHMS"
760 GOTO 630
770 IF B$<>"R25" THEN 800
780 R5=V1
790 GOTO 630
800 IF B$<>"R26" THEN 850
810 R3=V1
820 R2=V1
830 PRINT "R24=R26=";V1;"KOHMS"
840 GOTO 630
850 IF B$<>"C17" THEN 880
860 C1=V1
870 GOTO 630
880 IF B$<>"C18" THEN 910
890 C2=V1
900 GOTO 630
910 IF B$<>"C19" THEN 940
920 C3=V1
930 GOTO 630
940 IF B$<>"F1" THEN 970
950 F1=V1
960 GOTO 630
970 IF B$<>"F2" THEN 1000
980 F2=V1
990 GOTO 630
1000 IF B$<>"STEP" THEN 1030
1010 N=V1
1020 GOTO 630
1030 IF B$<>"R0" THEN 1060
1040 R0=V1
1050 GOTO 630
1060 IF B$<>"HELP" THEN 1090
1070 GOSUB 2250
1080 GOTO 180
1090 PRINT "UNRECOGNIZABLE COMPONENT DESIGNATION"
1100 GOTO 630
1110 PRINT
1120 PRINT "ILLEGAL COMMAND - RETRY (TYPE 'HELP' FOR INSTRUCTIONS)"
1130 GOTO 180
1140 PRINT
1150 PRINT
1160 PRINT "THIRD-ORDER TRANSFER EQUATIONS OF THE FORM:"
1170 PRINT
1180 PRINT TAB(30);"K"
1190 PRINT "H(S) = ---------------------------------------------"
1200 PRINT "       S^3     +     A*S^2     +     B*S     +    C"
1210 PRINT 
1220 RETURN
1230 T1=R1*C1*1E-03
1240 T2=R2*C2*1E-03
1250 T3=R3*C3*1E-03
1260 A=1/T1+2/T2
1270 B=1/(T2*T3)+2/(T1*T2)
1280 C=1/(T1*T2*T3)
1290 K=R1*C/R0
1300 M1=-10000
1310 M2=10000
1320 P=3.14159
1330 RETURN
1340 PRINT "INPUT BEGINNING FREQUENCY, FINAL FREQUENCY, AND"
1350 PRINT "AND STEP SIZE IN HERTZ ";
1360 INPUT F1,F2,N
1370 RETURN
1380 FOR I=1 TO 6
1390 PRINT
1400 NEXT I
1410 PRINT TAB(30);K
1420 PRINT "H(S) = ------------------------------------------------";
1430 PRINT "-------------"
1440 PRINT "       S^3  +  ";A;"S^2  +  ";B;"S  +  ";C
1450 PRINT 
1460 RETURN
1470 PRINT
1480 IF K9=1 THEN 1500
1490 PRINT "FROM ";F1;" HZ TO ";F2;" HZ IN STEPS OF ";N;" HZ."
1500 PRINT 
1510 PRINT "DC GAIN = ";K/C
1520 PRINT 
1530 IF K9=1 THEN 1560
1540 PRINT "FREQUENCY           VOLTAGE GAIN            DB GAIN"
1550 PRINT "-------------------------------------------------------"
1560 FOR F=F1 TO F2 STEP N
1570 IF K9=1 THEN 1590
1580 PRINT F;
1590 W=2*P*F
1600 H=(W*B-W^3)^2+(C-A*(W^2))^2
1610 H=H^.5
1620 H=K/H
1630 D=(20*LOG(H*C/K))/LOG(10)
1640 IF D<M1 THEN 1660 
1650 M1=D
1660 IF D>M2 THEN 1690 
1670 M2=D
1680 IF K9=1 THEN 1700
1690 PRINT TAB(20);H;TAB(45);D
1700 NEXT F
1710 RETURN
1720 PRINT
1730 PRINT
1740 PRINT
1750 PRINT "DB GAIN VERSUS FREQUENCY (HZ)"
1760 PRINT TAB(8);M2;TAB(60);M1
1770 PRINT TAB(10);
1780 PRINT "^---------------------------------------------------------^"
1790 FOR F=F1 TO F2 STEP N
1800 R=57/(M1-M2)
1810 W=P*2*F
1820 H=K/(((W*B-W^3)^2+(C-A*(W^2))^2)^.5)
1830 D=(20*LOG(H*C/K))/LOG(10)
1840 D=D+ABS(M2)
1850 D=INT(D*R)
1860 PRINT F;TAB(10);"!";TAB(D+11);"*"
1870 NEXT F
1880 PRINT
1890 PRINT
1900 PRINT
1910 RETURN
1920 PRINT
1930 PRINT "PRESENT ASSIGNED COMPONENT VALUES:"
1940 PRINT
1950 PRINT "R0  = ";R0;"KOHMS"
1960 PRINT "R22 = ";R4;"KOHMS"
1970 PRINT "R23 = ";R1;"KOHMS"
1980 PRINT "R24 = ";R2;"KOHMS"
1990 PRINT "R25 = ";R5;"KOHMS"
2000 PRINT "R26 = ";R3;"KOHMS"
2010 PRINT
2020 PRINT "C17 = ";C1;"UFD"
2030 PRINT "C18 = ";C2;"UFD"
2040 PRINT "C19 = ";C3;"UFD"
2050 PRINT
2060 PRINT "BEGINNING STEP FREQ. = ";F1;"HZ"
2070 PRINT "ENDING STEP FREQ. = ";F2;"HZ"
2080 PRINT "STEP = ";N;"HZ"
2090 PRINT
2100 RETURN
2110 REM: BASELINE FOR 2125/2295 HZ, 100 WPM
2120 R0=50
2130 R1=270
2140 R2=10
2150 R3=10
2160 R4=100
2170 R5=33
2180 C1=.012
2190 C2=.68
2200 C3=.18
2210 F1=5
2220 F2=100
2230 N=5
2240 RETURN
2250 PRINT
2260 PRINT "COMMAND MODE"
2270 PRINT
2280 PRINT "  'END'   -  ENDS THE PROGRAM"
2290 PRINT "  'MOD'   -  ENTERS THE MODIFY COMPONENT MODE"
2300 PRINT "  'RESET' -  RE-INITIALIZES ALL COMPONENT VALUES"
2310 PRINT "  'STAT'  -  PRINTS PRESENT COMPONENT VALUES"
2320 PRINT "  'HELP'  -  PRINTS THESE INSTRUCTIONS"
2330 PRINT "  'TABLE' -  PRINTS TABLE OF RESPONSE CALCULATIONS"
2340 PRINT "  'PLOT'  -  PLOTS THE RESPONSE"
2350 PRINT "  'EQN'   -  PRINTS THE GENERALIZED TRANSFER EQUATION"
2360 PRINT "  'XFER'  -  PRINTS THE TRANSFER FUNCTION W/ PRESENT VALUES"
2370 PRINT "  'FREQ'  -  PERMITS CHANGE IN MAX/MIN FREQ AND STEP"
2380 PRINT "  'ALL'   -  PRINTS 'STAT', 'XFER', 'TABLE' & 'PLOT'"
2390 PRINT "  'CIRCUIT' - DRAWS THE LPF SCHEMATIC DIAGRAM"
2400 PRINT
2410 PRINT "COMPONENT MODIFICATION MODE"
2420 PRINT
2430 PRINT "  TWO RESPONSES ARE REQUIRED TO EACH REQUEST:"
2440 PRINT
2450 PRINT "     (1)  COMPONENT DESIGNATION"
2460 PRINT "     (2)  NEW VALUE (IN KOHMS OR UFD)"
2470 PRINT
2480 PRINT "  R24 AND R26 MUST REMAIN THE SAME.  BOTH WILL CHANGE"
2490 PRINT "    IF ONE IS CHANGED."
2500 PRINT
2510 PRINT "  SAMPLE LEGAL INPUTS:"
2520 PRINT
2530 PRINT "    R0,100"
2540 PRINT "    R22,100"
2550 PRINT "    R23,270"
2560 PRINT "    R24,10"
2570 PRINT "    R25,33"
2580 PRINT "    R26,10"
2590 PRINT "    C17,.012"
2600 PRINT "    C18,.68"
2610 PRINT "    C19,.18"
2620 PRINT "    F1,5"
2630 PRINT "    F2,100"
2640 PRINT "    STEP,5   (SETS FREQ STEP IN HZ)"
2650 PRINT "    HELP,0   (PRINTS THESE INST. & RETURNS TO CMD MODE)"
2660 PRINT "    NO,0     (NO MORE MODS, RETURNS TO CMD MODE)"
2670 PRINT
2680 RETURN
2690 PRINT
2700 PRINT
2710 PRINT"        !---R23---!     !----------C18---!"
2720 PRINT"        !         !     !                !"
2730 PRINT"        !---C17---!     !      !---R25---!"
2740 PRINT"        !         !     !      !         !"
2750 PRINT"        !         !     !      !  !\     !"
2760 PRINT"        !         !     !      !--! \    !"
2770 PRINT"        !  !\     !     !         !  \   !"
2780 PRINT"IN--R0--!--! \    !     !         !   *--!---OUT"
2790 PRINT"           !  \   !     !         !  /"
2800 PRINT"           !   *--!-R24-!-R26--!--! /"
2810 PRINT"           !  /                !  !/"
2820 PRINT"        !--! /                C19"
2830 PRINT"        !  !                   !"
2840 PRINT"       R22                     !"
2850 PRINT"        !                      !"
2860 PRINT"       GND                     GND"
2870 PRINT
2880 PRINT
2890 RETURN
2900 END
     !                      !"
2860 PRINT"       GND                     GND"
2870 PRINT
2880 PRINT
2890