	TITLE	'SDNBOOT -- N* SD CP/M 2.2 BOOT OF 06/19/81'
;
;  THIS ROUTINE IS READ OFF THE DISK FROM TRACK ZERO,
; SECTOR FOUR BY THE NORTH STAR SINGLE DENSITY BOOT
; PROM. IT IS RESPONSIBLE FOR READING IN THE BIOS
; AND USER ROUTINES FROM THE DISK. IT MUST THEN CALL
; THE USER INIT ROUTINE, THEN JUMP OFF TO THE BIOS
; COLD BOOT ENTRY POINT. FOR CONVENIENCE, WE PRINT
; OUT THE PRETTY COLD-BOOT SIGN-ON MESSAGE HERE TOO.
;
;  THIS ROUTINE IS LOADED INTO THE SYSTEM IMAGE AT
; 880H, SO THAT IT CAN BE WRITTEN TO THE DISK. SINCE
; NEITHER THAT ADDRESS NOR OUR LOAD ADDRESS CHANGES,
; THE DDT LOAD OFFSET IS FIXED AT 880H-2000H = 0E880H.
;
BIOS:	EQU	4200H	;BIOS INIT AND LOAD ADDR
			; IN 20K SYSTEM
USER:	EQU	0A000H	;USER INIT AND LOAD ADDR
MSGOT:	EQU	USER+24	;CONSOLE MSG OUT ROUTINE
DISKIO:	EQU	0E91EH	;PROM DISK I/O ROUTINE
;
	ORG	2000H	;PROM LOADS US HERE
;
SDNBOOT: DB	0	;CURRENT TRACK IS ZERO
			; ON UNIT 1
	DB	59H,59H	;UNITS 2 AND 3 UNACESSED
	DB	1	;CURRENTLY SELECTED UNIT IS 1
;
;  PROM JUMPS HERE AFTER LOADING US.
;
BOOT:	LXI	SP,80H	;MOVE SP TO BETTER LOCATION
	MVI	A,2	;USER AREA IS 2 SECTORS LONG
	LXI	B,0001H	;TRACK ZERO, UNIT 1
	LXI	D,0201H	;READ FROM SECTOR 2
	LXI	H,USER	;READ INTO HIGH RAM
	CALL	DISKIO	;DO THE READ
	JNZ	BOOT	;IF ERROR, TRY AGAIN
	MVI	A,4	;BIOS IS 4 SECTORS LONG
	LXI	B,0001H	;TRACK ZERO, UNIT 1
	LXI	D,0501H	;READ FROM SECTOR 5
	LXI	H,BIOS	;READ INTO HERE
	CALL	DISKIO	;DO THE READ
	JNZ	BOOT	;IF ERROR, TRY AGAIN
	CALL	USER	;CALL USER INIT ROUTINE
	LXI	H,SIGNON
	CALL	MSGOT	;OUTPUT SIGNON MSG
	JMP	BIOS	;GO TO BIOS COLD BOOT
;
SIGNON:	DB	0DH,0AH
	DB	'North Star Single Density 20K'
	DB	' CP/M 2.2 of 06/19/81',0DH,0AH+80H
;
	END
