	TITLE	'SDNUSER -- MARTIN USER ROUTINES OF 06/14/81'
;
;  THESE ROUTINES PROVIDE CONSOLE AND LIST FUNCTIONS
; FOR CP/M 2.2, USING THE HARDWARE OF THE MARTIN
; RESEARCH MACHINE. THE ROUTINES ARE LOADED INTO
; THE NON-CONTIGUOUS 1K OF HIGH RAM BY THE BOOTSTRAP
; ROUTINE. ALL COMMUNICATION WITH THESE ROUTINES
; IS THROUGH THE JUMP VECTORS AT THE FRONT.
;
;  WHEN GENNING A NEW SYSTEM, THIS CODE MUST BE
; LOADED INTO MEMORY AT 1F80H. THE EQUATE "LOADR",
; WHICH IS SET TO 1F80H-USER, IS PROVIDED FOR
; CONVENIENCE. SINCE USER WILL PROBABLY ALWAYS
; HAVE THE VALUE 0A000H, THE LOAD OFFSET WOULD
; THEN BE 7F80H. NOTE THAT IF THE ORIGIN OF THIS
; MODULE CHANGES, THE VALUE OF THE USER EQUATES
; IN THE SDNBOOT AND SDNBIOS MODULES MUST ALSO
; BE CHANGED.
;
IOBYT	EQU	3
	;
KBREQ	EQU	0E500H	;MEM-MAPPED KB STATUS IN
KBCHR	EQU	0E700H	;MEM-MAPPED KB DATA IN
MODEM	EQU	0F100H	;MEM-MAPPED MODEM DATA
MSTAT	EQU	0F300H	;MEM-MAPPED MODEM STATUS
LBEL	EQU	1	;BEEPER BIT
SSBIT	EQU	4	;SUPER SHIFT (ALPHA LOCK) BIT
SOS	EQU	07C00H	;START OF MEM-MAPPED SCREEN
EOS	EQU	08000H	;END OF MEM-MAPPED SCREEN
SLEN	EQU	EOS-SOS ;LENGTH OF SCREEN MEMORY
LLEN	EQU	40H	;LENGTH OF SCREEN LINE
LMSK	EQU	0C0H	;LINE MASK
ILMSK	EQU	03FH	;INVERTED LINE MASK
BLANK	EQU	20H	;ASCII BLANK
CR	EQU	0DH	;ASCII CARRIAGE RETURN
LF	EQU	0AH	;ASCII LINE FEED
BS	EQU	08H	;ASCII BACKSPACE
BELL	EQU	07H	;ASCII BELL
	;
BTI	EQU	0B0EDH	;Z80 BLOCK XFER OP
	;
USER:	EQU	0A000H	;LOCATED IN HIGH RAM
LOADR:	EQU	1F80H-USER	;DDT LOAD OFFSET
;
	ORG	USER
	;
	;JUMP TABLE - CP/M JUMPS HERE FOR I/O
	;JUMPS MUST REMAIN HERE, IN SAME ORDER
INIT	JMP	INITR	;INITIALIZATION
CONST	JMP	TTYST	;CONSOLE STATUS CHECK
CONIN	JMP	TTYIN	;CONSOLE INPUT
CONOUT	JMP	TTYOUT	;CONSOLE OUTPUT
LIST	JMP	LSTOUT	;LIST OUTPUT
PUNCH	JMP	TTYOUT	;PUNCH OUTPUT
READER	JMP	TTYIN	;READER INPUT
LISTST	XRA	A	;LIST STATUS
	DCR	A	;ALWAYS RETURN READY
	RET
	JMP	MSGOT	;MSG STRING OUTPUT ROUTINE
	JMP	HXBOT	;HEX CONVERSION ROUTINE
	JMP	DSKERR	;DISK I/O ERROR REPORTER
	;
	;BEGIN USER DRIVER ROUTINES HERE
	;
TTYST	LDA	KBREQ	;KEYBOARD STATUS CHECK
	ANI	20H	;RESET BEING HELD DOWN?
	JZ	NORSET	;BRIF NOT
	LDA	MODE	;FLIP ALPHA LOCK STATE IF SO
	XRI	SSBIT
	STA	MODE
	STA	KBCHR	; AND FIX LITES
RSET	LDA	KBREQ	;DEBOUNCE
	ANI	20H
	JNZ	RSET
NORSET	LDA	KBREQ	;GET STATUS AGAIN
	ANI	80H
	RZ		;A=0 IF NO CHAR WAITS
	MVI	A,0FFH
	RET		;A=0FFH IF CHAR
;
TTYIN	CALL	TTYST	;CONSOLE INPUT DRIVER
	JZ	TTYIN
	LDA	KBCHR	;READ IN CHAR
	CPI	0C8H	;IS CHAR 'SEARCH' KEY?
	JNZ	NOTESC	;BRIF NOT
	MVI	A,01BH	;MAP TO ASCII ESC IF SO
	RET
NOTESC	ANI	7FH	;STRIP PARITY
	CPI	'Z'+20H+1	;SEE IF L.C. A-Z
	RNC		;DONE IF NOT
	CPI	'A'+20H
	RC
	PUSH	PSW	;SAVE IF SO
	LDA	MODE	;CHECK ALPHA LOCK
	ANI	SSBIT
	JNZ	NOFOLD	;PASS IF OFF
	POP	PSW
	SUI	20H	;FOLD TO U.C. IF ON
	RET
NOFOLD	POP	PSW
	RET
;
TTYOUT	XRA	A	;CONSOLE OUTPUT DRIVER
	CMP	C	;IS CHAR NULL?
	RZ		;TOSS IF SO
	PUSH	H	;SAVE REGS IF NOT
	PUSH	D
	PUSH	B
	LHLD	BUFPT	;CURR SCREEN POS
	MOV	A,M	;REMOVE CURSOR
	ANI	7FH
	MOV	M,A
	MOV	A,C	;GET CHAR TO OUTPUT
	ANI	7FH	;REMOVE ITS PARITY TOO
	CPI	CR	;IS IT <CR>?
	JZ	CRET	;GO PROCESS IF SO
	CPI	LF	;<LF>?
	JZ	LFEED
	CPI	BS	;BACKSPACE?
	JZ	BKSPC
	CPI	BELL	;BELL?
	JZ	RING
	ANI	7FH	;NORMAL CHAR, STRIP HIGH BIT
	CPI	7FH	;IS CHAR RUBOUT?
	JZ	CURSE	;TOSS IF SO
	CPI	20H	;CONTROL CHAR?
	JC	CURSE	;TOSS THAT TOO
	MOV	M,A	;IF OK, WRITE TO DISPLAY
	INX	H	;UPDATE THE PTR
	JMP	CURSE	;GO UPDATE CURSOR
;
;  BELL - RING IT
;
RING	MOV	A,M	;PUT CURSOR BACK
	ORI	80H
	MOV	M,A
	LDA	MODE	;PRESERVE LITE STATUS
	LXI	H,160H	;SUITABLE BELL-RING CONSTANT
	LXI	D,-1	;TO DEC WITH
RING5	XRI	LBEL	;FLIP BELL BIT
	STA	KBCHR	;TURN BELL OFF OR ON
	MVI	B,20H	;LEAVE BELL IN THAT STATE
RING10	DCR	B
	JNZ	RING10
	DAD	D	;RANG LONG ENUFF?
	JC	RING5	;IF NOT, GO OSCILLATE
	JMP	COUT7	; ELSE GO RESTORE REGS
;
;  BACKSPACE - BACK UP PTR 1 POSITION
;
BKSPC	MOV	A,L	;SEE IF ALREADY AT FRONT
	ANI	ILMSK
	JZ	CURSE	;NO BACKSPACE IF SO
	DCX	H	;BACKSPACE THE PTR
	JMP	CURSE
;
;  LINE FEED - PT TO SAME POS NEXT LINE
;
LFEED	LXI	B,LLEN	;LINE LENGTH
	DAD	B	;PT SAME POS NEXT LINE
	JMP	CURSE	; THEN PROCEED
;
;  CARRIAGE RETURN - PT TO START CURR LINE
;
CRET	MOV	A,L	;LOW BYTE OF PTR
	ANI	LMSK	;PT TO START OF LINE
	MOV	L,A	; THEN FALL INTO CURSE
;
;  OUTPUT CURSOR CHAR AND RESTORE REGS. IF PTR
; OFF SCREEN, SCROLL UP ONE LINE.
;
CURSE	MOV	A,H	;HI BYTE OF SCREEN PTR
	CPI	EOS SHR 8 ;OFF SCREEN?
	JNC	SCROLL	;BRIF SO
COUT5	SHLD	BUFPT	;SAVE SCREEN PTR
	MOV	A,M	;SET CURSOR
	ORI	80H
	MOV	M,A
COUT7	POP	B	;RESTORE REGS
	POP	D
	POP	H
	MOV	A,C	;RET OUTPUT CHAR IN ACC
	RET		;CHAR IS OUTPUT
;
;  MOVE EACH LINE ON SCREEN UP ONE LINE
;
SCROLL	PUSH	H	;SAVE CURR SCREEN PTR
	LXI	D,SOS
	LXI	B,SLEN-LLEN
	LXI	H,SOS+LLEN
	DW	BTI	;BLOCK XFER
;
;  FILL LAST LINE WITH BLANKS
;
	MOV	H,D	;MOVE DE TO HL
	MOV	L,E
	MVI	M,BLANK ;BLANK 1ST CHAR
	INX	D
	LXI	B,LLEN-1
	DW	BTI	;BLOCK XFER
	POP	H	;RESTORE SCREEN PTR
	LXI	B,-LLEN ;NEG LINE LENGTH
	DAD	B	;MOVE PTR UP ONE LINE
	JMP	COUT5	;GO FINISH UP
	;
LSTOUT: LDA	MSTAT	;LIST CHAR
	ANI	20H	;WAIT FOR MODEM READY
	JZ	LSTOUT
	MOV	A,C
	STA	MODEM	; THEN OUTPUT CHAR
	RET
	;
INITR	XRA A		;STORE 0
	STA IOBYT	;AT IOBYT LOCATION
	LDA FLAG
	ORA A
	RNZ		;INIT ALREADY DONE
	MVI A,1
	STA FLAG
	LXI	H,SOS	;BLANK THE SCREEN
	PUSH	H	;SAVE PTR OVER BTI
	MVI	M,BLANK
	LXI	D,SOS+1
	LXI	B,SLEN-1
	DW	BTI
	POP	H	;RESTORE SOS PTR
	MVI	M,BLANK+80H ;MAKE CURSOR
	SHLD	BUFPT	;REMEMBER BUF PTR
	MVI	A,7FH
	STA	KBCHR	;TURN OFF KB LITES
	STA	MODE	;SAVE MODE TOO
	STA	0F750H	;SET MODEM FOR 300 BAUD
	STA	0F5F8H	;8 BITS, 1 STOP, NO PARITY
	LDA	KBCHR	;FLUSH KB INPUT
	RET
;
;  MSGOT DISPLAYS STRING OF CHARS PT'ED AT BY HL ON
; CONSOLE, UNTIL CHAR WITH PARITY BIT SET IS OUTPUT.
;
MSGOT:	PUSH	PSW		;SAVE CALLER FLAGS
MSGL:	MOV	C,M		;LOAD CHAR
	CALL	TTYOUT		;OUTPUT IT, COMES BACK IN A
	INX	H		;LEAVE PTR ON NEXT CHAR
	RAL			;IS HIGH BIT ON?
	JNC	MSGL		;GO BACK IF NOT
	POP	PSW		; ELSE RESTORE FLAGS
	RET			; AND RETURN
;
;  DISK ERRORS REPORTED HERE, BECAUSE STUPID BDOS GIVES
; NO USEFUL INFORMATION. CALLED WITH MESSAGE PREAMBLE
; IN HL, HSTTRK IN D, HSTDSK IN E, AND ERSEC IN ACC.
;
DSKERR:	PUSH	PSW		;SAVE INFO
	PUSH	D
	PUSH	H		;SAVE BODY ADDRESS
	LXI	H,CRLF		;EJECT LINE
	CALL	MSGOT
	POP	H
	CALL	MSGOT		;REPORT BODY
	POP	D
	PUSH	D
	MOV	A,E		;THIS DISK
	ADI	'A'
	STA	ASCDSK
	LXI	H,ERRMSG
	CALL	MSGOT
	POP	D
	MOV	A,D		;THIS TRACK
	CALL	HXBOT
	LXI	H,SECMSG
	CALL	MSGOT
	POP	PSW		;THIS SECTOR
				;DROP INTO HXBOT TO FINISH
;
;  HXBOT DISPLAYS HEXIDECIMAL EQUIV OF ACC CONTENTS.
;
HXBOT:	PUSH	PSW		;SAVE CHAR
	RRC			;SWAP NIBBLES
	RRC
	RRC
	RRC
	CALL	HXNOT		;OUTPUT HIGH NIBBLE
	POP	PSW		; THEN LOW NIBBLE
HXNOT:	ANI	0FH		;STRIP HIGH NIBBLE
	ADI	90H		;CVT TO ASCII DECIMAL
	DAA
	ACI	40H
	DAA
	MOV	C,A		;CHAR TO C
	JMP	TTYOUT		;GO OUTPUT LAST CHAR
;
ERRMSG: DB	' err '
ASCDSK: DB	' : trk',' '+80H
SECMSG: DB	' sec',' '+80H
CRLF:	DB	CR,LF+80H
	;
FLAG	DB 0	;BEEN HERE BEFORE BYTE
BUFPT	DW 0	;SCREEN CURSOR ADDRESS
MODE	DB 0	;LITES STATE AND ALPHA LOCK MODE
	;
	END
