	TITLE	'SYNONYM Vers 2.0 Sep81'
;*------------------------------------------------------*
;*							*
;*	SYNONYM vers 1.0   by Bill allen - Feb81	*
;*							*
;* 	Version 1.1 Jun81  by Bill Allen 		*
;*	Version 1.2 Aug81  by Roy Lipscomb		*
;*	Version 2.0 Sep81  by Bill Allen		*
;*							*
;*	This program will create a  synonym for any	*
;*  CP/M  command.  A fixed paramater string may be	*
;*  entered as a part of the synonym and any paramaters	*
;*  given on the command line that invokes the synonym	*
;*  will be appended to the fixed string.		*
;*							*
;*	The program is self-modifying. It will create	*
;*  a .COM file with the "newname" given in the synonym	*
;*  command. This newname.COM when invoked will modify	*
;*  the CCP buffer using the "oldname" (see HELP) and	*
;*  then jump to the CCP to invoke the comand..		*
;*							*
;*      Help with the format of the synonym command	*
;*  may be obtained by typing:				*
;*		"SYNONYM <cr>"  or  "SYNONYM ?<cr>"	*
;*							*
;*  MODIFICATIONS:					*
;*							*
;*	09/01/81 - Version 2.0 - Simplified syntax so	*
;*	command may always have a variable paramater	*
;*	string and the fixed paramater does not have	*
;*	to use underlines to represent blanks. The	*
;*	combined fixed and variable data can now be	*
;*	up to 128 bytes. (WEA)				*
;*							*
;*	08/12/81 - fixed bug that caused program to	*
;*	abort if command line was moderately long.	*
;*	(RJL)						*
;*							*
;*	06/01/81 - Added the ability to have both a	*
;*	fixed and variable paramater string. The fix-	*
;*	ed string is entered by typing the underline	*
;*	(_) following the oldname. they will be re-	*
;*	placed by blanks in the command. (WEA)		*
;*							*
;*	06/01/81 - Modify to set $SYS indicator only	*
;*	when running under CP/M 2.X. (WEA)		*
;*							*
;*------------------------------------------------------*
BASE	EQU	0
	ORG	100H+BASE
BEGADR	EQU	$+1
	JMP	CONFIG		;modified by CONFIG
BEGIN	EQU	$
	LHLD	ENDFIX
	XCHG			;DE==>end of fixed string
	LXI	H,CPMBUF+1	;HL==>command buffer
	CALL	VARMOV
	CALL	XCTL
NEWBUF	DS	127
	DB	0
ENDFIX	DS	2		;address saved by CONFIG
	PAGE
;*------------------------------------------------------*
;*							*
;*	This routine will setup the CCP with a		*
;*	command passed by the calling program.		*
;*							*
;*	ENTRY CONDITIONS:				*
;*							*
;*		(SP)->A variable area containing	*
;*		      the command to be placed in	*
;*		      the CCP. The area MUST be		*
;*		      terminated by a one-byte 00H.	*
;*							*
;*------------------------------------------------------*
;
CCPCMD	EQU	08H		;start of CCP command buffer
CCPLTH	EQU	07H		;CCP command length
CCPPTR	EQU	88H		;CCP command pointer
CURDRV	EQU	0004H+BASE	;current drive in pg zero
CPMEP	EQU	0006H+BASE	;CP/M entry point addr
;
XCTL	EQU	$
	LHLD	CPMEP		;get addr of CP/M EP
	MVI	L,0		;point to FBASE
	LXI	D,-0800H	;lgth of CCP
	DAD	D		;compute CBASE
	SHLD	PNTCCP		;save ptr to CBASE
	LXI	D,CCPCMD	;offset of CCP command buffer...
	DAD	D		;...+ CBASE
	XCHG			;DE=>CCP command buffer
	MVI	B,0		;init byte ctr
	POP	H		;get ptr to command string
;
	CALL	VARMOV		;move command to CCP
	LHLD	PNTCCP		;CBASE
	LXI	D,CCPLTH	;offset of CCP bufr lgth
	DAD	D
	MOV	M,B		;put lgth in CCP
	LHLD	PNTCCP
	LXI	D,CCPPTR	;offset of CCP char ptr
	DAD	D
	MVI	A,CCPCMD	;offset of CCP command buffer
	MOV	M,A		;reset CCP buffer ptr
	LDA	CURDRV
	MOV	C,A		;select current drive
	LHLD	PNTCCP
	PCHL			;go exec command
;
PNTCCP	DW	0		;save ptr to CCP
	PAGE
;*------------------------------------------------------*
;*							*
;*	Parsing subroutines				*
;*							*
;*------------------------------------------------------*
;
;	Move from (HL) to (DE) until ZERO has been moved.
;
VARMOV	EQU	$
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	INR	B
	ORA	A
	RZ
	JMP	VARMOV
;
;	Move from (HL) to (DE) until (HL)=(ZERO or BLANK or "_")
;
WRDMOV	EQU	$
	MOV	A,M
	ORA	A
	RZ
	CPI	'_'		;pseudo blank?
	RZ
	CPI	BLANK
	RZ
	STAX	D
	INX	H
	INX	D
	JMP	WRDMOV
;
;	Incr HL to point to next non-BLANK.
;
NONBLK	EQU	$
	MOV	A,M
	CPI	BLANK
	RNZ
	INX	H
	JMP	NONBLK
;
;	Incr HL to point to next BLANK or ZERO.
;
FNDBLK	EQU	$
	MOV	A,M
	ORA	A
	RZ
	CPI	BLANK
	RZ
	INX	H
	JMP	FNDBLK
	PAGE
;*------------------------------------------------------*
;*							*
;*	NOTE:	All code above this address must 	*
;*		assemble at 01FFH or lower.		*
;*							*
;*------------------------------------------------------*
;
;
;*------------------------------------------------------*
;*							*
;*	Save old command name [and parm string]		*
;*	Save as a .COM file. 				*
;*							*
;*------------------------------------------------------*
CONFIG	EQU	$
	MVI	C,PRTSTR
	LXI	D,SGNMSG
	CALL	SYSTEM		;print signon msg
	LDA	FCB1+1
	CPI	BLANK		;nothing entered?
	JZ	HELP		;yes->
	CPI	'?'		;asking for help?
	JZ	HELP		;yes->
;
	MVI	C,GETVER
	CALL	SYSTEM		;get CP/M verson
	MOV	A,L
	ORA	A		;CP/M 2.x ?
	JZ	CONFI1		;no->
	MVI	A,'O'+128	;set $SYS indicator
	STA	TYPSYS
CONFI1	EQU	$
	LXI	H,BEGIN
	SHLD	BEGADR		;modify program EP
	LXI	H,CPMBUF+1
	CALL	NONBLK		;HL==>newname
	LXI	D,SAVNAM
	CALL	WRDMOV		;move newname to SAVE command
	CALL	NONBLK		;HL==>oldname
	PUSH	H
	LXI	H,TYPCOM	;HL==>".COM"
	CALL	VARMOV		;move typ to SAVE command
	POP	H		;HL==>oldname and parm string if any
	LXI	D,NEWBUF	;buffer to build cmd for XCTL
	CALL	VARMOV		;move real command and parms
	XCHG
	DCX	H		;point to 00H at end of string
	SHLD	ENDFIX		;save pointer to end of string
;
	CALL	XCTL		;issue SAVE command
	DB	'SAVE 1 '	;one page 0100H -- 01FFH
SAVNAM	DW	0,0,0,0,0,0,0,0	;synonym name
TYPCOM	DB	'.C'
TYPSYS	DB	'OM',0
;
HELP	EQU	$
	MVI	C,PRTSTR
	LXI	D,HLPMSG
	CALL	SYSTEM
	RET
SGNMSG	DB	CR,LF
	DB	'SYNONYM version 2.0  Sep81'
	DB	CR,LF,EOM
HLPMSG	DB	CR,LF
	DB	'The format of the SYNONYM command is:'
	DB	CR,LF,LF
	DB	'SYNONYM  newname  oldname [parm string]'
	DB	CR,LF,LF
	DB	'newname      is the name to be used as a synonym.'
	DB	CR,LF
	DB	'             It can be anything acceptable to CP/M'
	DB	CR,LF
	DB	'             as a file name.'
	DB	CR,LF,LF
	DB	'oldname      is the actual name of the command to be'
	DB	CR,LF
	DB	'             executed and may include a disk letter.'
	DB	CR,LF,LF
	DB	'parm string  is a  fixed string  to be passed to the'
	DB	CR,LF 
	DB	'             command.  It is optional and will preceed'
	DB	CR,LF
	DB	'             any  parameter string entered  when the'
	DB	CR,LF
	DB	'             synonym is invoked.'
	DB	CR,LF,LF,EOM
;
BLANK	EQU	20H
FCB1	EQU	005CH+BASE
CPMBUF	EQU	0080H+BASE
PRTSTR	EQU	9
GETVER	EQU	12
CR	EQU	13
LF	EQU	10
EOM	EQU	'$'
SYSTEM	EQU	0005H+BASE
	END
