;TM-MFI.ASM  version 1.0
;5 September 1985

;TIME overlay for the Electrologics MFIO real-time clock

;Written by:
;Robert MacKinnon
;#325-109 Generation Blvd.
;Scarborough, Ontario. CANADA

;Originally by:
;Joe Griffith
;4315 Aegean Dr. #222-C
;Tampa, FL 33611
;(813) 831-3765

; Version 1.0  5 Sept 85 
; TM-KCT11.ASM Version 1.0  22 Mar 85 - Original, from WT-KCT11.ASM

;--------------------------------------------------------------------
;     This overlay provides the current time to any ZCPR3 utility
; that conforms to the clock overlay scheme used by TIME, WAIT, and
; PRINT.  This overlay is configured for the Electrologics MFIO
; real-time calendar/clock although it will probably 
; work with any clock using the MM58167A clock chip.
;
;     In order to generate a working system, this file should be
; modified if necessary, assembled, and then loaded with the primary
; program to produce an executable program.  The program must then
; be installed using Z3INS before it will run properly.
; 
;     Here are step by step instructions using TIME as the primary
; program:
;
;     Step 1.  Modify this file if necessary.
;     Step 2.  Assemble this file to produce a .HEX file.
;
;		MAC TM-MFI10
;
;     Step 3.  Load with TIME10.OBJ using the following command -
;
;              MLOAD ZTIME.COM=TIME10.OBJ,TM-MFI10
;
;     Step 4.  Install using Z3INS and your environment package -
;
;              Z3INS SYS.ENV ZTIME.COM
;              (this assumes Z3INS version 1.1 or higher)
;
;     Optional Step 5.
;	       Because I like to see the date and time appear on 
;	       the console, I wrote an alias called TIME.  It
;	       contains:
;
;		A--> ZTIME D$1;
;
;	       Rather simple, don't you think?
;
;====================================================================
	maclib	z80	;standard MAC library of Z80 opcodes
;====================================================================
;
; overlay starts here.

curblk	equ	000Fh	;loc'n in Page 0 where current BLK is saved
blksel	equ	48h	;Port # to cmd. window to move
blk	equ	40h	;First port # in block of 8 for MFIO
;

;--------------------------------------------------------------------
; if your terminal allows you to turn the cursor off then put the
; code to do it here.  If you cannot turn your cursor off then this
; should simply be a null (ascii 0).  The string must be teriminated
; with a null and should not be more than 16 bytes long.

	org	0110h		;DO NOT CHANGE
coffmsg:
	db	0		;escape sequence to turn cursor off

;---------------------------------------------------------------------
; put the corresponding code to turn the cursor back on here.  It
; also must be terminated with a null and should not be more than
; 16 bytes long.

	org	0120h		;DO NOT CHANGE.
conmsg:	db	0		;escape sequence to turn cursor on

;---------------------------------------------------------------------
; You can add an ID string to identify the clock you are using here.
; It will be printed in the display, must be terminated with a null
; and should not be more than 48 bytes long.

	org	0130h		;DO NOT CHANGE
clockid:
	db	'Electrologics MFIO Real Time Clock'
	db	0

;---------------------------------------------------------------------
; This is the location where the current date and time will be stored.
; The format is 'YY/MM/DD HH:MM:SS',0 - that is, 17 bytes terminated
; with a null.  ; This format cannot be altered without also altering
; the primary program.  The slashes (/) and colons (:) must be in the
; string.  The clock routine should either just poke individual numbers
; into the string or should re-write the whole string including the
; slashes and colons.

	org	0160h		;DO NOT CHANGE
cdate	equ	$		;this is where current date is stored
ycdate	equ	cdate		;current year
mcdate	equ	ycdate+3	;current month
dcdate	equ	mcdate+3	;current day
	db	'85/00/00 '	;note the space on the end
				;MFIO doesn't supply year - hard code

ctime	equ	$		;this is where current time is stored
hctime	equ	ctime		;current hour
mctime	equ	hctime+3	;current minute
sctime	equ	mctime+3	;current seconds
	db	'00:00:00',0	;initialized to all zeros + null

;---------------------------------------------------------------------
; The rest of the overlay is the code to read the clock and place the
; current time into the string at location ctime.  It should be 
; structured as a subroutine... that is it must RET to the main program.
; and it must end before 0400h

clock:	lxi	h,ctime 	;point to where time should be stored
	call	rdtime		;...and update time

; NOTE because MFIO does not supply year, it is hard coded as a DB statement
;      The MFIO only updates the month and day.

	lxi	h,mcdate	;point to where date should be stored
				;...and fall through to update date
				;(also returns to caller through RDDATE)

;===============================================================
;
; date refresh subroutine
;
;rddate - stores the date (mm/dd) into
;	field pointed to by hl.  upon return,
;	hl points past last byte.
;
rddate:	mvi	c,blk+7		;point to HOURS reg.
	mvi	b,2		;two registers to read (and one to discard)
;
rd1lp:	ini			;read reg.
	jrz	bcd2asc 	;..last reg. and store it before ret to caller
	call	bcd2asc		;convert to ASCII and store at (HL)
	mvi	m,'/'   	;store delimiter
	inx	h 
	dcr	c		;next port to read
	jr	rd1lp

;===============================================================
;
; time print subroutine
;
;rdtime - stores the time (hh:mm:ss) into
;	field pointed to by hl.  upon return,
;	hl points past last byte.
;
rdtime:	mvi	a,0ch		;point MFIO to RTC read regs.
	out	blksel
	sta	0fh		;...and inform BIOS rtns. of same
	mvi	c,blk+4		;point to HOURS reg.
	mvi	b,3		;three registers to read (and one to discard)
;
rdlp:	ini			;read reg.
	jrz	bcd2asc 	;..last reg. and store it before ret to caller
	call	bcd2asc		;convert to ASCII and store at (HL)
	mvi	m,':'   	;store delimiter
	inx	h
	dcr	c		;next port to read
	jr	rdlp
;
;
; convert BCD digit in A-reg to ASCII and store at (HL) and (HL+1)
bcd2asc:
	dcx	h		;point to where clock value was stored
	mov	a,m   		;retrieve the stored byte
	push	psw		;Temporarily save A-reg.
	rar			;rotate high nibble to low nibble
	rar	
	rar	
	rar	
	call	cnvt		;and store high ASCII digit
	pop	psw		;restore A-reg contents to disp low nibble
; Convert to ASCII digit
cnvt:	ani	0fh		;mask low nibble
	adi	30h		;ASCII bias
	cpi	3ah		;greater than ASCII 9?
	jc	stor		;...no, store
	adi	7		;Adjust for higher numbers (A thru F)
stor:	mov	m,a   		;store byte
	inx	h 		;point to next loc'n for low ASCII digit
	ret
;
	end



                     