;****************************************************************
;*								*
;*	PROGRAM: MEX OVERLAY FOR CROMEMCO TUART I/O CARD	*
;*								*
;*	VERSION: 2.0	 	DATE:	Apr  30, 1985           *
;*								*
;*	WRITTEN BY:	RON LEWIS, TORONTO RCP/M 		*
;*								*
;****************************************************************

;****************************************************************
;*			EQUATES					*
;****************************************************************

BELL:		EQU	07H		;bell
CR:		EQU	0DH		;carriage return
ESC:		EQU	1BH		;escape
LF:		EQU	0AH		;linefeed
YES		EQU	0FFH
NO:		EQU	0

;port locations

PORT:		EQU	010H		;BASE LOCATION OF PORT
MODCTL1:	EQU	PORT		;MODEM CONTROL PORT
MODDATP:	EQU	PORT+1		;MODEM DATA IN PORT
MODDATO:	EQU	PORT+1		;MODEM DATA OUT PORT
BAUDRP:		EQU	PORT     	;BAUD RATE PORT
MODRCVB:	EQU	40H             ;BIT TO TEST FOR RECEIVE
MODRCVR:	EQU	40H		;VALUE WHEN READY
MODSNDB:	EQU	80H		;BIT TO TEST FOR SEND
MODSNDR:	EQU	80H		;VALUE WHEN READY

;mex processor calls

MEX		EQU	0D00H		;address of the service processor
INMDM		EQU	255		;get char from port to A, CY=no more in 100 ms
TIMER		EQU	254		;delay 100ms * reg B
TMDINP		EQU	253		;B=# secs to wait for char, cy=no char
CHEKCC		EQU	252		;check for ^C from KBD, Z=present
SNDRDY		EQU	251		;test for modem-send ready
RCVRDY		EQU	250		;test for modem-receive ready
SNDCHR		EQU	249		;send a character to the modem (after sndrdy)
RCVCHR		EQU	248		;recv a char from modem (after rcvrdy)
LOOKUP		EQU	247		;table search: see CMDTBL comments for info
PARSFN		EQU	246		;parse filename from input stream
BDPARS		EQU	245		;parse baud-rate from input stream
SBLANK		EQU	244		;scan input stream to next non-blank
EVALA		EQU	243		;evaluate numeric from input stream
LKAHED		EQU	242		;get nxt char w/o removing from input
GNC		EQU	241		;get char from input, cy=1 if none
ILP		EQU	240		;inline print
DECOUT		EQU	239		;decimal output
PRBAUD		EQU	238		;print baud rate
CONOUT		EQU	2		;simulated BDOS function 2: console char out
PRINT		EQU	9		;simulated BDOS function 9: print string
INBUF		EQU	10		;input buffer, same structure as BDOS 10

		ORG	100H

;****************************************************************
;*		  Default Values				*
;****************************************************************

		DS	3	;JMP START instruction in MEX
PMMIMODEM:	DB	NO	;yes=PMMI S-100 Modem			    
SMARTMODEM:	DB	NO	;yes=HAYES Smartmodem, no=non-PMMI	    
TOUCHPULSE:	DB	'T'	;T=touch, P=pulse (Smartmodem-only)	    
CLOCK:		DB	03	;clock speed in MHz x10, 25.5 MHz max.	    
MSPEED:		DB	5	;1=300 3=600 5=1200 6=2400 8=9600 default
BYTDLY:		DB	5	;0=0 delay  1=10ms  5=50 ms - 9=90 ms
CRDLY:		DB	5	;0=0 delay 1=100 ms 5=500 ms - 9=900 ms 
NOOFCOL:	DB	5	;number of DIR columns shown		
SETUPTST:	DB	YES	;yes=user-added Setup routine		
SCRNTEST:	DB	YES	;Cursor control routine 		
ACKNAK:		DB	YES	;yes=resend a record after any non-ACK	
BAKUPBYTE:	DB	NO	;yes=change any file same name to .BAK	
CRCDFLT:	DB	YES	;yes=default to CRC checking		
TOGGLECRC:	DB	YES	;yes=allow toggling of CRC to Checksum	
CONVBKSP:	DB	NO	;yes=convert backspace to rub		
TOGGLEBK:	DB	YES	;yes=allow toggling of bksp to rub	
ADDLF:		DB	NO	;yes=add LF after CR in terminal mode 
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR	
TRANLOGON:	DB	YES	;yes=allow transmission of logon	
SAVCCP:		DB	YES	;yes=do not overwrite CCP		
LOCONEXTCHR:	DB	NO	;yes=local command if EXTCHR precedes	
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR	
LSTTST:		DB	YES	;yes=printer available on printer port	
XOFFTST:	DB	NO 	;yes=checks for XOFF from remote	
XONWAIT:	DB	NO	;yes=wait for XON after CR whilesending a file
TOGXOFF:	DB	YES	;yes=allow toggling of XOFF checking	
IGNORCTL:	DB	NO 	;yes=CTL-chars above ^M not displayed	
EXTRA1:		DB	0	;for future expansion			
EXTRA2:		DB	0	;for future expansion			
BRKCHR:		DB	'@'-40H	;^@ = Send 300 ms. break tone		
NOCONNCT:	DB	'N'-40H	;^N = Disconnect from the phone line	
LOGCHR:		DB	'L'-40H	;^L = Send logon			
LSTCHR:		DB	'P'-40H	;^P = Toggle printer			
UNSAVE:		DB	'R'-40H	;^R = Close input text buffer		
TRANCHR:	DB	'T'-40H ;^T = Transmit file to remote		
SAVECHR:	DB	'Y'-40H	;^Y = Open input text buffer		
EXTCHR:		DB	'^'-40H	;^^ = Send next character		
		DS	2	;leave two empty spots

;****************************************************************
;*		Modem  I/O Commands 				*
;****************************************************************

IN$MODCTL1:	IN	MODCTL1 ;in modem control port		
		RET
		DS	7	

OUT$MODDATP:	OUT	MODDATP ;out modem data port		
		RET
		DS	7	

IN$MODDATP:	IN	MODDATP ;in modem data port		
		RET
		DS	7

;****************************************************************
;*		  Bit Test Routines 				*
;****************************************************************

ANI$MODRCVB:	ANI	MODRCVB	;bit to test for receive ready	
		RET	

CPI$MODRCVR:	CPI	MODRCVR	;value of rcv. bit when ready	
		RET

ANI$MODSNDB:	ANI	MODSNDB	;bit to test for send ready	
		RET

CPI$MODSNDR:	CPI	MODSNDR	;value of send bit when ready	
		RET

		DS	12		 				

;****************************************************************
;*		  Modem Function Jump Table			*
;****************************************************************

LOGONPTR:	DS	2		;not used in MEX  		
DIALV:		ds  	3    		;dial the number
DISCV:		JMP 	PDISC		;disconnect the modem
GOODBV:     	JMP	GOODBYE		;return to CP/M
INMODV:      	JMP	ONMODEM 	;init modem                	
NEWBDV: 	DS      3        	
NOPARV: 	DS      3     		                        	
PARITY:         DS  	3      						
SETUPV:    	JMP	SETUPR 						
SPMENV:      	DS	3       			
VERSNV:    	JMP	SYSVER						
BREADV:   	DS      3  						
ILPRTV:   	DS	3						
INBUFV:  	DS	3						
ILCMPV:      	DS	3						
INMDMV:    	DS	3						
NXSCRV:     	DS	3						
TIMERV:  	DS	3						

;****************************************************************
;*		  Terminal Screen Commands 			*
;****************************************************************

CLREOS:		LXI 	D,EOSMSG;clear to end of screen
		MVI     C,PRINT 					
		CALL	MEX
		RET			

CLRSCRN:	LXI 	D,CLSMSG;clear screen
		MVI	C,PRINT		
		CALL	MEX
		RET			
	
SYSVER:		LXI 	D,SOMESG;sign on message
		MVI	C,PRINT
		JMP	MEX
		
;****************************************************************
;*		     Message section       			*
;****************************************************************

EOSMSG		DB	01BH,'J$'  
CLSMSG		DB	01BH,'H',01BH,'J$'
SOMESG			
		DB	'Cromemco TUART Data Communications Package',0AH,0DH
		DB	'Mex Overlay by Ron Lewis - V.2.00 04/30/85',CR,LF,'$'
BYEMESS		DB	CR,LF,'End MEX - returning to CP/M command mode$'
LOGON:		DB	'HELLO RON.DYER,SPOOLER;TERM=9',CR,LF,'$'
SETMESS		DB	CR,LF,'New Baudrate now set',CR,LF,'$'
SETEMS:		DB	CR,LF,'SET error - Type SET ? for help',CR,LF,'$'
HLPMSG:		DB	'INVALID..Use SETXXXX',cr,lf
        	DB	CR,LF
		DB      '============================',cr,lf
		DB	'Valid SET commands for TUART',cr,lf
		DB	'============================',CR,LF
		DB	'SET   110          SET   150',CR,LF
		DB	'SET   300          SET  1200',CR,LF
		DB	'SET  2400          SET  4800',CR,LF
		DB	'SET  9600          SET 19200',CR,LF
		DB	'SET 38400          SET 76800',CR,LF
		DB	'============================',CR,LF
		DB	'$'

;****************************************************************
;*		       Routines            			*
;****************************************************************

;delay one second

ONESEC		MVI	B,2	
		MVI	C,TIMER
		CALL	MEX
		RET

;output char to modem port

OUTCHR		MOV	B,A		;SAVE CHAR
TRYOUT		CALL 	IN$MODCTL1
		CALL	ANI$MODSNDB
		CALL	CPI$MODSNDR
		JNZ	TRYOUT
		MOV	A,B
		CALL	OUT$MODDATP
		CALL	ONESEC
		RET

;INPUT A CHAR FROM MODEM PORT

INCHR		CALL	IN$MODCTL1
		CALL	ANI$MODRCVB
		CALL	CPI$MODRCVR
		JNZ	INCHR
		CALL	IN$MODDATP
		RET

;turn on the modem 
		
ONMODEM		mvi 	a,01h
		out	014h
		ret


GOODBYE:	CALL	PDISC
		LXI	D,BYEMESS	;print goodbye message
		MVI	C,PRINT
		CALL	MEX
		RET

;DISCONNECT MODEM

PDISC		MVI	a,00h
		out 	014h  		       
		RET

;set command

SETUPR:		MVI	C,SBLANK	;any arguments?
		CALL	MEX
		JC	STHELP		;if not, go print out values
		LXI	D,CMDTBL	;parse command
		MVI	C,LOOKUP
		CALL	MEX  		;from table
		PUSH	H		;any address on stack
		RNC			;if we have one, execute it
		POP	H		;nope, fix stack
SETERR:		LXI	D,SETEMS	;print error
		MVI	C,PRINT
		JMP	MEX

CMDTBL:		DB	'?'+80H			;"set ?"
		DW	STHELP
		DB	'11','0'+80H
		DW	BD110
		DB	'15','0'+80H
		DW	BD150
		DB	'30','0'+80H
		DW	BD300
		DB	'120','0'+80H			;SET TO 1200 BAUD
		DW	BD1200
		DB	'240','0'+80H 			;SET TO 2400
		DW	BD2400		
		DB	'480','0'+80H 
		DW	BD4800
		DB	'960','0'+80H 
		DW	BD9600
		DB	'1920','0'+80H 
		DW	BD19200
		DB	'3840','0'+80H 
		DW	BD38400
		DB	'7680','0'+80H 
		DW	BD76800
		DB	'BAU','D'+80H
		DW	PRMEX
		DB	0		;<<=== table terminator
	
PRMEX		MVI	C,238		;PRINT BAUD RATE
		CALL	MEX		 
		RET
BD110		MVI	A,081H		;CODE FOR 110
		OUT	PORT	
		JMP	SETMES 
BD150		MVI	A,082H		;CODE FOR 150
		OUT	PORT
		JMP	SETMES
BD300		MVI	A,084H		;CODE FOR 300
		OUT	PORT
		JMP	SETMES
BD1200		MVI	A,088H		;CODE FOR 1200	
		OUT	PORT
		JMP 	SETMES
BD2400		MVI	A,090H		;CODE FOR 2400
		OUT	PORT
		JMP	SETMES
BD4800		MVI	A,0A0H		;CODE FOR 4800
		OUT 	PORT 
		JMP	SETMES		          
BD9600  	MVI	A,0C0H		;CODE FOR 9600
		OUT	PORT
		JMP	SETMES
BD19200 	MVI	A,10H
		OUT	PORT+2
		MVI	A,090H
		OUT	PORT
		JMP	SETMES
BD38400 	MVI	A,10H
		OUT	PORT+2
		MVI	A,0A0H	
		OUT	PORT
		JMP	SETMES
BD76800 	MVI	A,10H
		OUT	PORT+2
		MVI	A,0C0H	
		OUT	PORT
SETMES		LXI	D,SETMESS	
		MVI	C,PRINT
		CALL	MEX
		RET

STHELP:		LXI	D,HLPMSG
		MVI	C,PRINT
		JMP	MEX

INBUFF		EQU	$
