The following code segments can be placed into a version of SD to allow
ZCPR-style drive/user codes to be used in place of the $U command.

That means, the following commands are now possible:

A>SD B5:*.COM
B1>SD 0:
C10>SD A0:*.FOO

To modify SD (pre- SD-72), you need SYSLIB.REL, RMAC, and LINK.

First, remove the ASEG directives from the program, set RMAC EQU FALSE(!)
and delete any ORG's you find. Just before the start of the code, where
you removed the ORG, insert the following two lines:

	cseg
	extrn	fname


Next, locate the following code segment at the beginning of SD:

	MVI	E,0FFH		;Get current user number if using CP/M 2, or
	MVI	C,CURUSR	;Fall through with A=0 if not
	CNC	CPM

	STA	OLDUSR		;Initialize startup user number
	STA	NEWUSR		;..and make new	user match it

	IF	DOPT
	STA	BASUSR		;Save extra copy for multi-disk	directories
	ENDIF

Now, insert the following code:


	lxi	h,81h
	mov	a,m
	inx	h
	ora	a
	jnz	xxok
	mov	m,a
xxok:	lxi	d,5ch
	call	fname
	mov	a,b
	cpi	0ffh
	jz	xxus
	stax	d
xxus:	mov	a,c
	cpi	0ffh
	jz	xxnone
	sta	newusr


	If you use DOPT, you should also insert the next 3 lines:

	IF	DOPT
	STA	BASUSR
	ENDIF

xxnone:


Later in the code, towards the end of the file...

	IF	DOPT
VECTBL: DW	DSKERR		;BDOS SECTOR ERROR INTERCEPT VECTOR
	DW	DSKERR		;BDOS SELECT ERROR INTERCEPT VECTOR
	ENDIF

Insert the DSEG directive right here to ensure all DS statements are located
at the physical end of the program.

	dseg

	IF	FOPT
BUFPNT: DW	OUTBUF		;POINTER TO NEXT LOCATION IN OUTPUT BUFFER
BUFCNT: DB	128		;NUMBER OF BYTES LEFT IN OUTPUT BUFFER


This completes the modification. Now, use RMAC to assemble the code and
produce SD.REL. Use the following command line to integrate the SYSLIB
file parser into SD:

A>link sd=sd,syslib[s]

The resulting COM file can now be tested for correct operation.
