;;;	This file compiled by:
;
;	Bill Parrott, [70070,462]
;	Modified by Y.M. Wong, Oct 24, 1983 for the Super 19,
;	an enhancement ROM for the H19.

;;;	This file is used to patch WordStar 3.0 to utilize
;	the H19 keypad and function keys.
;
;	These patches may be applied as follows:
;
;	1)  Run INSTALL to install WordStar as normal
;	    for your printer and terminal.
;
;	2)  Assemble this file, producing the .HEX output.
;		A>ASM WS30-S19.AAZ
;
;	3)  Install the patches in your INSTALLed WS.COM.
;		A>DDT WS.COM
;		DDT VERS 2.2
;		NEXT  PC
;		3F00 0100
;		-IWS30-S19.HEX
;		-R
;		NEXT  PC
;		3F00 0000
;		-G0
;		A>SAVE 121 WS.COM
;
;	4)  The patches are now installed in WS.COM.
;


;;;	Function key and keypad definitions:
;
;	Key		WordStar	Description
;	-----		--------	----------------------------------
;	f1		^A		Move cursor to word on left
;	shift/f1	^QA		Move cursor to left of line
;	f2		^F		Move cursor to word on right
;	shift/f2	^QF		Move cursor to right of line
;	f3		^QC		To end of file
;	shift/f3	^QR		To beginning of file
;	f4	  	^C		Page down
;	shift/f4	^KC		Block copy
;	f5	  	^R		Page up
;	shift/f5	^KV		Block move
;	Erase	  	^T		Delete word right
;	shift/Erase	^QY		Erase to end of line
;	Blue		^KQ		Abandon edit
;	shift/Blue	^KD		Done with file, stay in WS
;	Red		^QF		Find string
;	shift/Red	^QA		Replace string
;	White		^L		Find/replace again
;	shift/White	^JH		Set HELP level to 0-3
;	
;	IC	  	^V		Insert toggle
;	DC	  	^G		Delete character
;	Home	  	^QE		Move to top of screen
;	IL	  	^N		Insert RETURN
;	DL	  	^Y		Delete line
;	Arrows
;	 Up		^E		Cursor 1 line up
;	 Down		^X		Cursor 1 line down
;	 Left	  	^S		Cursor back 1 character
;	 Right	  	^D		Cursor forward 1 character
;
;	Notes:
;
;	During initialization, WordStar will automatically setup
;	the H19 terminal for shifted keypad operation and will
;	display a help line on lines 24-25 defining the various
;	function keys.
;
;	Upon leaving WordStar, the H19 will be reset according
;	to it's internal DIP switch settings.
;
;	The information to create this file was obtained through
;	an examination of INSTALL.COM supplied with WordStar and
;	through study of the WordStar reference manual.


;;;	WordStar 3.0 Equates

OUTCHR	EQU	0106H			; Character output routine
IDTEX	EQU	018FH			; Terminal ID text
HITE	EQU	0248H			; Lines on CRT
WID	EQU	0249H			; Columns on CRT


;	Cursor Addressing Control

CLEAD1	EQU	024AH			; Cursor address lead-in
CLEAD2	EQU	0253H			; Cursor address l/c seperator
CTRAIL	EQU	0258H			; Cursor address trailer
CB4LFG	EQU	025DH			; Column before line number flag
LINOFF	EQU	025EH			; Line offset
COLOFF	EQU	025FH			; Column offset
ASCUR	EQU	0260H			; Binary/ASCII flag & # ASCII digits
DELCUS	EQU	02AEH			; Delay after other functions


;	Terminal Control

ERAEOL	EQU	026DH			; Erase to end of line
LINDEL	EQU	0274H			; Delete line
LININS	EQU	027BH			; Insert line
IVON	EQU	0284H			; Inverse video ON
IVOFF	EQU	028BH			; Inverse video OFF
TRMINI	EQU	0292H			; Terminal initialization string
TRMUNI	EQU	029BH			; Terminal de-initialization string
INISUB	EQU	02A4H			; Terminal initialization subroutine
DELMIS	EQU	02AFH			; Delay after cursor set


;	WordStar Flags

ITHELP	EQU	0360H			; Default Help level
ITITOG	EQU	0362H			; Initial insert toggle
ITDSDR	EQU	0363H			; Initial No-file directory display
ITPOPN	EQU	03D3H			; Omit page numbers on documents
NITHLF	EQU	0361H			; Display short help under levels 1,2
NONDOC	EQU	0392H			; Default to non-document mode
SCRLSZ	EQU	02DDH			; Horizontal scroll size
MORPAT	EQU	02E0H			; Patch area
HITE	EQU	0248H			; Use only 23 lines for display

;	Some ASCII characters

BS	EQU	08H
TAB	EQU	09H
FF	EQU	0CH
ESC	EQU	1BH

;	equates for inverse video

VON	EQU	70H			;inverse on
VOFF	EQU	71H			;inverse off

;	Boolean values

FALSE	EQU	0
TRUE	EQU	0FFH
ON	EQU	TRUE
OFF	EQU	FALSE



;;;	Terminal initialization.
;
;	The cursor is on line 25 when this string is sent
;	by WordStar.  (see initialization subroutine).
;
;	ESC H   = Cursor Home
;	ESC E   = Clear Screen
;	ESC x 6 = Keypad Shifted Mode

	ORG	TRMINI

	DB	7
	DB	ESC,'H',ESC,'E',ESC,'x6'


;;;	Terminal De-initialization.
;
;	ESC z   = Reset to power-up

	ORG	TRMUNI

	DB	2,ESC,'z'


;;;	Terminal initialization subroutine.
;
;	This routine will set up the 25th line and display
;	a help message there.


	ORG	INISUB

	JMP	MORPAT			; Jump to subroutine


	ORG	MORPAT

	LXI	H,SLINE			; status line message
LOOP:	MOV	A,M
	ANA	A
	RZ
	CALL	OUTCHR
	INX	H
	JMP	LOOP




;;;	Terminal identification text.
;
;	This text is displayed by WordStar when the program
;	is invoked.

	ORG	IDTEX

	DB	' Super 19 w/ Function key mods. '
;		'---------------------------------'



;;;	Terminal control.
;
;	These escape sequences define those sent to the H19
;	to perform the indicated functions.
;
;	Note:	This wasn't really necessary since INSTALL
;		sets all of this, but I got carried away.

	ORG	ERAEOL

	DB	2,ESC,'K'		; Erase to end of line

	ORG	LINDEL

	DB	2,ESC,'M'		; Delete line

	ORG	LININS

	DB	2,ESC,'L'		; Insert line

	ORG	IVON

	DB	2,ESC,'p'		; Reverse video ON

	ORG	IVOFF

	DB	2,ESC,'q'		; Reverse video OFF

	ORG	DELCUS

	DB	0			; Cursor address delay

	ORG	DELMIS

	DB	0			; Other functions delay



;;;	WordStar flags
;
;	These flags specify certain initial conditions when
;	WordStar is invoked.


;;;	ITHELP - Initial Help level
;
;	Set to a value from 0 to 3 for default Help level.

	ORG	ITHELP

	DB	2			; Initial help level


;;;	ITITOG - Initial Insert Toggle
;
;	Set to ON for insert mode on, else set to OFF.

	ORG	ITITOG

	DB	OFF			; Initial insert toggle


;;;	ITDSDR - Initial NOFILE directory display.
;
;	Set to ON for NOFILE directory on, else set to OFF.

	ORG	ITDSDR

	DB	ON			; Initial NOFILE directory display


;;;	ITPOPN - Omit page numbers flag.
;
;	Set to TRUE to omit page numbers (.OP) by default when
;	printing document files with WordStar.  Set to
;	FALSE to include page numbers (.PN) when printing.

	ORG	ITPOPN

	DB	TRUE			; Omit page numbers flag


;;;	NITHLF - Display short help at 1st invocation.
;
;	Setting this value to OFF will cause WordStar to display
;	a short help message with the 1st invocation if ITHELP is
;	set to 1 or 2.  If this message is not desired, set this
;	to ON.

	ORG	NITHLF

	DB	OFF			; Display short help at levels 1,2


;;;	NONDOC - Default to Non-document mode.
;
;	Setting this to TRUE will cause WordStar to deafult to
;	Non-document mode.  If the user wishes to to enter in
;	document mode, set this to FALSE.  This variable is
;	effective when a file name is specified with the
;	WordStar invocation.  (ie. A>WS MYFILE.ASM).

	ORG	NONDOC

	DB	TRUE			; Default to non-document mode


;;;	SCRLSZ - Horizontal Scroll Size.
;
;	This value determines the number of columns WordStar
;	will scroll with each horizontal scroll operation.

	ORG	SCRLSZ

	DB	15			; Horizontal scroll size

;;;	Screen size patch.  Use the top 23 lines only.
;
;
	ORG	HITE

	DB	23


;;;	Function key and Keypad patches.
;
;	This section contains all patches to enable the
;	functions described at the beginning of this file.
;	The escape sequences here are those transmitted by
;	the H19 when the indicated key is depressed.

	ORG	04A1H			; Word left

	DB	ESC,'S'			; f1

	ORG	04B1H			; Left margin

	DB	ESC,27H			; shift/f1


	ORG	04A5H			; Word right

	DB	ESC,'T'			; f2

	ORG	04B5H			; Right margin

	DB	ESC,'('			; shift/f2


	ORG	04FDH			; End of file

	DB	ESC,'U'			; f3

	ORG	04F9H			; Beginning of file

	DB	ESC,')'			; shift/f3


	ORG	0525H			; Page up

	DB	ESC,'V'			; f4

	ORG	059DH			; Copy block

	DB	ESC,'*'			; shift/f4


	ORG	0521H			; Page down

	DB	ESC,'W'			; f5

	ORG	0599H			; Move block

	DB	ESC,'+'			; shift/f5



	ORG	05BDH			; Abandon edit

	DB	ESC,'P'			; Blue

	ORG	05B5H			; Done editing

	DB	ESC,'$'			; shift/Blue


	ORG	0501H			; Find text

	DB	ESC,'Q'			; Red

	ORG	0505H			; Replace text

	DB	ESC,'%'			; shift/Red


	ORG	050DH			; Repeat last find/replace

	DB	ESC,'R'			; White

	ORG	0491H			; Help!

	DB	ESC,'&'			; shift/White


	ORG	0545H			; Delete word right

	DB	ESC,'J'			; Erase

	ORG	0541H			; Delete line right

	DB	ESC,'E'			; shift/Erase


	ORG	04BDH			; Home cursor

	DB	ESC,'H'			; Home


	ORG	04ADH			; Up cursor

	DB	ESC,'A'			; Up arrow


	ORG	04A9H			; Down cursor

	DB	ESC,'B'			; Down arrow


	ORG	049DH			; Right cursor

	DB	ESC,'C'			; Right arrow


	ORG	0495H			; Left cursor

	DB	ESC,'D'			; Left arrow


	ORG	0549H			; Insert character

	DB	ESC,'@'			; IC


	ORG	0531H			; Delete character

	DB	ESC,'N'			; DC


	ORG	0555H			; Insert line

	DB	ESC,'L'			; IL


	ORG	0535H			; Delete line

	DB	ESC,'M'			; DL

;
; This is the initialization sequence to set up the labels
; of the function keys on lines 24-25.  When initialization
; is done, this area is overlaid by the WS work area.  If
; PBGMEM is patched in your version of WS, you'll need to
; put the origin of this area to the address in PBGMEM.
; See WS installation guide, USER1, page 18.
;

	ORG	07849H		;address of standard WS
				; working storage
SLINE:	DB	ESC,'mAW'	;scroll top 23 lines only
	DB	ESC,'x1'	;enable 25th line
	DB	ESC,'Y7('	;goto 24th line for labels
	DB	ESC,VON,'L line R',ESC,VOFF,'    '
	DB	ESC,VON,'bgn',ESC,VOFF,'    '
	DB	ESC,VON,'copy',ESC,VOFF,'  '
	DB	ESC,VON,'move',ESC,VOFF,'   '
	DB	ESC,VON,'eol ',ESC,VOFF,'  '
	DB	ESC,VON,'done',ESC,VOFF,'   '
	DB	ESC,VON,'repl',ESC,VOFF,'   '
	DB	ESC,VON,'help '
	DB	ESC,'Y8('	;goto 25th line for labels
	DB	'L word R',ESC,VOFF,'    '
	DB	ESC,VON,'end',ESC,VOFF,'    '
	DB	ESC,VON,'Up page Dn',ESC,VOFF,'   '
	DB	ESC,VON,'word',ESC,VOFF,'  '
	DB	ESC,VON,'quit',ESC,VOFF,'   '
	DB	ESC,VON,'find',ESC,VOFF,'   '
	DB	ESC,VON,'again',ESC,VOFF
	DB	ESC,'h6'	;relative origin mode to
				; protect lines 24-25
	DB	0
