/* baud.c 7-16-82
 * set baudrate on pmmi mm-103 modem
 * code adapted from steve passe's cnode
 * compile: cc1 baud.c -o -e 0f70
 * l2 baud
 */

#include "a:pmmi.h"
#include "a:bdscio.h"
#define SAVBAUD 0xfffb	/* place to put baud_rate_divisor for xmodem.c */
#define BELL 0x07
main(p_argc, p_argv)
int p_argc;
char **p_argv;
{
	int baudrate;

	if (p_argc != 2) {
		printf("\nusage: 'baud <baudrate> <cr>'");
		printf("\nsets modem speed to <baudrate>\n");
		exit();
	}
	baudrate = atoi(p_argv[1]);
	if ((baudrate < 61) || (baudrate >710 )) {
		printf("\nbaudrate out of range (61-710)");
		printf("\nCAUTION- baud did not execute properly!%c\n",BELL);
		exit();
	}
	if (baudrate > 300) outp(MODEMCP3, OVR300);  /* optimize 0-600 */
	else outp(MODEMCP3, UND300);  /* optimize 0-300 */
	sleep(2);
	outp(MODEMCP2, 15625/baudrate);
	poke(SAVBAUD,(15625/atoi(p_argv[1])));	/* save divisor for xmodem */
	exit();
}
