;------------------------------------------------
;GET PROM PROGRAM AS SEEN IN LIFELINES MAGAZINE
;DECEMBER 1981....ENTERED BY BYRON MCKAY
;
;LANGUAGE: CP/M ASM
;TYPE : UTILITY
;PURPOSE: USED TO DISCOVER INTERNAL DETAILS OF THE
;SYSTEM ROMS FOR THE OSBORNE 01 COMPUTER
;------------------------------------------------
;LAST UPDATED: DECEMBER 20, 1981 BAM
;
;TO USE: EDIT AND ASSEMBLE, LOAD THE HEX FILE WITH
;DDT.COM, EXECUTE WITH A G4000<CR> COMMAND, RE-EXECUTE 
;DDT.COM WHEN THROWN BACK INTO CP/M, AND DUMP OR LIST
;OR EVEN MOVE DATA TO 100 HEX!  EXIT DDT AND USE SAVE 
;COMMAND TO SAVE 16 PROMS.COM<CR> FOR DISSASEMBLY BY
;ANY DISSASEMBLER (LIKE ZESOURCE.COM) AND MAYBE YOU WILL
;FIND EVEN MORE FASCINATING THINGS OUT ABOUT YOUR
;OSBORNE!!
;
;
;PROGRAM BEGINS HERE
;
	ORG	4000H	;PUT ABOVE SYSTEM PROM AREA
	
	DI		;DISABLE INTERRUPTS OR IT WON'T WORK
	XRA	A	;TURN ON PROMS
	OUT	00H

	STA	0EF08H	;LET SYSTEM KNOW WE ARE IN PROM
	LXI	B,1000H	;MAKE COUNTER FOR 4K BYTES TO MOVE
	LXI	H,0000H	;AND MOVE DATA STARTING FROM ADDRESS 0
	LXI	D,8000H	;AND PUT IT IN HIGH RAM AT 8000H

MOVE	MOV	A,M	;GET A BYTE OF PROM
	STAX	D	;SAVE IT IN RAM
	INX	H	;BUMP PROM POINTER
	INX	D	;BUMP RAM POINTER
	DCX	B	;DE-BUMP BYTE COUNT TO MOVE

	MOV	A,B	;CHECK IF ALL DATA MOVED
	ORA	C

	JNZ	MOVE	;LOOP UNTILL ALL 4K PROM MOVED TO RAM

	MVI	A,1	;TURN OFF PROMS
	OUT 	1	

	STA	0EF08H	;LET SYSTEM KNOW WE ARE IN RAM
	EI		;ENABLE INTERRUPTS
	JMP	0000H	;WARM BOOT CP/M

	END
