	name	'DIOMOD'
	title	'Direct CP/M Calls and CRC calculation for SWEEP'
;
;***********************************************************
;*                                                         *
;*	cp/m calls from pl/i for direct i/o                *
;*                                                         *
;* mostly from DR's PLIDIO, with help from J.Karras's      *
;* articles in Lifelines for the getpl* modifications.     *
;***********************************************************
	public	memptr	;return pointer to base of free mem
	public	memsiz	;return size of memory in bytes
	public	memwds	;return size of memory in words
	public	dfcb0	;return address of default fcb 0
	public	dfcb1	;return address of default fcb 1
	public	dbuff	;return address of default buffer
	public	reboot	;system reboot (#0)
	public	rdcon	;read console character (#1)
	public	wrcon	;write console character(#2)
	public	rdstat	;read console status (#6c)
	public	break	;get console status (#11)
	public	vers	;get version number (#12)
	public	reset	;reset disk system (#13)
	public	select	;select disk (#14)
	public	open	;open file (#15)
	public	close	;close file (#16)
	public	sear	;search for file (#17)
	public	searn	;search for next (#18)
	public	delete	;delete file (#19)
	public	rdseq	;read file sequential mode (#20)
	public	wrseq	;write file sequential mode (#21)
	public	make	;create file (#22)
	public	rename	;rename file (#23)
	public	curdsk	;return current disk number
	public	setdma	;set DMA address (#26)
	public	allvec	;return address of alloc vector (#27)
	public	filatt	;set file attributes (#30)
	public	getdpb	;get base of disk parm block (#31)
	public	getusr	;get user code (#32a)
	public	setusr	;set user code (#32b)
;
	public	update	;update crcsum from current byte
	public	updsec	;update crcsum from current sector
;
;
	extrn	?begin	;beginning of free list
	extrn	?boot	;system reboot entry point
	extrn	?bdos	;bdos entry point
	extrn	?dfcb0	;default fcb 0
	extrn	?dfcb1	;default fcb 1
	extrn	?dbuff	;default buffer
;
;***********************************************************
;*                                                         *
;*        equates for interface to cp/m bdos               *
;*                                                         *
;***********************************************************
cr	equ	0dh	;carriage return
lf	equ	0ah	;line feed
eof	equ	1ah	;end of file
;
readc	equ	1	;read character from console
writc	equ	2	;write console character
statf	equ	11	;return console status
versf	equ	12	;get version number
resetf	equ	13	;system reset
seldf	equ	14	;select disk function
openf	equ	15	;open file function
closef	equ	16	;close file
serchf	equ	17	;search for file
serchn	equ	18	;search next
deletf	equ	19	;delete file
readf	equ	20	;read next record
writf	equ	21	;write next record
makef	equ	22	;make file
renamf	equ	23	;rename file
cdiskf	equ	25	;get current disk number
setdmf	equ	26	;set dma function
getalf	equ	27	;get allocation base
setatf	equ	30	;set file attributes
getdpf	equ	31	;get disk parameter block
userf	equ	32	;set/get user code
;
;	utility functions
;***********************************************************
;*                                                         *
;*       general purpose routines used upon entry          *
;*                                                         *
;***********************************************************
;
getp1:	;get single byte parameter to register c
	mov	e,m		;low (addr)
	inx	h
	mov	d,m		;high(addr)
	inx	h
	xchg			;hl = .char
	mov	c,m		;to register e
	xchg
	ret
;
getp2:	;get single word value to DE
getp2i:	;(equivalent to getp2)
	call	getp1
	inx	d
	ldax	d		;get high byte as well
	mov	d,a
	mov	e,c
	ret
;
getver:	;get cp/m or mp/m version number
	push	h		;save possible data adr
	mvi	c,versf
	call	?bdos
	pop	h		;recall data addr
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
memptr:	;return pointer to base of free storage
	lhld	?begin
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
memsiz:	;return size of free memory in bytes
	lhld	?bdos+1		;base of bdos
	xchg			;de = .bdos
	lhld	?begin		;beginning of free storage
	mov	a,e		;low(.bdos)
	sub	l		;-low(begin)
	mov	l,a		;back to l
	mov	a,d		;high(.bdos)
	sbb	h
	mov	h,a		;hl = mem size remaining
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
memwds:	;return size of free memory in words
	call	memsiz		;hl = size in bytes
	mov	a,h		;high(size)
	ora	a		;cy = 0
	rar			;cy = ls bit
	mov	h,a		;back to h
	mov	a,l		;low(size)
	rar			;include ls bit
	mov	l,a		;back to l
	ret			;with wds in hl
;
;***********************************************************
;*                                                         *
;***********************************************************
dfcb0:	;return address of default fcb 0
	lxi	h,?dfcb0
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
dfcb1:	;return address of default fcb 1
	lxi	h,?dfcb1
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
dbuff:	;return address of default buffer
	lxi	h,?dbuff
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
reboot:	;system reboot (#0)
	jmp	?boot
;
;***********************************************************
;*                                                         *
;***********************************************************
rdcon:	;read console character (#1)
	;return character value to stack
	mvi	c,readc
chrin:
	;common code for character input
	call	?bdos		;value returned to A
	pop	h		;return address
	push	psw		;character to stack
	inx	sp		;delete flags
	mvi	a,1		;character length is 1
	pchl			;back to calling routine
;
;***********************************************************
;*                                                         *
;***********************************************************
wrcon:	;write console character(#2)
	;1->char(1)
	call	getp1		;output char to register e
	mov	e,c
	mvi	c,writc		;console write function
	jmp	?bdos		;to write and return
;
;***********************************************************
;*                                                         *
;***********************************************************
rdstat:	;direct console status read
	lxi	h,rdsret	;read status return
	push	h		;return to rdsret
	lhld	?boot+1		;base of jmp vector
	lxi	d,1*3		;offset to .jmp const
	dad	d		;hl = .jmp const
	pchl
;
;***********************************************************
;*                                                         *
;***********************************************************
;***********************************************************
;*                                                         *
;***********************************************************
break:	;get console status (#11)
	mvi	c,statf
	call	?bdos		;return through bdos
;
rdsret:	;return clean true value
	ora	a		;zero?
	rz			;return if so
	mvi	a,0ffh		;clean true value
	ret
;
;***********************************************************
;*                                                         *
;***********************************************************
vers:	;get version number (#12)
	mvi	c,versf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
reset:	;reset disk system (#13)
	mvi	c,resetf
	jmp	?bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
select:	;select disk (#14)
	;1->fixed(7) drive number
	call	getp1		;disk number to C
	mov	e,c
	mvi	c,seldf
	jmp	?bdos		;return through bdos
;***********************************************************
;*                                                         *
;***********************************************************
open:	;open file (#15)
	;1-> addr(fcb)
	call	getp2i		;fcb address to de
	mvi	c,openf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
close:	;close file (#16)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,closef
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
sear:	;search for file (#17)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,serchf
	jmp	?bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
searn:	;search for next (#18)
	mvi	c,serchn	;search next function
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
delete:	;delete file (#19)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,deletf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
rdseq:	;read file sequential mode (#20)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,readf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
wrseq:	;write file sequential mode (#21)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,writf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
make:	;create file (#22)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,makef
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
rename:	;rename file (#23)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,renamf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
curdsk:	;return current disk number (#25)
	mvi	c,cdiskf
	jmp	?bdos		;return value in A
;
;***********************************************************
;*                                                         *
;***********************************************************
setdma:	;set DMA address (#26)
	;1-> pointer (dma address)
	call	getp2		;dma address to DE
	mvi	c,setdmf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
allvec:	;return address of allocation vector (#27)
	mvi	c,getalf
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
filatt:	;set file attributes (#30)
	;1-> addr(fcb)
	call	getp2i		;.fcb to DE
	mvi	c,setatf
	jmp	?bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
getdpb:	;get base of current disk parm block (#31)
	mvi	c,getdpf
	jmp	?bdos		;addr returned in HL
;
;***********************************************************
;*                                                         *
;***********************************************************
getusr:	;get user code to register A
	mvi	e,0ffh		;to get user code
	mvi	c,userf
	jmp	?bdos
;
;***********************************************************
;*                                                         *
;***********************************************************
setusr:	;set user code
	call	getp1		;code to E
	mov	e,c
	mvi	c,userf
	jmp	?bdos
;
;***********************************************************
;*							   *
;*  Cyclic Redundancy Check algorithms                     *
;* update updates the CRC (first parameter) by the single  *
;* byte second parameter.                                  *
;* updsec is similar, but works at an entire 128 byte      *
;* block pointed at by the second parameter.               *
;* The algorithm is essentially the same as that used in   *
;* the Dave Barker modified versions of CRCK, except that  *
;* I don't use the table lookup, and I use a different     *
;* polynomial : x^16 + x^12 + x^5 + 1.                     *
;* People who care should change the 10h and 21h to the    *
;* appropriate values (0a0h,97h).	                   *
;***********************************************************

update:
	;get the parameters
	call 	getp2
	push	d
	call	getp1
	mov	a,c
	pop	h	
docrc:	;common entry with crc in h,byte in a
	xra	h
	mov	h,a
	mvi	c,8
loop:	dad	h
	jnc	l1
	mov	a,h
	xri	10h
	mov	h,a
	mov	a,l
	xri	21h
	mov	l,a
l1:	dcr	c
	jnz	loop
	ret
;
updsec:
	call	getp2	;get crcsum
	push	d
	call	getp2	;get location of sector
	pop	h
	mvi	b,128
seclp:	ldax	d	;get next byte
	call	docrc	;update the crcsum
	inx	d
	dcr	b
	jnz	seclp
	ret
;
	end
