100 '------------------------------------------------------------------------
110 '                               COUNT.BAS
120 '                              version 2.0
130 '                                   by
140 '                           Wayne M. Hammerly
150 '                           Laurel  RCPM/SBBS
160 '                             (301) 953-3753
170 '                             July  7, 1982
180 '
190 '      COUNT is a utility for use by Sysops running OXGATE, RBBS, or my
200 '  SBBS.   I like to keep a daily record of the system's use,  and have
210 '  gotten tired of jotting down the  contents of 'COUNTERS' before I go
220 '  to bed each night.  Version 1.0 of  COUNT only put the three figures
230 '  found in the COUNTERS file in a file called  'COUNT.ARC'.  It wasn't
240 '  long before I started adding routines to archive the  COUNT.ARC file
250 '  each month, and to start comparing the figures.   When XMODEM50  was
260 '  released, I added routines to display the up/dowloads in the LOG.SYS
270 '  file, and added those figures to COUNT.ARC.
280 '      The result is an all-purpose utility that will keep track of all
290 '  system statistics on a day-to-day basis and log them to a file. This
300 '  can then be archived every month. The program also includes a 'scan'
310 '  feature   that is  used to just  check out the day's useage  without
320 '  updating the COUNT.ARC.  Running COUNT when you come home from  work
330 '  will give you an instant accounting of the system's useage.
340 '
350 '                             SEE COUNT.DOC
360 '
370 '  Please pass on any improvements, comments, or  suggestions to either
380 '  the SYSOPS RCPM or my system at (301) 953-3753.
390 '                                                     Wayne M. Hammerly
400 '
410 '---------------------------- get last count ----------------------------
420 '
430 ' this routine gets yesterday's count from COUNT.ARC
440 '
450 OPEN "R",1,"B:COUNT.ARC",60:FIELD#1,60 AS RR$:RE=1
460 GET#1,RE:GOSUB 1380:Z=VAL(S$):IF EOF(1) OR BK THEN 480
470 RE=Z+1:GET#1,RE:GOSUB 1380
480 CLOSE:LASTDAT$=LEFT$(S$,8)
490 IF VAL(LASTDAT$)=0 THEN NWFIL=1:GOTO 540
500 LASTMSG$=LEFT$(MID$(S$,10,16),5):LASTMSG=VAL(LASTMSG$)
510 LASTCAL$=LEFT$(MID$(S$,17,23),5):LASTCAL=VAL(LASTCAL$)
520 LASTHIM$=LEFT$(MID$(S$,24,30),5):LASTHIM=VAL(LASTHIM$):PRINT:PRINT:PRINT
530 '
540 '---------------------------------- ego ---------------------------------
550 '
560 PRINT "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
570 PRINT "                     COUNT version 2.0"
580 PRINT "                     Wayne M. Hammerly"
590 PRINT "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
600 '
610 '---------------------------------- menu --------------------------------
620 '
630 PRINT:PRINT TAB(5)"1  COUNT AND DISPLAY            2  COUNT AND LOG"
640 PRINT TAB(5)"3  DISPLAY COUNT.ARC            4  ARCHIVE  FILE"
650 PRINT TAB(5)"5  DISPLAY XMODEM LOG           6  EXIT TO CP/M"
660 PRINT:INPUT "Which";Q$
670 IF Q$="1" THEN C=1:PRINT:

    PRINT "Display only, not logging to file.":GOTO 750
680 IF Q$="2" THEN 750
690 IF Q$="3" THEN PRINT:PRINT:GOSUB 1450:GOTO 610
700 IF Q$="4" THEN 1920
710 IF Q$="5" THEN 2140
720 IF Q$="6" THEN POKE 0,&HC3:SYSTEM
730 GOTO 610
740 '
750 '------------------------- get date from lastcalr -----------------------
760 '
770 ' all we are interested in is DATE$.  the rest is superfalous
780 OPEN "I",1,"A:LASTCALR"
790 INPUT #1,N$,O$,TON$,LM$,UP$,MF$,DATE$:CLOSE
800 PRINT:PRINT "Date of count: "+DATE$:PRINT
810 '
820 '---------------------------- get log.sys -------------------------------
830 '
840 OPEN "I",1,"B:LOG.SYS":BK=0:RCOUNT=0:SCOUNT=0
850 IF EOF(1) OR BK THEN 970 ELSE LINE INPUT#1,A$
860 LGSYS$=A$:R$=RIGHT$(LGSYS$,10):LGDATE$=MID$(R$,2,8)
870 '
880 ' The next line will force COUNT to read ONLY the up/downloads made on
890 ' the same date as the one in LASTCALR. Rem it out if you want to read
900 ' the entire LOG.SYS file every day.
910 '
920 'IF LGDATE$<>DATE$ THEN 1040
930 '
940 IF LEFT$(LGSYS$,1)="R" THEN RCOUNT=RCOUNT+1
950 IF LEFT$(LGSYS$,1)="S" THEN SCOUNT=SCOUNT+1
960 GOTO 850
970 PRINT:CLOSE:RCOUNT$=STR$(RCOUNT):SCOUNT$=STR$(SCOUNT)
980 '
990 ' The next 2 lines will archive the LOG.SYS file everyday, and name it as
1000 ' the date. (i.e. on 07/15/82 the file will be '07/15/82.LOG' Rem this
1010 ' line out if you do not want this feature. The file will be renamed
1020 ' ONLY if the file is to be updated, not if you chose 'DISPLAY ONLY'.
1030 '
1040 IF C=1 THEN 1070
1050 FT$=".LOG":NAME "LOG.SYS" AS DATE$+FT$
1060 '
1070 '------------------------- get count from counters ---------------------
1080 '
1090 OPEN "R",1,"A:COUNTERS",5:FIELD#1,5 AS RR$
1100 GET#1,1:M$=RR$:GET#1,2:CN$=RR$:GET#1,3:U$=RR$:CLOSE
1110 M=VAL(M$):CN=VAL(CN$):U=VAL(U$)
1120 IF NWFIL=0 THEN 1130 ELSE NWCAL=0:NWMSG=0:GOTO 1140
1130 NWCAL=(CN-LASTCAL):NWMSG=(U-LASTHIM)
1140 NWCAL$=STR$(NWCAL):NWMSG$=STR$(NWMSG)
1150 PRINT "Active number of  Messages     "+M$
1160 PRINT "Total  callers to date  is     "+CN$
1170 PRINT "The high message # is  now     "+U$
1180 IF NWFIL=1 THEN 1230
1190 PRINT "Number   of   calls  today     "+NWCAL$
1200 PRINT "Number of new  msgs  today     "+NWMSG$
1210 PRINT:PRINT "Number  of  uploads  today     "+RCOUNT$
1220 PRINT "Number of  downloads today     "+SCOUNT$:PRINT
1230 IF C=1 THEN PRINT:C=0:GOTO 610
1240 '
1250 '------------------------ put count and date in arc --------------------
1260 '
1270 OPEN "R",1,"B:COUNT.ARC",60:FIELD#1,60 AS RR$:GET#1,1
1280 RE=VAL(RR$)+1:S$=STR$(RE):RL=60:GOSUB 1340:PUT#1,1:RE=RE+1
1290 IF NWFIL=1 THEN S$=DATE$+"  "+M$+" "+CN$+" "+U$:GOTO 1310
1300 S$=DATE$+"  "+M$+" "+CN$+" "+U$+"  "+NWCAL$+"   "+NWMSG$+"   "+

     RCOUNT$+" "+SCOUNT$
1310 LASTUP$=S$:GOSUB 1340:PUT#1,RE
1320 CLOSE:PRINT:PRINT "COUNT.ARC now updated.":PRINT:PRINT:GOTO 610
1330 '
1340 '----------------------- fill and store a disk record ------------------
1350 '
1360 LSET RR$=LEFT$(S$+SPACE$(RL-2),RL-2)+CHR$(13)+CHR$(10):RETURN
1370 '
1380 '------------------------- unpack disk record --------------------------
1390 '
1400 ZZ=LEN(RR$)-2:WHILE MID$(RR$,ZZ,1)=" ":ZZ=ZZ-1:IF ZZ=1 THEN 1420
1410 WEND
1420 S$=LEFT$(RR$,ZZ):IF MID$(S$,ZZ,1)="?" THEN S$=S$+" "
1430 RETURN
1440 '
1450 '-------------------------- display count.arc --------------------------
1460 '
1470 H1$="-----------------------------------------------"
1480 H2$="DATE     #MSGS   CALLS HIGH# NCAL NMSG  UP DOWN
1490 PRINT H1$:PRINT H2$
1500 OPEN "I",1,"B:COUNT.ARC":BK=0
1510 IF EOF(1) OR BK THEN 1530 ELSE LINE INPUT#1,A$
1520 GOSUB 1590:GOSUB 1810:GOTO 1510
1530 CLOSE:PRINT "Total calls to system this month :";CNCAL
1540 PRINT "Total messages left this month   :";CNMSG
1550 PRINT "Total # of uploads this month    :";CNUP
1560 PRINT "Total # of downloads this month  :";CNDW
1570 CNCAL=0:CNMSG=0:CNUP=0:CNDW=0:PRINT:PRINT:RETURN
1580 '
1590 '--------------------------- count the columns -------------------------
1600 '
1610 CDATE=VAL(LEFT$(A$,2)):IF CDATE< VAL(LEFT$(LASTDAT$,2)) THEN GOSUB 1700
1620 TNCAL$=LEFT$(MID$(A$,31,34),3):TNCAL=VAL(TNCAL$)
1630 CNCAL=CNCAL+TNCAL:CNCAL$=STR$(CNCAL)
1640 TNMSG$=LEFT$(MID$(A$,36,40),4):TNMSG=VAL(TNMSG$)
1650 CNMSG=CNMSG+TNMSG:CNMSG$=STR$(CNMSG)
1660 TNUP$=LEFT$(MID$(A$,41,43),3):TNUP=VAL(TNUP$)
1670 CNUP=CNUP+TNUP:CNUP$=STR$(CNUP)
1680 TNDW$=LEFT$(MID$(A$,44,48),4):TNDW=VAL(TNDW$)
1690 CNDW=CNDW+TNDW:CNDW$=STR$(CNDW):RETURN
1700 '
1710 '--------------------- deduct the archive line totals ------------------
1720 '
1730 ' this routine will cause the totals count to ignore the first line
1740 ' of COUNT.ARC which is a carry-over from the previous month.
1750 '
1760 ARCAL$=LEFT$(MID$(A$,31,34),3):ARCAL=VAL(ARCAL$):CNCAL=CNCAL-ARCAL
1770 ARMSG$=LEFT$(MID$(A$,36,40),3):ARMSG=VAL(ARMSG$):CNMSG=CNMSG-ARMSG
1780 ARUP$=LEFT$(MID$(A$,41,43),3):ARUP=VAL(ARUP$):CNUP=CNUP-ARUP
1790 ARDW$=LEFT$(MID$(A$,44,48),4):ARDW=VAL(ARDW$):CNDW=CNDW-ARDW:RETURN
1800 '
1810 '--------------------- print string from a$ on console -----------------
1820 '
1830 IF SAV$<>"" AND A1$<>"" THEN A1$="":RETURN
1840 IF A1$<>"" THEN A$=A1$:A1$=""
1850 IF RIGHT$(A$,1)="?" OR N=1 THEN PRINT A$;:PP$=A$:GOTO 1880
1860 BI=ASC(INKEY$+" "):IF BI=19 THEN BI=ASC(INPUT$(1))
1870 IF BI=11 THEN BK=-1:GOTO 1890 ELSE PRINT A$
1880 A=A+LEN(A$)
1890 A$="":N=0
1900 RETURN
1910 '
1920 '------------------------------ archive file ---------------------------
1930 '
1940 X$=LEFT$(DATE$,3):Y$=LEFT$(MID$(DATE$,7,8),2):FIL$=X$+Y$+"CNT.ARC"
1950 IF VAL(X$)=0 THEN PRINT:PRINT "The archive file has not been updated!":

     PRINT:GOTO 610
1960 PRINT:PRINT "Archive file will be named "+FIL$:PRINT
1970 OPEN "I",#1,"B:COUNT.ARC":BK=0
1980 OPEN "O",#2,"B:"+X$+Y$+"CNT.ARC"
1990 PRINT#2,H1$:PRINT#2,H2$
2000 IF EOF(1) OR BK THEN 2020 ELSE LINE INPUT#1,A$
2010 PRINT#2,A$:GOSUB 1590:GOSUB 1810:GOTO 2000
2020 H3$="Total calls to system this month :"+CNCAL$
2030 H4$="Total messages left this month   :"+CNMSG$
2040 H5$="Total # of uploads this month    :"+CNUP$
2050 H6$="Total # of downloads this month  :"+CNDW$
2060 PRINT#2,H3$:PRINT#2,H4$:PRINT#2,H5$:PRINT#2,H6$
2070 CLOSE#1:CLOSE#2:KILL "B:COUNT.ARC"
2080 OPEN "R",1,"B:COUNT.ARC",60:FIELD#1,60 AS RR$:GET#1,1
2090 RE=VAL(RR$)+1:S$=STR$(RE):RL=60:GOSUB 1340:PUT#1,1:RE=RE+1
2100 S$=LASTUP$
2110 GOSUB 1340:PUT#1,RE:CLOSE
2120 PRINT:PRINT "Archive of "+FIL$+" completed. ":PRINT:GOTO 610
2130 '
2140 '------------------------------ log.sys II -----------------------------
2150 '
2160 PRINT:PRINT:PRINT:UP=0:DN=0
2170 PRINT TAB(5)"1  DISPLAY LOG.SYS FILE         2  DISPLAY UPLOADS"
2180 PRINT TAB(5)"3  DISPLAY DOWNLOADS            4  RETURN TO MAIN MENU"
2190 PRINT:INPUT "Which";L$
2200 IF L$="1" THEN GOSUB 2260:GOTO 2140
2210 IF L$="2" THEN U=1:GOSUB 2330:U=0:GOTO 2140
2220 IF L$="3" THEN D=1:GOSUB 2330:R=0:GOTO 2140
2230 IF L$="4" THEN PRINT:PRINT:GOTO 610
2240 GOTO 2140
2250 '
2260 '---------------------------- display log.sys --------------------------
2270 '
2280 OPEN "I",1,"B:LOG.SYS":BK=0:PRINT:PRINT
2290 IF EOF(1) OR BK THEN 2310 ELSE LINE INPUT#1,A$
2300 GOSUB 1810:GOTO 2290
2310 PRINT:CLOSE:RETURN
2320 '
2330 '-------------------------- display up/downloads ----------------------
2340 '
2350 OPEN "I",1,"B:LOG.SYS":BK=0:PRINT:PRINT:UP=0:DN=0
2360 IF EOF(1) OR BK THEN 2400 ELSE LINE INPUT#1,A$
2370 IF U=1 AND LEFT$(A$,1)="R" THEN GOSUB 1810:UP=UP+1:GOTO 2360
2380 IF D=1 AND LEFT$(A$,1)="S" THEN GOSUB 1810:DN=DN+1:GOTO 2360
2390 GOTO 2360
2400 PRINT:CLOSE:UP$=STR$(UP):DN$=STR$(DN)
2410 U=0:D=0
2420 IF UP>1 THEN 2430 ELSE 2440
2430 PRINT TAB(10)"Total uploads :"+UP$:PRINT:GOTO 2140
2440 PRINT TAB(10)"Total downloads :"+DN$:PRINT:GOTO 2140
