;	CROSS-REFERENCE PROGRAM FOR MAST.CAT
;
;	THIS PROGRAM USES AS ITS DATA BASE THE FILE MAST.CAT,
;	WHICH MUST HAVE PREVIOUSLY BEEN CREATED USING THE CP/M
;	USER GROUP CATALOG DISKETTE CATALOGING SYSTEM.  THE
;	OUTPUT FROM THIS PROGRAM IS A DISK FILE WITH THE
;	NAME SPECIFIED AFTER THE 'CROSSREF' COMMAND, DEFAULTING
;	TO 'CATALOG.NDX' IF NO NAME IS GIVEN.  THE RESULTING
;	FILE LISTS ALL DISK FILES (NOT INCLUDING THOSE IN THE
;	MAST.CAT 'IGNORE' LIST) ALPHABETICALLY, FOLLOWED BY
;	THE DISK ID NUMBERS OF ALL DISKS ON WHICH THE FILE 
;	IS FOUND.  THIS INDEX FILE MAY BE LISTED WITH ANY
;	AVAILABLE PRINT UTILITY, OR VIEWED ON THE CONSOLE WITH 
;	THE 'TYPE' COMMAND.
;
;	ALL OF THE NAMES IN MAST.CAT ARE READ INTO MEMORY AT
;	ONCE, AND SORTED IN MEMORY AT ONCE.  THUS, MEMORY      
;	REQUIREMENTS ARE BASED ON THE SIZE OF MAST.CAT.  EACH
;	MAST.CAT ENTRY TAKES 16 BYTES OF MEMORY.  THE PROGRAM
;	ITSELF TAKES SOMEWHAT LESS THAN 2K.  THE CCP CAN BE
;	OVERWRITTEN.  THUS A MAST.CAT CONTAINING 1000 ENTRIES
;	CAN BE EASILY HANDLED IN A 24K SYSTEM.
;
;	PUBLIC DOMAIN SOFTWARE COURTESY OF:
;	LEWIS MOSELEY, JR.
;	2576 GLENDALE CT., NE
;	CONYERS, GEORGIA 30208
;	THIS VERSION 1.0 OF 12/79
;
;	SPECIAL NOTE:  ALTHOUGH NOT ORIGINALLY INTENDED TO BE,
;	THIS PROGRAM IS A THUMB-OF-THE-NOSE TO STRUCTURED
;	PROGRAMMERS EVERYWHERE.  THE PROGRAMMING STYLE CAN BE
;	LOOSELY DESCRIBED AS 'MODIFIED TOP-DOWN'.  NEVERTHELESS,
;	IT WORKS WELL.  DON'T CRITICIZE; SIT BACK AND ENJOY!
;
	ORG	100H
CROSS:	LXI	SP,STACK+64
	LXI	H,MSG1		;PRINT SIGN ON MESSAGE
	CALL	WASC
;
;READ - OPEN 'MAST.CAT', READ ENTIRE CONTENTS INTO
;MEMORY TABLE (EXCLUDING THE MAST.CAT IGNORE FILES)
READ:	LXI	H,FNT
	SHLD	FNTP		;INIT. FNT POINTER
	LXI	H,0
	SHLD	FNTC		;CLEAR COUNT
	LXI	H,DBUF+80H
	SHLD	DBUFP		;FORCE INITIAL DISK READ  
;
;OPEN MAST.CAT
	LXI	D,FCB
	MVI	C,OPEN
	CALL	ENTRY
	INR	A
	LXI	H,MSG2
	JZ	ERXIT		;JUMP IF UNABLE TO OPEN
	LXI	H,MSG3		;KEEP USER INFORMED
	CALL	WASC
;
;SKIP THE IGNORE FILENAMES AT THE HEAD OF MAST.CAT
;
SKPIGN	CALL	RDCHR
	CPI	')'	;END OF IGNORE?
	JNZ	SKPIGN
;
;MAIN READ LOOP: READ FN,FT,DN,DT FROM MAST.CAT, 
;DISCARD DN, ENTER THE REST IN THE FNT.  NOTE: BECAUSE OF
;THE SORTING SCHEME IN USE, EXACTLY 16 CHARACTERS MUST BE
;PUT IN THE TABLE FOR EACH ENTRY.
;
;SKIP TO END OF LINE (L/F) IN MAST.CAT FILE
SKIPLF	CALL	RDCHR		;READ UNTIL <LF>
	CPI	0AH
	JNZ	SKIPLF
;
LOOP:	LHLD	FNTP		;GET LOCATION IN TABLE
	XCHG			;TO DE
;GET FILENAME
	MVI	B,8
	CALL	GETNF
;GET FILETYPE
	MVI	B,3
	CALL	GETNF
;SKIP OVER DISK NAME PART OF FLAG FILE, AND TAKE
;ONLY THE DISK NUMBER (UP TO 3 ALPHANUMERIC CHARS)
	PUSH	D		;SAVE TABLE POINTER
	LXI	D,TRASH		;THROW AWAY DISK NAME
	MVI	B,8
	CALL	GETNF
;NOW MOVE IN DISK'S FILETYPE (NUMBER)
	POP	D		;GET BACK TABLE POINTER
	MVI	A,20H		;PUT IN LEADING SPACE
	STAX	D
	INX 	D
	MVI	B,3
	CALL	GETNF		;FILE TYPE
	MVI	A,20H		;AND TRAILING SPACE
	STAX	D  
	INX	D
	XCHG
	SHLD	FNTP		;SAVE POINTER
	LHLD	FNTC		;BUMP NAME COUNTER
	INX	H
	SHLD	FNTC
	JMP	SKIPLF		;LOOP 'FOREVER'
;
;
;;	SORT - SORT FNT (BY NAME, TYPE, DISK ID) BY THE
;	NOT-SO-QUICK-BUT-NEVERTHELESS-DIRTY TRADITIONAL
;	BUBBLE SORT.  THE PROGRAM MAKES REPEATED LOOPS
;	THROUGH FNT, EACH TIME ALLOWING 'SMALLEST' VALUES
;	TO 'BUBBLE UP' TO THE TOP OF THE TABLE. 
;	*ENTER BY FORCED EXIT FROM 'RDCHR' ROUTINE WHEN
;	 NORMAL EOF CHARACTER 1AH (CTRL-Z) IS FOUND.
;
SORT:	LXI	H,MSG5		;KEEP USER INFORMED
	CALL	WASC
	LXI	H,0		;I=0
	SHLD	I
SORT1:	LHLD	I		;J=I+1
	INX	H
	SHLD	J
;NOTE: ALTHOUGH THE SORT FIELD IS 16 BYTES LONG, THE LAST FIELD
;IS ALWAYS A BLANK, SO DON'T BOTHER SORTING OR SWAPPING.
SORT2:	MVI	C,16-1		;IF LINE(J) < LINE(I), SWAP
	CALL	COMP
	CC	SWAP
	LHLD	J		;J=J+1
	INX	H
	SHLD	J
	XCHG			;IF J < FNTC, GOTO SORT2
	LHLD	FNTC
	MOV	A,D
	CMP	H
	JC	SORT2
	MOV	A,E
	CMP	L
	JC	SORT2
	LHLD	I		;I=I+1
	INX	H
	SHLD	I
	XCHG			;IF I < FNTC-1, GOTO SORT1
	LHLD	FNTC
	DCX	H
	MOV	A,D
	CMP	H
	JC	SORT1
	MOV	A,E
	CMP	L
	JC	SORT1
;
;THROUGH WITH SORT, FALL THRU TO PRINT OUT
;
;;	PRINT - PRINT INDEX FROM SORTED FNT
;
PRINT:	LXI	H,MSG6		;TELL USER WHERE WE ARE
	CALL	WASC
	CALL	RESET		;MAKE DISK R/W
;	NOW SEE IF AN OUTPUT FILE NAME WAS GIVEN INITIALLY
	LDA	TFCB+FN		;JUMP IF NON-BLANK NAME OR TYPE
	CPI	' '
	JNZ	PRINT0
;	LDA	TFCB+FT		;ALLOW BLANK FT
;	CPI	' '
;	JNZ	PRINT0
	LXI	H,DEFLT		;DEFAULT TO 'DISKETTE.NDX'
	LXI	D,TFCB
	MVI	B,12
	CALL	MOVE
PRINT0:	XRA	A
	STA	TFCB+EX
	CALL	CREATE
	INR	A		;CREATE OK?
	LXI	H,MSG7
	JZ	ERXIT		;	1
OP IF NOT
	LXI	H,MSG6A		;ELSE TELL USER
	CALL	WASC
	XRA	A
	STA	TFCB+NR
	LXI	H,DBUF
	SHLD	DBUFP
	XRA	A
	STA	DBUFC
	LXI	H,0		;I=0
	SHLD	I
	INX	H		;J=1
	SHLD	J
PRINT1:	LHLD	I		;COPY NAME(I) INTO OBUF
	CALL	NDX
	LXI	D,OBUF
	MVI	B,8
	CALL	MOVE
	MVI	A,'.'		;COPY '.' INTO OBUF
	STAX	D
	INX	D
	MVI	B,3		;COPY TYPE(I) INTO OBUF
	CALL	MOVE
	PUSH	H
	LXI	H,DASH		;COPY ' - ' INTO OBUF
	MVI	B,3
	CALL	MOVE
	POP	H
;IN THIS VERSION, USE ONLY 4 CHARS OF THE 5 CHAR ID FIELD
	MVI	B,5-1		;COPY DISKID(I) INTO OBUF
	CALL	MOVE
	XRA	A		;FLAG END OF OBUF
	STAX	D
	MVI	A,1		;START WITH ONE ON LINE
	STA	CNT
	PUSH	D
PRINT2:	MVI	C,11		;IF NAME(I) <> NAME(J) GOTO PRINT3
	CALL	COMP
	POP	D
	JNZ	PRINT3
	LDA	CNT		;ADD ONE TO NUMBER ON LINE
	INR	A
	STA	CNT
	CPI	11		;JUMP IF 10 OR LESS ON LINE
	JC	PRINT8
	LXI	H,PRBUF		;PRINT FULL LINE
	CALL	WASD
	CALL	WEOLD
	LXI	D,OBUF		;START NEW ONE
	MVI	B,14
	MVI	A,' '
PRINT7:	STAX	D
	INX	D
	DCR	B
	JNZ	PRINT7
	MVI	A,1		;BACK TO ONE ON LINE
	STA	CNT
PRINT8:	MVI	A,' '		;INSERT 1 BLANK IN OBUF
	STAX	D
	INX	D
	LHLD	J		;COPY DISKID(J) INTO OBUF
	CALL	NDX
	LXI	B,11
	DAD	B
	MVI	B,5-1
	CALL	MOVE
	XRA	A		;FLAG END OF OBUF
	STAX	D
	PUSH	D
	LHLD	J		;J=J+1
	INX	H
	SHLD	J
	XCHG			;IF J < FNTC+1, GOTO PRINT2
	LHLD	FNTC
	INX	H
	MOV	A,D
	CMP	H
	JC	PRINT2
	MOV	A,E
	CMP	L
	JC	PRINT2
	POP	D
	JMP	PRINT4		;GO PRINT LAST LINE OF INDEX
PRINT3:	LXI	H,PRBUF		;PRINT OUTPUT BUFFER
	CALL	WASD
	CALL	WEOLD
PRINT6:	LHLD	J		;I=J
	SHLD	I
	INX	H		;J=I+1
	SHLD	J
	XCHG			;IF J < FNTC+1, GOTO PRINT1
	LHLD	FNTC
	INX	H
	MOV	A,D
	CMP	H
	JC	PRINT1
	MOV	A,E
	CMP	L
	JC	PRINT1
	JMP	PRINTX
PRINT4:	LXI	H,PRBUF		;PRINT OUTPUT BUFFER
	CALL	WASD
	CALL	WEOLD
PRINTX:	CALL	FLUSH
	LXI	H,MSG9		;NORMAL EXIT
	JMP	EXIT
;
;EXIT ROUTINES: ERXIT - COME HERE ON ERROR OF SOME SORT.  PRINT
;			MSG IN (HL), THEN PRINT 'ABORT' MSG.
;		EXIT  -	NORMAL EXIT. PRINT MSG IN (HL) AND
;			RETURN TO CP/M.
;
ERXIT:	CALL	WEOLC		;INITIAL <CR><LF>
	CALL	WASC
	LXI	H,MSG10
EXIT:	CALL	WASC
	JMP	0	;WARM BOOT IN CASE CCP OVERWRITTEN
;
;	COMP - COMPARE ENTRIES IN FNT, AND SWAP IF NECESSARY
;
COMP:	PUSH	H
	PUSH	D
	LHLD	I		;HL= FNT + 16*I
	CALL	NDX
	PUSH	H
	LHLD	J		;DE= FNT + 16*J
	CALL	NDX
	XCHG
	POP	H
COMP1:	LDAX	D		;COMPARE NEXT BYTE
	CMP	M
	JNZ	COMP2		;JUMP IF NOT EQUAL
	INX	D
	INX	H
	DCR	C		;KEEP TRYING
	JNZ	COMP1
	XRA	A		;STRINGS ARE EQUAL
COMP2:	POP	D
	POP	H
	RET
 
SWAP:	PUSH	H		;COME HERE IF SWAP IS NECESSARY
	PUSH	D		;CONVERT THE I AND J INDICES...
	LHLD	I		;INTO THE FWA'S OF THE TWO...
	CALL	NDX		;ENTRIES.
	PUSH	H
	LHLD	J
	CALL	NDX
	XCHG
	POP	H
	MVI	C,16-1		;ONLY SWAP 15 CHARS FOR SPEED
SWAP1:	LDAX	D
	MOV	B,A
	MOV	A,M
	STAX	D
	MOV	M,B
	INX	D
	INX	H
	DCR	C
	JNZ	SWAP1
	POP	D
	POP	H
	RET
;
;COMPUTE FWA OF TABLE ENTRY FROM THE INDEX TO THE TABLE.
;FWA=(INDEX*16)+TABLE$ORIGIN.  WORKS EASY BECAUSE ENTRIES
;ARE 16 BYTES LONG.  ENTER WITH INDEX IN HL, EXIT WITH
;FWA IN HL.
;
NDX:	PUSH	D
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,FNT	;ADD TO TABLE ORIGIN
	DAD	D
	POP	D
	RET
 
X.:L;;	MOVE - MOVE UP TO 256 BYTES OF MEMORY
;	ENTRY CONDITIONS
;		HL	FWA OF SOURCE
;		DE	FWA OF DESTINATION
;		B	NUMBER OF BYTES TO MOVE
 
MOVE:	INR	B
MOVE1:	DCR	B
	RZ
	MOV	A,M
	INX	H
	STAX	D
	INX	D
	JMP	MOVE1
 
;;	WEOLC - WRITE END OF LINE TO CONSOLE
;
 
WEOLC:	MVI	A,CR
	CALL	WACC
	MVI	A,LF
	CALL	WACC
	RET
 
;;	WASC - WRITE ASCII STRING TO CONSOLE
;
;	ENTRY CONDITIONS
;
;		HL	FWA OF STRING (TERM. BY ZERO BYTE)
 
WASC:	MOV	A,M
	ORA	A
	RZ
	CALL	WACC
	INX	H
	JMP	WASC
 
;;	WACC - WRITE ASCII CHARACTER TO CONSOLE
;	ENTRY CONDITIONS
;		A	CHARACTER TO WRITE
 
WACC:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	MOV	E,A
	MVI 	C,WCFC
	CALL	ENTRY 
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
 
;;	WEOLD - WRITE END OF LINE TO DISK
;
 
WEOLD:	MVI	A,CR
	CALL	WACD
	MVI	A,LF
	CALL	WACD
	RET
 
;;	WASD - WRITE ASCII STRING TO DISK
;
;	ENTRY CONDITIONS
;
;		HL	FWA OF STRING (TERM. BY ZERO BYTE)
 
WASD:	MOV	A,M
	ORA	A
	RZ
	CALL	WACD
	INX	H
	JMP	WASD
 
;;	WACD - WRITE ASCII CHARACTER TO DISK
;
 
WACD:	PUSH	H
	PUSH	PSW
	LDA	DBUFC
	CPI	128
	JC	WACD1
	CALL	WRREC
	LXI	H,DBUF
	SHLD	DBUFP
	XRA	A
WACD1:	INR	A
	STA	DBUFC
	POP	PSW
	LHLD	DBUFP
	MOV	M,A
	INX	H
	SHLD	DBUFP
	POP	H
	RET
 
;;	FLUSH - FLUSH DISK OUTPUT BUFFER
;
 
FLUSH:	PUSH	H
	PUSH	D
	MVI	A,1AH
	CALL	WACD
	LHLD	DBUFP
	LDA	DBUFC
FLUSH1:	CPI	128
	JZ	FLUSH2
	MVI	M,1AH
	INX	H
	INR	A
	JMP	FLUSH1
FLUSH2:	CALL	WRREC
	CALL	CLOSE
	POP	D
	POP	H
	RET
 
;;	WRREC - WRITE RECORD TO DISK
;
 
WRREC:	PUSH	H
	PUSH	D
	PUSH	B
	LXI	D,TFCB
	MVI	C,WRFC
	CALL	ENTRY
	LXI	H,MSG8		;WRITE ERROR?
	ORA	A
	JNZ	ERXIT		;JUMP IF SO
	POP	B
	POP	D
	POP	H
	RET
 
;;	CREATE - CREATE DISK FILE
;
 
CREATE:	PUSH	H
	PUSH	D
	PUSH	B
	LXI	D,TFCB
	MVI	C,DFFC
	CALL	ENTRY
	LXI	D,TFCB
	MVI	C,MFFC
	CALL	ENTRY
	POP	B
	POP	D
	POP	H
	RET
 
;;	CLOSE - CLOSE DISK FILE
;
 
CLOSE:	PUSH	H
	PUSH	D
	PUSH	B
	LXI	D,TFCB
	MVI	C,CFFC
	CALL	ENTRY
	LXI	H,MSG8		;CLOSE ERROR?
	CPI	255
	JZ	ERXIT		;JUMP IF SO
	POP	B
	POP	D
	POP	H
	RET
 
;;	RESET - RESET DISK SYSTEM
;
 
RESET:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,RDFC
	CALL	ENTRY
	POP	B
	POP	D
	POP	H
	RET
;
;GET NEXT FILENAME OR FILETYPE FROM MAST.CAT.
;TERMINATE WHEN B CHARS HAVE BEEN READ. IF
;NAME IS SHORTER THAN 'B' CHARS, LEFT-JUSTIFY
;AND BLANK-FILL.
;
GETNF:	CALL	RDCHR		;GET ONE CHAR FROM DISK
	STAX	D		;ASSUME GOOD CHAR
	CPI	'.'		;END OF FN?
	JZ	PAD
	CPI	','		;FN,DN SEPARATOR?
	JZ	PAD
	CPI	CR		;END OF LINE?
	JZ	PAD
	INX	D	;ELSE KEEP CHAR & PREPARE FOR NEXT
	DCR	B 		;ENOUGH CHARS READ?
	JNZ	GETNF		;JUMP IF NOT
	CALL 	RDCHR		;ELSE THROW AWAY SEPARATOR
	RET			;AND RETURN
;
PAD:	MVI	A,20H		;BLANK-FILL IF NECESSARY
	STAX	D
	INX	D
	DCR	B
	JNZ	PAD
	RET
;
;READ CHAR FROM DISK
;
RDCHR	PUSH	B
	PUSH	D
	PUSH	H
	LHLD	DBUFP
	MOV	A,H	;TIME TO READ?
	DCR	A
	JNZ	NOREAD
	LXI	D,FCB
	MVI	C,RNFC
	CALL	ENTRY
	ORA	A
	LXI	H,MSG4		;EARLY END?
	JNZ	ERXIT		;JUMP IF SO
RDOK	LXI	H,80H
NOREAD	MOV	A,M	;GET CHAR
	INX	H
	SHLD	DBUFP
	POP	H
	POP	D
	POP	B
	CPI	'Z'-40H		;EOF?
;	IF SO, ABORT READ ROUTINE AND DO SORT
	JZ	SORT
	RET
;
;
;	MISC STORAGE LOCATIONS
;
;	MESSAGES
;
MSG1:	DB	'MASTER DISKETTE CATALOG CROSSREFERENCE '
	DB	'UTILITY V2.0',CR,LF,0
MSG2:	DB	'++UNABLE TO OPEN MAST.CAT++',CR,LF,0
MSG3:	DB	'**NOW READING MAST.CAT**',CR,LF,0
MSG4:	DB	'++READ ERROR OR EARLY EOF++',CR,LF,0
MSG5:	DB	'**NOW SORTING FILE NAME TABLE**',CR,LF,0
MSG6:	DB	'**SORT COMPLETE**',CR,LF,0
MSG6A:	DB	'**NOW WRITING OUTPUT FILE**',CR,LF,0
MSG7:	DB	'++UNABLE TO MAKE OUTPUT FILE++',CR,LF,0
MSG8:	DB	'++DISK OR DIRECTORY FULL++',CR,LF,0
MSG9:	DB	'**FUNCTION COMPLETE**',CR,LF,0
MSG10:	DB	'++PROGRAM ABORTED++',CR,LF,0
;
DASH:	DB	' - '		;USED TO FORMAT PRINTOUT
;
STACK:	DS	64		;LOCAL STACK
;
;TO GIVE THE FINAL LISTING A LEFT-MARGIN SO THAT IT CAN BE
;MORE EASILY USED IN A BINDER, INSERT THE NECESSARY NUMBER
;OF BLANKS (SPACES) BETWEEN 'PRBUF' AND 'OBUF'.
PRBUF	DB	'  '    ;PAD OBUF WITH LEADING BLANKS (2 HERE)
OBUF:	DS	80		;OUTPUT LINE BUFFER
DBUFP:	DS	2		;OUTPUT BUFFER POINTER
DBUFC:	DS	1		;OUTPUT BUFFER COUNT
 
I:	DS	2		;OUTER LOOP INDEX FOR SORT
J:	DS	2		;INNER LOOP INDEX FOR SORT
CNT:	DS	1		;NUMBER OF DISKID'S ON LINE
 
FNTC:	DS	2		;FILE NAME TABLE COUNT
FNTP:	DS	2		;FILE NAME TABLE POINTER
TRASH:	DS	10		;STASH FOR UNWANTED DISK NAME
;
;	FCB FOR READING MAST.CAT
FCB:	DB	0,'MAST    CAT',0 	;2ND 0 = EXTENT #
	DS	19D			;REST OF FCB
	DB	0			;NR FIELD
;
DEFLT:	DB	0,'CATALOG NDX'	;DEFAULT OUTPUT FILE NAME
;
;	GENERAL EQUATES:
;	ENTRY DEFINITIONS
 
ENTRY	EQU	0005H
RCFC	EQU	1
WCFC	EQU	2
KSTAT	EQU	11
RDFC	EQU	13
OPEN	EQU	15
CFFC	EQU	16
DFFC	EQU	19
RNFC	EQU	20
WRFC	EQU	21
MFFC	EQU	22
 
;	ASCII CHARACTERS
 
BS	EQU	08H
LF	EQU	0AH
CR	EQU	0DH
 
DBUF	EQU	0080H		;DEFAULT DISK BUFFER ADDRESS
 
TFCB	EQU	005CH		;DEFAULT FILE CONTROL BLOCK
 
FN	EQU	01		;DATA POSITIONS WITHIN FCB
FT	EQU	09
EX	EQU	12
NR	EQU	32
;
FNT 	EQU	($+15)/16*16	;START OF FILE NAME TABLE
	END	CROSS
