	TITLE	'SPELLING CHECKER - VERSION 1.1A'
	PAGE 60
;
;
;	version 1.1A	(06/21/82)	(Fred Lepow)
;
;	This program is too good to be restricted only to those
;	fortunate enough to have Z80 machines and specialized
;	assemblers.  Therefore I have converted SPELL to run
;	on 8080 code - which can be assembled with the standard
;	ASM or MAC assemblers.  This should increase the number
;	of users of SPELL by a factor of ten.
;
;	I had previously converted the Z80 SARGON chess program
;	to 8080 code and, in comparing timings with the 
;	original author, Dan Spracklen, we found the difference
;	in performance to be negligible.
;
;	version 1.1  (04/30/82)  (Jim Byram)
;	Changed last instruction of GBYTE1 from OR A to AND 7FH
;	to clear high bit of text character as well as to reset
;	carry.  Necessary to scan WordStar files.
;	Changed all unconditional JR instructions to JP to speed
;	execution.  Moved BDOS calls in-line.
;	Added file output using routines from SD-42.ASM.  Words
;	not matched are written to console and (optionally) to
;	the printer and/or to a file named SPELL.LEX.  The file
;	is created on the default drive if it did not previously
;	exist.  If it did exist, the new list of unmatched words
;	is appended to the file.  This feature allows generation
;	of word lists which can be sorted and edited and then
;	added to your MASTER.LEX.
;	Added command line options for file and printer output.
;
;	version 1.0  (Alan Bomberger)
;
;	Bomberger, Alan.  1982.  A poor person's spelling
;	checker. Dr. Dobb's Journal 7(4):42-53. (DDJ #66)
;
;	Released for NON COMMERCIAL USE ONLY
;	   (c)  1981  Alan Bomberger
;
;	USAGE:  [d:]spell [d:]filename.typ [fp]
;
;		spell filename.typ    --> output to console
;
;		spell filename.typ f  --> ..and to file
;
;		spell filename.typ p  --> ..or to printer
;
;		spell filename.typ fp --> output to all three
;
;	The input file is checked using the lexicon files and
;	misspelled words (i.e., unmatched words) are printed in
;	the order they appear in the text.
;
;	The input file is broken down into a word list and the
;	user is prompted to enter the name of each lexicon to
;	be scanned.
;
;	Note -- a lexicon is a list of words usually separated
;	by <crlf>.  The words comprising a lexicon may be in
;	any order, but program execution is much faster if all
;	lexicon words are UPPER CASE.
;
;	The word list will fill all available memory so only
;	very large documents will require more than one pass
;	of the lexicons.
;
BOOT	EQU	0
BDOS	EQU	5
;
PCHAR	EQU	2
LISTC	EQU	5
PSTRING	EQU	9
RSTRING	EQU	10
OPENF	EQU	15
CLOSEF	EQU	16
SRCHF	EQU	17
READF	EQU	20
WRITEF	EQU	21
MAKEF	EQU	22
SETDMA	EQU	26
;
FCB	EQU	5CH
FCB2	EQU	6CH
BUFF1	EQU	80H
;
CR	EQU	0DH
LF	EQU	0AH
BELL	EQU	7
;
	ORG	100H
;
SPELIT:
	LXI	SP,STACK	; a new stack pointer
	LDA	FCB2+1		; check for output options
	CPI	' '		; any options?
	JZ	NOOPT
	CALL	CHKOPT		; yes, determine which
	LDA	FCB2+2		;check for second option
	CPI	' '		; another option?
	JZ	NOOPT
	CALL	CHKOPT		; yes, determine which
NOOPT:
	LXI	D,COPYR
	MVI	C,PSTRING
	CALL	BDOS
	CALL	OPENIN		; open input files
	CALL	ZCHN		; zap chains
BUILDL:
	CALL	GWORD		; get the next word of text
	JC	ENDIN		; no more left, check spelling
	CALL	SEARCH		; see if in word list
	JNC	BUILDL		; yes, it is
	CALL	ADDW		; no, so add it in
;
;	'WORK' contains the address of the last word put into
;	the word list.  See if this word is past the threshold
;	of memory.
;
	CALL	COMPARE
	JNC	BUILDL		; no, so continue
	LXI	H,NUMWDC+2	; mark as incomplete
	MVI	M,'*'
	CALL	SPELL		; check the current list
	CALL	PTABLE		; print the misspelled words
	LXI	H,COMWDL	; the last of the common words
	MVI	A,80H
	ORA	M		; mark this as the last in list
	MOV	M,A		;save list pointer
	MVI	C,6
	MVI	B,0
	LXI	D,NUMWD
	LXI	H,ZCOUNT	; zero counter
	CALL	LDIR
	CALL	ZCHN		; zap chains
	JMP	BUILDL		; and get next word
LDIR:
	PUSH	PSW
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	LDIR+1
	POP	PSW
	RET
ENDIN:
	CALL	SPELL		; check words in list
	LXI	D,FCB
	MVI	C,CLOSEF
	CALL	BDOS		; close up input file
	CALL	OUTPUT		; print words not in lexicon
	JMP	CLZOUT		; close output file and exit
;
;	chkopt
;
;	determine whether file and/or printer output selected
;	any unrecognized options will be ignored
;
CHKOPT:
	CPI	'F'		; file output wanted?
	JNZ	NOTF		; no, what about printer?
	MVI	A,0
	STA	FOPFLG		 ; set flag
	RET
NOTF:
	CPI	'P'		; printer output wanted?
	RNZ			; no
	MVI	A,0
	STA	POPFLG		; set flag
	RET
;
;	compare
;
;	compare the value in work with 'endmem'
;
COMPARE:
	LXI	H,WORK		; address of last word
	LDA	ENDMEM		; end of memory
	SUB	M
	LDA	ENDMEM+1
	INX	H
	SBB	M		; double precision subtract
	RET
;
;	openin
;
;	open input file and locate end of memory
;
OPENIN:
	LXI	D,FCB		; input file
	MVI	C,OPENF
	CALL	BDOS
	LXI	D,NINPUT	; in case not there
	INR	A
	JZ	FAILED		; no file
	MVI	A,128
	STA	IBP		; 1st call gets disk record
;
;	find end of memory
;
	LHLD	6		; address of bdos
	MOV	A,L
	SUI	64
	MOV	L,A
	MOV	A,H
	SBI	0
	MOV	H,A
	SHLD	ENDMEM
	RET
FAILED:
	MVI	C,PSTRING
	CALL	BDOS
	JMP	BOOT		; quit now
;
;	gword
;
;	get next word in text into cword
;	carry flag on means end of input
;
GWORD:
;
	MVI	A,128
	STA	CFLAGS		; set this word as last
	LXI	D,0		; length of word
GWORDL:
	CALL	GBYTE		; get next byte of text
	JC	GWORDE		; end of input
	LHLD	DELIML		; length of delimiter table
	MOV	B,H
	MOV	C,L
	LXI	H,DELIMT	; the table
	CALL	CPIR		; is it a delimiter?
	JZ	DELIM		; yes
	LHLD	ALPHAL
	MOV	B,H
	MOV	C,L
	LXI	H,ALPHA		; is it alphabetic?
	CALL	CPIR
	JNZ	GWORDL		; no, skip it
	CPI	'a'		; is it lower case
	JC	GWORDU		; no
	CPI	'{'		; lower
	JNC	GWORDU
	ANI	5FH		; make all upper case
GWORDU:
	LXI	H,CWORD+4	; place to build word
	DAD	D
	MOV	M,A		; put byte in word
	INR	E		; new length
	MOV	A,E
	STA	CLEN		; update in word entry
	CPI	30		; how long is word?
	JZ	GWORDT		; too long a word
	JMP	GWORDL		; loop
DELIM:
	MOV	A,E		; current length
	CPI	0
	JZ	GWORDL		; skip leading delimiters
	ORA	A		; zero carry
GWORDE:
	RET
CPIR:
	PUSH	D
	MOV	D,A
	MOV	A,D
	CMP	M
	INX	H
	DCX	B
	JZ	CPIRX
	MOV	A,B
	ORA	C
	JNZ	CPIR+2
	ADI	1		;turn off zero flag
	MOV     A,D
CPIRX:	POP	D
	RET
GWORDT:
	LXI	D,LNGWD1	; first part of text
	MVI	C,PSTRING
	CALL	BDOS
	LXI	D,CWORD+4
	MVI	C,PSTRING
	CALL	BDOS
	LXI	D,LNGLX2	; second part
	MVI	C,PSTRING
	CALL	BDOS
	ORA	A
	JMP	GWORDE
;
;	getbyte
;
;	get next byte of text
;	carry flag on for end of file
;
GBYTE:
	PUSH	D
	LDA	IBP
	CPI	128		; is buffer full?
	JNZ	GBYTE1		; no
	LXI	D,FCB
	MVI	C,READF
	CALL	BDOS		; read a block
	CPI	0		; did it ok?
	STC			; in case not
	JNZ	GBYTER		; end of file return
GBYTE1:
	MOV	E,A		; current byte index to fetch
	MVI	D,0		; double precision
	LXI	H,BUFF1
	DAD	D
	INR	A		; next index
	STA	IBP
	MOV	A,M		; get byte
	CPI	1AH		; check for end
	STC			; in case it is
	JZ	GBYTER		; yes
	ANI	7FH		; clear carry and set bit 7 to 0
GBYTER:
	POP	D
	RET
;
;	search
;
;	search word list for match with cword
;
;	on return hl will point to matched entry or last in list
;	carry on if no match
;
;	searc1 is the entry when searching on a chain
;
SEARCH:
	LXI	H,WORDS		; start of list
SEARC1:				; entry if starting with chain
SLOOP:
	LDA	CLEN		; length of current word
	INX	H		; point to current word length
	CMP	M		; must be same as list entry
	DCX	H		; point to start of current word
	JNZ	NEXTW		; try next entry
	CALL	CLC		; compare
	JZ	MATCH		; it is a match
NEXTW:
	MOV	A,M		; get current word flag byte
	ANI	80H		; is this the last entry?
	JNZ	NMATCH		; yes, then no match
	INX	H		; skip over flag byte
	INX	H		; skip over length byte
	MOV	A,M		; get chain pointer
	STA	WORK
	INX	H		; point to high chain byte
	MOV	A,M
	STA	WORK+1
	CPI	0		; zero only if end
	JZ	NMATCH		; end of chain
	LHLD	WORK
	JMP	SLOOP
MATCH:
	ORA	A		; clear carry
	JMP	SRET
NMATCH:
	STC			; set carry
SRET:
	RET
;
;	clc
;
;	compare logical character
;	cword with list entry pointed to by hl
;	a contains length
;
CLC:
	PUSH	H
	MOV	C,A		; length for down count
	LXI	D,CWORD+4	; compare here
	INX	H
	INX	H
	INX	H
	INX	H
CLCL:
	LDAX	D		; first character
	CMP	M		; is it?
	JNZ	CLCE		; no, stop
	INX	H
	INX	D
	DCR	C
	JNZ	CLCL		; not end so continue
CLCE:
	POP	H
	RET
;
;	addw
;
;	add word to list
;	word is in cword and hl points to last entry
;
ADDW:
	MOV	D,H		; save old position
	MOV	E,L
	MVI	A,0
	STA	CCHN
	STA	CCHN1		; zero chain pointer
	MVI	A,7FH
	ANA	M		; clear this is last entry flag
	MOV	M,A
	MVI	B,0
	INX	H		; point to length byte
	MOV	A,M		; get length of last word
	DCX	H
	ADI	4		; add length of prefix bytes
	MOV	C,A
	DAD	B		; skip over last entry
	SHLD	WORK
	XCHG			; get old position
	INX	H
	INX	H
	LDA	WORK
	MOV	M,A		; low chain
	INX	H
	LDA	WORK+1
	MOV	M,A		; high chain
	LDA	CLEN
	ADI	4
	MOV	C,A
	LHLD	WORK
	XCHG
	LXI	H,CWORD		; source
	CALL	LDIR		; move it
	CALL	COUNTW		; bump count
	RET
;
;	spell
;
;	check each lexicon word with list entries
;	mark correct (found) words in list
;
SPELL:
	LXI	D,NUMWD
	MVI	C,PSTRING
	CALL	BDOS		; inform of number of words
	CALL	SETCHN		; set up chains
	LXI	D,BUFF2		; switch buffers
	MVI	C,SETDMA
	CALL	BDOS
NEXTLEX:
	CALL	GETLEX		; get a lexicon file
	JC	SPELLR		; none, so return
	LXI	D,LFCB		; get lexicon file
	MVI	C,OPENF
	CALL	BDOS
	LXI	D,NOLEX		; in case not there
	INR	A
	JNZ	GOTLEX		; it is a valid lexicon
	MVI	C,PSTRING
	CALL	BDOS		; it is not a valid lexicon
	JMP	NEXTLEX		; try again
GOTLEX:
	LXI	D,LFCB		; lexicon fcb
	MVI	C,READF
	CALL	BDOS		; read first record
	CMP	0		; did it
	JNZ	ENDL		; quick exit
	LXI	D,CHECKM	; tell customer
	MVI	C,PSTRING
	CALL	BDOS		; that we begin
	MVI	A,0
	STA	IBPL
	STA	COMP		; say not compacted
	LDA	BUFF2		; first of compacted
	CPI	0FFH
	JNZ	SPELLL
	MVI	A,1
	STA	COMP		; set compacted
	STA	IBPL		; skip ff
SPELLL:
	CALL	LWORD		; get a word in cword
	JC	ENDL		; end of lexicon
	LXI	H,CWORD
	CALL	GETCHN		; get correct chain 
	XCHG
	MOV	E,M		; low order byte
	INX	H
	MOV	D,M		; high order byte
	XCHG
	SHLD	WORK		; get first word in list
	MOV	A,H
	CPI	0
	JZ	SPELLL		; if zero no words this letter
	CALL	SEARC1		; look for word in chain
	JC	SPELLL		; did not find it
	MOV	A,M
	ORI	040H
	MOV	M,A		;mark spelled correctly
	JMP	SPELLL		; and loop
ENDL:
	LXI	D,LFCB		; close
	MVI	C,CLOSEF
	CALL	BDOS
	JMP	NEXTLEX		; get another lexicon
SPELLR:
	LXI	D,BUFF1		; reset dma
	MVI	C,SETDMA
	CALL	BDOS		; in case more input
	RET
;
;	getlex
;
;	get a lexicon file from the customer
;	if none requested (null input) return with carry flag on
;
GETLEX:
	LXI	D,ASKLEX
	MVI	C,PSTRING
	CALL	BDOS		; type prompt
	CALL	ANSWER		; get answer
	JC	GETLXR		; return, no lexicon
	CALL	BLDFCB		; build a new fcb
	ORA	A		; clear carry
GETLXR:
	RET
;
;	answer
;
;	get answer to question in buff2
;
ANSWER:	LXI	D,BUFF2
	MVI	A,80
	STA	BUFF2
	MVI	C,RSTRING
	CALL	BDOS		; get answer
	LDA	BUFF2+1		; get length of answer
	CPI	0		; see if any
	STC			; none
	JZ	ANSWRT		; quit now
	ORA	A		; clear carry
ANSWRT:
	RET
;
;	bldfcb
;
;	build an fcb from information in buff2
;	assumes file type of .LEX
;
BLDFCB:
	LXI	H,DEFFCB	; the default fcb
	LXI	D,LFCB		; goes here
	LXI	B,16		; move this much
	CALL	LDIR		; move it
	XRA	A		; get a zero
	STA	LFCBCR		; zero this as well
	LXI	H,BUFF2+2
	LDA	BUFF2+1		; get number of bytes in name
	MOV	C,A		; b is zero from block above
BLLOOP:
	MOV	A,M		; get a byte
	CPI	' '		; is it a blank?
	JNZ	NOBLK		; no
	INX	H
	DCR	C
	JNZ	BLLOOP		; skip leading blanks
	JMP	BLDRET		; return with bad fcb
NOBLK:
	INX	H		; skip disk name if present
	MOV	A,M		; get suspected ':'
	DCX	H		; back to first character
	CPI	':'		; is it a disk name?
	JNZ	NODSK		; no, just a name
	MOV	A,M		; get disk name
	ANI	0FH		; to cp/m standards
	STA	LFCBDN		; to fcb
	INX	H
	INX	H		; skip name and ':'
	DCR	C
	JZ	BLDRET		; quit with bad fcb
	DCR	C
	JZ	BLDRET		; quit with bad fcb
NODSK:
	LXI	D,LFCBFN	; place for name
	MVI	A,8		; max length at this point
	CMP	C		; are we ok?
	JZ	BLDRET		; no, so leave blank
FILELP:
	MOV	A,M
	CPI	'.'		; this is end (we ignore)
	JZ	BLDRET
	CPI	' '		; also end
	JZ	BLDRET		; and this
	CPI	'a'		; lower case alpha?
	JC	FILEL1		; no
	ANI	5FH		; make upper
FILEL1:
	STAX	D		; put in fcb
	INX	D
	INX	H
	DCR	C
	JNZ	FILELP		; loop
BLDRET:
	RET
;
;	lword
;
;	get a lexicon word
;	carry flag on if end of lexicon
;
LWORD:
	LXI	D,0		; length of word
LWORDL:
	CALL	LCHAR		; get char from file
	JC	LWORDR		; if end
	CPI	LF		; skip these if present
	JZ	LWORDL
	CPI	' '
	JZ	LWORDL		; skip blanks in lexicon
	CPI	CR		; end of word
	JZ	LWORDE		; done
	CPI	1AH		; end
	JZ	LWORDF		; set carry and return
	CPI	'a'		; lower case?
	JC	LWORDU		; no, upper
	CPI	'{'
	JNC	LWORDU
	ANI	5FH		; make sure upper case
LWORDU:
	LXI	H,CWORD+4	; place to put it
	DAD	D
	MOV	M,A		; build word
	INR	E		; bump count
	MOV	A,E
	STA	CLEN
	CPI	30		; how long?
	JZ	LWORDT		; too long
	JMP	LWORDL		; get more bytes
LWORDE:
	MOV	A,E		; check for null word
	CPI	0		; any so far?
	JZ	LWORDL		; no, so continue
	ORA	A		; clear carry
LWORDR:
	RET
LWORDF:
	STC
	JMP	LWORDR		; return
LWORDT:
	LXI	D,LNGLX1	; first part
	MVI	C,PSTRING
	CALL	BDOS
	LXI	D,CWORD+4
	MVI	C,PSTRING
	CALL	BDOS
	LXI	D,LNGLX2	; second part
	MVI	C,PSTRING
	CALL	BDOS
	ORA	A
	JMP	LWORDR
;
;	lchar
;
;	get a character from lexicon (compacted or not)
;
LCHAR:
	LDA	COMP		; is it a compacted lexicon?
	CPI	0		; well?
	JNZ	LCHARC		; yes
	CALL	LBYTE		; no, get a byte
	RET			; and return
;
LCHARC:
	CALL	GNIB		; get a nibble
	JC	LCHARE		; end already
	CPI	0FH		; is it a flag?
	JZ	LCHARS		; yes, second set of letters
	MVI	C,16		; size of table
	LXI	H,T1		; in table one
LCHAR1:
	CMP	C
	JNC	LCHARE		; too big
	MVI	B,0
	MOV	C,A
	DAD	B
	JMP	LCHARG		; got it
LCHARE:
	LXI	D,BADLEX
	MVI	C,PSTRING
	CALL	BDOS
	STC
	RET			; say end of lexicon
LCHARS:
	CALL	GNIB
	JC	LCHARE
	MVI	C,14		; search length
	LXI	H,T2
	JMP	LCHAR1		; loop here
LCHARG:
	MOV	A,M
	ORA	A		; clear carry
	RET
;
;	gnib
;
;	get a nibble from compacted lexicon
;
GNIB:
	LDA	LRNIB
	CPI	1		; left or right?
	JZ	GNIBR		; right
	MVI	A,1
	STA	LRNIB
	CALL	LBYTE		; get a byte
	JC	GNIBR		; report carry
	STA	BYTE
	RRC	
	RRC	
	RRC	
	RRC			; put left in lower
	ANI	0FH		; clear carry
	RET
GNIBR:
	MVI	A,0
	STA	LRNIB
	LDA	BYTE
	ANI	0FH
	RET
;
;	lbyte
;
;	get a byte from lexicon file
;	carry flag on for end of file
;
LBYTE:
	PUSH	D
	LDA	IBPL		; get buffer pointer
	CPI	128		; at end?
	JNZ	LBYTE1		; no
	LXI	D,LFCB		; fcb for lexicon
	MVI	C,READF
	CALL	BDOS
	CPI	0		; did it work?
	STC			; in case not
	JNZ	LBYTER		; return with carry if end
LBYTE1:
	MOV	E,A		; position in buffer
	MVI	D,0
	LXI	H,BUFF2
	DAD	D		; correct byte
	INR	A		; for next time
	STA	IBPL		; store buffer pointer
	MOV	A,M		; get the byte
	ORA	A		; clear carry
LBYTER:
	POP	D
	RET
;
;	count words
;
COUNTW:
	LXI	H,NUMWDC	; get lowest byte
	MVI	A,':'		; a test for too large
COUNTL:
	INR	M
	CMP	M		; see if too big
	RNZ			; no
	MVI	M,'0'		; yes, set to 0
	DCX	H
	JMP	COUNTL		; backup and try again
;
;	zchn
;
;	zero chain headers
;
ZCHN:
	MVI	A,0		; get a zero
	MVI	C,54		; number
	LXI	H,ALPHC		; place
ZCHNL:
	MVI	M,0
	INX	H
	DCR	C
	JNZ	ZCHNL
	RET
;
;	getchn
;
;	get address of chain head of word pointed to by hl
;	put address in de register pair
;
GETCHN:
	PUSH	H
	INX	H
	INX	H
	INX	H
	INX	H
	MOV	A,M		; first char
	MVI	B,0
	LXI	H,ALPHC	; first chain head
	CPI	'A'		; first
	JC	CHNOTH		; lower use other
	CPI	'['
	JNC	CHNOTH		; greater use other
GETCHA:
	ANI	1FH		; mask
	DCR	A
	RLC			; double it
	MOV	C,A		; displacement
	DAD	B
	XCHG			; put result in de registers
	POP	H
	RET
CHNOTH:
	MVI	A,'['
	JMP	GETCHA		; use last chain
;
;	setchn
;
;	scans word list and rechains it by letter
;
SETCHN:
	LXI	H,WORDS		; place to start
SETCH0:
	CALL	GETCHN		; get the correct header in de
	MVI	A,0		; get a zero
	XCHG			; hl = chain, de = word
SETCHL:
	INX	H		; to high order byte
	CMP	M
	JNZ	NXTCHN		; not this one
	MOV	M,D
	DCX	H
	MOV	M,E
	XCHG			; hl = word, de = chain
	INX	H
	INX	H
	MOV	M,A		; zero forward
	INX	H
	MOV	M,A
	JP	SETCHW		; next word
NXTCHN:
	MOV	B,M
	DCX	H
	MOV	C,M
	MOV	H,B
	MOV	L,C		; hl = chain, de = word
	INX	H
	INX	H		; to chain portion of word
	MVI	A,0
	JMP	SETCHL
SETCHW:
	DCX	H
	DCX	H
	DCX	H
	MOV	A,M
	ANI	80H
	JNZ	SETCHR		; return
	INX	H
	MOV	A,M
	DCX	H
	ADI	4
	MOV	C,A
	MOV	B,0
	DAD	B
	JMP	SETCH0
SETCHR:
	RET
;
;	output
;
;	create or open output file for unmatched words
;
OUTPUT:
	LDA	FOPFLG		; is file output active?
	ORA	A
	JNZ	PTABLE		; no, begin console output
	LXI	D,OUTBUF	; set dma for output buffer
	MVI	C,SETDMA
	CALL	BDOS
;
;	first pass on file append
;	prepare SPELL.LEX to receive new or appended output
;
	LXI	D,OUTFCB	; does file already exist?
	MVI	C,SRCHF
	PUSH	D
	CALL	BDOS
	POP	D
	INR	A
	JNZ	OPENIT		; yes, open it for processing
	MVI	C,MAKEF
	CALL	BDOS		; no, create the output file
;
	INR	A
	JNZ	PTABLE		; continue if open successful
;
;	if make or open fails, declare error
;
OPNERR:
	CALL	ERXIT
	DB	CR,LF,'OPEN$'
;
WRTERR:
	CALL	ERXIT
	DB	CR,LF,'WRITE$'
;
;	openit
;
;	output file already exists - open it and position to
;	the last record of the last extent
;
OPENIT:
	MVI	C,OPENF
	PUSH	D
	CALL	BDOS		; open 1st extent of output file
	POP	D
	INR	A
	JZ	OPNERR		; bad deal if 1st won't open
OPNMOR:
	LDA	OUTFCB+15
	CPI	128
	JC	RDLAST		; if rc <128, this is last ext.
	LXI	H,OUTFCB+12
	INR	M		; else, bump to next extent
	MVI	C,OPENF
	PUSH	D
	PUSH	H
	CALL	BDOS		; and try to open it
	POP	H
	POP	D
	INR	A
	JNZ	OPNMOR		; open extents until no more
	DCR	M		; then, reopen preceding extent
	MVI	C,OPENF
	PUSH	D
	CALL	BDOS
	POP	D
	LDA	OUTFCB+15	; get rc for the last extent
;
;	rdlast
;
;	at this point, outfcb is opened to the last extent of
;	the file, so read in the last record of the last extent
;
RDLAST:
	ORA	A		; is this extent empty?
	JZ	PTABLE		; yes, start a clean slate
	DCR	A		; normalize record count
	STA	OUTFCB+32	; set record number to read
	MVI	C,READF
	PUSH	D
	CALL	BDOS		; and read last record of file
	POP	D
	ORA	A		; was read successful?
	JZ	RDOK		; yes, go scan for eof mark
;
;	if read or append fails, declare error
;
APERR:
	CALL	ERXIT
	DB	CR,LF,'APPEND$'
;
;	rdok
;
;	we now have the last record of the file in our buffer
;
;	scan the last record for the eof mark, indicating where
;	we can start adding data
;
RDOK:
	LXI	H,OUTBUF	; point to start of output buf.
	MVI	B,128		; get length of output buffer
SCAN:
	MOV	A,M
	CPI	'Z'-40H		; have we found end of file?
	JZ	RESCR		; yes, save pointers & reset cr
	INX	H
	DCR	B
	JNZ	SCAN		; no, keep looking till eob 
;
;	rescr	reset current record
;
;	if we find an explicit eof mark in the last buffer (or
;	implied eof if the last record is full),move fcb record
;	& extent pointers back to correct for read operation
;	so that first write operation will effectively replace
;	the last record of the spell.lex file
;
RESCR:
	PUSH	H		; save eof buffer pointer
	PUSH	B		; save eof buffer remaining
	LXI	H,OUTFCB+32	; get current record again
	DCR	M		; dock it
	JP	SAMEXT		; if cr >=0, still same extent
	LXI	H,OUTFCB+12	; else, move to previous extent
	DCR	M
	MVI	C,OPENF
	CALL	BDOS		; then, reopen previous extent
	INR	A
	JZ	APERR		; append err if we can't reopen
	LDA	OUTFCB+15	; position to last rec of ext
	DCR	A
	STA	OUTFCB+32
SAMEXT:
	POP	PSW		; recall where eof is in buffer
	STA	BUFCNT		; and set buffer counter
	POP	H		; recall next buffer pointer
	SHLD	BUFPNT		; set pointer for first addition
;
;	ptable
;
;	print misspelled words from list
;
PTABLE:
	MVI	B,0
	LXI	H,WORDS		; start
PTLOOP:
	MOV	A,M
	ANI	40H		; is this one correct?
	JNZ	PNEXT		; yes, don't print it
	CALL	PWORD		; print the word
PNEXT:
	MOV	A,M
	ANI	80H
	JNZ	PTABR
	INX	H
	MOV	A,M		; get length this entry
	DCX	H
	ADI	4
	MOV	C,A
	DAD	B
	JMP	PTLOOP		; try again
PTABR:
	RET
;
;	pword
;
;	print word pointed to by hl
;
PWORD:
	PUSH	H
	INX	H
	MOV	B,M
	INX	H
	INX	H
	INX	H
PWLOOP:
	MOV	E,M	; a character
	CALL	TYPE
	DCR	B
	JZ	CRLF
	INX	H		; next character
	JMP	PWLOOP
CRLF:
	MVI	E,CR
	CALL	TYPE
	MVI	E,LF
	CALL	TYPE
	POP	H
	RET
;
;	type
;
;	output character in e to console and (optionally) to
;	output file and/or to printer
;
TYPE:
	PUSH	H
	PUSH	B
	PUSH	D		; save the character to output
	MVI	C,PCHAR
	CALL	BDOS		; send it to console
	POP	D		; restore the output character
	MOV	B,E		; save character to b
	LDA	FOPFLG		; is file output active?
	ORA	A
	JNZ	NOWRIT		; no, bypass file output
;
;	file output mode active
;
;	make sure we have room in buffer to add next character
;
;	if buffer full, write out current record first and then
;	start a new record with current character
;
	LHLD	BUFPNT		; get current buffer pointer
	LDA	BUFCNT		; get buffer capacity remaining
	ORA	A
	JNZ	PUTBUF		; continue if buffer not full
	LXI	D,OUTFCB	; else, write current buffer
	MVI	C,WRITEF
	PUSH	B
	CALL	BDOS		; call must save character in b
	POP	B
	ORA	A
	JNZ	WRTERR	; error exit if disk full or r/o
	LXI	H,OUTBUF	; reset buffer pointer
	MVI	A,128		; reset buffer capacity
;
PUTBUF:
	MOV	M,B		; shove char to next position
	INX	H		; bump buffer pointer
	SHLD	BUFPNT		; and save it
	DCR	A		; dock count of chars left 
	STA	BUFCNT		; and save it
NOWRIT:
	MOV	E,B
	MVI	C,LISTC		; set up list output call
	LDA	POPFLG		; is printer output active?
	ORA	A
	CZ	BDOS		; yes, list char. on printer
	POP	B
	POP	H
	RET
;
;	clzout
;
;	we've finished all of our outputting
;	flush the remainder of the output buffer and close the
;	file before making our exit
;
CLZOUT:
	LDA	FOPFLG		; is file output active?
	ORA	A
	JNZ	BOOT		; no, exit from program
	LXI	H,BUFCNT
	MOV	A,M		; get # of unflushed chars 
	ORA	A		; if bufcnt=128, set sign bit
	JM	CLOZE		; close spell.lex if buff empty
	JZ	FLUSH		; write last rec if buff full
;
	LHLD	BUFPNT		; else, pad with ctrl-zs
PUTAGN:
	MVI	M,'Z'-40H
	INX	H
	DCR	A
	JNZ	PUTAGN		; continue until buffer filled 
;
FLUSH:
	LXI	D,OUTFCB	; flush the last output buffer
	MVI	C,WRITEF
	CALL	BDOS
	ORA	A
	JNZ	WRTERR
CLOZE:
	LXI	D,OUTFCB	; close the output file
	MVI	C,CLOSEF
	CALL	BDOS
	JMP	BOOT		; exit
;
;	erxit
;
;	abort program on output file error and define error
;
ERXIT:
	POP	D		; get pointer to message string
	MVI	C,PSTRING
	CALL	BDOS		; print it
	LXI	D,DSKERR	; print ' ERROR'
	MVI	C,PSTRING
	CALL	BDOS
	JMP	BOOT		; exit
;
;
	DS	64
STACK:	DS	1
ENDMEM:	DS	2
DEFFCB:	DB	0,'        LEX',0,0,0,0
LFCB:	DS	33
LFCBCR	EQU	LFCB+32
LFCBEX	EQU	LFCB+12
LFCBS1	EQU	LFCB+13
LFCBS2	EQU	LFCB+14
LFCBRC	EQU	LFCB+15
LFCBDN	EQU	LFCB+0
LFCBFN	EQU	LFCB+1
LFCBFT	EQU	LFCB+9
IBP:	DS	1
IBPL:	DS	1
WORK:	DS	2
BYTE:	DS	1
LRNIB:	DB	0
COMP:	DB	0
BUFF2:	DS	128
ZCOUNT:	DB	'0000  '
NUMWD:	DB	'0000   distinct words in text.',CR,LF,'$'
NUMWDC	EQU	NUMWD+3
LNGLX1:	DB	'Lexicon word "$'
LNGLX2:	DB	'" longer than 29 characters.',CR,LF,'$'
LNGWD1:	DB	'Text word "$'
BADLEX:	DB	'Error in compacted lexicon.',CR,LF,'$'
NINPUT:	DB	'Input file not specified or non-existant.'
	DB	CR,LF,'$'
NOLEX:	DB	CR,LF,'Lexicon file not specified' 
	DB	' or non-existant.'
	DB	CR,LF,'$'
CHECKM:	DB	CR,LF,'Begin spelling check pass...',CR,LF,'$'
ASKLEX:	DB	'Enter lexicon file name (.LEX assumed) '
 	DB	'or return" '
	DB	BELL,CR,LF,'$'
COPYR:	DB	CR,LF,'Poor Person Speller (c) '
	DB	'1981, Alan Bomberger'
	DB	CR,LF,'Version 1.1A-8080 Version by Fred Lepow'
	DB	CR,LF,'$'
CWORD:	DS	34
	DB	'$'
CFLAGS	EQU	CWORD
CLEN	EQU	CWORD+1
CCHN	EQU	CWORD+2
CCHN1	EQU	CWORD+3
;
FOPFLG:	DB	'F'		; file output option flag
POPFLG:	DB	'P'		; printer output option flag
;
BUFPNT: DW	OUTBUF		; next location in output buffer
BUFCNT: DB	128		; number bytes left in buffer
OUTFCB:	DB	0,'SPELL   LEX'
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
OUTBUF:	DS	128		; output file buffer
DSKERR: DB	' ERROR',CR,LF,'$'
;
DELIMT:	DB	' .,:;''"-?!/()[]{}',CR,LF,9
	DB	0,0,0,0,0,0,0,0
DELIML:	DB	DELIML-DELIMT-8,0
ALPHA:	DB	'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	DB	'abcdefghijklmnopqrstuvwxyz'
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ALPHAL:	DB	ALPHAL-ALPHA-20,0
T1:	DB	'EISNATR'
	DB	'OLDCUGP',CR
T2:	DB	'MHBYFVW'
	DB	'KZXQJ',1AH
ALPHC:	DS	54
WORDS:
COMWDL:	DB	192,1,0,0,'A'

	END	100H
/T
ISNATR'
	DB	'OLDCUGP'