/*
		fp functions
		sqrt
		log
		p10
		atan
		sin
		ftoi
*/
#include        <bdscio.h>


/*
	demo main
*/
main()
{
        int  len;
        char num[16], x[5], result[5];

        while((len = getline(num, 16)) > 0) {
          atof(x,num);
        printf("sin = %10.8f\n", sin(result,x));
        printf("sqrt = %10.8f\n", sqrt(result,x));
        printf("atan = %10.8f\n", atan(result,x));
        printf("p10 = %10.8f\n", p10(result,x));
        printf("log = %10.8f\n", log(result,x));
        }
}
/*
        fpfunc.c
        
        The sqrt, log, p10, and atan functions were taken from
        "Quick and Dirty functions for BASIC", by Dennis Allison,
        DDJ 29.  There are several errors in the BASIC programs
        presented in the article but the algorithms work.
        
        The sin function is taken from "BASIC Scientific Subroutines"
        Vol. 1, Byte Books. By F. R. Ruckdeschel.
        
        The ftoi and poly routines are my own and I claim rights to
        all errors, bugs and bad techniques in these programs.  The
        rest is up for grabs.
                R. Blessing   7/7/82
                
*/

/*
        sqrt(r,x)
*/
char    *sqrt(result, x)
char    result[5], x[5];
{
        char  temp0[5], temp1[5], temp2[5],
              temp3[5], temp4[5], temp5[5],
              temp6[5], x1[5];
        int   i;

        itof(temp0,0);
        itof(temp1,100);
        itof(temp2,1);
        itof(temp3,10);
        atof(temp4,"0.115442");
        atof(temp5,"1.15442");
        atof(temp6,"0.5");
	fpadd(result, x, temp0);


        if (fpcomp(result,temp0) != -1) {
                if (fpcomp(result,temp0) == 0)  
                        return itof(result,0);

                        itof(x1,1);

                while(fpcomp(temp2,result) == -1) {
                        fpdiv(result,result,temp1);
                        fpmult(x1,x1,temp3);
                }

                fpmult(temp1,temp5,result);
                fpadd(temp1,temp1,temp4);

                for(i=1; i<=5; i++) {
                        fpdiv(temp5,result,temp1);
                        fpadd(temp5,temp1,temp5);
                        fpmult(temp1,temp5,temp6);
                }

                return fpmult(result,temp1,x1);
        }
        else {
                printf("Negative number passed to sqrt");
                exit();
        }
}
/*
    log(r, x)      base 10
*/

char  *log(result,x)
char  result[5], x[5];
{
        char temp0[5], temp1[5], temp2[5],
             temp3[5], temp4[5],
             x1[5], x2[5],
             x3[5], x4[5];
        char consta[3][5], constb[3][5];

        itof(temp0,0);
        itof(temp1,1);
        itof(temp2,10);
        atof(temp3,"0.5");
        atof(temp4,"3.162278");
        atof(consta[2],"0.2668633");
        atof(consta[1],"-2.655809");
        atof(consta[0],"3.187822");
        itof(constb[2],1);
        atof(constb[1],"-4.280973");
        atof(constb[0],"3.670116");

	fpadd(result, x, temp0);


        if(fpcomp(result, temp0) > 0) {
                itof(x1,1);
                if(fpcomp(result, temp1) == -1) {
                        itof(x1,-1);
                        fpdiv(result,temp1,result);
                }
                itof(x2,0);

                while(fpcomp(result, temp1) > 0) {
                        fpdiv(result,result,temp2);
                        fpadd(x2,x2,temp1);
                }
                fpadd(temp0,result,temp1);
                fpsub(temp1,result,temp1);
                fpdiv(result,temp1,temp0);
                fpmult(temp2,result,result);

                poly(x3, temp2, 3, consta);

                poly(x4, temp2, 3, constb);

                fpmult(temp0,result,x3);
                fpdiv(temp0,temp0,x4);
                fpadd(temp0,x2,temp0);
                return fpmult(result,temp0,x1);
        }
        else {
                printf("a value of x<= 0 passed to log.");
                exit();
        }
}
/*
        p10(r, x) = 10 ^ x
*/

char    *p10(result,x)
char    result[5], x[5];
{
        char    temp0[5], temp1[5],
                temp2[5], temp3[5], temp4[5],
                temp5[5], temp6[5],
                x1[5], x2[5], x3[5], x4[5];
        char    consta[2][5],
                constb[3][5];

        itof(temp0,0);
        itof(temp1,1);
        itof(temp2,-1);
        itof(temp3,2);
        atof(temp4,"0.5");
        atof(consta[1],"8.751758");
        atof(consta[0],"69.55697");
        itof(constb[2],1);
        atof(constb[1],"34.29514");
        atof(constb[0],"60.41641");
        itof(temp5,10);
        atof(temp6,"3.162278");

	fpadd(result, x, temp0);

        itof(x1,0);

        if(fpcomp(temp0,result) == 1) {
                itof(x1,1);
                fpmult(result,result,temp2);
        }
	ftoi(x2, result);
        fpsub(result,result,x2);
        fpsub(result,result,temp4);
        fpmult(temp2,result,result);

        poly(x3, temp2, 2, consta);

        poly(x4, temp2, 3, constb);

        fpmult(temp2,result,x3);
        fpsub(temp2,x4,temp2);

        fpmult(temp4,result,x3);
        fpmult(temp4,temp3,temp4);
        fpdiv(result,temp4,temp2);

        fpadd(result,result,temp1);
        fpmult(result,result,temp6);

        while(fpcomp(x2,temp0) > 0) {
                fpmult(result,result,temp5);
                fpsub(x2,x2,temp1);
        }
        if(fpcomp(x1,temp1) == 0)
                fpdiv(result,temp1,result);

        return result;
}


/*
        atan(r, x)
*/
char    *atan(result,x)
char    result[5], x[5];
{
        char    temp0[5], temp1[5], temp2[5],
                temp3[5],
                x1[5], x2[5], x3[5], x4[5];
        char    consta[3][5], constb[4][5];

        itof(temp0,0);
        itof(temp1,1);
        itof(temp2,-1);
        atof(temp3,"1.570796");
        atof(consta[2],"11.11774");
        atof(consta[1],"72.58144");
        atof(consta[0],"80.78998");
        itof(constb[3],1);
        atof(constb[2],"28.13286");
        atof(constb[1],"99.51128");
        atof(constb[0],"80.78999");
        itof(x1,1);
        itof(x2,0);

	fpadd(result, x, temp0);

        if(fpcomp(result,temp0) < 0) {
                itof(x1,-1);
                fpmult(result,result,temp2);
        }

        if(fpcomp(result,temp1) > 0) {
                itof(x2,1);
                fpdiv(result,temp1,result);
        }

        fpmult(temp2,result,result);

        poly(x3, temp2, 3, consta);

        poly(x4, temp2, 4, constb);

        fpmult(result,result,x3);
        fpdiv(result,result,x4);

        if(fpcomp(x2,temp1) == 0)
                fpsub(result,temp3,result);

        return fpmult(result,result,x1);
}



/*
        sin(r, x)
*/

char    *sin(result,x)
char    result[5], x[5];
{
        char    temp0[5], temp1[5], temp2[5],
                temp3[5], temp4[5], temp5[5],
                x1[5], x2[5], x3[5];
        char    consta[6][5];

        itof(temp0,0);
        itof(temp1,1000);
        itof(temp2,-1);
        atof(temp3,"1.570796");
        atof(temp4,"3.141593");
        atof(temp5,"6.283185");
        atof(consta[5],"-2.50706E-8");
        atof(consta[4],"2.755759E-6");
        atof(consta[3],"-1.984127e-4");
        atof(consta[2],"8.333333E-3");
        atof(consta[1],"-1.666667E-1");
        itof(consta[0],1);

	fpadd(result, x, temp0);


        itof(x2, 1);

        if(fpcomp(result,temp0) < 0) {
                itof(x2, -1);
                fpmult(result, result, temp2);
        }


        if(fpcomp(result,temp1) > 0) {
                printf("Number passed to sin > 1000.\n");
                exit();
        }

        fpdiv(temp1,result,temp5);
        ftoi(result,temp1);
        fpmult(temp1,result,temp5);
        fpsub(result,x,temp1);

        if(fpcomp(result, temp4) > 0) {
                fpmult(x2, x2, temp2);
                fpsub(result, result, temp4);
        }

        if(fpcomp(result, temp3) > 0)
                fpsub(result, temp4, result);

        fpmult(x1,result,result);

        poly(x3, x1, 6, consta);

        fpmult(x3, x3, x2);
	return fpmult(result, result, x3);
}


/*
        ftoi(r, x) = int(x)
*/

char *ftoi(result,x)
char    result[5], x[5];
{
        char    ohold[15], nhold[7];
        int     i;

        itof(result,0);

        if(fpcomp(x,"999999.9") > 0)
                return fpadd(result,result,x);

        sprintf(ohold, "%7.7f", x);
        i = 0;
        while(((nhold[i] = ohold[i]) != '.')  && i < 15)
                i++;
        nhold[i] = '\000';
        return atof(result, nhold);
}


/*
        poly(r, x, s, c[s][5])
*/

char    *poly(result, x, size, const)
char    result[5], x[5], const[][5];
int     size;
{

        size--;

        itof(result, 0);
        fpadd(result, result, const[size--]);


        while (size >= 0) {
                fpmult(result, result, x);
                fpadd(result, result, const[size--]);
        }

        return result;
}
