/*	alldir.c - dump all CP/M directory entries		*/
/*					1982/08/17 19:38	*/
/*
	Inspired by the assembly language routine ALLDIR in
David E. Cortesi's INSIDE CP/M: A Guide for Users and Programmers,
Holt, Rinehart and Winston, New York 1982, p. 226-228.

C version:

	Copyright 1982	William G. Hutchison, Jr.
			P.O. Box 278
			Exton, PA 19341-0278
			U.S.A.

			CompuServe 70665,1307




    This  program  may be used freely for any non-commercial
purpose, provided that the user does  not  remove  or  alter
this notice or the copyright statement.
    Those  who  wish  to  sell  or lease this program, or to
incorporate it into a product  for  sale  or  lease,  should
apply to the author (above) for licensing information.
    This  program  is  not  covered  by  a  warranty, either
express or implied. The author shall not be responsible  for
any  damages (including consequential) caused by reliance on
the  materials  presented,  including  but  not  limited  to
typographical errors or arithmetic errors.

    This version is for C/80 Version 2 from Software Toolworks.


 */

#include "c80def.h"

#define DEFAULT_DRIVE 25
#define SELECT_DRIVE 14
#define SRCH_FIRST 17
#define SRCH_NEXT 18

#include "printf.c"

/*	define the number of Bytes Per Line to be dumped:	*/
#define BPL 16

struct dir {			/* CP/M directory entry		*/
	char user;
	char filename[8];
	char type[3];
	char extent;
	char s1, s2, rec_count;
	char map[16];
	};

#define DIR_SIZE sizeof(struct dir)

struct fcb {			/* CP/M FCB entry		*/
	char drv;
	char filename[8];
	char type[3];
	char extent;
	char s1, s2, rec_count;
	char map[16];
	char rec, d1, d2, d3;
	};

#define FCB_SIZE sizeof(struct fcb)


static struct fcb *cpmfcb= 0x5C;
static struct dir *cpmbuff=0x80;

main()
{
int drive, place;
struct fcb *locfcb;

if	((drive= cpmfcb->drv) == 0)
	drive= bdos(DEFAULT_DRIVE, 0);
else
	drive--			/* 1..26 => 0..25		*/;

init_fcb(locfcb= alloc(FCB_SIZE), '?', "????????", "???", '?');

printf("All directory entries, drive %c.\n", 'A'+drive);
bdos(SELECT_DRIVE, drive);

place= bdos(SRCH_FIRST, locfcb) & 0xFF;
while	(place != 0xFF) {
	printf("\n");
	hex_dump(cpmbuff + place, DIR_SIZE);
	place= bdos(SRCH_NEXT, locfcb) & 0xFF;
	}
}				/* end of main			*/

hex_dump(base, len)
char *base;
int len;
{
char *p;
int i;

for	(; len > 0; len-= BPL, base+= BPL) {
/*
	printf("%4x:", (unsigned)base);
 */
	for	(p= base, i= (len > BPL)? BPL : len; i > 0; i--)
		printf(" %2x", peek(p++));
	for	(i= BPL-len; i > 0; i--)
		printf("   ");
	printf("  ");
	for	(p= base, i= (len > BPL)? BPL : len; i > 0; i--)
		printf("%c", printable(*p++));
	printf("\n");
	}
}				/* end of hex_dump		*/

init_fcb(f, d, fn, ft, x)	/* initialize an FCB		*/
struct fcb *f;
char d, *fn, *ft, x;
{
int i;

f->drv= d;
strmove(fn, f->filename);
strmove(ft, f->type);
f->extent= x;
f->s1= f->s2= f->rec_count= 0;
for	(i= 16-1; i >= 0; i--)
	f->map[i]= 0;
}				/* end of init_fcb		*/

peek(p)
char *p;
{return	(0xFF & *p);}

#ifdef ASCII
printable(c)
char c;
{
return	(32 <= c && c <= 127? c : '.');
}
#endif

strmove(from, to)		/* move string but not '\0'	*/
char   *from,*to;
{
while	(*from)
	*to++= *from++;
}				/* end of strmove		*/

bdos(fcn, arg)			/* do BDOS function fcn with arg */
unsigned fcn, arg;
{
arg;
#asm
	MOV	D,H
	MOV	E,L
#endasm
fcn;
#asm
	MOV	C,L
	CALL	5		;CALL BDOS
	PUSH	PSW		;SAVE VALUE IF RETURNED IN A
	PUSH	H		;SAVE VALUE IF RETURNED IN HL
#endasm
switch	(fcn) {			/* is value already in HL?	*/
	case 12:
	case 24:
	case 27:
	case 29:
	case 31:
#asm
	POP	H		;PUT VALUE BACK IN HL
	POP	B		;DISCARD VALUE FROM A
	RET			;AND SILENTLY STEAL AWAY
#endasm
	default:
#asm
	POP	H		;DISCARD VALUE FROM HL
	POP	PSW		;RECOVER VALUE FROM A
	MOV	L,A		;PUT IT INTO HL
	MVI	H,0
#endasm
	}
}				/* end of bdos			*/
