/* ccc:	Version 1.01, H.Schulz, Nov 24, 1982
**
**	A short routine that makes or appends compile and link
**	commands for BDS C to a $$$.SUB file for batch execution.
**
**			cc1 ccc.c -o -e1500
**			l2 ccc
**
**	For maximum speed (I'm talking .1~.2 seconds difference max)
**	use
**			l2 ccc -l bdsnew ,
**
**	where bdsnew is the new machine language versions of the
**	standard string functions.
**
**	Make sure to change the CCNAME and LINKNAME defines to the names
**	for the compiler and linker you have and use. The SUBNAME define
**	should have the drive your system expects to find a $$$.SUB file.
**	This is usually A: or the default drive (the use "$$$.SUB").
**
**	If you decide to change either the LINKDELIM and/or the LINKNOT
**	characters, make sure you DON'T choose ';' since the CCP considers
**	anything after a ';' a comment.
**
**	Version 1.01: H.S.
**		The only change in logic was to cut off the extension of
**		all files that were put into the link line. The linker
**		doesn't even look at the extension so this change is 
**		purely esthetic. For purely esthetic reasons, other code 
**		was also slightly cleaned up.
*/
#include <bdscio.h>

#define BDS146			/* put in the -x option if >1.46 */
#define CCNAME "CC"		/* what you call your BDS C compiler */
#define LINKNAME "NL2"		/* the name of the linker of your choice */
#define SUBNAME "A:$$$.SUB"	/* make sure it's on the right drive! */

#define LINKDELIM '\\'		/* anything after this goes to the linker */
#define LINKNOT '!'	     /* if NEXT parameter after LINKDELIM don't link */

#define MAXFILE 10		/* maximum number of files allowed */
#define SLENGTH 81		/* 80 char + '\0' */

/* globals */
char ccs[MAXFILE][SLENGTH];		/* buffers for the compile lines */
int ncc;				/* number of compiled functions */
char links[SLENGTH];			/* the string for the linker */
char files[SLENGTH];			/* string of file names to link */
char opts[SLENGTH];			/* compile options */

char subbuf[SECSIZ];			/* sector buffer */

main(argc, argv)
int argc;
char **argv;
{
	if (argc < 2)
		abort("usage: ccc {fname [opt]} [ \\ {fname | opt} | !]");
		
	init();
	
	while (--argc && **(++argv) != LINKDELIM)
		cclines(*argv);
	if (*opts)
		addopts();
		
	if (!argc || (argc-- && **(++argv) != LINKNOT)) {
		sprintf(links, "%s%s", LINKNAME, files);
		while (argc--)
			spstrcat(links, *(argv++));
	}
	
	makesub();
}

init()
{
	ncc = 0;
	*links = *files = *opts = '\0';
}

cclines(sp)
char *sp;
{
	int ndx;

	if (*sp == '-') 
		spstrcat(opts, sp);
	else {
		if (ncc >= MAXFILE)
			abort("Too many files requested.");
		sprintf(ccs[ncc++], "%s %s", CCNAME, sp);
		if ((ndx = index(sp, ".")) != ERROR)
			sp[ndx] = '\0';
		spstrcat(files, sp);
	}
}

addopts()
{
	int i;
	
#ifdef BDS146
	strcat(opts, " -X");
#endif
	for (i = ncc; --i >= 0;)
		strcat(ccs[i], opts);

}

spstrcat(dp, sp)
char *dp;
char *sp;
{
	strcat(dp, " ");
	strcat(dp, sp);
}

makesub()
{
	int fd;
	
	if ((fd = open(SUBNAME, 1)) == ERROR)
		fd = creat(SUBNAME);
	else
		seek(fd, rcfsiz(fd), 0);
	
	if (*links)
		makeline(fd, links);
	
	while (ncc)
		makeline(fd, ccs[--ncc]);
	
	close(fd);
}

makeline(fd, sp)
int fd;
char *sp;
{
	*subbuf = strlen(sp);
	strcpy((subbuf + 1), sp);
	if (write(fd, subbuf, 1) != 1) {
		close(fd);
		abort("ERROR writing to $$$.SUB: out of room?");
	}
}

abort(msg)
char *msg;
{
	puts(msg);
	unlink(SUBNAME);
	exit(1);
}
}

cclines(sp)
char *sp;
{
	int ndx;

	if (*