;
;	CHGPW.ASM  Ver 1.0  as of 08/25/82
;	for USERPW.ASM
;	By Dave Hardy
;
;    This program will allow users to change their passwords, as kept
;    by the USERPW (version 36 and later) program.  It also allows
;    passwords (and user names) to be added, deleted, and changed by
;    anyone who has a 'master' password that is kept in the password
;    file of USERPW with the name 'MASTER PASS'.
;
;    The program is invoked without a command tail:
;	A>CHGPW
;    for normal use, and will prompt:
;	Type Ctl-C to abort, ? for help
;	Enter your name:<enter your name>
;	Enter your CURRENT password:<enter your old PW>
;	Enter your NEW password:<enter your new PW>
;	OLD PW=<your old PW>
;	NEW PW=<your new PW>
;	OK (Y/N)?<Y, or N> 
;    If you answer Y, then the program will say:
;	PW change complete.
;    and return to CP/M
;    If you answer N, then the program will say:
;	PW change aborted.  No changes made.
;    and return to CP/M
;    If the program can't find your name in the PW file, it will say:
;	+++NAME NOT FOUND.  ABORTING.
;    and abort.  If the wrong current PW is given, it will say:
;	+++INCORRECT OLD PW.  ABORTING.
;    and abort.
;
;    To enter the 'MASTER' mode, invoke the program with a command tail:
;	CHGPW <your master PW as listed in PWFILE>
;    You will then be asked: 
;	Add, Delete, Change, List, or Exit (A/D/C/L/E)?
;
;    The Add option will ask:
;	Enter new name:<type new user name>
;	Enter new password:<type new user password>
;	Enter user access areas:<type areas, separated by commas>
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;	OK (Y/N)?
;
;    The Delete option will ask:
;	Enter NAME to be deleted:<type user name to be deleted>
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;	OK (Y/N)?
;
;    The Change option will ask:
;	Enter NAME of user:<enter user name>
;    then it will print the user information:
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;	Change Name, Password, User access, or Abort (N/P/U/A)?
;    If you answer N, then:
;	Enter new NAME:<type new name>
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;	OK (Y/N)?
;    If you answer P, then:
;	Enter new password:<type new pw>
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;	OK (Y/N)?
;    If you answer U, then:
;	Enter new user area list:<type new user list.  e.g. 1,2,3,12>
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;	OK (Y/N)?
;    If you answer A, then back to the MASTER prompt:
;	Add, Delete, Change, List, or Exit (A/D/C/L/E)?
;
;    The List option will print the entire PWFILE on the console in
;    the form:
;	NAME=JOHN SMITH            PW=PASSWORD          UA=1,2,3,4,6,12
;    Names can be up to 20 characters, PWs up to 16.
;    Upper/Lower case MATTERS!
;
;    Type ^C to exit or use the 'E' option.  The PWFILE is only written
;    back to disk when the program is exited via the 'E' option, so a
;    ^C will allow you to exit gracefully if you ever mess up the PWFILE
;    and decide to abort the whole session.
;
;    The PWFILE can only be as large as your system's TPA.  If the file
;    becomes too large to fit in memory while in MASTER mode, an error
;    message will be displayed, the last line entered or changed will be
;    lost, and the program will return to the MASTER prompt.  If the file
;    becomes too large while a user is changing a password, the message:
;	+++MEMORY FULL, USE SHORTER PASSWORD OR NOTIFY OPERATOR
;    will appear, and the program will abort back to CP/M.
;
;
;Define TRUE and FALSE:
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
;Define some miscellaneous things:
BASE	EQU	0	;Your CP/M's base address.  4200H for ALTCPM
WBOOT	EQU	BASE	;Warm-boot jump address
BDOS	EQU	5	;BDOS service jump address
DFCB	EQU	BASE+5CH;Default file control block address
CR	EQU	0DH	;ASCII Carriage Return character
LF	EQU	0AH	;ASCII Linefeed character
;
;BDOS functions used:
CONIN	EQU	1	;Console Input
CONOUT	EQU	2	;Console Output
PRNSTR	EQU	9	;Print String
RDBUF	EQU	10	;Read Console Buffer
OPEN	EQU	15	;Open File
CLOSE	EQU	16	;Close File
SRCFST	EQU	17	;Search for First
DELETE	EQU	19	;Delete File
RDSEQ	EQU	20	;Read Sequential
WRSEQ	EQU	21	;Write Sequential
MKFIL	EQU	22	;Make a File
RENAME	EQU	23	;Rename a file
STDMA	EQU	26	;Set DMA Address
SETUSR	EQU	32	;Set/Get User Code
;
;Set the following for your system and USERPW program
PWUSR	EQU	21	;Set to user number where PWFILE is kept
PWDRV	EQU	1	;Set to drive where PWFILE is kept (1=A, 2=B, etc.)
TRAPLC	EQU	TRUE	;True, if want only upper case names and passwords
NOBAK	EQU	TRUE	;True, if do not want to keep a backup PWFILE.BAK
;			 (If false, then PWFILE.BAK is created from the
;			  old PWFILE, before new PWFILE is written to disk.)
	ORG	BASE+100H	;Start of TPA
;
;Start of CHGPW code
;
;First, load the PWFILE into memory
	CALL	LODPWF		;Load entire file in after program end
;
;Then, see if there is anything on the command tail 
	LXI	H,DFCB+1	;Look at first argument
	MOV	A,M
	CPI	'?'		;See if HELP request
	JZ	HELP		;If yes, then print help info
	CPI	20H		;Something there? (other than a space or '?')
	JNZ	MASTER		;If yes, then assume it is MASTER request
;
;
;  USER section of program.  This section allows user to change PW only
;
;
;Not MASTER user, so ask for user name
GNAME	CALL	AHLP		;Print info message
	DB	'Type CTL-C to abort, ? for help$'
AHLP	POP	D
	CALL	PTMSG
	CALL	ASKNAM		;Ask for user name
	DB	'Enter your name: $'
ASKNAM	POP	D
	LXI	B,CNAME		;Answer goes in CNAME buffer
	CALL	DOMSG		;Print msg and get answer
	LDA	UNAME		;See if request for help
	CPI	'?'
	JNZ	NOHLP		;Jump if not
	CALL	DHLP
	DB	CR,LF,'HELP INFO GOES HERE$'
DHLP	JMP	ERRXIT
;
;Get the current password
NOHLP	CALL	ASKOPW
	DB	'Enter your CURRENT password: $'
ASKOPW	POP	D
	LXI	B,CPSWD		;Answer goes in CPSWD buffer
	CALL	DOMSG		;Print msg and get answer
;
;Get the new password
	CALL	ASKNPW
	DB	'Enter your NEW password: $'
ASKNPW	POP	D
	LXI	B,CNPSWD	;Answer goes in CNPSWD
	CALL	DOMSG		;Print msg and get answer
;Check for embedded commas (that would cause UA to be mis-read next time)
	MVI	B,0
	LXI	H,NPSWD-1	;Get length of PW into BC
	MOV	C,M
	INX	H
	DAD	B
	INX	H
	MVI	M,'$'		;Put a '$' at end of PW
	LXI	H,NPSWD
	CALL	CMC1
	DB	'+++BAD ENTRY, no ","''s, ";"''s or "$"''s allowed.$'
CMC1	POP	D		;Point DE to error message just in case
CMACHK	MOV	A,M
	CPI	','		;Check for commas
	JZ	ERRXND		;Abort if comma found
	CPI	';'		;Check for semicolons
	JZ	ERRXND		;Abort if semicolon found
	CPI	'$'		;See if at end of PW
	INX	H
	JNZ	CMACHK		;Continue if not, else fall through
;
;Now print the old and new passwords, and have user verify if ok
	CALL	SOPW
	DB	'OLD PW=$'
SOPW	POP	D		;DE is message pointer
	LXI	H,PSWD-1	;HL points to length of OLD PW
	CALL	PITEM		;Print 'OLD PW=<oldpw>'
	CALL	SNPW
	DB	'NEW PW=$'
SNPW	POP	D
	LXI	H,NPSWD-1
	CALL	PITEM		;Print 'NEW PW=<newpw>'
	CALL	YESNO		;Ask if ok.  Abort if no, else return
;
;Data is entered, request is ok'ed, so change user's PW
;  Do this by:
;    Finding the user's name, verifying the old PW,
;    Reading the user's entry to get the UA access,
;    Copying the UA info into the UA buffer (USRS),
;    Deleting the old entry, and
;    Writing the new entry onto the end of the file.  Then,
;    Write the file back to disk.
;
;First, find the user's name in the PWFILE (then check that the PW's match)
;
	LXI	H,PWBUF		;Point to start of PWFILE
NX	MOV	A,M		;Check for start of name(=;) or EOF(=$)
	INX	H		;Point to next character in PWFILE
	CPI	';'		
	JZ	GOTNAM		;Jump if start of a name found
	CPI	'$'
	JNZ	NX		;Continue until EOF or name found
;
NONAME	CALL	ERRXIT		;Tell user that he has screwed up
	DB	'Sorry, but that name is not listed in the PWFILE.$'
;See if names match.  if so, then move on, else find next name and try agn
;HL points to start of name in PWFILE
GOTNAM	LXI	D,UNAME-1
	LDAX	D
	MOV	C,A		;Get length of user name into C
	INX	D		;Point DE to start of user name
GN1	LDAX	D		;See if character matches
	CMP	M
	JNZ	NX		;Jump if these names don't match and try
	INX	H		;     the next name.
	INX	D
	DCR	C
	JZ	MITMAT	;Jump if at end of user name;see if CR in pwfile
	MOV	A,M		;Check for end of PWFILE
	CPI	'$'
	JNZ	GN1		;If $ found, then pwfile is bad, and no match
;				;	else continue checking
BPWF	CALL	ERRXIT
	DB	'+++BAD FORMAT IN PWFILE, notify operator$'
;
MITMAT	MOV	A,M		;If next char in PWFILE is CR, then match
	CPI	CR		; so move on
	JNZ	NX		;Else continue checking for name match
;Users name found, now verify the old pws
;  point HL to start of PW in PWFILE
BKUP	DCX	H	;Back up HL to start of line in PWFILE to get old PW
	MOV	A,M
	CPI	LF
	JNZ	BKUP
	INX	H	;HL now points to start of old PW in PWFILE
	LXI	D,PSWD-1
	LDAX	D
	MOV	C,A	;Get length of user's old PW into C
	INX	D	;Point DE to start of user's old PW
CNPW	LDAX	D
	CMP	M
	JNZ	PWNG	;Jump if names ok, but old PWs don't match
	INX	H
	INX	D
	DCR	C
	JNZ	CNPW	;Jump if at end of user's PW and see if match
;			;Else continue checking characters for match
;
	MOV	A,M	;See if at comma in PWFILE
	CPI	','	;If so, then PWs match
	JZ	PWSMAT	;So jump, else say PW's don't match
PWNG	CALL	ERRXIT
	DB	'+++INCORRECT OLD PASSWORD ENTERED, aborting unchanged.$'
;
;user is legit, so copy UA info into USRS(=UA buffer)
;HL points to first number of UA info in PWFILE
;so copy until ';' found. Terminate UA buffer with 00H
PWSMAT	LXI	D,USRS	;Point DE to start of UA buffer
PWSM2	MOV	A,M	;Get a number (or a comma) from the PWFILE UA info
	STAX	D
	INX	H
	INX	D
	CPI	';'	;If char is ';' then done
	JNZ	PWSM2	;Else continue copying
;
;All info copied into local buffers, so now delete old PWFILE entry
;HL points to ';' in entry in PWFILE, so back up to start of entry, save it,
;find and save end of entry, then back up rest of file over it to delete it
FNENT	DCX	H	;Find start of entry
	MOV	A,M
	CPI	CR
	JNZ	FNENT
	INX	H	;HL points to the LF after the CR
	INX	H	;HL now points to start of entry
	MOV	D,H	;Save it in DE
	MOV	E,L
FNEND	INX	H
	MOV	A,M
	CPI	LF
	JNZ	FNEND	;Fall through when HL points to end of entry
	INX	H	;HL now points to start of NEXT entry
;Move from HL to DE, inx, until a '$' is moved
MVNXT	MOV	A,M
	STAX	D
	INX	H
	INX	D
	CPI	'$'
	JNZ	MVNXT	;Fall through when entry is deleted
;
;Write the NEW entry onto the end of the PWFILE. Check for overwriting BDOS
;NPSWD points to new PW, NPSWD-1 has length
;DE points to '$' at end of PWFILE, where addition is to be put
;First, see if enough room for write (16,90;20<cr><lf>$)=131 characters max
	PUSH	D	;Save EOF pointer
	LXI	H,131
	DAD	D	;HL now points to where file would end after extension
	XCHG		;Get new end into DE
	LHLD	6	;Get BDOS start pointer  if DE>=HL then can't write
	MOV	A,D	; Since BDOS is on page boundary, only check D and H
	CMP	H
	JC	WROK	;If D<H, then ok to write
NOWR	CALL	ERRXIT	;If D>H, then no write, so error
	DB	'+++PWFILE TOO BIG TO FIT IN MEMORY, notify operator.$'
;Enough room in memory, so write the new entry onto the end of PWFILE
; Copy the new PW onto the end of the PWFILE
WROK	POP	D	;Restore EOF ('$') pointer
	DCX	D	;Position to write over it
	LXI	H,NPSWD-1
	MOV	C,M	;Get PW length into C
	INX	H	;HL points to start of new PW in buffer
MVNXP	MOV	A,M
	STAX	D	;Move the PW to the PWFILE
	INX	D	;Point for next move
	INX	H
	DCR	C
	JNZ	MVNXP	;Move entire PW, then fall through
; Copy the UA info onto the end of the PWFILE
	LXI	H,USRS	;Point HL to start of UA buffer
DNUA	MOV	A,M
	STAX	D	;Write UA info to end of PWFILE
	CPI	';'	;';' marks end of UA info
	JZ	UAMD
	INX	H
	INX	D
	JMP	DNUA	;Continue until all UA info is copied
; Copy the user name onto the end of the PWFILE
UAMD	INX	D
	LXI	H,UNAME-1
	MOV	C,M	;Get name length into C
	INX	H	;Point HL to start of name
ANXN	MOV	A,M	;Copy the name
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	ANXN	;Fall through when finished
	MVI	A,CR	;Add a CF,LF,$ to the end of the file
	STAX	D
	INX	D
	MVI	A,LF
	STAX	D
	INX	D
	MVI	A,'$'
	STAX	D	;DE now points to the new end of PWFILE
	XCHG
	SHLD	EOPWF	;Save new EOF pointer for file write routines
; Write the file back to disk
	CALL	WRPWF	;Write the file back to disk
	CALL	ERRXIT	;Say change complete
	DB	'PW change complete.$'
;
;  End of user section
;
;
;
;
;
;MASTER section goes here
;
MASTER	JMP	0
;
;
;
;
;
;
;Help routine goes here.  Prints usage info then exits
HELP	JMP	0	
;
;  Subroutine to load the password file
LODPWF	MVI	E,PWUSR
	MVI	C,SETUSR
	CALL	BDOS	;Set to whatever user number that PWFILE is in
	MVI	A,PWDRV	;Initialize FCB for selected drive
	STA	LOCFCB
	LXI	H,LOCFCB+12
	MVI	B,21
ZLOOP	MVI	M,0
	INX	H
	DCR	B
	JNZ	ZLOOP
	MVI	C,OPEN	;Open the file
	LXI	D,LOCFCB
	CALL	BDOS
	INR	A
	JZ	ABORT	;If A has 0 then no file, so abort
;
;  Now load the file
	LHLD	6	;Check for attempt to load past top of TPA
	LXI	D,-880H	;Calculate BDOS - 800H (=CCP) - 80H
	DAD	D
	PUSH	H	;Save top of memory for later checks
;
	LXI	D,PWBUF-80H	;Point to file load area-80H
	LXI	B,0	;Initialize record counter
	PUSH	B	; and save it
	PUSH	D	;Save load address, too
GLOOP	POP	D	;Get last load address
	LXI	H,80H	;Point HL to next address to read to
	DAD	D
	POP	B	;Increment the record counter
;
;  Check for attempt to load past top-of-memory
	POP	D	;Get -(TOP-OF-MEMORY)
	PUSH	D	;Save again for next time
;
	MOV	A,E	;Subtract: (TOP) - (ADRS)
	SUB	L
	MOV	A,D	;Look at carry to see if out of memory
	SBB	H
;
	JNC	SIZEOK	;Jump if enough room
	CALL	ERRXIT	; Else print message and abort
	DB	'+++PWFILE TOO BIG TO LOAD INTO MEMORY, ABORTING.','$'
;
SIZEOK	INX	B	;Continue loading...
	PUSH	B
	PUSH	H	;Save load address
	XCHG
	MVI	C,STDMA ;Set DMA address for next read
	CALL	BDOS
	LXI	D,LOCFCB ;Then read the next sector
	MVI	C,RDSEQ
	CALL	BDOS
	ORA	A
	JZ	GLOOP	;If A=0 then more to read
	POP	D	;Restore load address
	POP	B	;Restore record counter
	POP	H
	MOV	A,B
	ORA	C
	JZ	ABORT	;If 0 then nothing read, so abort
	XCHG		;Save end of file
	SHLD	EOPWF
	LXI	D,80H	;Else, reset DMA address
	MVI	C,STDMA
	CALL	BDOS
	RET		; and return
;
ABORT	CALL	ERRXIT
	DB	'+++CANNOT FIND PW FILE, notify operator$'
;
;
;  Subroutine to write PWFILE to disk
;    For safety, the new PWFILE is written to disk before the old
;    PWFILE is erased.  Otherwise, a 'DISK FULL' error from writing
;    the new file to disk could leave the system without a PWFILE.
;    So, the procedure is:
;	Set user area for PWFILE access
;	Erase old PWFILE.BAK file
;	Rename the old PWFILE to PWFILE.BAK
;	Write the new PWFILE to disk
;	   If create or write error, then notify user, erase PWFILE, rename
;	   PWFILE.BAK to PWFILE, then abort.
;	If NOBAK option is selected, then erase PWFILE.BAK
;
;Set user area
WRPWF	MVI	C,SETUSR	;Change current user number
	MVI	E,PWUSR		; to whatever user area PWFILE
	CALL	BDOS		; is kept in
;Erase PWFILE.BAK
	CALL	INITFCB		;Initialize local FCB
	CALL	WRNM1		;Fill in name to be erased
ERA1	DB	'PWFILE  BAK'	;Must be 11 characters
WRNM1	POP	H
	LXI	D,LOCFCB+1
	MVI	C,11
ERA2	MOV	A,M
	STAX	D
	DCR	C
	INX	H
	INX	D
	JNZ	ERA2
	LXI	D,LOCFCB
	MVI	C,DELETE	;Erase old file, if it exists
	CALL	BDOS
;Rename PWFILE to PWFILE.BAK
	CALL	INITFCB		;Initialize local FCB
	CALL	WRNM2		;Fill in names to be used
ERA3	DB	'PWFILE     '	;  Old name here
	DB	0,0,0,0,0
	DB	'PWFILE  BAK'	;  New name here
WRNM2	POP	H
	LXI	D,LOCFCB+1
	MVI	C,27
ERA4	MOV	A,M
	STAX	D
	DCR	C
	INX	H
	INX	D
	JNZ	ERA4
	LXI	D,LOCFCB
	MVI	C,RENAME	;Rename file
	CALL	BDOS
;Create new PWFILE
	CALL	INITFCB
	CALL	WRNM3
MAK1	DB	'PWFILE     '	;New file name here
WRNM3	POP	H
	LXI	D,LOCFCB+1
	MVI	C,11
MAK2	MOV	A,M
	STAX	D
	DCR	C
	INX	H
	INX	D
	JNZ	MAK2
	LXI	D,LOCFCB
	MVI	C,MKFIL		;Create file
	CALL	BDOS
	INR	A
	JNZ	MKOK		;Jump if file created, else say error
	CALL	DFU
	DB	'+++DIRECTORY FULL',CR,LF,'$'
DFU	POP	D
	CALL	PTNCR
	JMP	ERAREN		;and ERA PWFILE, REN PWFILE=PWFILE.BAK
;Write the file to disk
MKOK	LXI	D,PWBUF		;Point DE to start of file
	LHLD	EOPWF		;Point HL to last character of file
	INX	H		;Put EOF mark at EOF
	MVI	M,1AH
	INX	H		;Point HL to next byte after EOF marker
	PUSH	H		;Save EOF+2 for write complete test
	PUSH	D		;Save DMA address pointer
WRIT	POP	D		;Set DMA address for write
	PUSH	D		;Re-save DMA address
	MVI	C,STDMA
	CALL	BDOS
	LXI	D,LOCFCB	;Write the buffer to disk
	MVI	C,WRSEQ
	CALL	BDOS
	ORA	A
	JZ	WOK		;Jump if no write error
	CALL	DFM		;Else delete new, rename old.
	DB	'+++DISK FULL',CR,LF,'$'
DFM	POP	D
	CALL	PTNCR
	JMP	ERAREN		;  and notify user, etc.
WOK	POP	H		;Get old DMA address into HL
	LXI	B,128
	DAD	B		;Calculate new DMA address for next write
	XCHG			;Get new DMA address into DE
	POP	H		;Get EOF pointer into HL
	PUSH	H		;Save it for next write
	PUSH	D		;Save new DMA address for next write
	MOV	A,D
	CMP	H		;D<H? if so, then
	JC	WRIT		;  continue writing file
	JNZ	WDON		;If D>H, then done, so unjunk, close, ret
	MOV	A,E
	CMP	L		;E>=L? if so, then
	JNC	WDON		;  done, so unjunk stack, close, return
	JMP	WRIT		;Else continue writing file
;Write done, so repair stack, close file, then return
WDON	POP	D		;Unjunk stack
	POP	H
	LXI	D,LOCFCB	;Close the file
	MVI	C,CLOSE
	CALL	BDOS
	INR	A		;0FFH returned means close failed
;
	IF	NOT NOBAK	;Then don't erase PWFILE.BAK
	RNZ			;Return ok if close successful
	ENDIF
;
	IF	NOBAK		;Then erase PWFILE.BAK
	JNZ	KILBAK		;Jump if close successful
	ENDIF
;
;Error, so tell user, ERA PWFILE, REN PWFILE=PWFILE.BAK, then abort
ERAREN	CALL	INITFCB
	CALL	ERNM3
EE2	DB	'PWFILE     '	;New file name here
ERNM3	POP	H
	LXI	D,LOCFCB+1
	MVI	C,11
EE3	MOV	A,M
	STAX	D
	DCR	C
	INX	H
	INX	D
	JNZ	EE3
	LXI	D,LOCFCB
	MVI	C,DELETE		;Erase file
	CALL	BDOS
;Rename PWFILE.BAK to PWFILE
	CALL	INITFCB		;Initialize local FCB
	CALL	EENM2		;Fill in names to be used
EEA3	DB	'PWFILE  BAK'	;  Old name here
	DB	0,0,0,0,0
	DB	'PWFILE     '	;  New name here
EENM2	POP	H
	LXI	D,LOCFCB+1
	MVI	C,27
EEA4	MOV	A,M
	STAX	D
	DCR	C
	INX	H
	INX	D
	JNZ	EEA4
	LXI	D,LOCFCB
	MVI	C,RENAME	;Rename file
	CALL	BDOS
;
	CALL	ERRXIT		;Tell operator
	DB	'CAN''T MAKE NEW FILE, notify operator.  Aborting unchanged.$'
;
; Subroutine to erase PWFILE.BAK and return
KILBAK	CALL	INITFCB
	CALL	KBNM3
KB2	DB	'PWFILE  BAK'	;Back-up file goes here
KBNM3	POP	H
	LXI	D,LOCFCB+1
	MVI	C,11
KB3	MOV	A,M
	STAX	D
	DCR	C
	INX	H
	INX	D
	JNZ	KB3
	LXI	D,LOCFCB
	MVI	C,DELETE		;Erase file
	JMP	BDOS
;	
;  Subroutine to initialize the local FCB
INITFCB	MVI	C,36H		;Initialize local FCB
	LXI	H,LOCFCB
NXFCB:	MVI	M,0
	DCR	C
	INX	H
	JNZ	NXFCB
	XRA	A
	STA	LOCFCB+32		;Initialize record number
	MVI	A,PWDRV		;Get drive # where PWFILE is stored
	STA	LOCFCB		;Set up to write to that drive
	RET
;
;
;Miscellaneous subroutines
ERRXIT	POP	D
ERRXND	CALL	PTNCR	;Print the message pointed to by DE
	JMP	WBOOT
;
CRLF	CALL	DOCRLF
	DB	CR,LF,'$'
DOCRLF	POP	D
	JMP	PTNCR	;Print a CRLF, then return
;
;  Subroutine to print a message followed by a buffer
;  Prints '<message>=<buffer>'
PITEM	PUSH	H		;Save buffer pointer
	CALL	PTNCR		;Print the msg pointed to by DE
	POP	H		;Restore buffer pointer
	MVI	B,0
	MOV	C,M		;Get PW buffer length into BC
	INX	H		;Point to start of message in buffer
	MOV	D,H
	MOV	E,L
	DAD	B		;Compute end of message in buffer
	INX	H
	MVI	M,'$'		;Mark it with a '$'
	CALL	PTMSG		;Print the message in the buffer
	RET
;
;  Subroutine to ask 'OK (Y/N)'  Aborts if no, else returns
YESNO	CALL	ISOK
	DB	'OK (Y/N)? $'
ISOK	POP	D
	CALL	PTNCR		;Ask if OK
	MVI	C,CONIN		;Get the answer
	CALL	BDOS
	ANI	5FH		;Make response upper case
	CPI	'N'
	JNZ	SEEIFY		;Abort if answer is N
	CALL	ERRXIT
	DB	CR,LF,'+++ABORTED.  No changes made.$'
SEEIFY	PUSH	PSW
	CALL	CRLF		;Else Move to next line
	POP	PSW
	CPI	'Y'		;If answer is not Y or N, then ask again
	JNZ	YESNO
	RET			;Else assume Y, and return
;
;  Subroutine to print message and CRLF
PTMSG	CALL	PTNCR
	JMP	CRLF
;
;  Subroutine to print message without CRLF
PTNCR	MVI	C,PRNSTR
	JMP	BDOS
;
;  Subroutine to ask question pointed to by DE and point BC to answer given
DOMSG	PUSH	B		;Save answer buffer pointer
	CALL	PTNCR		;Print the message pointed to by DE
	POP	D		;Put the answer into the buffer pointed
	PUSH	D
	MVI	C,RDBUF		;  to by DE
	CALL	BDOS
	POP	D		;Restore buffer pointer
	IF	TRAPLC		;Convert to UPPER case
	XCHG			;Get message length
	INX	H
	MOV	C,M		;into C
NMLC	INX	H		;point HL to start of buffer message
	MOV	A,M		;Get a character from message into A
	CPI	'a'
	JC	UPCAS		;Jump if definitely UPPER case
	CPI	'{'
	JNC	UPCAS		;Jump if not an alpha
	ANI	5FH		;Else, make UPPER case
	MOV	M,A		;Put character back into buffer
UPCAS	DCR	C
	JNZ	NMLC		;Continue until entire message checked
	ENDIF	;TRAPLC
	JMP	CRLF		;Move to next line, then return
;
;  Miscellaneous messages:
BADMSG	DB	'+++INCORRECT','$'
;
;Current user's information is stored here
;
;  USER NAME is stored here
CNAME	DB	20	;Max number of chars allowed into buffer
	DB	0	;Current number of chars in buffer (filled in by FDOS)
UNAME	DB	'                    '	;20 characters for name
;
;  OLD PASSWORD is stored here
CPSWD	DB	16	;Max number of chars allowed for old password
	DB	0	;Current number of characters in buffer
PSWD	DB	'                '	;16 characters for password
	DB	'$'	;String terminator
;
;  NEW PASSWORD is stored here
CNPSWD	DB	16	;Max number of chars allowed for new password
	DB	0	;Current number of characters in buffer
NPSWD	DB	'                '	;16 characters for password
	DB	'$'	;String Terminator
;
;  USER ACCESS NUMBERS are stored here
USRS	DS	90	;Space for user access numbers. Ends with 00H
;
;Local File Control Block used to read and write PWFILE
LOCFCB	DB	0	;Drive is filled in here
	DB	'PWFILE     '	;Name of password file
	DS	40H	;Some more room+ for PWFILE
;
;  Pointer to end of PWFILE is stored here
EOPWF	DW	0000H	;Filled in by program
;
;  PWFILE is read in starting here.  It can take up the entire TPA
;	if desired.  The CCP is not overlayed.
PWBUF	EQU	$	;Rest of TPA is available for PWFILE
;
	END
