#include "libc.h"

#define MAXLINE 256 /* max number of chars in a line */
#define NMAX 100 /* max lines to tail */
#define DFLT  10 /* default to last 10 lines */

main(argc,argv) /* tail -n : print out last n lines, n defaults to DFLT */
int argc;
char **argv;
{
	register int n; /* buffer pointer */
	int ring; /* ring buffer - set if Num input lines > ntail */
	int ntail; /* number of lines to tail */
	int i;
	char line[MAXLINE]; /* input string buffer */
	char *lineptr[NMAX]; /* line pointer buffer */
	FILE *fin;	/* stream pointer to an input file */
	char *alloc(); /* define the memory allocator */
	char *fgets(); /* define the string get function */
	FILE *fopen(); /* define the file open function */
	
	ntail = DFLT;
	if (argc == 1 || argc > 3 || (argc == 2 && *argv[1] == '-') || (argc == 3 && *argv[1] != '-')) {
		fprintf(stderr, "usage: tail [-n] infile\n -n\ttail n last lines (0<n<=%d, default = %d)", NMAX, DFLT);
		exit(1);
	}

	if (argc == 3) {
		ntail = atoi(++argv[1]);
		if ((ntail <= 0) || (ntail > NMAX)) {
			fprintf(stderr, "must have 0<n<=%d\n", NMAX);
			exit(1);
		}
	}
	

	if ((n = index(argv[argc - 1], '.')) &&	(!strcmp(n, ".COM") || !strcmp(n, ".OBJ"))) {
		fputs("you can only tail a text file\n", stderr);
		exit(1);
	}
	
	if ((fin = fopen(argv[argc - 1], "r")) == NULL) {
		fprintf(stderr, "error opening %s to read\n", argv[argc - 1]);
		exit(1);
	}
	
	n = 0; ring = FALSE;
	while ((fgets(line, MAXLINE, fin)) != NULL) {
		if (ring)
			free(lineptr[n]);
		if ((lineptr[n] = alloc(strlen(line) + 3)) == NULL) {
			fputs("\n\nnot enough memory\007\n\n", stderr);
			exit(1);
		}
		strcpy(lineptr[n++],line);
		if (!(n %= ntail))
			ring = TRUE;
	}

	if (ring)  /* print high end of ring first */
		for (i = n; i < ntail; i++)
			fputs(lineptr[i], stdout);
	for (i = 0; i < n; i++)
		fputs(lineptr[i], stdout);

	fclose(fin);
} /* main */
<n<=%d, default = %d)", NMAX, DFLT);
		exit(1);
	}

	if (argc == 3) {
		ntail = atoi(++argv[1]);
