;	APPLE CP/M--DC HAYES PATCH
;
;   THIS PATCH WAS PROVIDED BY MICROSOFT TO
;ALLOW THE USE OF THE ON-BOARD MICROMODEM
;FIRMWARE WHILE IN CP/M.
;
;   ONCE ASSEMBLED AND LOADED, USE CONFIGIO.BAS
;OPTIONS 3 & 4 TO PATCH AND SAVE YOUR CBIOS AREA.
;
;   TO TURN-ON THE MMII, TYPE:
;
;	A>STAT CON:=UC1:
;
;   TO TURN-OFF THE MMII, TYPE:
;
;	A>STAT CON:=CRT:
;
;   FROM BASIC:
;
;   FOR TURN-ON TYPE: POKE 3,PEEK(3) OR 3
;   TO TURN OFF TYPE: POKE 3,PEEK(3) AND &HFC
;
;
;   ONCE ON, YOU CAN USE ALL OF THE NORMAL CONTROL
;CODES EXPECTED BY THE MMII.  BE SURE, WHEN USING
;PEEKS AND POKES TO ADD IN THE 0F000H REQUIRED BY
;THE Z80 REMAPPING.
;
;   FOR DIALING, ETC. WHEN ON, A 'CTRL-T' WILL
;FORCE A PSEUDO PR#2 FOR OUTPUT TO THE CARD WHILE
;A 'CTRL-S' WILL FORCE A PSEUDO PR#0 AND RESUME
;NORMAL OUTPUT.
;
; -------------------------------------------------
;
	ORG	0100H

ORIGIN	EQU	0F280H		;SLOT 2 PATCH AREA

OFF$	SET	ORIGIN-CONIN	;'LOAD' PROGRAM
				;FAKE-OUT CONSTANT
CSWL	EQU	0F036H		;APPLE OUTPUT HOOK
KSWL	EQU	0F038H		;APPLE INPUT HOOK
A$ACC	EQU	0F045H		;6502 ACC. PASS AREA
A$VEC	EQU	0F3D0H		;ADDR. OF 6502 SUBROUTINE TO CALL
Z$CPU	EQU	0F3DEH		;ADDR. OF SOFTCARD HELD HERE
SLTTYP	EQU	0F3B9H		;SLOT TYPE TABLE
CTRLS	EQU	19
CTRLT	EQU	20

	DB	2		;MAKE 2 PATCHES
	DW	ORIGIN		;PUT CODE HERE
	DW	LENGTH		;LENGTH OF CODE

	DB	1		;TYPE 1 PATCH
	DB	3		;CONSOLE INP. VECT.#2
	DW	CONIN+OFF$

	DB	2		;TYPE 2 PATCH
	DB	5		;CONSOLE OUT. VECT.#2
	DW	OUTCH+OFF$+1
	DW	CONOUT+OFF$

CONIN	LXI	H,KSWL+1	;PT. TO INPUT VECTOR
	MVI	A,0C2H		;AND SEE IF IT IS POINTING
	CMP	M		;TO MMII IN SLOT 2
	JZ	ISTWO+OFF$	;'IN#2' IN EFFECT

	MOV	M,A		;DO A 'PR#2'
	DCR	L
	MVI	M,0

	LDA	SLTTYP+2
	ORA	A		;SLOT 3 = VIDEO CARD?
	JZ	ISTWO+OFF$	;'PR#3' IN EFFECT

	LXI	H,0C300H
	SHLD	CSWL		;FORCE A 'PR#3'

ISTWO	LXI	H,0FD0CH	;CALL APPLE MON.
	CALL	CALL65+OFF$	;RDKEY RTN.

;   IF CARD IN SLOT 3 NEEDS SOME RECONFIGURATION
;FOR CP/M OPERATION AFTER HAVING DONE A 'PR#3'
;I/O, PUT CODE HERE.

	LDA	A$ACC		;GET RET.'D CHAR.
	ANI	7FH		;STRIP PARITY BIT
	RET

CONOUT	LXI	H,FLAG+OFF$	;GET CHAR. BEING SENT
	MOV	A,C

	SUI	CTRLS		;IS IT A 'CTRL-S'?
	JZ	PR$0+OFF$	;YES,RESUME NORM. OUTPUT

	CPI	CTRLT-CTRLS	;'CTRL-T'?
	JNZ	JSTCHR+OFF$	;NO, IT IS NOT.

PR$2	STA	CSWL+1		;FORCE A 'PR#2' LATER

PR$0	MOV	M,A		;SET-UP FLAG BYTE
	RET

JSTCHR	MOV	A,M		;GET FLAG BYTE
	ORA	A		;SET FLAGS

OUTCH	JZ	0000H		;GO VIA 'NORMAL OUTPUT'

	MOV	A,C		;GET CHAR TO SEND

	CPI	10		;STRIP LF'S
	RZ

	ORI	80H		;SET HIGH BIT
	STA	A$ACC		;PUT CHAR. IN 6502 'A' REG.

	LHLD	CSWL		;LOOK AT OUTPUT HOOKS
	MOV	A,H
	CPI	0C2H		;POINTING AT MMII?
	JZ	CALL65+OFF$	;YES...

	LXI	H,0C200H	;FORCE A 'PR#2'
	SHLD	CSWL

CALL65	SHLD	A$VEC		;STUFF SUBROUTINE ADDR.
	LHLD	Z$CPU		;GET ADDR. OF SOFTCARD
	MOV	M,A
	RET

FLAG	DS	1

LENGTH	EQU	$-CONIN

	END
