;
;
;                    TIME AND DATE ROUTINES
;           for Mountain Hardware 100,000 Day Clock.
;                         AS OF 2/8/81
;
;      On execution, this program relocates itself to high RAM
;  (outside of CPM, if desired) so that it can be called by any
;  other program as a subroutine.  During installation, after
;  it relocates itself, it calls itself so that it can be used
;  as a stand-alone program to give the date and time.  This
;  program assumes that the clock is already operating and has
;  been set to the proper time and for the proper number of
;  elapsed days.
;
;
;12/11/80 added set-up for 100's milliseconds, and print the
;	  day of week.	By Ben D. Miller Jr.  WB8LGH
;
;02/08/81 Made miscellaneous harmless changes and re-arranged
;	  some stuff.  Also put warning label on "DAYALWD"
;	  routines, because they don't always work right and
;	  I'm too lazy to repair them.  Added "DEST" label and
;	  caution sign to allow easier set-up with external RAM.
;	  Increased local stack space to 30 levels.
;	  By Dave Hardy
;
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
BDOS	EQU	5	;BDOS CALL ADDRESS IN 0-BASED CP/M
FASTCLK	EQU	TRUE	;SET TO TRUE FOR 4Mhz CLOCK
CLK	EQU	20H	;BASE PORT ADDRESS OF CLOCK
CLKDIG	EQU	7	;NUMBER OF DIGITS FOR TIME
;
	ORG	100H	;START OF TPA
;
;  *** THIS WILL HAVE TO BE REPAIRED BEFORE BEING SET TO TRUE: ***
dayalwd	EQU	FALSE	;SET TO TRUE IF DAY OF WEEK IS TO BE DISPLAYED
daylth	EQU	0ch	;length of day string.
;
;------------------------------------------------
;
;CHANGE THE FOLLOWING EQUATE TO AN AREA IN YOUR
;HI MEMORY WHERE THIS PROGRAM MAY PATCH ITSELF IN.
;APPROX MEMORY REQUIREMENTS: UP TO 900 BYTES.
;
DEST	EQU	0E800H	;RUNNING LOCATION OF CODE
;
;
;MOVE THE TIME PROGRAM UP TO HI RAM
;AND JUMP TO IT.
;
MOVEUP	XI	B,PEND-START+1		;NUMBER OF BYTES TO MOVE
	LXI	H,DEST+PEND-START+1	;END OF MOVED CODE
	LXI	D,SOURCE+PEND-START	;END OF SOURCE CODE
MVLP	LDAX	D	;GET BYTE
	DCX	H	;BUMP POINTERS
	MOV	M,A	;NEW HOME
	DCX	D
	DCX	B	;BUMP BYTE COUNT
	MOV	A,B	;CHECK IF ZERO
	ORA	C
	JNZ	MVLP	;IF NOT, DO SOME MORE
	PCHL
;
SOURCE	EQU	$	;BOUNDARY MEMORY MARKER
;
OFFSET	EQU	DEST-SOURCE ;RELOC AMOUNT
;
;-----------------------------------------------;
;	THE FOLLOWING CODE GETS MOVED		;
;	 TO HI RAM LOCATED AT "DEST",		;
;	    WHERE IT IS EXECUTED.		;
;-----------------------------------------------;
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;XX   C A U T I O N :  IF MODIFYING ANYTHING	XX
;XX	IN THIS PROGRAM FROM HERE ON:		XX
;XX	A-L-L  LABELS MUST BE OF THE FORM:	XX
;XX	label	EQU	$+OFFSET		XX
;XX	IN ORDER THAT THE RELOCATION TO HI RAM	XX
;XX	WORK SUCCESSFULLY.  FORGETTING TO	XX
;XX	SPECIFY '$+OFFSET' WILL CAUSE THE PRO-	XX
;XX	GRAM TO JMP INTO WHATEVER IS CURRENTLY	XX
;XX	IN LOW MEMORY, WITH UNPREDICTABLE	XX
;XX	RESULTS.  BE CAREFUL....		XX
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;
START	EQU	$+OFFSET
	LXI	H,0
	DAD	SP
	SHLD	OLDSTK
	LXI	SP,CLKSTK
	CALL	ENTRY
retprg	EQU	$+OFFSET
	LHLD	OLDSTK
	SPHL
	RET
;
entry	EQU	$+OFFSET
	call	tread
	call	tcrlf
	call	ckampm
;
	if dayalwd
	lxi	d,daystr
	call	opstr
	call	opday
	call	tcrlf
	endif
;
	lxi	d,datstr
	call	opstr
	call	opdat
;	call	tcrlf
	lxi	d,timstr
	call	opstr
	jmp	optim
;
ckampm	EQU	$+OFFSET
	lda	hrs10
	ora	a
	jz	ckhrs
nochng	EQU	$+OFFSET
	lda	hrs10
	cpi	2
	jz	adj
	lda	hrs
	sui	2
	rm
	jnz	skp
	mvi	a,2
	sta	ampm
	sta	hrs
	ret
;
skp	EQU	$+OFFSET
	sta	hrs
	sta	ampm
	xra	a
	sta	hrs10
	ret
;
ckhrs	EQU	$+OFFSET
	sta	ampm
	lda	hrs
	ora	a
	rnz
	mvi	a,1
	sta	hrs10
	inr	a
	sta	hrs
	ret
;
adj	EQU	$+OFFSET
	sui	1
	sta	hrs10
	sta	ampm
	lda	hrs
	sui	2
	sta	hrs
	rp
	adi	10
	sta	hrs
	xra	a
	sta	hrs10
	ret
;
;
optim	EQU	$+OFFSET
	mvi	a,CLKDIG	; number of chars to output
	sta	cnt
	lxi	h,RAMBEG	; pointer to storage
lp1	EQU	$+OFFSET
	mov	a,m		; digit to <A>
	adi	30h		; add ascii bias
	mov	e,a
	mvi	c,2
	push	h
	call	bdos
	pop	h
	inx	h		; bump pointer to next digit
	lda	cnt
	dcr	a
	sta	cnt
	push	psw
	push	h
	cpi	7
	cz	opcln
	cpi	5
	cz	opcln
	cpi	3
	cz	opcln
	cpi	1
	cz	opprd
	pop	h
	pop	psw
	ora	a
	jnz	lp1
;
	lda	ampm
	ora	a
	jz	am
pm	EQU	$+OFFSET
	lxi	d,pmstr
	jmp	opstr
;
am	EQU	$+OFFSET
	lxi	d,amstr
	jmp	opstr
;
tcrlf	EQU	$+OFFSET
	lxi	d,ptcrlf
opstr	EQU	$+OFFSET
	mvi	c,9
	jmp	bdos
;
opcln	EQU	$+OFFSET
	lxi	d,colonc
	jmp	opstr
;
opprd	EQU	$+OFFSET
	lxi	d,period
	jmp	opstr
;
	if dayalwd
opday	EQU	$+OFFSET
	lda	days
	ani	07h
	mov	c,a
	lxi	h,daytbl
	lxi	d,daylth
CALDAY	EQU	$+OFFSET
	dcr	c
	JZ	OVRIT
	dad	d
	JMP	calday
;
OVRIT	EQU	$+OFFSET
	xchg
	call	opstr
	ret
	ENDIF
;
;
opdat	EQU	$+OFFSET
	lda	tdate
	mvi	h,0
	mov	l,a
	call	decout
	lda	month
	mov	c,a
	ral
	ral
	add	c
	add	c
	MVI	H,0
	MOV	L,A
	lxi	d,mntbl-6
	DAD	D
	XCHG
	call	opstr
	lhld	tyear
	mvi	h,0
	mov	a,l
	sui	6ch
	mov	l,a
	jmp	decout
;
decout	EQU	$+OFFSET
	push	b
	push	d
	push	h
	lxi	b,-10
	lxi	d,-1
dx	EQU	$+OFFSET
	dad	b
	inx	d
	jc	dx
	lxi	b,10
	dad	b
	xchg
	mov	a,h
	ora	l
	cnz	decout
	mov	a,e
	adi	'0'
	mov	e,a
	mvi	c,2
	call	bdos
	pop	h
	pop	d
	pop	b
	ret
;
mntbl	EQU	$+OFFSET
	db	'-Jan-$','-Feb-$','-Mar-$','-Apr-$'
	db	'-May-$','-Jun-$','-Jul-$','-Aug-$'
	db	'-Sep-$','-Oct-$','-Nov-$','-Dec-$'
;
	IF DAYALWD
daytbl	EQU	$+OFFSET
	db	'Sunday    $ ','Monday    $ ','Tuesday   $ '
	db	'Wednesday $ ','Thursday  $ ','Friday    $ '
	db	'Saturday  $ ','Sunday    $ '
	ENDIF
;
timstr	EQU	$+OFFSET
	db	'   $'
datstr	EQU	$+OFFSET
	db	'$'
daystr	EQU	$+OFFSET
	db	'$'
ptcrlf	EQU	$+OFFSET
	db	13,10,'$'
colonc	EQU	$+OFFSET
	db	':$'
period	EQU	$+OFFSET
	db	'.$'
amstr	EQU	$+OFFSET
	db	' AM',13,10,10,'$'
pmstr	EQU	$+OFFSET
	db	' PM',13,10,10,'$'
;
;
; tdate routines for mountain hardware
; 100,000 day clock/calendar board (s-100)
;
; main read routine here
tread	EQU	$+OFFSET
read1	EQU	$+OFFSET
	push	h		; save registers
	push	d
	push	b
; get the time into ram first
;
tim	EQU	$+OFFSET
	lxi	h,RAMBEG	; pointer to ram storage
	mvi	c,clkdig
	mvi	a,clk+9
	sta	ovrly+1		; restore overlay
;
	if fastclk
	sta	ovrlya+1
	endif
;
ovrly	EQU	$+OFFSET
	in	clk+9
;
	if fastclk
	call	tlay		;for time read delay.
	push	b
	mov	c,a
ovrlya	EQU	$+OFFSET
	in	clk+9
	mov	b,a
	ani	080h
	jz	ovrly2
	mov	a,b
	ani	7fh
	cmp	c
	jnz	ovrly2
	mov	a,c
	pop	b
	endif
;
	ani	0fh		; lower 4 bits only
	mov	m,a
	inx	h
	dcr	c
	jz	getdat
	lda	ovrly+1
	dcr	a
	sta	ovrly+1
;
	if fastclk
	sta	ovrlya+1
	endif
;
	jmp	ovrly
;
	if fastclk
ovrly2	EQU	$+OFFSET
	pop	b
	jmp	ovrly
;
tlay	EQU	$+OFFSET
	push	h
	lxi	h,010ch
	jmp	tlay1
tlay0	EQU	$+OFFSET
	push	h
	lxi	h,0102h
tlay1	EQU	$+OFFSET
	dcr	l
	jnz	tlay1
	dcr	h
	jnz	tlay1
	pop	h
	ret			;done here.
	endif
;
;
getdat	EQU	$+OFFSET
	lxi	h,1981		; set initial tyear
	shld	tyear		; store in tyear
;
; read digits from clock board into <hl>
; as a binary number from 0 - 32767.
;
getdata	EQU	$+OFFSET
;
	lxi	h,0
	mvi	a,clk+14	; base address + OFFSET to days
	mov	c,a		; keep in c for inp routine
	mvi	b,5		; five digits to get
;
read2	EQU	$+OFFSET
	call	indo		; read clock port
	if fastclk
	call	tlay0
	push	d
	mov	e,a
	call	indo
	mov	d,a
	ani	080h
	jz	readck
	mov	a,d
	ani	7fh
	cmp	e
	jnz	readck
	mov	a,e
	pop	d
	endif
;
	ani	0fh		; mask off high 4 bits
	mov	d,h		; set de=hl
	mov	e,l
	dad	h		; set hl=hl*10
	dad	h
	dad	d
	dad	h
	add	l		; plus digit from clock
	mov	l,a
	jnc	read3		; take care of carry
	inr	h
read3	EQU	$+OFFSET
	dcr	c		; prepare to get next digit
	dcr	b		; more digits to get ?
	jnz	read2		; yes.
	shld	days		; all done reading clock, save.
;
; compute number of tyears, add on to tyear then
; see how many days into this tyear.
;
	lxi	b,2		; lpflg=0, lpcnt=2
abba1	EQU	$+OFFSET
	lxi	d,365		; <de>=365
	mov	a,b		; check lpflg
	ora	a
	jz	abba2		; <de> ok if not leap tyear
	inx	d		; else make <de> = 366
abba2	EQU	$+OFFSET
	push	h		; save # of days left
	mov	a,h		; compare hl-de
	sub	d
	jnz	zit1
	mov	a,l
	sub	e
zit1	EQU	$+OFFSET
	push	psw		; save flags
	mov	a,l		; <HL>=<HL>-<DE>
	sub	e
	mov	l,a
	mov	a,h
	sbb	d
	mov	h,a
	pop	psw		; restore flags from compare
	jc	abba3		; carry says de>hl
	jz	abba3		; zero says de=hl
	mvi	b,0		; clear lpflag
	pop	psw		; clear stack from old <HL>
	push	h		; save this <HL>
	lhld	tyear		; <tyear>=<tyear>+1
	inx	h
	shld	tyear
	pop	h		; restore this <hl>
	inr	c		; <lpcnt>=<lppcnt>+1
	mov	a,c		; if (<lpcnt> and 3) = 0, then
	ani	3		;     <lpflg> =1
	jnz	abba1
	inr	b
	jmp	abba1
;
	if fastclk
readck	EQU	$+OFFSET
	pop	d
	jmp	read2
	endif
;
abba3	EQU	$+OFFSET
	pop	d		; get last <HL> value into <DE>
;
; <tyear> now has correct tyear.
; now calculate month, day-of-month.
;
	mvi	c,1		; <month>=1 initially
	lxi	h,mtbl		; <HL> points to table of days
abba4	EQU	$+OFFSET
	push	d		; save <DE>  (days)
	mov	a,m		; <DE>=<DE>-<M(<MONTH>)>-
	push	h		; (if <MONTH>=2, then
	mov	l,a		; lpflg, else 0)
	mov	a,c
	cpi	2
	mov	a,l
	jnz	abba5
	add	b
	mov	l,a
abba5	EQU	$+OFFSET
	mov	a,d		; do  DE-HL compare
	ora	a
	jnz	zit2
	mov	a,e
	sub	l
zit2	EQU	$+OFFSET
	push	psw		; save flags
	mov	a,e
	sub	l
	mov	e,a
	mov	a,d
	sbi	0
	mov	d,a
	pop	psw		; restore flags
	pop	h
	jc	abba7		; carry says <DE> too small
	jz	abba7		; zero says <DE> just right.
	inr	c		; <MONTH>=<MONTH>+1
	inx	h		; point to next table entry
	pop	psw		; clear stack of old <DAYS>
	jmp	abba4		; process more
;
abba7	EQU	$+OFFSET
	pop	h		; get last <DAYS>
	mov	a,l		; look only at low order byte
	sta	tdate		; which is day-of-month
	mov	a,c		; look at <MONTH>
	sta	month		; store in appropriate place
	lhld	days		; get days in clock
	xchg			; put in DE
	lxi	h,7		; divide by 7
	call	divide		; do divide
	mov	a,l		; get low remainder
	sta	day		; store day-of-week
;
; processing finished, restore user's registers and return
;
	pop	b		; restore registers
	pop	d
	pop	h
	ret			; return to calling program
;
getdatc	EQU	$+OFFSET
	pop	psw		;restore from stack, from
	jmp	getdata		;getdatb label.
;
indo	EQU	$+OFFSET		; get input from port C
	push	h		; save user's <HL>
	call	indo2		; get byte from port
	pop	h		; restore <HL>
	ret			; return to caller
;
indo2	EQU	$+OFFSET
	lxi	h,ret*256
	push	h		; push 'nop' 'ret' on stack
	mov	h,c
	mvi	l,IN
	push	h		; push IN<port> on stack
	lxi	h,0
	dad	sp		; <HL>=<SP>
	pop	psw		; <SP>=<SP>+2
	pop	psw		; <SP>=<SP>+2
	pchl			; jump to stack and run it.
;
; 16-BIT Divide. divide <DE> by <HL>.
; return <DE>=result, <HL>=remainder.
;
divide	EQU	$+OFFSET
	push	b
	shld	dvtmp1
	lxi	h,dvtmp2
	mvi	m,11h
	lxi	b,0
	push	b
divid2	EQU	$+OFFSET
	mov	a,e
	ral
	mov	e,a
	mov	a,d
	ral
	mov	d,a
	dcr	m
	pop	h
	jnz	divid3
	pop	b
	ret
;
divid3	EQU	$+OFFSET
	mvi	a,0
	aci	0
	dad	h
	mov	b,h
	add	l
	lhld	dvtmp1
	sub	l
	mov	c,a
	mov	a,b
	sbb	h
	mov	b,a
	push	b
	jnc	divid4
	dad	b
	xthl
divid4	EQU	$+OFFSET
	lxi	h,dvtmp2
	cmc
	jmp	divid2
;
; table of days in each month starting with JANUARY.
;
mtbl	EQU	$+OFFSET
	db	31,28,31
	db	30,31,30
	db	31,31,30
	db	31,30,31
;
;
;  C L O C K     G L O B A L   A R E A
;
RAMBEG	EQU	$+OFFSET
;
hrs10	EQU	$+OFFSET
	ds	1		; tens of hours
hrs	EQU	$+OFFSET
	ds	1		; hours
min10	EQU	$+OFFSET
	ds	1		; tens	of minutes
min	EQU	$+OFFSET
	ds	1		; tens of minutes
sec10	EQU	$+OFFSET
	ds	1		; tens of seconds
sec	EQU	$+OFFSET
	ds	1		; seconds
msec100	EQU	$+OFFSET
	ds	1		; milli seconds 100's
day	EQU	$+OFFSET
	ds	1		; day-of-week (0=sat, 1=sun..)
month	EQU	$+OFFSET
	ds	1		; month-of-tyear (1=jan, 2=feb..)
tdate	EQU	$+OFFSET
	ds	1		; day-of-month (1 to 31)
tyear	EQU	$+OFFSET
	ds	1		; tyear (1978...)
days	EQU	$+OFFSET
	ds	2		; temp storage for days since
;				;  12/31/77
dvtmp1	EQU	$+OFFSET
	ds	2		; temp for 'divide'
dvtmp2	EQU	$+OFFSET
	ds	1		; temp for 'divide'
ampm	EQU	$+OFFSET
	ds	1		; am/pm/ flag  0 = am
cnt	EQU	$+OFFSET
	ds	1
;
	ds	60h
CLKSTK	EQU	$+OFFSET	;INITIAL STACK POINTER
	ds	0
OLDSTK	EQU	$+OFFSET	;OLD STACK IS SAVED HERE
	ds	2h
;
PEND	EQU	$+OFFSET	;END LABEL.
	end
