/*	>>>>> start cc0 <<<<<<		*/

/*					*/
/*	Compiler begins execution here	*/
/*					*/
main()
	{
	glbptr=startglb;	/* clear global symbols */
	locptr=startloc;	/* clear local symbols */
	wqptr=wq;		/* clear while queue */
	macptr=		/* clear the macro pool */
	litptr=		/* clear literal pool */
  	Msp =		/* stack ptr (maximum) */
  	Zsp =		/* stack ptr (relative) */
	errcnt=		/* no errors */
	errstop=	/* keep going after an error		gtf 7/17/80 */
	eof=		/* not eof yet */
	input=		/* no input file */
	input2=		/* or include file */
	output=		/* no open units */
	saveout=	/* no diverted output */
	ncmp=		/* no open compound states */
	lastst=		/* no last statement yet */
	mainflg=	/* not first file to asm 		gtf 4/9/80 */
	fnstart=	/* current "function" started at line 0 gtf 7/2/80 */
	lineno=		/* no lines read from file		gtf 7/2/80 */
	infunc=		/* not in function now			gtf 7/2/80 */
	quote[1]=
	0;		/*  ...all set to zero.... */
	quote[0]='"';		/* fake a quote literal */
	currfn=NULL;	/* no function yet			gtf 7/2/80 */
	cmode=1;	/* enable preprocessing */
	/*				*/
	/*	compiler body		*/
	/*				*/
	ask();			/* get user options */
	openout();		/* get an output file */
	openin();		/* and initial input file */
	header();		/* intro code */
	parse(); 		/* process ALL input */
	dumpglbs();		/* and all static memory */
	trailer();		/* follow-up code */
	closeout();		/* close the output (if any) */
	errorsummary();		/* summarize errors (on console!) */
	return;			/* then exit to system */
	}

/*					*/
/*	Abort compilation		*/
/*		gtf 7/17/80		*/
abort()
{
	if(input2)
		endinclude();
	if(input)
		fclose(input);
	closeout();
	toconsole();
	pl("Compilation aborted.");  nl();
	exit();
/* end abort */}

/*					*/
/*	Process all input text		*/
/*					*/
/* At this level, only static declarations, */
/*	defines, includes, and function */
/*	definitions are legal...	*/
parse()
	{
	while (eof==0)		/* do until no more input */
		{
		if(amatch("char",4)){declglb(cchar);ns();}
		else if(amatch("int",3)){declglb(cint);ns();}
		else if(match("#asm"))doasm();
		else if(match("#include"))doinclude();
		else if(match("#define"))addmac();
		else newfunc();
		blanks();	/* force eof if pending */
		}
	}
/*					*/
/*	Dump the literal pool		*/
/*					*/
dumplits()
	{int j,k;
	if (litptr==0) return;	/* if nothing there, exit...*/
	cdseg();		/* Put back in data segment. */
	printlabel(litlab);	/* print literal label */
	k=0;			/* init an index... */
	while (k<litptr)	/* 	to loop with */
		{defbyte();	/* pseudo-op to define byte */
		j=10;		/* max bytes per line */
		while(j--)
			{outudec((litq[k++]&127));
			if ((j==0) | (k>=litptr))
				{nl();		/* need <cr> */
				break;
				}
			outbyte(',');	/* separate bytes */
			}
		}
	ccseg();		/* Put back in code segment. */
	}
/*					*/
/*	Dump all static variables	*/
/*					*/
dumpglbs()
	{
	int j;
	if(glbflag==0)return;	/* don't if user said no */
	cdseg();		/* Put back in data segment. */
	cptr=startglb;
	while(cptr<glbptr)
		{if(cptr[ident]!=function)
			/* do if anything but function */
			{outname(cptr);
				/* output name as label... */

				/* issue assembler defn type... */
			if(cptr[ident]==pointer) /* Pointer */
				defstorptr();
			else
				{if(cptr[type]==cchar)	/* Character */
					defstorchr();
				if(cptr[type]==cint)	/* Integer */
					defstorint();
				}

				/* issue amount needed. */
			j=((cptr[offset]&255)+
				((cptr[offset+1]&255)<<8));
			outdec(j);	/* need that many */
			nl();
			}
		cptr=cptr+symsiz;
		}
	ccseg();		/* Put back in code segment. */
	}
/*					*/
/*	Dump all local variables	*/
/*					*/
dumplocs()
	{
	int j;
	if(ctext==0)		/* Do not insert comments. */
		return;
	cptr=startloc;
	while(cptr!=locptr)
		{comment();
		tab();
		outname(cptr);
				/* output name as label... */
		tab();
				/* issue assembler defn ident... */
		if(cptr[ident]==variable)
			outstr("VAR");
		else if(cptr[ident]==array)
			outstr("ARRAY");
		else if(cptr[ident]==pointer)
			outstr("PTR");
		else if(cptr[ident]==function)
			outstr("FUNC");
		tab();
				/* issue assembler defn type... */
		if(cptr[type]==cchar) /* Char */
			outstr("CHAR");
		else if(cptr[type]==cint)
			outstr("INT");
		tab();
				/* issue offset. */
		j=((cptr[offset]&255)+
			((cptr[offset+1]&255)<<8));
		outdec(j);
		nl();
		cptr=cptr+symsiz;
		}
	}
/*					*/
/*	Report errors for user		*/
/*					*/
errorsummary()
	{
	/* see if anything left hanging... */
	if (ncmp) error("missing closing bracket");
		/* open compound statement ... */
	nl();
	outstr("There were ");
	outdec(errcnt);	/* total # errors */
	outstr(" errors in compilation.");
	nl();
	}
