/* program to identify which file reside on "bad" track&sector */
/* Copyright 1985 Louis Baker all rights reserved */

#include "libc.h"

#define ESC 27
#define CR 13
#define LF 10
#define FF 255 /* code returned by find bdos call if no file */
#define DFCB 92 /* 92 = 5CH address of default file control blk */
#define DMA 128 /* address of DMA */

struct dpb {
	char spt[2];/* low order byte first */
	char bsh;
	int blmexm,dsm,drm,al,cks; /*not used */
	char off[2];
 } /* disk parameter block structure */ ;

struct fcb{
	char drive;
	char fname[8];
	char type[3];
	char fex;
	char sys[2];
	char frec;
	char falg[16];
	char cr;
	char r0,r1,r2;
} /* file control block */;


main (argc,argv) /*  IDENTIFY FILE CORRESP. TO BAD SECTOR */
int argc;
{
	register int i;
	static int mode,alg,track,sector,secpt,offset,bls,length,j;
	static int bad,blksf,driven,bc,de; 
	int *hl;
	struct fcb *fcbp,*fcb2;
	struct dpb *dpbp;
	char name[13],byte;
		/* CPM version number */
	bc=12; de=0 /* unused */; j = bdos(bc,de) ;/* this works */
	printf(" CP/M version number %x\n",j); 
		/*  desired drive? */
	printf("enter drive (default=0,A=1,B=2,etc) ");
	scanf(" %d",&driven) /* scanf need pointers */;
		/*input desired mode of search */
	printf("enter 0 if track/sector given, 1 if group");
	scanf(" %d",&mode);
	/* BIOS CALL to select disk if not default */
	bc=driven-1;/* bc registers for disk selection */
	/* SELDSK 9th bios entry hl points to disk parameter
		header */
	 if(bc!=-1) hl = bioshl(9,bc,de); 
	printf(" alloc. group of disk parameter header %x\n",hl); 
	if(mode==1) { /* read in allocation group */
	printf(" enter hex alloc. gp.");
	scanf("%x",&alg);
	/* use hl= adr of disk parameter header to get dp block */
	 hl = hl +5; /* 5 words = 10 bytes */
	/* hl now points to dpb address */
	printf(" address containing dpb address %x\n",hl);
	dpbp= *hl; /* dpbp= contents of what hl points to */
	printf(" loc of dpb %x\n",dpbp);
	/*dpbp points to address in dpb field of dph */
	}
	else {
		printf(" enter track(decimal)");
		scanf(" %d",&track);
		printf(" enter sector (decimal)");
		scanf(" %d",&sector);
		/* determine allocation group  */
		/* another way to locate dp block-BDOS CALL */
 		bc = 31;  
		dpbp = bdoshl(bc,de) ;/*  get dpb address.  de unused */ 
		/* now find allocation group */
		secpt = (dpbp->spt[0]) +256 * (dpbp->spt[1]) ;
		printf(" sectors per track %d\n", secpt);
		offset= (dpbp->off[0])+256*(dpbp->off[1]);
		printf(" offset %d\n",offset);
		blksf = dpbp->bsh;
		/*	printf(" loc offset %x\n",&(dpbp->off)); */
		printf(" block shift factor %d\n",blksf);
		alg =
		 ( (track-offset)*secpt +sector-1 ) >>(blksf);
		} /* END of else clause */
	/* echo check */
	printf(" alloc.gp.= %x\n", alg); /* code working up to here */
		/* now search for that alloc. gp. */ ;
	fcbp =  DFCB           /* specify file control block */;
	fcbp->drive= driven /* drive name */;
		/* set file name,type,extent to wild card= ? */
	for (i=0;i<8;i++)
		fcbp->fname[i]= '?';
	fcbp->type[0]= '?';fcbp->type[1]='?';fcbp->type[2]='?';
	fcbp->fex= '?' /* we don't use strings, which require \0
		term. */ ;
	/* loop over files  max 64 dir. entries in CP/M*/
	length = dpbp->drm;
	printf(" directory length %d entries\n",length);
	for (bc=17,j=0; j<length;j++,bc=18) {
		mode = bdos(bc,fcbp);
		 /* DE=fcbp points to fcb. A=directory code
		  in variable mode =FF if done else 0 to 3 */
		if (mode==FF)
			goto fini;
		fcb2 = mode*32 + DMA  ;/* point to found fcb */
		/* loop over groups in this extent */
		for(i=0;i<16;i++){
			if(fcb2->falg[i]==alg)
				goto found;
			/* we could put here go to next file if falg=0 */
		if (fcb2->falg[i]=='\0') break;
		} /* end of the for loop over extent*/
	} /* end of for loop over directory entries */
fini:	printf(" no user file at that group\n");
	goto term;
found:/* print file name. get size and approx. position */
	j=fcb2->fex;
	printf(" bad record %d of extent %d\n",i+1,j);
		/* BDOS call for record count */
	bc=35; 
	fcb2->drive = fcbp->drive;/* move drive i.d. to 
	make fcb out of file  info in DMA area */
        hl = bdoshl(bc,fcb2); /* CP/M to get record count*/
	/* call to bdos or CPM equivalent, as answer in fcb */
	if ( (fcb2->r2) == 1 ) length = 65536; 
		else length= ((int)(fcb2->r0)) + 256*((int)(fcb2->r1)); 
	printf(" bad file: %d records\n",length);
/* position of bad sector NB- 1 record can be >1 sector in file */
	length=(100*(16*j+i))/length; 
	printf(" bad record approx %d percent into file:\n",length); 
	pfilen(fcb2);
term:	exit(0);/*return to system, job done */
}

pfilen(fcbp) struct fcb *fcbp;
{
struct fcb *fcb2;
static char pname[9],ptype[4];
register int i;
	fcb2=fcbp;
	pname[8]='\0';ptype[3]='\0';
	/* move i no longer needed for position of bad gp. */
	for (i=0;i<8;i++) pname[i]= fcb2->fname[i];
	for (i=0;i<3;i++) ptype[i]= fcb2->type[i];
	/* terminate string name-eliminate trailing blanks in name */
	for (i=7;i>-1;i--){
		if(pname[i]==' ')pname[i]='\0';
		else break; /* do NOT eliminate embedded blanks */
	}
/* output file ID */
	printf ("%s.%s\n",pname,ptype);
}