;W.ASM  by Mark Gardner - 9/12/83 - Jan/Feb 1984 PROFILES    JCS II 
;Invokes WS from any user by changing directory entry for both .OVR 
;files that WS.COM will access.  Once these are found and changed to
;current user, WS.COM is loaded from A0 into TPA and control given
;to it.  A filename entered on command line after W is passed direct
;to WS and handled correctly.  When session is finished, .OVR files
;will remain and show in directory of this user area.  Leave them
;and they will be moved to wherever needed on next use of WS. 
;NOTE:  Before first using program, delete all copies of the two .OVR
;files except those on A0 or it will crash them all into current area!
;Assemble with ASM and ignore value error in sector loop.

;*Begin WSGET

	ORG	100H

BDOS	EQU	5
;BIOS	EQU	0EA00H          ;FOR KP10 CP/M BIOS
BIOS    EQU     0E200H          ;FOR KP10 ZCPR3
SETTRK  EQU	BIOS+1EH
SETSEC	EQU	BIOS+21H
SETDMA	EQU	BIOS+24H
READ	EQU	BIOS+27H
WRITE	EQU	BIOS+2AH

;INITIALIZE VARIABLES
;  Marked flag to 0
	MVI	A,0
	STA	MARKED
;  Determine current user
	MVI	C,20H		;GET USER BDOS FUNCTION
	MVI	E,0FFH
	CALL	5
	STA	USER		;SAVE USER CODE FOR LATER USE
;  Establish buffer area
	LXI	B,BUFFER
	CALL	SETDMA		;BIOS SETDMA FUNCTION
	JMP	PROG		;JUMP OVER STORED VARIABLES

BUFFER	EQU	8000H		;SIMPLE AND SAFE LOCATION
USER:	DS	1		;CODE FOR CURRENT USER AREA
SECTOR: DS	1		;STORAGE FOR DIRECTORY SECTOR
TRACK:	DS	1		;   "     "      "     TRACK
MARKED: DS	1		;SET WHEN .OVR FILE IN SECTOR

FRSTRK	EQU	4		;FIRST DIRECTORY TRACK ON DISK
LASTRK	EQU	7		;LAST      "       "    "   "
FRSSEC  EQU 	0		;FIRST SECTOR ON EACH TRACK
LASSEC	EQU	67		;LAST     "    "   "    "
MSGSTR: DB	'WSMSGS  OVR'   ;NAME OF MESSAGE OVERLAYS
OVLSTR: DB      'WSOVLY1 OVR'	;  "  "  PROGRAM    "

;;COMPARE SUBROUTINE
;;Compares two strings of length 11 -- one string pointer in DE,
;;other in HL.  Must preserve C.  Returns Z if equal, NZ if not.

COMPAR:
	MVI	B,12		;COUNTER FOR 11 COMPARES
COMLUP:
	DCR	B		;DECREASE THE COUNTER
	RZ			;IF 0, STRINGS EQUAL
	LDAX 	D		;ELSE, COMPARE NEXT ENTRIES
	CMP	M		
	RNZ			;IF NOT EQUAL, RETURN WITH NZ
	INX	H		;ELSE CONTINUE TO NEXT ENTRIES
        INX     D
	JMP	COMLUP

PROG:
; For each sector in the directory space on the disk
;;TRACK LOOP
	MVI 	A,FRSTRK-1	;START WITH FIRST TRACK
	STA	TRACK
TRKLUP:
	LDA	TRACK
	INR	A		;INCREASE IT EACH TIME
	STA	TRACK
	CPI	LASTRK+1	;AND STOP AFTER THE LAST
	JZ	MOVLOD
;;SECTOR LOOP
	MVI	A,FRSSEC-1
	STA	SECTOR
SECLUP:
	LDA 	SECTOR
	INR	A
	STA	SECTOR
	CPI	LASSEC+1
	JZ	TRKLUP
; For each entry in the sector (0 - 3)
	LDA	TRACK		;CALL SET TRACK ROUTINE
	MOV 	C,A
	MVI	B,0
	CALL	SETTRK
	LDA	SECTOR		;CALL SET SECTOR ROUTINE 
	MOV	C,A
	MVI	B,0
	CALL	SETSEC
	CALL	READ		;READ SECTOR FROM DIRECTORY
;;ENTRY LOOP
 	MVI	A,7*32		;KLUDGE FOR -32
	MOV	C,A		;STORE ENTRY POINTER
ENTLUP:
	MOV	A,C		;START WITH FIRST ENTRY
	ADI	32		;INCREASE EACH TIME
	MOV	C,A		
	CPI	80H	        ;AND STOP AFTER LAST
	JZ	ENDENT
; If the entry is for WSMSGS.OVL or WSOVL1.OVL
	LXI 	D,BUFFER
	MOV	E,A		;SET UP POINTER TO BUFFER STRING
	LDAX	D		;PICK UP FIRST BYTE OF ENTRY
    	CPI	0E5H		;IF DELETED ENTRY, DON'T BOTHER
 	JZ	ENTLUP
	INR 	E		;POINT TO ENTRY NAME
	LXI	H,MSGSTR	;POINT TO COMPARE STRING
	CALL	COMPAR		;AND SEE IF EQUAL
	JNZ	TRYOVL		;IF NOT, PROCEED TO OVL1
	MVI	A,0FFH		;IF SO, SET MARKED FLAG
	STA	MARKED
	LXI	H,BUFFER	
	MOV	L,C		;AND SET DIRECTORY ENTRY TO
	LDA	USER		;CURRENT USER CODE
  	MOV	M,A
TRYOVL:
	MOV     A,C		;AS ABOVE BUT FOR WSOVLY1
	INR	A
	LXI	D,BUFFER
	MOV 	E,A
	LXI	H,OVLSTR
	CALL    COMPAR
        JNZ 	ENTLUP
; Set the marked flag
	MVI     A,0FFH
	STA	MARKED
; Mark the entry to the current user
	LXI	H,BUFFER
	MOV	L,C
	LDA	USER
	MOV	M,A
; End if
	JMP 	ENTLUP
; End for
ENDENT:
; If marked flag is set
	LDA	MARKED		;IF CURRENT BUFFERFUL OF
	ANA	A		;DIRECTORY ENTRIES HAD ANY
	JZ	SECLUP		;MATCHES, THEN WRITE NEW CODE
; Write changed buffer to disk
	CALL	WRITE		;BIOS WRITE FUNCTION
; Clear marked flag
	MVI	A,0 		;CLEAR MARKED FLAG IN
	STA	MARKED		;PREP FOR NEXT BUFFER
; End if
; End for	
	JMP	SECLUP
MOVLOD:
; Move WS loader into high memory

PATCBS	EQU	0C000H		;LOCATION FOR PATCH ASSEMBLY
TRANSI	EQU	100H		;TPA
OPEN	EQU	0FH		;BDOS OPEN FILE
BDREAD	EQU	20		;BDOS FILE READ
BDSDMA  EQU	26		;BDOS SET DMA

	MVI	E,0
	MVI	C,20H		;SET USER TO 0 TEMPORARILY
	CALL	BDOS

	LXI	H,MOVBAS	;MOVE THE LOADER AND PATCH
	LXI	D,MOVLOC	;TO THE UPPER MEMORY AREA
	LXI	B,MOVSIZ

MOVLUP:
	MOV	A,M		;GET A BYTE OF PATCH
	STAX	D		;AND MOVE TO PATCH AREA
	DCX	B		;SEE IF DONE
	MOV	A,B
	ORA	C
	JZ	LOAD + OFFSET	;IF DONE, GO TO WS LOADER
	INX	H
	INX	D
	JMP	MOVLUP		;ELSE, GET NEXT BYTE TO MOVE

;Load WS.COM	
;Transfer control
;End WSGET

;*WS LOADER
;       ORG	PATCBS-(BDOSRE-MOVBAS)
BDOSRE:
MOVBAS:
WSTFCB:				;FILE CONTROL BLOCK FOR MBASIC
	DB	0,'WS      COM'
	DB	0,0,0,0,0,0,0,0		
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0

LOAD:				;LOAD WS AND TRANSFER CONTROL
	LDA	USER		;SET UP TO RESTORE USER
	STA	RESUSR+1+OFFSET

	LXI	D,WSTFCB+OFFSET ;OPEN THE FILE
	MVI	C,OPEN
	CALL	BDOS
	LXI	D,TRANSI	;LOAD INTO USER TPA
LOADLP:				;LOAD LOOP
	PUSH	D		;SAVE FOR INCREMENTING
	MVI	C,BDSDMA
	CALL	BDOS
	LXI	D,WSTFCB+OFFSET 
	MVI	C,BDREAD	;BDOS READ
 	CALL	BDOS
	POP	D
	ANA 	A		;SEE IF END OF FILE
	JNZ	RESUSR+OFFSET	;IF SO, GO TO WS, ELSE
	LXI	H,128		;POINT TO NEXT SECTOR AREA
	DAD	D
	XCHG
	JMP	LOADLP+OFFSET	;AND GO LOAD NEXT FILE SECTOR
RESUSR:				;RESTORE THE USER
	MVI	E,0		;(REPLACED BEFORE EXECUTION)
	MVI	C,20H		;SET USER BDOS FUNCTION
	CALL    BDOS
        JMP 	TRANSI		;ALL SET, START WS
MOVLIM:

;;EQUATE STATEMENTS TO CALCULATE MOVE PARAMETERS FOR MOVLUP

MOVSIZ 	EQU	MOVLIM-MOVBAS
MOVLOC	EQU	PATCBS-(BDOSRE-MOVBAS)
OFFSET  EQU	PATCBS-BDOSRE
	END		

