*  PROGRAM:  INUSE
*  AUTHOR:  RICHARD CONN
*  VERSION:  1.0
*  DATE:  12 JAN 82
*  DERIVATION:  From BANNER Version 1.0 by Richard Conn ... which was from:
*  DERIVATION:  From Public Domain BANNER Program, Author Unknown
*  PREVIOUS VERSIONS:  None

VERS	EQU	10	;VERSION NUMBER
*********************************
*				*
*   I N U S E  P R I N T	*
*				*
*********************************
*
*  INUSE is a program which prints large (5x7) block letters
* on the CON: Device the word 'INUSE'.  When first started up, INUSE
* asks for a password, to which the user gives a desired password.
* INUSE is intended to be terminated by the user typing an Escape Character
* and then giving the original password.
*
*  INUSE is executed in one of two forms:
*	INUSE -- Normal operation
*	INUSE /? -- Prints HELP Info
*

*********************************
*  User-Customized Parameters	*
*********************************

ESC	EQU	1BH	; ESCAPE CHARACTER TO INPUT PASSWORD

*********************************
*  Constants			*
*********************************

BDOS		EQU 		0005H
FCB		EQU		005CH
BUFF		EQU		0080H
CTRLC		EQU		03H
CR		EQU		0DH
LF		EQU		0AH
TAB		EQU		09H
INCHAR		EQU		1	;INPUT FROM CON:
PRLINE		EQU		9	;Print Line Routine
READLN		EQU		10	;Input Line Editor
OUTC		EQU		2	;OUTPUT TO CON:

	ORG	100H

	LXI	H,0	; GET STACK PTR
	DAD	SP
	SHLD	STACK	; SAVE IT
	LXI	SP,STACK	; SET NEW SP
	CALL	PMSG	; PRINT PROMPT
	DB	CR,LF,'INUSE Version ',VERS/10+'0','.',(VERS MOD 10)+'0',CR,LF
	DB	0
	LDA	FCB+1	; GET FIRST CHAR OF FCB
	CPI	'/'	; QUERY?
	JNZ	IN1
	CALL	PMSG
	DB	CR,LF,'	INUSE is employed to print a banner on a user''s'
	DB	CR,LF,'terminal that said terminal is in use and by whom.  A'
	DB	CR,LF,'comment is asked for when INUSE is executed by the'
	DB	CR,LF,'command line -- '
	DB	CR,LF,'		INUSE'
	DB	CR,LF,'and this comment is printed with the INUSE Banner.'
	DB	CR,LF,'After being asked for the comment, he is then asked for'
	DB	CR,LF,'a password which should be typed to restore control.'
	DB	CR,LF,'Both the comment and the password are typed in the'
	DB	CR,LF,'usual fashion followed by a <CR>.'
	DB	CR,LF,'	After INUSE prints the Banner and the Comment, it'
	DB	CR,LF,'waits for a user to hit the <ESCAPE> key, at which'
	DB	CR,LF,'time it asks for the password.  If the correct password'
	DB	CR,LF,'is entered, control is restored to CP/M; otherwise,'
	DB	CR,LF,'the Banner and Comment are reprinted and INUSE waits'
	DB	CR,LF,'for the <ESCAPE> key again.'
	DB	CR,LF,'	The INUSE command takes two forms --'
	DB	CR,LF,'		INUSE -- Runs INUSE'
	DB	CR,LF,'		INUSE / -- Prints this HELP Message'
	DB	CR,LF,0
	JMP	EXIT
IN1:
	CALL	PMSG
	DB	'   Comment? ',0
	LXI	D,COMMENT	; GET RESPONSE
	MVI	C,READLN	; INPUT LINE VIA BDOS
	CALL	BDOS
	CALL	PMSG
	DB	CR,LF,'   Password? ',0
	LXI	D,INLINE	; GET RESPONSE
	MVI	C,READLN	; INPUT LINE VIA BDOS
	CALL	BDOS
INUSE:
	CALL	SPACER		; SPACE DOWN ON SCREEN
	CALL	BANNER		; PRINT INUSE MESSAGE
	CALL	PRCMT		; PRINT COMMENT ON NEXT LINE
	CALL	SPACER		; SPACE DOWN ON SCREEN
INUSE1:
	MVI	C,INCHAR	; BDOS CHAR INPUT
	CALL	BDOS
	ANI	7FH		; MASK MSB
	CPI	61H		; SMALL A?
	JC	INUSE2
	CPI	61H+26+1	; > SMALL Z?
	JNC	INUSE2
	SUI	20H		; CAPITALIZE
INUSE2:
	CPI	ESC		; ESCAPE CHAR?
	JNZ	INUSE1
	CALL	PMSG
	DB	CR,LF,'   Password? ',0
	LXI	D,RDLINE	; GET RESPONSE
	MVI	C,READLN
	CALL	BDOS
	LXI	H,INLINE+1	; COMPARE PASSWORDS
	LXI	D,RDLINE+1
	LDAX	D		; GET CHAR COUNT
	CMP	M		; COMPARE CHAR COUNT
	JNZ	INUSE		; REPRINT BANNER IF NO MATCH
	MOV	B,A		; CHAR COUNT IN B
	ORA	A		; NO CHARS?
	JZ	EXIT		; EXIT IF SO
INUSE3:
	INX	H		; PT TO NEXT CHAR
	INX	D
	LDAX	D		; GET NEXT CHAR
	CMP	M		; COMPARE
	JNZ	INUSE		; NEW BANNER IF NO MATCH
	DCR	B		; COUNT DOWN
	JNZ	INUSE3
;
;  Exit INUSE
;
EXIT:
	LHLD	STACK	;GET OLD STACK PTR
	SPHL		;LOAD SP
	RET
*
*  PRINT BANNER CONTAINED IN BLINE BUFFER
*
BANNER:
	MVI	D,80H	;PT TO MSB+1
CBAN:
	LXI	H,BLINE	;SET PTR TO FIRST CHAR
	SHLD	NEXTCH
	CALL	CRLF	;NEW LINE
	MOV	A,D	;GET BIT PTR
	RRC		;ROTATE
	ANI	7FH	;MASK OUT MSB
	MOV	D,A	;SET BIT PTR
	JZ	CB2	;NEW LINE AND THEN EXIT
CB1:
	CALL	CONIN	;GET NEXT CHAR
	MOV	C,A	;CHAR IN C
	ORA	A	;DONE?
	JZ	CBAN	;DO NEXT LINE IF SO
	CALL	CONV	;GET ADDRESS OF DATA IN HL
	JC	CB1	;SKIP IF ERROR
	CALL	PRINT	;PRINT 5 CHARS FOLLOWED BY TWO SPACES
	JMP	CB1	;CONTINUE
CB2:
	CALL	CRLF	;1 CRLF
	RET

*
*  COMPUTE POINTER TO TABLE ENTRY OF CHAR IN REG A
*    ON INPUT, A=CHAR; ON OUTPUT, HL=PTR TO TABLE ENTRY (1ST BYTE)
*
CONV:
	PUSH	B		;SAVE BC
	PUSH	D		;SAVE DE
	SUI	' '		;CONVERT <SP> TO 0
	RC			;INVALID CHAR
	CPI	7BH-' '		;IN RANGE?
	JNC	CNVER		;INVALID CHAR
	MOV	E,A		;VALUE IN E
	MVI	D,0		;VALUE IN DE
	MOV	H,D		;VALUE IN HL
	MOV	L,E
	DAD	H		;VALUE * 2
	DAD	H		;VALUE * 4
	DAD	D		;HL = VALUE * 5
	LXI	D,CHARS		;POINT TO BEGINNING OF TABLE
	DAD	D		;HL PTS TO ELEMENT IN TABLE
	POP	D		;RESTORE DE
	POP	B		;RESTORE BC
	ORA	A		;CLEAR CARRY
	RET
CNVER:
	STC			;SET CARRY FOR INVALID CHAR
	POP	D		;RESTORE DE
	POP	B		;RESTORE BC
	RET
*
*  PRINT CHAR IN C ACCORDING TO THE ENTRY PTED TO BY HL
*    BIT MASK IS IN D
*
PRINT:
	PUSH	B		;SAVE BC (C=CHAR)
	MVI	B,5		;5 BYTES/CHAR
PRINT1:
	MOV	A,M		;GET BIT SET
	ANA	D		;MASK FOR BIT IN QUESTION
	JZ	PRINT3		;IF ZERO, PRINT <SP>
	CALL	CONOUT		;PRINT CHAR IN C
PRINT2:
	INX	H		;PT TO NEXT BYTE
	DCR	B		;COUNT DOWN
	JNZ	PRINT1
	MVI	C,' '		;PRINT THREE SPACES
	CALL	CONOUT
	CALL	CONOUT
	CALL	CONOUT
	POP	B		;RESTORE BC
	RET
PRINT3:
	MOV	E,C		;SAVE CHAR
	MVI	C,' '		;PRINT <SP>
	CALL	CONOUT
	MOV	C,E		;GET CHAR
	JMP	PRINT2
*
*  PRINT COMMENT ON SCREEN IF ANY
*
PRCMT:
	CALL	CRLF		; NEW LINE
	LXI	H,COMMENT+1	; PT TO CHAR COUNT
	MOV	A,M		; GET CHAR COUNT
	INX	H		; PT TO FIRST CHAR
	ORA	A		; ANY?
	RZ
	PUSH	H		; SAVE PTR TO FIRST CHAR
	ADD	L		; POINT TO AFTER LAST CHAR
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	MVI	M,'$'		; STORE ENDING '$'
	POP	D		; PT TO LINE
	MVI	C,PRLINE	; BDOS PRINT
	CALL	BDOS
	CALL	CRLF		; NEW LINE
	RET
*
*  SUPPORT ROUTINES
*
SPACER:
	MVI	B,8		; GO DOWN SCREEN
SPACE0:
	CALL	CRLF		; NEW LINE
	DCR	B		; COUNT DOWN
	JNZ	SPACE0
	RET
PMSG:
	XTHL		;GET PTR TO STRING
	MVI	B,0	;SET TAB COUNTER
PMSG1:
	MOV	A,M	;GET NEXT BYTE
	INX	H	;PT TO NEXT
	ORA	A	;DONE?
	JZ	PMSG2
	CPI	TAB	;TABULATE?
	JZ	PMSG$TAB
	MOV	C,A	;CHAR IN C
	CALL	CONOUT	;PRINT CHAR
	INR	B	;INCR CHAR COUNT
	JMP	PMSG1
PMSG$TAB:
	MVI	C,' '	;PRINT <SP>
	CALL	CONOUT	;PRINT
	INR	B	;INCR POSITION COUNT
	MOV	A,B	;GET IT
	ANI	7	;DONE?
	JNZ	PMSG$TAB
	JMP	PMSG1	;PROCESS NEXT CHAR
PMSG2:
	XTHL		;RESTORE HL, PTR
	RET
CRLF:
	MVI	C,CR
	CALL	CONOUT
	MVI	C,LF
	CALL	CONOUT
	MVI	C,0	; 2 <NULL>S
	CALL	CONOUT	; FALL THRU FOR 2ND
CONOUT:
	PUSH H ! PUSH B ! PUSH D
	MOV	E,C
	MVI	C,OUTC		;OUTPUT TO CON:
	CALL	BDOS
	POP D ! POP B ! POP H
	RET
CONIN:
	PUSH H ! PUSH D ! PUSH B
	LHLD	NEXTCH	;GET NEXT CHAR PTR
	MOV	A,M	;GET CHAR
	INX	H	;PT TO NEXT
	SHLD	NEXTCH
	ANI	7FH	;MASK MSB IF ANY
	POP B ! POP D ! POP H
	RET
*
*  CHARACTER TABLE
*    THE CHARACTERS REPRESENTED IN THIS TABLE ARE IN A 5X7 FORMAT
*    THE FIRST BYTE IN EACH ENTRY REPRESENTS THE FIRST CHAR TO PRINT, ETC
*    THE BITS 6 TO 0 REPRESENT LINES (SUCCESSIVE) TO PRINT FOR THE CHAR
*
CHARS:
	DB	00H,00H,00H,00H,00H	;<SP>
	DB	00H,00H,7DH,00H,00H	;EXCLAMATION MARK
	DB	00H,70H,00H,70H,00H	;"
	DB	14H,7FH,14H,7FH,14H	;#
	DB	12H,2AH,7FH,2AH,24H	;$
	DB	62H,64H,08H,13H,23H	;%
	DB	36H,49H,35H,02H,05H	;&
	DB	00H,00H,70H,00H,00H	;'
	DB	1CH,22H,41H,00H,00H	;(
	DB	00H,00H,41H,22H,1CH	;)
	DB	22H,14H,7FH,14H,22H	;*
	DB	08H,08H,3EH,08H,08H	;+
	DB	00H,01H,06H,00H,00H	;,
	DB	08H,08H,08H,08H,08H	;-
	DB	00H,03H,03H,00H,00H	;.
	DB	02H,04H,08H,10H,20H	;/
	DB	3EH,45H,49H,51H,3EH	;0
	DB	11H,31H,7FH,01H,01H	;1
	DB	21H,43H,45H,49H,31H	;2
	DB	22H,41H,49H,49H,36H	;3
	DB	0CH,14H,24H,7FH,04H	;4
	DB	7AH,49H,49H,49H,46H	;5
	DB	3EH,49H,49H,49H,26H	;6
	DB	43H,44H,48H,50H,60H	;7
	DB	36H,49H,49H,49H,36H	;8
	DB	30H,49H,49H,49H,3EH	;9
	DB	00H,00H,36H,00H,00H	;:
	DB	00H,01H,16H,00H,00H	;;
	DB	08H,14H,22H,41H,00H	;<
	DB	14H,14H,14H,14H,14H	;=
	DB	00H,41H,22H,14H,08H	;>
	DB	20H,40H,4DH,50H,20H	;?
	DB	7EH,41H,5DH,4DH,39H	;@
	DB	3FH,48H,48H,48H,3FH	;A
	DB	7FH,49H,49H,49H,36H	;B
	DB	7FH,41H,41H,41H,41H	;C
	DB	7FH,41H,41H,41H,3EH	;D
	DB	7FH,49H,49H,49H,41H	;E
	DB	7FH,48H,48H,48H,40H	;F
	DB	7FH,41H,41H,49H,4FH	;G
	DB	7FH,08H,08H,08H,7FH	;H
	DB	41H,7FH,41H,80H,80H	;I
	DB	03H,01H,01H,01H,7FH	;J
	DB	7FH,08H,14H,22H,41H	;K
	DB	7FH,01H,01H,01H,01H	;L
	DB	7FH,20H,10H,20H,7FH	;M
	DB	7FH,30H,08H,06H,7FH	;N
	DB	7FH,41H,41H,41H,7FH	;O
	DB	7FH,48H,48H,48H,78H	;P
	DB	7FH,41H,45H,43H,7FH	;Q
	DB	7FH,48H,4CH,4AH,79H	;R
	DB	32H,49H,49H,49H,26H	;S
	DB	40H,40H,7FH,40H,40H	;T
	DB	7FH,01H,01H,01H,7FH	;U
	DB	70H,0CH,03H,0CH,70H	;V
	DB	7FH,02H,04H,02H,7FH	;W
	DB	63H,14H,08H,14H,63H	;X
	DB	60H,10H,0FH,10H,60H	;Y
	DB	43H,45H,49H,51H,61H	;Z
	DB	7FH,41H,41H,41H,00H	;[
	DB	20H,10H,08H,04H,02H	;\
	DB	00H,41H,41H,41H,7FH	;]
	DB	04H,08H,10H,08H,04H	;^
	DB	01H,01H,01H,01H,01H	;_
	DB	00H,40H,20H,10H,00H	;@
	DB	3FH,48H,48H,48H,3FH	;A
	DB	7FH,49H,49H,49H,36H	;B
	DB	7FH,41H,41H,41H,41H	;C
	DB	7FH,41H,41H,41H,3EH	;D
	DB	7FH,49H,49H,49H,41H	;E
	DB	7FH,48H,48H,48H,40H	;F
	DB	7FH,41H,41H,49H,4FH	;G
	DB	7FH,08H,08H,08H,7FH	;H
	DB	41H,7FH,41H,80H,80H	;I
	DB	03H,01H,01H,01H,7FH	;J
	DB	7FH,08H,14H,22H,41H	;K
	DB	7FH,01H,01H,01H,01H	;L
	DB	7FH,20H,10H,20H,7FH	;M
	DB	7FH,30H,08H,06H,7FH	;N
	DB	7FH,41H,41H,41H,7FH	;O
	DB	7FH,48H,48H,48H,78H	;P
	DB	7FH,41H,45H,43H,7FH	;Q
	DB	7FH,48H,4CH,4AH,79H	;R
	DB	32H,49H,49H,49H,26H	;S
	DB	40H,40H,7FH,40H,40H	;T
	DB	7FH,01H,01H,01H,7FH	;U
	DB	70H,0CH,03H,0CH,70H	;V
	DB	7FH,02H,04H,02H,7FH	;W
	DB	63H,14H,08H,14H,63H	;X
	DB	60H,10H,0FH,10H,60H	;Y
	DB	43H,45H,49H,51H,61H	;Z

*
*  BUFFERS
*
	DS	40	;20-ELT STACK
STACK:
	DS	2	;TOP OF BANNER STACK; CP/M STACK
NEXTCH:
	DS	2
LLEN	EQU	80	;NUMBER OF CHARS IN LINE, MAX
INLINE:
	DB	LLEN	;CHAR COUNT FOR INLINE
	DS	LLEN+1
RDLINE:
	DB	LLEN	;CHAR COUNT FOR RDLINE
	DS	LLEN+1
COMMENT:
	DB	LLEN
	DS	LLEN+1
BLINE:
	DB	'* INUSE *',0	; MESSAGE

	END
