;
; Patch to load with CONFIGIO to define user console 1 as a 
; CCS 7710 serial card.
;
slot	equ	2		;card slot
sersta	equ	slot*16+0e080h	;status register
serdat	equ	sersta+1	;serial data register
inrdy	equ	01h		;set means input ready
outrdy	equ	02h		;set means output ready
;
origin	equ	0f300h		;origin for patches
offset	set	origin-prgbeg	;must be added to addresses
;
	org	0100h
	db	3		;will patch 3 vectors
	dw	origin		;eventual address
	dw	prgend-prgbeg	;size of patch
;
	db	1		;patch type 1
	db	1		;vector 1, console status
	dw	consta+offset	;address to patch
;
	db	1		;patch type 1
	db	2		;vector 2, console in
	dw	conin+offset	;address to patch
;
	db	1		;patch type 1
	db	4		;vector 4, console out
	dw	conout+offset	;address to patch
;
prgbeg	equ	$
;
consta	lda	sersta		;get line status
	ani	inrdy		;see if ready
	rz			;return 0 if not ready
	mvi	a,0ffh		;if ready
	ret			;return ff
;
conin	call	consta+offset	;check if character
	jz	conin+offset	;if not
	lda	serdat		;get char
	ani	07fh		;mask off hi bit
	ret			;return character
;
conout	lda	sersta		;get line status
	ani	outrdy		;see if ready
	jz	conout+offset	;wait till ready
	mov	a,c		;char to a
	sta	serdat		;send it
	ret			;back we go
;
prgend	equ	$		;define end of program
;
	end
