static char rcsid[] = "$Header: process.c,v 800.0 85/07/30 13:56:20 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

#
/****************************************************************************

	DEBUGGER - sub process creation and setup

****************************************************************************/
#include "defs.h"

#define	CALL2	0x4E90		/* jsr a0@	*/
#define CALL6	0x4EB9		/* jsr <adr>	*/
#define ADDQL	0x5080		/* addql #x,	*/
#define ADDL	0xD1FC		/* addl #X,	*/
#define ISYM	2

MSG	BADWAIT;
MSG	NOPCS;
MSG	ENDPCS;
STRING	signals[];
STRING	corfil;
int	pid = 0;
int	fcor;
long	mainsval;
int	signum;
int	(*sigint)();
int	(*sigqit)();

/*
 * Changed reference of RPS to PS
 * sas 840615
 */
int	regloc[] = { R0,R1,R2,R3,R4,R5,R6,R7,AR0,AR1,
		     AR2,AR3,AR4,AR5,AR6,SP,PC,PS };

#if 0
runwait(addr, statusp)
int	addr;
int	*statusp;
{
	ioctl(0, TIOCSETP, &subtty);
	ioctl(0, TIOCSETC, &subtch);
	ptrace(CONTIN, pid, addr, signum);
	return(subwait(statusp));
}

subwait(statusp)
int	*statusp;
{
	int	code;

	signal(SIGINT, SIG_IGN);
	while (((code = wait(statusp)) != pid) && (code != -1));
	signal(SIGINT, sigint);
	ioctl(0, TIOCGETP, &subtty);
	ioctl(0, TIOCGETC, &subtch);
	ioctl(0, TIOCSETP, &adbtty);
	ioctl(0, TIOCSETC, &adbtch);
	if (code == -1)
	{
		pid = 0;
		error(BADWAIT);
	}
	else code = *statusp & 0177;
	if (code != 0177)
	{
		pid = 0;
		if (signum = code) prints(signals[signum]);
		if (*statusp & 0200)
		{
			prints(" - core dumped\n");
			close(fcor); corfil = "core"; setcor();
		}
		error(ENDPCS);
	}
	else
	{
		signum = (*statusp >> 8) & 0377;
		if ((signum != SIGTRAP) && (signum != SIGIOT))
			prints(signals[signum]);
		else signum = 0;
		flushbuf();
	}
	return(code);
}
#endif /* of if 0 */

getreg(pid, offset)
{
	register int	data;

#ifdef ADB_DEBUG
	if (adbdebug) fprintf(stderr,"getreg(pid=0%o,off=0%o (rloc 0x%x)) ",
		pid, offset, (pid ? 0 : regloc[offset]));
#endif ADB_DEBUG
	if (pid) data = ptrace(RUREGS, pid, offset, 0);
	else data = u.u_ar0[regloc[offset]];
#ifdef ADB_DEBUG
	if (adbdebug) fprintf(stderr,"got data=0%o\n", data);
#endif ADB_DEBUG
	return(data);
}

putreg(pid, offset, data)
{
	if (pid) ptrace(WUREGS, pid, offset, data);
}

backtr(link, cnt)
{
	register long	rtn, p, inst;
	long		calladr, entadr;
	int		n = 1, i, argn;

#ifdef ADB_DEBUG
	if (adbdebug) fprintf(stderr,"backtr(link=0x%x,cnt=0x%x)\n",
		link, cnt);
#endif ADB_DEBUG
	while(cnt--)
	{
		p = link; calladr = -1; entadr = -1;
		link = fetch(p, DSP, 4); p += 4;
		rtn = fetch(p, DSP, 4);
		if (fetch(rtn - 6, ISP, 2) == CALL6)
		{
			entadr = fetch(rtn - 4, ISP, 4);
			calladr = rtn - 6;
		}
		else if (fetch(rtn - 2, ISP, 2) == CALL2)
			calladr = rtn - 2;

		inst = fetch(rtn, ISP, 2);
		if ((inst & 0xF1C0) == ADDQL)
		{
			argn = (inst>>9) & 07;
			if (argn == 0) argn = 8;
		}
		else if ((inst & 0xF1FC) == ADDL)
			argn = fetch(rtn + 2, ISP, 4);
		else argn = 0;
		if (argn && (argn % 4)) argn = (argn/4) + 1;
		else argn /= 4;

		if (calladr != -1) psymoff(calladr, ISYM, ":");
		else printf("???:");
		while (charpos() % 8) printc(' ');
		if (charpos() == 8) printc('\t');
		if (entadr != -1) psymoff(entadr, ISYM, "");
		else printf("???");
		while (charpos() % 8) printc(' '); printc('(');
		if (argn) printf("%X", fetch(p += 4, DSP, 4)); 
		for(i = 1; i < argn; i++)
			printf(", %X", fetch(p += 4, DSP, 4));
		printf(")\n");
		if ((entadr == mainsval) || (++n > 15)) break;
	}
}

fetch(adr, space, size)
{
	register long data = 0;

#ifdef ADB_DEBUG
	/*
	if (adbdebug)
		fprintf(stderr, "fetch(addr=0%o, sp=0%o, sz=0%o) ",
			adr, space, size);
	*/
#endif ADB_DEBUG
	if (size == 4) data = itol68(get(adr, space), get(adr+2, space));
	else data = get(adr, space);
#ifdef ADB_DEBUG
	/*
	if (adbdebug)
		fprintf(stderr, "got 0x%x\n", data);
	*/
#endif ADB_DEBUG
	return(data);
}

