/* rcsid[]="$Header: netisr.h,v 820.1 86/12/04 19:50:43 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	netisr.h	6.1	83/07/29	*/

/*
 * The networking code runs off software interrupts.
 *
 * You can switch into the network by doing splnet() and return by splx().
 * The software interrupt level for the network is higher than the software
 * level for the clock (so you can enter the network in routines called
 * at timeout time).
 */
#ifdef vax
#define	setsoftnet()	mtpr(SIRR, 12)
#endif
#ifdef s32
#define setsoftnet()	(sirnetflag = 1)
#ifndef LOCORE
extern char sirnetflag;
#endif LOCORE
#endif s32

/*
 * Each ``pup-level-1'' (routing or ISO network services)
 * input queue has a bit in a ``netisr'' status
 * word which is used to de-multiplex a single software
 * interrupt used for scheduling the network code to calls
 * on the lowest level routine of each protocol.
 */
#define	NETISR_RAW	0		/* same as AF_UNSPEC */
#define	NETISR_IP	2		/* same as AF_INET */
#define	NETISR_NS	6		/* same as AF_NS */
#define	NETISR_ND	7		/* network disk protocol */
#ifdef VALID_RPC
#define NETISR_RPC	12		/* same as AF_RPC */
#define NETISR_CONN	13		/* same as AF_CONN */
#define NETISR_BULK	15		/* same as AF_BULK */
#endif VALID_RPC
#ifdef DECnet
#define NETISR_DECnet	16		/* same as AF_DECnet */
#endif DECnet


#define	schednetisr(anisr)	{ netisr |= 1<<(anisr); setsoftnet(); }

#ifndef LOCORE
#ifdef KERNEL
int	netisr;				/* scheduling bits for network */
#endif
#endif
